SetDual8RAxleEvent = {};
SetDual8RAxleEvent_mt = Class(SetDual8RAxleEvent, Event);

InitEventClass(SetDual8RAxleEvent, "SetDual8RAxleEvent");

function SetDual8RAxleEvent:emptyNew()
    local self = Event:new(SetDual8RAxleEvent_mt);
    self.className="SetDual8RAxleEvent";
    return self;
end;

function SetDual8RAxleEvent:new(vehicle, isDualRAxleState)
    local self = SetDual8RAxleEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDual8RAxleState = isDual8RAxleState;
    return self;
end;

function SetDual8RAxleEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDual8RAxleState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDual8RAxleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDual8RAxleState);
end;

function SetDual8RAxleEvent:run(connection)   
	self.vehicle:setDual8RAxle(self.isDual8RAxleState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDual8RAxleEvent:new(self.vehicle, self.isDual8RAxleState), nil, connection, self.vehicle);
    end;
end;

function SetDual8RAxleEvent.sendEvent(vehicle, isDual8RAxleState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDual8RAxleEvent:new(vehicle, isDual8RAxleState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDual8RAxleEvent:new(vehicle, isDual8RAxleState));
		end;
	end;
end;