--
-- MFWD
-- Specialization for MFWD
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- MP Fhig!


MFWD = {};

function MFWD.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MFWD:load(xmlFile)

    self.MFWDState = MFWD.MFWDState;

    self.MFWDActive = true;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.MFWDwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.MFWDwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudMFWDPosX = 0.75;
    self.hudMFWDWidth = 0.08;
    self.hudMFWDPosY = 0.16;
    self.hudMFWDHeight = 0.08;
	self.infoPanelMFWDPath = Utils.getFilename("Textur/four_wheel_drive_active_symbol.png", self.baseDirectory);
	self.hudMFWDOverlay = Overlay:new("hudMFWDOverlay", self.infoPanelMFWDPath, self.hudMFWDPosX, self.hudMFWDPosY, self.hudMFWDWidth, self.hudMFWDHeight);
	self.showhudMFWD = true;
	
	self.infoPanelMFWDinPath = Utils.getFilename("Textur/four_wheel_drive_inactive_symbol.png", self.baseDirectory);
	self.hudMFWDinOverlay = Overlay:new("hudMFWDinOverlay", self.infoPanelMFWDinPath, self.hudMFWDPosX, self.hudMFWDPosY, self.hudMFWDWidth, self.hudMFWDHeight);
	self.showhudMFWDin = true;

end;

function MFWD:delete()
    if self.hudMFWDOverlay ~= nil then
		self.hudMFWDOverlay:delete();
	end;
end;

function MFWD:readStream(streamId, connection)  
     self:MFWDState(streamReadBool(streamId), true);  
end;

function MFWD:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.MFWDActive);  
end;

function MFWD:mouseEvent(posX, posY, isDown, isUp, button)
end;
function MFWD:keyEvent(unicode, sym, modifier, isDown)
end;

function MFWD:MFWDState(state, noEventSend)  
    MFWDStateEvent.sendEvent(self, state, noEventSend);	
    self.MFWDActive = state;
end;

function MFWD:update(dt)

	if isDown and sym == Input.KEY_l then
		self.tractorlightsActive = not self.tractorlightsActive;
	end;
    if self:getIsActiveForInput() then  
		if not self.tractorlightsActive then
			if InputBinding.hasEvent(InputBinding.MFWD) then
				self.MFWDActive = not self.MFWDActive;
			end;
		end;
    end;	
	if self:getIsActive() then	
   		if self.MFWDActive == true then
			self.showhudMFWD = true;		
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudMFWD = false;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	      local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
	      for i=1, self.wellenCount do
	         setRotation(self.Wellen[i], 0, 0, getRx);
	      end;
	    end;		
    end; 
end;

function MFWD:draw()
   if self.showhudMFWD == true then
      	self.hudMFWDOverlay:render();
	else
		self.hudMFWDinOverlay:render();
   end;
end;

MFWDStateEvent = {};
MFWDStateEvent_mt = Class(MFWDStateEvent, Event);

InitEventClass(MFWDStateEvent, "MFWDStateEvent");

function MFWDStateEvent:emptyNew() 
    local self = Event:new(MFWDStateEvent_mt );
    self.className="MFWDStateEvent";
    return self;
end;

function MFWDStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function MFWDStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function MFWDStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function MFWDStateEvent:run(connection)  
    self.vehicle:MFWDState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(MFWDStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function MFWDStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(MFWDStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(MFWDStateEvent:new(vehicle, state));
		end;
	end;
end;

