--
-- JD_Lights
-- Specialization class for John Deere 8360R
--Jeremy Brown
JD_Lights = {};

function JD_Lights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD_Lights:load(xmlFile)
	
	self.Park = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Park#index"));
	self.Park2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Park#index2"));
	self.Park3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Park#index3"));
	self.Road = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Road#index"));
	self.Road2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Road#index2"));
	self.HighBeam = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.HighBeam#index"));
	self.InnerNoseWork = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.InnerNoseWork#index"));
	self.OuterNoseWork = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.OuterNoseWork#index"));
	self.Waist1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist1#index"));
	self.Waist2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist2#index"));
	self.Waist3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist3#index"));
	self.CabFrontInner = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontInner#index"));
	self.CabFrontMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontMiddle#index"));
	self.CabFrontOuterLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontOuterLeft#index"));
	self.CabFrontOuterRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontOuterRight#index"));
	self.CabRearOuterLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearOuterLeft#index"));
	self.CabRearOuterRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearOuterRight#index"));
	self.CabRearMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearMiddle#index"));
	self.CabRearInner = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearInner#index"));
	self.RearFender = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.RearFender#index"));
	
	self.LowBeamlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LowBeamlight#index"));
	self.HighBeamlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.HighBeamlight#index"));
	self.InnerNoseWorklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.InnerNoseWorklight#index"));
	self.OuterNoseWorklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.OuterNoseWorklight#index"));
	self.Waist1light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist1light#index"));
	self.Waist2light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist2light#index"));
	self.Waist3light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Waist3light#index"));
	self.CabFrontInnerlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontInnerlight#index"));
	self.CabFrontMiddlelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontMiddlelight#index"));
	self.CabFrontOuterLeftlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontOuterLeftlight#index"));
	self.CabFrontOuterRightlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontOuterRightlight#index"));
	self.CabRearOuterLeftlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearOuterLeftlight#index"));
	self.CabRearOuterRightlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearOuterRightlight#index"));
	self.CabRearMiddlelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearMiddlelight#index"));
	self.CabRearInnerlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearInnerlight#index"));
	self.RearFenderlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.RearFenderlight#index"));
	self.InnerOuterNoselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.InnerOuterNoselight#index"));
	self.AllWaistlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.AllWaistlight#index"));
	self.CabFrontInnerMiddlelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabFrontInnerMiddlelight#index"));
	self.AllFrontWorklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.AllFrontWorklight#index"));
	self.CabLeftlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabLeftlight#index"));
	self.CabRightlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRightlight#index"));
	self.CabRearMiddleInnerlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearMiddleInnerlight#index"));
	self.CabRearMiddleFenderlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearMiddleFenderlight#index"));
	self.CabRearInnerFenderlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CabRearInnerFenderlight#index"));
	self.AllRearlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.AllRearlight#index"));
	
	
	self.ParkActive = false;
	self.RoadActive = false;
	self.HighBeamActive = false;
	self.InnerNoseWorkActive = false;
	self.OuterNoseWorkActive = false;
	self.Waist1Active = false;
	self.Waist2Active = false;
	self.Waist3Active = false;
	self.CabFrontInnerActive = false;
	self.CabFrontMiddleActive = false;
	self.CabFrontOuterLeftActive = false;
	self.CabFrontOuterRightActive = false;
	self.CabRearOuterLeftActive = false;
	self.CabRearOuterRightActive = false;
	self.CabRearMiddleActive = false;
	self.CabRearInnerActive = false;
	self.RearFenderActive = false;
	
	self.LowBeamlightActive = true;
	self.HighBeamlightActive = false;
	self.InnerNoseWorklightActive = false;
	self.OuterNoseWorklightActive = false;
	self.Waist1lightActive = false;
	self.Waist2lightActive = false;
	self.Waist3lightActive = false;
	self.CabFrontInnerlightActive = false;
	self.CabFrontMiddlelightActive = false;
	self.CabFrontOuterLeftlightActive = false;
	self.CabFrontOuterRightlightActive = false;
	self.CabRearOuterLeftlightActive = false;
	self.CabRearOuterRightlightActive = false;
	self.CabRearOuterlightActive = false;
	self.CabRearMiddlelightActive = false;
	self.CabRearInnerlightActive = false;
	self.RearFenderlightActive = false;
	self.InnerOuterNoselightActive = false;
	self.AllWaistlightActive = false;
	self.CabFrontInnerMiddlelightActive = false;
	self.AllFrontWorklightActive = false;
	self.CabLeftlightActive = false;
	self.CabRightlightActive = false;
	self.CabRearMiddleInnerlightActive = false;
	self.CabRearMiddleFenderlightActive = false;
	self.CabRearInnerFenderlightActive = false;
	self.AllRearlightActive = false;
	
end;

function JD_Lights:delete()

end;

function JD_Lights:readStream(streamId, connection)
	
end;

function JD_Lights:writeStream(streamId, connection)
	
end;

function JD_Lights:readUpdateStream(streamId, timestamp, connection)
end;

function JD_Lights:writeUpdateStream(streamId, connection, dirtyMask)
end;

function JD_Lights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD_Lights:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_l then
		self.tractorlightsActive = not self.tractorlightsActive;
	end;
	if isDown and sym == Input.KEY_f then
		self.ParkActive = not self.ParkActive
		self.RoadActive = not self.RoadActive
	end;
	if isDown and sym == Input.KEY_f2 then
		self.HighBeamActive = not self.HighBeamActive
		self.LowBeamlightActive = not self.LowBeamlightActive
		self.HighBeamlightActive = not self.HighBeamlightActive
	end;
	
	if self.tractorlightsActive then
		if isDown and sym == Input.KEY_f3 then
			self.InnerNoseWorkActive = not self.InnerNoseWorkActive
		end;
		if isDown and sym == Input.KEY_f4 then
			self.OuterNoseWorkActive = not self.OuterNoseWorkActive
		end;
		if isDown and sym == Input.KEY_f5 then
			self.Waist1Active = not self.Waist1Active
		end;
		if isDown and sym == Input.KEY_f6 then
			self.Waist2Active = not self.Waist2Active
		end;
		if isDown and sym == Input.KEY_f7 then
			self.Waist3Active = not self.Waist3Active
			self.Waist3lightActive = not self.Waist3lightActive
		end;
		if isDown and sym == Input.KEY_f8 then
			self.CabFrontInnerActive = not self.CabFrontInnerActive
		end;
		if isDown and sym == Input.KEY_f9 then
			self.CabFrontMiddleActive = not self.CabFrontMiddleActive
		end;
		if isDown and sym == Input.KEY_f10 then
			self.CabFrontOuterLeftActive = not self.CabFrontOuterLeftActive
		end;
		if isDown and sym == Input.KEY_f11 then
			self.CabFrontOuterRightActive = not self.CabFrontOuterRightActive
		end;
		if isDown and sym == Input.KEY_5 then
			self.CabRearOuterLeftActive = not self.CabRearOuterLeftActive
		end;
		if isDown and sym == Input.KEY_6 then
			self.CabRearOuterRightActive = not self.CabRearOuterRightActive
		end;
		if isDown and sym == Input.KEY_7 then
			self.CabRearMiddleActive = not self.CabRearMiddleActive
		end;
		
		if isDown and sym == Input.KEY_8 then
			self.CabRearInnerActive = not self.CabRearInnerActive
		end;
		if isDown and sym == Input.KEY_9 then
			self.RearFenderActive = not self.RearFenderActive
		end;
	end;
end;

function JD_Lights:update(dt)
	setVisibility(self.Road, self.RoadActive);
	setVisibility(self.Road2, self.RoadActive);
	setVisibility(self.Park, self.ParkActive);
	setVisibility(self.Park2, self.ParkActive);
	setVisibility(self.Park3, self.ParkActive);
	
	setVisibility(self.HighBeam, self.HighBeamActive);
	setVisibility(self.LowBeamlight, self.LowBeamlightActive);
	setVisibility(self.HighBeamlight, self.HighBeamlightActive);
	
	setVisibility(self.InnerNoseWork, self.InnerNoseWorkActive);
	setVisibility(self.InnerNoseWorklight, self.InnerNoseWorklightActive);
	
	setVisibility(self.OuterNoseWork, self.OuterNoseWorkActive);
	setVisibility(self.OuterNoseWorklight, self.OuterNoseWorklightActive);
	
	setVisibility(self.Waist1, self.Waist1Active);
	setVisibility(self.Waist1light, self.Waist1lightActive);
	
	setVisibility(self.Waist2, self.Waist2Active);
	setVisibility(self.Waist2light, self.Waist2lightActive);
	
	setVisibility(self.Waist3, self.Waist3Active);
	setVisibility(self.Waist3light, self.Waist3lightActive);
	
	setVisibility(self.CabFrontInner, self.CabFrontInnerActive);
	setVisibility(self.CabFrontInnerlight, self.CabFrontInnerlightActive);
	
	setVisibility(self.CabFrontMiddle, self.CabFrontMiddleActive);
	setVisibility(self.CabFrontMiddlelight, self.CabFrontMiddlelightActive);
	
	if self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = true;
	elseif not self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and not self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and not self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and not self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and not self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = true;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = true;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and self.Waist1Active and self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = true;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = true;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = true;
		self.AllFrontWorklightActive = false;
	elseif self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = true;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = true;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = true;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = true;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = true;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = true;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	elseif not self.CabFrontInnerActive and not self.CabFrontMiddleActive and not self.Waist1Active and not self.Waist2Active and not self.InnerNoseWorkActive and not self.OuterNoseWorkActive then
		self.InnerNoseWorklightActive = false;
		self.OuterNoseWorklightActive = false;
		self.InnerOuterNoselightActive = false;
		self.Waist1lightActive = false;
		self.Waist2lightActive = false;
		self.AllWaistlightActive = false;
		self.CabFrontInnerlightActive = false;
		self.CabFrontMiddlelightActive = false;
		self.CabFrontInnerMiddlelightActive = false;
		self.AllFrontWorklightActive = false;
	end;
	
	setVisibility(self.CabFrontOuterLeft, self.CabFrontOuterLeftActive);
	setVisibility(self.CabFrontOuterLeftlight, self.CabFrontOuterLeftlightActive);
	
	setVisibility(self.CabFrontOuterRight, self.CabFrontOuterRightActive);
	setVisibility(self.CabFrontOuterRightlight, self.CabFrontOuterRightlightActive);
	
	setVisibility(self.CabRearOuterLeft, self.CabRearOuterLeftActive);
	setVisibility(self.CabRearOuterLeftlight, self.CabRearOuterLeftlightActive);
	
	setVisibility(self.CabRearOuterRight, self.CabRearOuterRightActive);
	setVisibility(self.CabRearOuterRightlight, self.CabRearOuterRightlightActive);
	
	if self.CabFrontOuterLeftActive and self.CabRearOuterLeftActive then
		self.CabFrontOuterLeftlightActive = false;
		self.CabRearOuterLeftlightActive = false;
		self.CabLeftlightActive = true;
	elseif self.CabFrontOuterLeftActive and not self.CabRearOuterLeftActive then
		self.CabFrontOuterLeftlightActive = true;
		self.CabRearOuterLeftlightActive = false;
		self.CabLeftlightActive = false;
	elseif not self.CabFrontOuterLeftActive and self.CabRearOuterLeftActive then
		self.CabFrontOuterLeftlightActive = false;
		self.CabRearOuterLeftlightActive = true;
		self.CabLeftlightActive = false;
	elseif not self.CabFrontOuterLeftActive and not self.CabRearOuterLeftActive then
		self.CabFrontOuterLeftlightActive = false;
		self.CabRearOuterLeftlightActive = false;
		self.CabLeftlightActive = false;
	end;
	
	if self.CabFrontOuterRightActive and self.CabRearOuterRightActive then
		self.CabFrontOuterRightlightActive = false;
		self.CabRearOuterRightlightActive = false;
		self.CabRightlightActive = true;
	elseif self.CabFrontOuterRightActive and not self.CabRearOuterRightActive then
		self.CabFrontOuterRightlightActive = true;
		self.CabRearOuterRightlightActive = false;
		self.CabRightlightActive = false;
	elseif not self.CabFrontOuterRightActive and self.CabRearOuterRightActive then
		self.CabFrontOuterRightlightActive = false;
		self.CabRearOuterRightlightActive = true;
		self.CabRightlightActive = false;
	elseif not self.CabFrontOuterRightActive and not self.CabRearOuterRightActive then
		self.CabFrontOuterRightlightActive = false;
		self.CabRearOuterRightlightActive = false;
		self.CabRightlightActive = false;
	end;
	
	setVisibility(self.CabRearMiddle, self.CabRearMiddleActive);
	setVisibility(self.CabRearMiddlelight, self.CabRearMiddlelightActive);
	
	setVisibility(self.CabRearInner, self.CabRearInnerActive);
	setVisibility(self.CabRearInnerlight, self.CabRearInnerlightActive);
	
	setVisibility(self.RearFender, self.RearFenderActive);
	setVisibility(self.RearFenderlight, self.RearFenderlightActive);
	
	if self.RearFenderActive and self.CabRearInnerActive and self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = true;
	elseif not self.RearFenderActive and self.CabRearInnerActive and self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = true;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	elseif self.RearFenderActive and self.CabRearInnerActive and not self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = true;
		self.AllRearlightActive = false;
	elseif self.RearFenderActive and not self.CabRearInnerActive and self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = true;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	elseif not self.RearFenderActive and not self.CabRearInnerActive and self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = true;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	elseif not self.RearFenderActive and self.CabRearInnerActive and not self.CabRearMiddleActive then
		self.CabRearInnerlightActive = true;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	elseif self.RearFenderActive and not self.CabRearInnerActive and not self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = true;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	elseif not self.RearFenderActive and not self.CabRearInnerActive and not self.CabRearMiddleActive then
		self.CabRearInnerlightActive = false;
		self.CabRearMiddlelightActive = false;
		self.RearFenderlightActive = false;
		self.CabRearMiddleInnerlightActive = false;
		self.CabRearMiddleFenderlightActive = false;
		self.CabRearInnerFenderlightActive = false;
		self.AllRearlightActive = false;
	end;
	
	setVisibility(self.InnerOuterNoselight, self.InnerOuterNoselightActive);
	setVisibility(self.AllWaistlight, self.AllWaistlightActive);
	setVisibility(self.CabFrontInnerMiddlelight, self.CabFrontInnerMiddlelightActive);
	setVisibility(self.AllFrontWorklight, self.AllFrontWorklightActive);
	setVisibility(self.CabLeftlight, self.CabLeftlightActive);
	setVisibility(self.CabRightlight, self.CabRightlightActive);
	setVisibility(self.CabRearMiddleInnerlight, self.CabRearMiddleInnerlightActive);
	setVisibility(self.CabRearMiddleFenderlight, self.CabRearMiddleFenderlightActive);
	setVisibility(self.CabRearInnerFenderlight, self.CabRearInnerFenderlightActive);
	setVisibility(self.AllRearlight, self.AllRearlightActive);
	
end;

function JD_Lights:updateTick(dt)
end;

function JD_Lights:draw()
	if self.tractorlightsActive then			
		if self.RoadActive then
			renderText(0.42, 0.98, 0.021, "Press F: Road Lights On");
		else
			renderText(0.42, 0.98, 0.021, "Press F: Road Lights Off");
		end;
		if self.HighBeamActive then
			renderText(0.42, 0.96, 0.021, "Press F2: High Beam");
		else
			renderText(0.42, 0.96, 0.021, "Press F2: Low Beam");
		end;
		if self.InnerNoseWorkActive then
			renderText(0.42, 0.94, 0.021, "Press F3: Inner Nose Work Lights on");
		else
			renderText(0.42, 0.94, 0.021, "Press F3: Inner Nose Work Lights off");
		end;
		if self.OuterNoseWorkActive then
			renderText(0.42, 0.92, 0.021, "Press F4: Outer Nose Work Lights on");
		else
			renderText(0.42, 0.92, 0.021, "Press F4: Outer Nose Work Lights off");
		end;
		if self.Waist1Active then
			renderText(0.42, 0.90, 0.021, "Press F5: Lower Waist Lights on");
		else
			renderText(0.42, 0.90, 0.021, "Press F5: Lower Waist Lights off");
		end;
		if self.Waist2Active then
			renderText(0.42, 0.88, 0.021, "Press F6: Upper Waist Lights on");
		else
			renderText(0.42, 0.88, 0.021, "Press F6: Upper Waist Lights off");
		end;
		if self.CabFrontInnerActive then
			renderText(0.42, 0.84, 0.021, "Press F8: Cab Front Inner Lights on");
		else
			renderText(0.42, 0.84, 0.021, "Press F8: Cab Front Inner Lights off");
		end;
		if self.CabFrontMiddleActive then
			renderText(0.42, 0.82, 0.021, "Press F9: Cab Front Middle Lights on");
		else
			renderText(0.42, 0.82, 0.021, "Press F9: Cab Front Middle Lights off");
		end;
		if self.CabFrontOuterLeftActive then
			renderText(0.42, 0.80, 0.021, "Press F10: Cab Front Outer Left Lights on");
		else
			renderText(0.42, 0.80, 0.021, "Press F10: Cab Front Outer Left Lights off");
		end;
		if self.CabFrontOuterRightActive then
			renderText(0.42, 0.78, 0.021, "Press F11: Cab Front Outer Right Lights on");
		else
			renderText(0.42, 0.78, 0.021, "Press F11: Cab Front Outer Right Lights off");
		end;
		if self.CabRearOuterLeftActive then
			renderText(0.42, 0.76, 0.021, "Press 5: Cab Rear Outer Left Lights on");
		else
			renderText(0.42, 0.76, 0.021, "Press 5: Cab Rear Outer Left Lights off");
		end;
		if self.CabRearOuterRightActive then
			renderText(0.42, 0.74, 0.021, "Press 6: Cab Rear Outer Right Lights on");
		else
			renderText(0.42, 0.74, 0.021, "Press 6: Cab Rear Outer Right Lights off");
		end;
		if self.CabRearMiddleActive then
			renderText(0.42, 0.72, 0.021, "Press 7: Cab Rear Middle Lights on");
		else
			renderText(0.42, 0.72, 0.021, "Press 7: Cab Rear Middle Lights off");
		end;
		if self.CabRearInnerActive then
			renderText(0.42, 0.70, 0.021, "Press 8: Cab Rear Inner Lights on");
		else
			renderText(0.42, 0.70, 0.021, "Press 8: Cab Rear Inner Lights off");
		end;
		if self.RearFenderActive then
			renderText(0.42, 0.68, 0.021, "Press 9: Rear Fender Lights on");
		else
			renderText(0.42, 0.68, 0.021, "Press 9: Rear Fender Lights off");
		end;
	end;
	if self.tractorlightsActive then
		renderText(0.76, 0.26, 0.021, "Press L: Work Lights Active");
	else
		renderText(0.76, 0.26, 0.021, "Press L: Work Lights Inactive");
	end;
end;

function JD_Lights:onEnter()
	
end;

function JD_Lights:onLeave()

end;
