--
-- JD_8360R
-- Specialization class for John Deere 8360R
--
-- @author  Mario
-- @date  24/08/2010
--
-- Copyright (C) Mario, All Rights Reserved.

JD_8360R = {};

function JD_8360R.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD_8360R:load(xmlFile)
	
	self.warn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.warn#index"));
	self.Parklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index"));
	self.Parklight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index2"));
	self.Parklight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index3"));
	
	self.FrontHitch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.FrontHitch#index"));
	
	self.setFHitch= SpecializationUtil.callSpecializationsFunction("setFHitch");
	self.setDualRAxle= SpecializationUtil.callSpecializationsFunction("setDualRAxle");
	self.setRWFender= SpecializationUtil.callSpecializationsFunction("setRWFender");
	self.setLFrame= SpecializationUtil.callSpecializationsFunction("setLFrame");
	self.SetCoverEdgeDoorPanel= SpecializationUtil.callSpecializationsFunction("SetCoverEdgeDoorPanel");
	self.CoverEdgeDoorPanelAnimation = getXMLString(xmlFile, "vehicle.CoverEdgeDoorPanel#animationName");
	self.setControlledWheelSpacing= SpecializationUtil.callSpecializationsFunction("setControlledWheelSpacing");
	
	self.wyc = 650;
	self.tankwarn = 100;
	self.ParklightActive = false;
	self.loaderframeActive = false;
	self.fendersActive = true;
	self.regfendersActive = true;
	self.widefendersActive = false;
	self.FrontHitchActive = false;
	self.controlledwheelspacerActive = true;
	
	self.FHitch = false;
	self.DualRAxle = false;
	self.RWFender = false;
	self.LFrame = false;
	self.CoverEdgeDoorPanel = true;
	self.ControlledWheelSpacing = false;
	
    self.tafeln1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tafeln.tafeln1#index"));
    self.tafeln2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tafeln.tafeln2#index"));
	self.tafeln = false;
	
	self.controlledwheelspacer  = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.controlledwheelspacer#index"));
	self.controlledwheelspacer2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.controlledwheelspacer#index2"));
	self.controlledwheelspacer3  = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.controlledwheelspacer#index3"));
	self.controlledwheelspacer4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.controlledwheelspacer#index4"));
	
	self.fenders = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fenders#index2"));
	self.regfenders = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.regfenders#index"));
	self.regfenders2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.regfenders#index2"));
	self.widefenders = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.widefenders#index"));
	self.widefenders2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.widefenders#index2"));
	
	self.loaderframe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.loaderframe#index"));
	
   
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	local rotationPartNodePedal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPedal#index"));
    if rotationPartNodePedal ~= nil then
        self.rotationPartPedal = {};
        self.rotationPartPedal.node = rotationPartNodePedal;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#minRot"));
        self.rotationPartPedal.minRot = {};
        self.rotationPartPedal.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#maxRot"));
        self.rotationPartPedal.maxRot = {};
        self.rotationPartPedal.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPedal.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#rotTime"), 2)*1000;
        self.rotationPartPedal.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#touchRotLimit"), 10));
    end;
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNodeAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartAttacher#index"));
    if translationPartNodeAttacher ~= nil then
        self.translationPartAttacher = {};
        self.translationPartAttacher.node = translationPartNodeAttacher;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#minTrans"));
        self.translationPartAttacher.minTrans = {};
        self.translationPartAttacher.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartAttacher.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartAttacher.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#maxTrans"));
        self.translationPartAttacher.maxTrans = {};
        self.translationPartAttacher.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartAttacher.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartAttacher.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartAttacher.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#transTime"), 2)*1000;
        self.translationPartAttacher.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#touchTransLimit"), 10);
    end;
	
	local rotationPartNodeAttacherPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#index"));
    if rotationPartNodeAttacherPart ~= nil then
        self.rotationPartAttacherPart = {};
        self.rotationPartAttacherPart.node = rotationPartNodeAttacherPart;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#minRot"));
        self.rotationPartAttacherPart.minRot = {};
        self.rotationPartAttacherPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacherPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacherPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#maxRot"));
        self.rotationPartAttacherPart.maxRot = {};
        self.rotationPartAttacherPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacherPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacherPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAttacherPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#rotTime"), 2)*1000;
        self.rotationPartAttacherPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#touchRotLimit"), 10));
    end;
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
	klaksonFile = Utils.getFilename("sounds/horn.wav", self.baseDirectory);
    self.klaksonId = createSample("klakson");
    loadSample(self.klaksonId, klaksonFile, false);
    self.klaksonPlaying = false;
	
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
	fuelwarningSoundFile = Utils.getFilename("sounds/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
	
	 ---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
	self.FlashLightLeft2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index2"));
	self.FlashLightLeft3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index3"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	
	self.FlashLightRight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index2"));	
	self.FlashLightRight3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index3"));		
	
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	local rotationNodeEchelle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchelle#index"));
    if rotationNodeEchelle ~= nil then
        self.rotationEchelle = {};
        self.rotationEchelle.node = rotationNodeEchelle;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle#minRot"));
        self.rotationEchelle.minRot = {};
        self.rotationEchelle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle#maxRot"));
        self.rotationEchelle.maxRot = {};
        self.rotationEchelle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchelle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle#rotTime"), 2)*1000;
        self.rotationEchelle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle#touchRotLimit"), 10));
    end;

	local rotationNodeEchelle1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchelle1#index"));
    if rotationNodeEchelle1 ~= nil then
        self.rotationEchelle1 = {};
        self.rotationEchelle1.node = rotationNodeEchelle1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle1#minRot"));
        self.rotationEchelle1.minRot = {};
        self.rotationEchelle1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle1#maxRot"));
        self.rotationEchelle1.maxRot = {};
        self.rotationEchelle1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchelle1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle1#rotTime"), 2)*1000;
        self.rotationEchelle1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle1#touchRotLimit"), 10));
    end; 
	
	local rotationNodeEchelle2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchelle2#index"));
    if rotationNodeEchelle2 ~= nil then
        self.rotationEchelle2 = {};
        self.rotationEchelle2.node = rotationNodeEchelle2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle2#minRot"));
        self.rotationEchelle2.minRot = {};
        self.rotationEchelle2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchelle2#maxRot"));
        self.rotationEchelle2.maxRot = {};
        self.rotationEchelle2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchelle2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchelle2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchelle2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle2#rotTime"), 2)*1000;
        self.rotationEchelle2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchelle2#touchRotLimit"), 10));
    end; 
	local rotationNodeSeat = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationSeat#index"));
    if rotationNodeSeat ~= nil then
        self.rotationSeat = {};
        self.rotationSeat.node = rotationNodeSeat;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSeat#minRot"));
        self.rotationSeat.minRot = {};
        self.rotationSeat.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSeat.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSeat.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSeat#maxRot"));
        self.rotationSeat.maxRot = {};
        self.rotationSeat.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSeat.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSeat.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSeat.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSeat#rotTime"), 2)*1000;
        self.rotationSeat.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSeat#touchRotLimit"), 10));
    end;
	
	self.Echelle = false;
	self.Seat = false;
end;

function JD_8360R:delete()

end;

function JD_8360R:readStream(streamId, connection)
	self:SetCoverEdgeDoorPanel(streamReadBool(streamId), true);
	self:setFHitch(streamReadBool(streamId), true);
	self:setDualRAxle(streamReadBool(streamId), true);
	self:setRWFender(streamReadBool(streamId), true);
	self:setLFrame(streamReadBool(streamId), true);
	self:setControlledWheelSpacing(streamReadBool(streamId), true);
end;

function JD_8360R:writeStream(streamId, connection)
	streamWriteBool(streamId, self.CoverEdgeDoorPanel);
	streamWriteBool(streamId, self.FHitch);
	streamWriteBool(streamId, self.DualRAxle);
	streamWriteBool(streamId, self.RWFender);
	streamWriteBool(streamId, self.LFrame);
	streamWriteBool(streamId, self.ControlledWheelSpacing);
end;

function JD_8360R:readUpdateStream(streamId, timestamp, connection)
end;

function JD_8360R:writeUpdateStream(streamId, connection, dirtyMask)
end;

function JD_8360R:mouseEvent(posX, posY, isDown, isUp, button)

end;

function JD_8360R:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_t then
		self.tractorfunctionsActive = not self.tractorfunctionsActive;
	end;
	
	if isDown and sym == Input.KEY_f then
		self.ParklightActive = not self.ParklightActive;
	end;
	
	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
	
	if isDown then
		if sym == Input.KEY_z then
			self.klaksonAllow = true;
		end;
	else
		self.klaksonAllow = false;
	end;
	
	if sym == Input.KEY_9 then
		self.translationMaxAttacher = isDown;
	end;
	if sym == Input.KEY_0 then
		self.translationMinAttacher = isDown;
	end;
	
	if isDown and sym == Input.KEY_g then
		self.chuj = not self.chuj;
	end;
	
	if isDown and sym == Input.KEY_v then
		if self.chuj then
			self.rotationMaxWajcha = true;
		else
			self.rotationMaxWajcha2 = true
		end;
	else
		self.rotationMaxWajcha = false;
		self.rotationMaxWajcha2 = false;
	end;
	
	---flashlights
	
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;
	
	if self.tractorfunctionsActive then	
	if isDown and sym == self.keys.Echelle then
		self.Echelle = not self.Echelle;
	end;
	if isDown and sym == self.keys.Seat then
		self.Seat = not self.Seat;
	end;
	end;
end;

function JD_8360R:update(dt)

	if self.inrange then
		if InputBinding.hasEvent(InputBinding.DUALRWHEEL) then
			self:setDualRAxle(not self.DualRAxle);
		end;
		if InputBinding.hasEvent(InputBinding.FENDERSELECT) then
			self:setRWFender(not self.RWFender);
		end;
		if InputBinding.hasEvent(InputBinding.LOADERAFRAME) then
			self:setLFrame(not self.LFrame);
		end;
		if InputBinding.hasEvent(InputBinding.FRONTHITCHTRANSPORT) then
			self:SetCoverEdgeDoorPanel(not self.CoverEdgeDoorPanel);
		end;
		if InputBinding.hasEvent(InputBinding.FRONTHITCH) then
			self:setFHitch(not self.FHitch);
		end;
		if InputBinding.hasEvent(InputBinding.CONTROLLEDSPACING) then
			self:setControlledWheelSpacing(not self.ControlledWheelSpacing);
		end;
	end;
	-- Display key when in range --
	if self.inrange then
		if self.RAxleMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("DUALWHEEL_MODE"), self.typeDesc), InputBinding.DUALRWHEEL);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SINGLEWHEEL_MODE"), self.typeDesc), InputBinding.DUALRWHEEL);
		end;
		if self.RWFendersMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WIDEFENDERS_MODE"), self.typeDesc), InputBinding.FENDERSELECT);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REGFENDERS_MODE"), self.typeDesc), InputBinding.FENDERSELECT);
		end;
		if self.FrameMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TURNINGFENDER_MODE"), self.typeDesc), InputBinding.LOADERAFRAME);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("LOADERFRAME_MODE"), self.typeDesc), InputBinding.LOADERAFRAME);
		end;
		if self.HitchMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FRONTHITCH_MODE"), self.typeDesc), InputBinding.FRONTHITCH);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FRONTWEIGHT_MODE"), self.typeDesc), InputBinding.FRONTHITCH);
		end;
		if self.ControlledWSMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TAKEAWAYWHEELS"), self.typeDesc), InputBinding.CONTROLLEDSPACING);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ADDWHEELS"), self.typeDesc), InputBinding.CONTROLLEDSPACING);
		end;
	end;
	if self.isEntered and Input.isKeyPressed(Input.KEY_w) then
		Utils.setEmittingState(self.dustParticleSystems, true);
	else
		Utils.setEmittingState(self.dustParticleSystems, false);
	end;

	if self.handbrake then
		self.rotationMaxReczny = true;
	else
		self.rotationMaxReczny = false;
	end;
	
	if Input.isKeyPressed(Input.KEY_0) then
		self.rotationMaxWajchaZaczep = true;
		self.rotationMaxWajchaZaczep2 = false;
	else
		self.rotationMaxWajchaZaczep = false;
	end;
	if Input.isKeyPressed(Input.KEY_9) then
		self.rotationMaxWajchaZaczep2 = true;
		self.rotationMaxWajchaZaczep = false;
	else
		self.rotationMaxWajchaZaczep2 = false;
	end;
	
	if self.isEntered then
		if self.attachedTrailer then
			self.rotationMaxAttacherPart = true;
			self.translationMax = true;
		else
			self.rotationMaxAttacherPart = false;
			self.translationMax = false;
		end;
	end;
	
	if self.translationPart ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
	end;

	if self.rotationPartAttacherPart ~= nil then
		local x, y, z = getRotation(self.rotationPartAttacherPart.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartAttacherPart.maxRot, self.rotationPartAttacherPart.minRot, 3, self.rotationPartAttacherPart.rotTime, dt, not self.rotationMaxAttacherPart);
		setRotation(self.rotationPartAttacherPart.node, unpack(newRot));
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) then
			self.rotationMaxPedal = true;
		else
			self.rotationMaxPedal = false;
		end;
		if Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxBrake = true;
		else
			self.rotationMaxBrake = false;
		end;
		if self.gang0 then
			self.rotationMaxClutch = true;
		else
			self.rotationMaxClutch = false;
		end;
	end;
	
	if self.rotationPartPedal ~= nil then
		local x, y, z = getRotation(self.rotationPartPedal.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPedal.maxRot, self.rotationPartPedal.minRot, 3, self.rotationPartPedal.rotTime, dt, not self.rotationMaxPedal);
		setRotation(self.rotationPartPedal.node, unpack(newRot));
	end;

	setVisibility(self.warn, self.warnLightActive);
	setVisibility(self.Parklight, self.ParklightActive);
	setVisibility(self.Parklight2, self.ParklightActive);
	setVisibility(self.Parklight3, self.ParklightActive);
	
	
	
	if self.klaksonAllow and not self.klaksonPlaying then
		playSample(self.klaksonId,0,1,0);
		self.klaksonPlaying = true;
	elseif not self.klaksonAllow and self.klaksonPlaying then
		stopSample(self.klaksonId);
		self.klaksonPlaying = false;
	end;
	
	if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
		end;
		
	--- flashLights

		if self.FlashLightLeft ~= nil then
				if self.flashLightLeftActive then
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft2, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft3, self.flashLightLeftActive);
					
			else
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft2, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft3, self.flashLightLeftActive);
			end;
			end;

		if self.FlashLightRight ~= nil then
				if self.FlashLightRightActive then
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
					setVisibility(self.FlashLightRight2, self.flashLightRightActive);
					setVisibility(self.FlashLightRight3, self.flashLightRightActive);
			else
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
					setVisibility(self.FlashLightRight2, self.flashLightRightActive);
					setVisibility(self.FlashLightRight3, self.flashLightRightActive);
			end;
			end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashLightLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashLightLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashLightLeftActive = false;
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashLightRightActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashLightRightActive = false;
				end;
			end;
		end;

		if self.flash then
		
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					
					self.flashLightRightActive = true;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
					
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
				
					self.flashLightLeftActive = false;
					self.flashLightRightActive = false;
				end;
			end;
			else
			
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashLightRightActive = false;
				self.flashLightLeftActive = false;
			end;
		end;
			
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashLightRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashLightLeftActive = false;
			end;
		end;
	
	local doRotate = self.rotationEchelleMax or self.rotationEchelleMin 
	if self.rotationEchelle ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchelle.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchelle.maxRot, self.rotationEchelle.minRot, 3, self.rotationEchelle.rotTime, dt, not self.rotationEchelleMax);
        setRotation(self.rotationEchelle.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationEchelle1Max or self.rotationEchelle1Min 
	if self.rotationEchelle1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchelle1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchelle1.maxRot, self.rotationEchelle1.minRot, 3, self.rotationEchelle1.rotTime, dt, not self.rotationEchelle1Max);
        setRotation(self.rotationEchelle1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationEchelle2Max or self.rotationEchelle2Min 
	if self.rotationEchelle2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchelle2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchelle2.maxRot, self.rotationEchelle2.minRot, 3, self.rotationEchelle2.rotTime, dt, not self.rotationEchelle2Max);
        setRotation(self.rotationEchelle2.node, unpack(newRot));
    end;
	if self.rotationSeat ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSeat.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSeat.maxRot, self.rotationSeat.minRot, 3, self.rotationSeat.rotTime, dt, not self.rotationSeatMax);
        setRotation(self.rotationSeat.node, unpack(newRot));
    end;
	
		-- Echelle --
		
	if self.Echelle then
		self.rotationEchelleMax = true;
		self.rotationEchelleMin = false;
		self.rotationEchelle1Max = true;
		self.rotationEchelle1Min = false;
		self.rotationEchelle2Max = true;
		self.rotationEchelle2Min = false;
	else
		self.rotationEchelleMax = false;
		self.rotationEchelleMin = true;
		self.rotationEchelle1Max = false;
		self.rotationEchelle1Min = true;
		self.rotationEchelle2Max = false;
		self.rotationEchelle2Min = true;
	end;
	if self.Seat then
		self.rotationSeatMax = true;
		self.rotationSeatMin = false;
	else
		self.rotationSeatMax = false;
		self.rotationSeatMin = true;
	end;
	if self.doorIObject == nil then
		for k,iObject in pairs(self.interactiveObjects) do
			if iObject.name == g_i18n:getText("leftDoor") then
				self.doorIObject = iObject;
			end;
		end;
	end;
end;

function JD_8360R:updateTick(dt)
	if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function JD_8360R:draw()
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.82, 0.22, 0.021, "Press 0: Info on");
		else
			renderText(0.82, 0.22, 0.021, "Press 0: Info off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.66, 0.023, "- John Deere 8R Info -");
			
			if self.flashLeft then
				renderText(0.02, 0.48, 0.021, "Press Num Pad 1: Left Turn Signal off");
			else
				renderText(0.02, 0.48, 0.021, "Press Num Pad 1: Left Turn Signal on");
			end;
			if self.flashRight then
				renderText(0.02, 0.52, 0.021, "Press Num Pad 3: Right Turn Signal off");
			else
				renderText(0.02, 0.52, 0.021, "Press Num Pad 3: Right Turn Signal on");
			end;
			if self.flash then
				renderText(0.02, 0.50, 0.021, "Press Num Pad 2: Hazards off");
			else
				renderText(0.02, 0.50, 0.021, "Press Num Pad 2: Hazards on");
			end;
			if self.rundumleuchtenAn then
				renderText(0.02, 0.54, 0.021, "Press Home: Warning Light off ");
			else
				renderText(0.02, 0.54, 0.021, "Press Home: Warning Light on");
			end;
			renderText(0.02, 0.58, 0.021, "Leave Tractor and press F5 to cycle Regular or Wide Fenders");
			renderText(0.02, 0.56, 0.021, "Leave Tractor and press F6 to cycle Rear Dual Axle");
			renderText(0.02, 0.60, 0.021, "Leave Tractor and press F8 to cycle Loader Frame");
			renderText(0.02, 0.62, 0.021, "Leave Tractor and press F9 to cycle Front Hitch");
			renderText(0.02, 0.64, 0.021, "Leave Tractor and press T to cycle Controlled Wheel Spacing");
			renderText(0.02, 0.46, 0.021, "Press U to Fold Front Hitch");
			renderText(0.02, 0.44, 0.021, "Press S to turn Seat");
			renderText(0.02, 0.42, 0.021, "Press Z: horn");
			renderText(0.02, 0.36, 0.021, "Press NUM Enter: start/stop motor");
			renderText(0.02, 0.34, 0.021, "Leave Tractor and Press F9: show/hide front hitch");
		end;
	end;
	if self.tractorfunctionsActive then
		renderText(0.76, 0.24, 0.021, "Press T: Tractor Functions Active");
	else
		renderText(0.76, 0.24, 0.021, "Press T: Tractor Functions Inactive");
	end;
end;

function JD_8360R:setFHitch(isFHitchState,noEventSend)
	SetFHitchEvent.sendEvent(self, isFHitchState, noEventSend);
	-- FHitch/Hitch mode --
	self.HitchMode = isFHitchState;
	if self.HitchMode then
		setVisibility(self.FrontHitch, true);
		self.FHitch = true;
	else
		setVisibility(self.FrontHitch, false);
		self.FHitch = false;
	end;
end;
function JD_8360R:setDualRAxle(isDualRAxleState,noEventSend)
	SetDualRAxleEvent.sendEvent(self, isDualRAxleState, noEventSend);
	-- Dual Rear Axle mode --
	self.RAxleMode = isDualRAxleState;
	if self.RAxleMode then
		setVisibility(self.tafeln1, false);
		setVisibility(self.tafeln2, false);
		self.DualRAxle = true;
	else
		setVisibility(self.tafeln1, true);
		setVisibility(self.tafeln2, true);
		self.DualRAxle = false;
	end;
end;
function JD_8360R:setRWFender(isRWFenderState,noEventSend)
	SetRWFenderEvent.sendEvent(self, isRWFenderState, noEventSend);
	-- Dual Rear Axle mode --
	self.RWFenderSMode = isRWFenderState;
	if self.RWFenderSMode then
		setVisibility(self.regfenders, false);
		setVisibility(self.regfenders2, false);
		setVisibility(self.widefenders, true);
		setVisibility(self.widefenders2, true);
		self.RWFender = true;
	else
		setVisibility(self.regfenders, true);
		setVisibility(self.regfenders2, true);
		setVisibility(self.widefenders, false);
		setVisibility(self.widefenders2, false);
		self.RWFender = false;
	end;
end;
function JD_8360R:setLFrame(isLFrameState,noEventSend)
	SetLFrameEvent.sendEvent(self, isLFrameState, noEventSend);
	-- Loader Frame mode --
	self.FrameMode = isLFrameState;
	if self.FrameMode then
		setVisibility(self.loaderframe, true);
		setVisibility(self.fenders, false);
		setVisibility(self.fenders2, false);
		self.LFrame = true;
	else
		setVisibility(self.loaderframe, false);
		setVisibility(self.fenders, true);
		setVisibility(self.fenders2, true);
		self.LFrame = false;
	end;
end;
function JD_8360R:setControlledWheelSpacing(isControlledWheelSpacingState,noEventSend)
	SetControlledWheelSpacingEvent.sendEvent(self, isControlledWheelSpacingState, noEventSend);
	-- ControlledWS mode --
	self.ControlledWSMode = isControlledWheelSpacingState;
	if self.ControlledWSMode then
		setVisibility(self.controlledwheelspacer, false);
		setVisibility(self.controlledwheelspacer2, false);
		setVisibility(self.controlledwheelspacer3, false);
		setVisibility(self.controlledwheelspacer4, false);
		self.ControlledWheelSpacing = true;
	else
		setVisibility(self.controlledwheelspacer, true);
		setVisibility(self.controlledwheelspacer2, true);
		setVisibility(self.controlledwheelspacer3, true);
		setVisibility(self.controlledwheelspacer4, true);
		self.ControlledWheelSpacing = false;
	end;
end;

function JD_8360R:onEnter()
	
end;

function JD_8360R:onLeave()

end;
