
JDFrontWeights = {};

function JDFrontWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JDFrontWeights:load(xmlFile)
	self.extrafrontWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extrafrontWeights#count"), 0);
    self.frontweights = {};
    for i=1, self.extrafrontWeights do
        local frontweightnamei = string.format("vehicle.extrafrontWeights.weight%d", i);
        self.frontweights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, frontweightnamei .. "#index"));
        setVisibility(self.frontweights[i], false);
    end;
	self.setfWeights= SpecializationUtil.callSpecializationsFunction("setFweights");
	
	self.currentfrontWeight = 0;
	self.controlfrontWeight = 0;
	self.singlefrontWeight = 0;
	self.maxfrontWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxfrontWeight#weight"), 1034);
	
	self.tractorfunctionsActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
	self.fWeights = false;
end;

function JDFrontWeights:delete()
end;

function JDFrontWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDFrontWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function JDFrontWeights:update(dt)
	if self.inrange then
	    self.singlefrontWeight = (self.maxfrontWeight / self.extrafrontWeights);
	
		if InputBinding.hasEvent(InputBinding.WEIGHT_ADD_front) then
			if self.currentfrontWeight >= self.maxfrontWeight then
				self.currentfrontWeight = 0;
			else
				self.currentfrontWeight = self.currentfrontWeight + self.singlefrontWeight;
			end;
		end;
		
		if self.frontweights ~= nil then
		    if self.currentfrontWeight ~= self.controlfrontWeight then
		        self.controlfrontWeight = self.currentfrontWeight;
			
			    if self.currentfrontWeight > 0 then
		            for i = 1, self.extrafrontWeights do
				        if i * self.singlefrontWeight <= self.currentfrontWeight then
					        setVisibility(self.frontweights[i], true);
					    end;
				    end;
				else
				    for i = 1, self.extrafrontWeights do
					    setVisibility(self.frontweights[i], false);
					end;
			    end;
		    end;
		end;
		if self.emptyMass == nil then
			self.emptyMass = getMass(self.components[2].node);
			self.currentMass = self.emptyMass;
		end;
		local newMass = self.emptyMass + (self.currentfrontWeight/1000);
		if newMass ~= self.currentMass then
			setMass(self.components[2].node, newMass);
			self.currentMass = newMass;
			for k,v in pairs(self.components) do
				if v.node == self.components[2].node then
					if v.centerOfMass ~= nil then
						setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
					end;
					break;
				end;
			end;
		end;
	end;
	if self.inrange then
		if self.fWeightsMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TAKEOFFFRONTWEIGHTS"), self.typeDesc), InputBinding.WEIGHT_ADD_front);
			renderText(0.42, 0.86, 0.021, "Add Front Weights: " ..string.format("%d lbs", self.currentfrontWeight), InputBinding.WEIGHT_ADD_front);	
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ADDFRONTWEIGHTS"), self.typeDesc), InputBinding.WEIGHT_ADD_front);
			renderText(0.42, 0.86, 0.021, "Add Front Weights: " ..string.format("%d lbs", self.currentfrontWeight), InputBinding.WEIGHT_ADD_front);	
		end;
	end;
end;

function JDFrontWeights:updateTick(dt)
	if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function JDFrontWeights:onLeave()
	
end;

function JDFrontWeights:draw()
	--if self.isEntered then
		--if self.helpPanel then	
			--renderText(0.42, 0.86, 0.021, "Add Front Weights: " ..string.format("%d lbs", self.currentfrontWeight), InputBinding.WEIGHT_ADD_front);			
		--end;
	--end;
end;
