--
-- WarningLight
-- Specialization for WarningLight
-- Spezialisierung fr WarningLight
-- @author  Sven777b And Larsey123
-- 
-- Modifikationen erst nach Rcksprache
--

WarningLight = {};

function WarningLight.prerequisitesPresent(specializations)
    return true;
end;

function WarningLight:load(xmlFile)
		print("specialization WarningLight by Sven777b And Larsey123");
		local i = 0;
		self.WarningLight = {};
    self.WarningLightAn = false;
		while true do
			local WarningLight = {};
			local objname = string.format("vehicle.WarningLight.WarningLight(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then 
      	break;
      end;
      WarningLight = {};
      WarningLight.rotNode = Utils.indexToObject(self.components, rotnode);
      WarningLight.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(WarningLight.rotNode == nil or WarningLight.light == nil) then
      	print("Error: Index ("..rotnode..") zur WarningLight nicht gefunden");
      else
	      WarningLight.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      WarningLight.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (WarningLight.source == nil) then
	      	WarningLight.emit = false;
	      else
      		WarningLight.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not WarningLight.emit then
      			setVisibility(WarningLight.source, false);
      		end;
      	end;
      	table.insert(self.WarningLight, WarningLight);
      end;
      i=i+1;
    end;
    self.WarningLightAnz = table.getn(self.WarningLight);
end;

function WarningLight:delete()
end;

function WarningLight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WarningLight:keyEvent(unicode, sym, modifier, isDown)
end;

function WarningLight:update(dt)
	if self.WarningLightAnz > 0 and self:getIsActive() then
    if InputBinding.hasEvent(InputBinding.WarningLight) then
    	self.WarningLightAn = not self.WarningLightAn;
      for i=1, self.WarningLightAnz do
        setVisibility(self.WarningLight[i].light, self.WarningLightAn);
      end;
    end;
    if self.WarningLightAn then
      for i=1, self.WarningLightAnz do
        rotate(self.WarningLight[i].rotNode, 0, dt*self.WarningLight[i].speed, 0);
      end;
    end;
  end;
end;

function WarningLight:draw()
    if self.WarningLightAnz > 0 and self:getIsActive() then
    		g_currentMission:addHelpButtonText(g_i18n:getText("WarningLight"), InputBinding.WarningLight);
    end;
end;

