--JD2058
--hz888


JD2058 = {};

function JD2058.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD2058:load(xmlFile)

    self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));
    if self.pipeLight ~= nil then
	setVisibility(self.pipeLight, false);
    end;
    self.pipeLightActive = false;
    self.balcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balcamera#index"));
    self.jobbcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.jobbcamera#index"));

    local lepcsoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lepcso#index"));
    if lepcsoNode ~= nil then
        self.lepcso = {};
        self.lepcso.node = lepcsoNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lepcso#minRot"));
        self.lepcso.minRot = {};
        self.lepcso.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lepcso.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lepcso.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lepcso#maxRot"));
        self.lepcso.maxRot = {};
        self.lepcso.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lepcso.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lepcso.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.lepcso.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lepcso#rotTime"), 2)*1000;
        self.lepcso.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.lepcso#touchRotLimit"), 10));
    end;	

end;

function JD2058:delete()

end;

function JD2058:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD2058:keyEvent(unicode, sym, modifier, isDown)
end;

function JD2058:update(dt)

	if self.isEntered then
		if self.camIndex == 2 then

    			if self.motorSound ~= nil then
				setSampleVolume(self.motorSound, self.motorSoundVolume/2);
   			end;
    			if self.motorSoundRun ~= nil then
				setSampleVolume(self.motorSoundRun, self.motorSoundRunVolume/2);
    			end;
    			if self.motorStartSound ~= nil then
				setSampleVolume(self.motorStartSound, self.motorStartSoundVolume/2);
    			end;
    			if self.motorStopSound ~= nil then
				setSampleVolume(self.motorStopSound, self.motorStopSoundVolume/2);
    			end;
    			if self.reverseDriveSound ~= nil then
				setSampleVolume(self.reverseDriveSound, self.reverseDriveSoundVolume/2);
    			end;
    			if self.compressedAirSound ~= nil then
				setSampleVolume(self.compressedAirSound, self.compressedAirSoundVolume/2);
    			end;
    			if self.compressionSound ~= nil then
				setSampleVolume(self.compressionSound, self.compressionSoundVolume/2);
    			end;
    			if self.aiMotorSound ~= nil then
				setSampleVolume(self.aiMotorSound, self.aiMotorSoundVolume/2);
    			end;
    			if self.aiThreshingSound ~= nil then
				setSampleVolume(self.aiThreshingSound, self.aiThreshingSoundVolume/2);
    			end;
    			if self.pipeSound ~= nil then
				setSampleVolume(self.pipeSound, 0.5);
    			end;
    			if self.threshingStartSound ~= nil then
				setSampleVolume(self.threshingStartSound, 0.5);
    			end;
    			if self.threshingSound ~= nil then
				setSampleVolume(self.threshingSound, 0.5);
    			end;
    			if self.cutterthreshingSound ~= nil then
				setSampleVolume(self.cutterthreshingSound, self.cutterthreshingSoundVolume/2);
    			end;
    			if self.threshingStopSound ~= nil then
				setSampleVolume(self.threshingStopSound, 0.5);
    			end;
    			if self.attachSound ~= nil then
				setSampleVolume(self.attachSound, 0.5);
    			end;
    			if self.honkSound ~= nil then
				setSampleVolume(self.honkSound, self.honkSoundVolume/2);
   			end;
		else
    			if self.motorSound ~= nil then
				setSampleVolume(self.motorSound, self.motorSoundVolume);
   			end;
     			if self.motorSoundRun ~= nil then
				setSampleVolume(self.motorSoundRun, self.motorSoundRunVolume);
    			end;
    			if self.motorStartSound ~= nil then
				setSampleVolume(self.motorStartSound, self.motorStartSoundVolume);
    			end;
    			if self.motorStopSound ~= nil then
				setSampleVolume(self.motorStopSound, self.motorStopSoundVolume);
    			end;
    			if self.reverseDriveSound ~= nil then
				setSampleVolume(self.reverseDriveSound, self.reverseDriveSoundVolume);
    			end;
    			if self.compressedAirSound ~= nil then
				setSampleVolume(self.compressedAirSound, self.compressedAirSoundVolume);
    			end;
    			if self.compressionSound ~= nil then
				setSampleVolume(self.compressionSound, self.compressionSoundVolume);
    			end;
    			if self.aiMotorSound ~= nil then
				setSampleVolume(self.aiMotorSound, self.aiMotorSoundVolume);
    			end;
    			if self.aiThreshingSound ~= nil then
				setSampleVolume(self.aiThreshingSound, self.aiThreshingSoundVolume);
    			end;
    			if self.pipeSound ~= nil then
				setSampleVolume(self.pipeSound, 1);
    			end;
    			if self.threshingStartSound ~= nil then
				setSampleVolume(self.threshingStartSound, 1);
    			end;
    			if self.threshingSound ~= nil then
				setSampleVolume(self.threshingSound, 1);
    			end;
    			if self.cutterthreshingSound ~= nil then
				setSampleVolume(self.cutterthreshingSound, self.cutterthreshingSoundVolume);
    			end;
    			if self.threshingStopSound ~= nil then
				setSampleVolume(self.threshingStopSound, 1);
    			end;
    			if self.attachSound ~= nil then
				setSampleVolume(self.attachSound, 1);
    			end;
    			if self.honkSound ~= nil then
				setSampleVolume(self.honkSound, self.honkSoundVolume);
   			end;
		end;
		if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
			if g_currentMission.environment.isSunOn then
				self.pipeLightActive = false;
			else
				self.pipeLightActive = not self.pipeLightActive;
			end;
		end;
        	if Input.isKeyPressed(Input.KEY_shift) and self.camIndex == 2 then
                	setCamera(self.balcamera);
       		end;
        	if Input.isKeyPressed(60) and self.camIndex == 2 then
                	setCamera(self.jobbcamera);
       		end;
        	if self.pipeLight ~= nil then
            		if self.pipeLightActive then
            			setVisibility(self.pipeLight, self.pipeLightActive);
	    		else
            			setVisibility(self.pipeLight, self.pipeLightActive);
	    		end;
        	end;
		if self.lepcso ~= nil then
			local x, y, z = getRotation(self.lepcso.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.lepcso.maxRot, self.lepcso.minRot, 3, self.lepcso.rotTime, dt, not self.lepcsoMax);
			setRotation(self.lepcso.node, unpack(newRot));
		end;
		if self.numAttachedCutters == 0 then
			self.lepcsoMax = true;
		else
    			self.lepcsoMax = false;
		end;

	end;	
   		if (self.grainTankFillLevel >= self.grainTankCapacity*0.8) and not self.autoBeacon then
          self:setBeaconLightsVisibility(true);
          self.autoBeacon=true;
        end;                                    
        
        if (self.grainTankFillLevel < self.grainTankCapacity*0.8) and self.autoBeacon then
          self:setBeaconLightsVisibility(false);
          self.autoBeacon = false;
        end;        
end;

function JD2058:draw()  
end;

function JD2058:onEnter()

    self.lepcsoMax = true;

end;

function JD2058:onLeave()

    self.lepcsoMax = false;
    if self.pipeLight ~= nil then
    	setVisibility(self.pipeLight, false);
    end;
    setRotation(self.lepcso.node, 0, 0, 0);
end;