--
-- Specialization for a baler.
--
-- @author  Stefan Geiger
-- @date  10/09/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
-- >><<--
-- McHale F550
--
-- author  	LS-UK Modteam 
-- date  	28-06-2011
-- www.ls-uk.info/modteam
-- ALL RIGHTS RESERVED
  

McHale_F550 = {};
  
McHale_F550.UNLOADING_CLOSED = 1;
McHale_F550.UNLOADING_OPENING = 2;
McHale_F550.UNLOADING_OPEN = 3;
McHale_F550.UNLOADING_CLOSING = 4;
  
function McHale_F550.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(PowerShaft, specializations);
end;
  
function McHale_F550:load(xmlFile)
  
      self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
 	  self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	  self.saveMinRpm = 0; 
      self.getTimeFromLevel = McHale_F550.getTimeFromLevel;
      self.moveBales = SpecializationUtil.callSpecializationsFunction("moveBales");
      self.moveBale = SpecializationUtil.callSpecializationsFunction("moveBale");
      self.allowFillType = McHale_F550.allowFillType;
      self.allowPickingUp = McHale_F550.allowPickingUp;
      self.setIsUnloadingBale = McHale_F550.setIsUnloadingBale;
 
      self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
  
     local firstBaleMarker = getXMLFloat(xmlFile, "vehicle.baleAnimation#firstBaleMarker");
      if firstBaleMarker ~= nil then
          local baleAnimCurve = AnimCurve:new(linearInterpolatorN);
          local keyI = 0;
          while true do
              local key = string.format("vehicle.baleAnimation.key(%d)", keyI);
              local t = getXMLFloat(xmlFile, key.."#time");
              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#pos"));
              if x == nil or y == nil or z == nil then
                  break;
              end;
              local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rot"));
              rx = math.rad(Utils.getNoNil(rx, 0));
              ry = math.rad(Utils.getNoNil(ry, 0));
              rz = math.rad(Utils.getNoNil(rz, 0));
              baleAnimCurve:addKeyframe({ v={x, y, z, rx, ry, rz}, time = t});
              keyI = keyI +1;
          end;
          if keyI > 0 then
              self.baleAnimCurve = baleAnimCurve;
              self.firstBaleMarker = firstBaleMarker;
              --self.baleFilename = Utils.getNoNil(getXMLString(xmlFile, "vehicle.baleAnimation#filename"), "data/maps/models/objects/strawbale/strawbaleBaler.i3d");
          end;
      end;
      self.baleAnimRoot = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleAnimation#node")), self.components[1].node);
  
      -- there is no standard bale animation, load the unload animation (for round baler)
      if self.firstBaleMarker == nil then
          local unloadAnimationName = getXMLString(xmlFile, "vehicle.baleAnimation#unloadAnimationName");
          local closeAnimationName = getXMLString(xmlFile, "vehicle.baleAnimation#closeAnimationName");
          local unloadAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.baleAnimation#unloadAnimationSpeed"), 1);
          local closeAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.baleAnimation#closeAnimationSpeed"), 1);
          if unloadAnimationName ~= nil and closeAnimationName ~= nil then
              if self.playAnimation ~= nil and self.animations ~= nil then
                  if self.animations[unloadAnimationName] ~= nil and self.animations[closeAnimationName] ~= nil then
                      --print("has unload animation");
                      self.baleUnloadAnimationName = unloadAnimationName;
                      self.baleUnloadAnimationSpeed = unloadAnimationSpeed;
  
                      self.baleCloseAnimationName = closeAnimationName;
                      self.baleCloseAnimationSpeed = closeAnimationSpeed;
  
                      self.baleDropAnimTime = getXMLFloat(xmlFile, "vehicle.baleAnimation#baleDropAnimTime");
                      if self.baleDropAnimTime == nil then
                          self.baleDropAnimTime = self:getAnimationDuration(self.baleUnloadAnimationName);
                     else
                          self.baleDropAnimTime = self.baleDropAnimTime * 1000;
                      end;
                  else
                      print("Error: Failed to find unload animations '"..unloadAnimationName.."' and '"..closeAnimationName.."' in '"..self.configFileName.."'.");
                  end;
              else
                  print("Error: There is an unload animation in '"..self.configFileName.."' but it is not a AnimatedVehicle. Change to a vehicle type which has the AnimatedVehicle specialization.");
              end;
          end;
      end;
  
      self.baleTypes = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.baleTypes.baleType(%d)", i);
          local t = getXMLString(xmlFile, key.."#fruitType");
          local filename = getXMLString(xmlFile, key.."#filename");
          if t==nil or filename==nil then
              break;
          end;
  
          local entry = {};
          entry.filename = filename;
          local desc = FruitUtil.fruitTypes[t];
          if desc ~= nil then
              self.baleTypes[desc.index] = entry;
  
              if self.defaultBaleType == nil then
                  self.defaultBaleType = entry;
              end;
          end;
          i = i +1;
      end;
      if self.defaultBaleType == nil then
          self.baleTypes = nil;
      end;
  
      local balerSound = getXMLString(xmlFile, "vehicle.balerSound#file");
      if balerSound ~= nil and balerSound ~= "" then
          balerSound = Utils.getFilename(balerSound, self.baseDirectory);
          self.balerSound = createSample("balerSound");
          self.balerSoundEnabled = false;
          loadSample(self.balerSound, balerSound, false);
          self.balerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerSound#pitchOffset"), 1);
          self.balerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerSound#volume"), 1);
      end;
  
      local balerAlarm = getXMLString(xmlFile, "vehicle.balerAlarm#file");
      if balerAlarm ~= nil and balerAlarm ~= "" then
          balerAlarm = Utils.getFilename(balerAlarm, self.baseDirectory);
          self.balerAlarm = createSample("balerAlarm");
          self.balerAlarmEnabled = false;
          loadSample(self.balerAlarm, balerAlarm, false);
          self.balerAlarmPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAlarm#pitchOffset"), 1);
          self.balerAlarmVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerAlarm#volume"), 1);
      end;
  
  	local balerBaleEject = getXMLString(xmlFile, "vehicle.balerBaleEject#file");
      if balerBaleEject ~= nil and balerBaleEject ~= "" then
          balerBaleEject = Utils.getFilename(balerBaleEject, self.baseDirectory);
          self.balerBaleEject = createSample("balerBaleEject");
          self.balerBaleEjectEnabled = false;
          loadSample(self.balerBaleEject, balerBaleEject, false);
          self.balerBaleEjectPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerBaleEject#pitchOffset"), 1);
          self.balerBaleEjectVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerBaleEject#volume"), 1);
      end;
  
  	local balerDoor = getXMLString(xmlFile, "vehicle.balerDoor#file");
      if balerDoor ~= nil and balerDoor ~= "" then
          balerDoor = Utils.getFilename(balerDoor, self.baseDirectory);
          self.balerDoor = createSample("balerDoor");
          self.balerDoorEnabled = false;
          loadSample(self.balerDoor, balerDoor, false);
          self.balerDoorPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerDoor#pitchOffset"), 1);
          self.balerDoorVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerDoor#volume"), 1);
      end;
  
 	local balerKnotCleaning = getXMLString(xmlFile, "vehicle.balerKnotCleaning#file");
     if balerKnotCleaning ~= nil and balerKnotCleaning ~= "" then
          balerKnotCleaning = Utils.getFilename(balerKnotCleaning, self.baseDirectory);
         self.balerKnotCleaning = createSample("balerKnotCleaning");
          self.balerKnotCleaningEnabled = false;
  		self.balerKnotCleaningTime = 100000;
          loadSample(self.balerKnotCleaning, balerKnotCleaning, false);
          self.balerKnotCleaningPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerKnotCleaning#pitchOffset"), 1);
          self.balerKnotCleaningVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerKnotCleaning#volume"), 1);
      end;
  
      self.balerUVScrollParts = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.balerUVScrollParts.balerUVScrollPart(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
          if node ~= nil and speed then
              table.insert(self.balerUVScrollParts, {node=node, speed=speed});
          end;
          i = i +1;
      end;

	  self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, McHale_F550.getIsAreaActive);	
	  self.setTransRot = SpecializationUtil.callSpecializationsFunction("setTransRot");
	  self.TransRotAnimation = getXMLString(xmlFile, "vehicle.TransRot#animationName");
	  self.TransRot = false;

	  self.balerParticleSystems = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.balerParticleSystems.balerParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.balerParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
      end;

      self.rollNodes = {};
      
      local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
      if rollNode ~= nil then
          local speed = 0.003*3;
          table.insert(self.rollNodes, {node=rollNode, speed=speed});
      end;
      local i = 0;
      while true do
          local key = string.format("vehicle.rolls.roll(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
          if rollNode ~= nil then
              table.insert(self.rollNodes, {node=rollNode, speed=speed});
          end;
          i = i + 1;
      end;
	  
     self.speedRotatingParts = {};
     local i=0;
     while true do
          local baseName = string.format("vehicle.speedRotatingParts.speedRotatingPart(%d)", i);
          local index = getXMLString(xmlFile, baseName.. "#index");
          if index == nil then
              break;
          end;
          local node = Utils.indexToObject(self.components, index);
          if node ~= nil then
              local entry = {};
              entry.node = node;
              entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
              if entry.rotationSpeedScale == nil then
                  entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
              end;
  
  
              table.insert(self.speedRotatingParts, entry);
          end;
          i = i+1;
      end;

      self.setWheel = SpecializationUtil.callSpecializationsFunction("setWheel");

      self.wheel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickupWheels#index1"));
      self.wheel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pickupWheels#index2"));
      self.wheelId = 0;
	  
      self.printWarningTime = 0;
      self.baleLastPositionTime = 0;
  
      self.balerUnloadingState = McHale_F550.UNLOADING_CLOSED;
  
      self.bales = {};
      self.wasToFast = false;
      self.isTurnedOn = false;

	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

	self.brakelightsActive = false;
    self.braking = false;	
end;
  
function McHale_F550:delete()
	if self.balerSound ~= nil then
		delete(self.balerSound);
		self.balerSoundEnabled = false;
	end;
  	if self.balerAlarm ~= nil then
          delete(self.balerAlarm);
          self.balerAlarmEnabled = false;
      end;
  	if self.balerBaleEject ~= nil then
          delete(self.balerBaleEject);
          self.balerBaleEjectEnabled = false;
      end;
  	if self.balerDoor ~= nil then
          delete(self.balerDoor);
          self.balerDoorEnabled = false;
      end;
  	if self.balerKnotCleaning ~= nil then
          delete(self.balerKnotCleaning);
          self.balerKnotCleaningEnabled = false;
      end;
	Utils.deleteParticleSystem(self.balerParticleSystems);
end;
  
function McHale_F550:readStream(streamId, connection)
      local turnedOn = streamReadBool(streamId);
      self:setIsTurnedOn(turnedOn, true);
      local numBales = streamReadInt16(streamId);
      for i=1, numBales do
          local fruitType = streamReadInt8(streamId);
          McHale_F550.createBale(self, fruitType);
          if self.baleAnimCurve ~= nil then
              local baleTime = streamReadFloat32(streamId);
              McHale_F550.setBaleTime(self, i, baleTime);
          end;
      end;
	self:setTransRot(streamReadBool(streamId), true);
	self:setWheel(streamReadInt8(streamId), true);
end;
  
function McHale_F550:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
      streamWriteInt16(streamId, table.getn(self.bales));
      for i=1, table.getn(self.bales) do
          local bale = self.bales[i];
          streamWriteInt8(streamId, bale.fruitType);
          if self.baleAnimCurve ~= nil then
              streamWriteFloat32(streamId, bale.time);
          end;
      end;
    streamWriteBool(streamId, self.TransRot);
	streamWriteInt8(streamId, self.wheelId);
end;
  
function McHale_F550:readUpdateStream(streamId, timestamp, connection)
end;
  
function McHale_F550:writeUpdateStream(streamId, connection, dirtyMask)
end;
  
function McHale_F550:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
      local numBales = getXMLInt(xmlFile, key.."#numBales");
      if numBales ~= nil then
          for i=1, numBales do
              local baleKey = key..string.format(".bale(%d)", i-1);
  
              local fruitType = getXMLString(xmlFile, baleKey.."#fruitType");
              local baleTime = getXMLFloat(xmlFile, baleKey.."#baleTime");
              if fruitType ~= nil and (baleTime ~= nil or self.baleAnimCurve == nil) then
                  local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
                  if fruitTypeDesc ~= nil then
                      McHale_F550.createBale(self, fruitTypeDesc.index);
                      if self.baleAnimCurve ~= nil then
                          McHale_F550.setBaleTime(self, table.getn(self.bales), baleTime);
                      end;
                  end;
              end;
          end;
      end;
      return BaseMission.VEHICLE_LOAD_OK;
end
  
function McHale_F550:getSaveAttributesAndNodes(nodeIdent)
  
      local attributes = 'numBales="'..table.getn(self.bales)..'"';
      local nodes = "";
      local baleNum = 0;
  
      for i=1, table.getn(self.bales) do
          local bale = self.bales[i];
          local fruitType = "unknown";
          if bale.fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
              fruitType = FruitUtil.fruitIndexToDesc[bale.fruitType].name;
          end;
  
          if baleNum>0 then
              nodes = nodes.."\n";
          end;
          nodes = nodes..nodeIdent..'<bale fruitType="'..fruitType..'"';
          if self.baleAnimCurve ~= nil then
              nodes = nodes..' baleTime="'..bale.time..'"';
          end;
          nodes = nodes..' />';
          baleNum = baleNum+1;
      end;
      return attributes,nodes;
end;
  
function McHale_F550:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function McHale_F550:keyEvent(unicode, sym, modifier, isDown)
  end;
  
function McHale_F550:update(dt)
  
	if self:getIsActiveForInput() then
		if not self.PTOId then

			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.attacherVehicle.isMotorStarted then
				self:setIsTurnedOn(not self.isTurnedOn);

			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.baleUnloadAnimationName ~= nil then
				if self.balerUnloadingState == McHale_F550.UNLOADING_CLOSED then
					if table.getn(self.bales) > 0 then
						self:setIsUnloadingBale(true);
					end;
				elseif self.balerUnloadingState == McHale_F550.UNLOADING_OPEN then
					self:setIsUnloadingBale(false);
				end;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setTransRot(not self.isTransRotOn);
		end;
		if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
			self.printWarningTime = self.time + 1500;
		end;
	end;
	
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(inputAxisY) then
		inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;
	
	if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
	end;
end;
  
function McHale_F550:updateTick(dt)
	self.wasToFast = false;
	

	if self:getIsActive() then
	if not self.attacherVehicle.isMotorStarted then
		self.isTurnedOn = false;
	end;
	if self.PTOId then
		self.isTurnedOn = false;
	end;
		local isKeyEvent = false;	
		if self.isTurnedOn then
 			isKeyEvent = true;	
		else
 			isKeyEvent = false;	
		end;
		self:setVehicleRpmUp(dt, isKeyEvent);	
		if self.isTurnedOn then
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
			if not toFast then
				if self.isServer and self:allowPickingUp() then
					local totalArea =0;
					local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
  
					local fruitTypes = {};
					for fillType,enabled in pairs(self.fillTypes) do
						if enabled then
							local fruitType = FruitUtil.fillTypeToFruitType[fillType];
							if fruitType ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
								table.insert(fruitTypes, fruitType);
							end;
						end;
					end;
					if table.getn(fruitTypes) > 0 then
  
						local cuttingAreasSend = {};
						for k, cuttingArea in pairs(self.cuttingAreas) do
							if self:getIsAreaActive(cuttingArea) then
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
  
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							end;
						end;
						if table.getn(cuttingAreasSend) > 0 then
  
							totalArea, usedFruitType = BalerAreaEvent.runLocally(cuttingAreasSend, fruitTypes);
							if totalArea > 0 then
								if (table.getn(cuttingAreasSend) > 0) then
									g_server:broadcastEvent(BalerAreaEvent:new(cuttingAreasSend, fruitTypes));
								end;
							end;
						end;
					end;
  
					if totalArea > 0 then
						local literPerPixel = g_currentMission:getFruitPixelsToSqm()*g_strawLitersPerSqm;  --8000/1200 / 6 / (2*2) *12/4 / 4;
  
						local deltaLevel = totalArea * literPerPixel * self.fillScale;
  
						if self.baleUnloadAnimationName == nil then
                              -- move all bales
							local deltaTime = self:getTimeFromLevel(deltaLevel);
							self:moveBales(deltaTime);
						end;
  
						local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];
  
						local oldFillLevel = self.fillLevel;
						self:setFillLevel(self.fillLevel+deltaLevel, usedFillType);
						if self.fillLevel == self.capacity then
							if self.baleTypes ~= nil then
                               -- create bale
								if self.baleAnimCurve ~= nil then
									local restDeltaFillLevel = deltaLevel - (self.fillLevel-oldFillLevel)
									self:setFillLevel(restDeltaFillLevel, usedFillType);
  
									McHale_F550.createBale(self, usedFruitType);
  
									local numBales = table.getn(self.bales);
									local bale = self.bales[numBales]
  
									self:moveBale(numBales, self:getTimeFromLevel(restDeltaFillLevel), true);
                                      -- note: self.bales[numBales] can not be accessed anymore since the bale might be dropped already
									g_server:broadcastEvent(BalerCreateBaleEvent:new(self, usedFruitType, bale.time), nil, nil, self);
								elseif self.baleUnloadAnimationName ~= nil then
  
									McHale_F550.createBale(self, usedFruitType);
									g_server:broadcastEvent(BalerCreateBaleEvent:new(self, usedFruitType, 0), nil, nil, self);
								end;
							end;
						end;
					end;
				end;
			end;

			if self.isClient then
				if self.balerKnotCleaning ~= nil and self.balerKnotCleaningTime <= self.time and self:getIsActiveForSound() then
					playSample(self.balerKnotCleaning, 1, self.balerKnotCleaningVolume, 0);
					setSamplePitch(self.balerKnotCleaning, self.balerKnotCleaningPitchOffset);
					self.balerKnotCleaningTime = self.time + 120000;
					self.balerKnotCleaningEnabled = true;
				end;
  
				if not self.balerSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.balerSound, self.balerSoundPitchOffset);
					playSample(self.balerSound, 0, self.balerSoundVolume, 0);
					self.balerSoundEnabled = true;
				end;
			end;
			  
			for _, rollNode in pairs(self.rollNodes) do
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;	
  
			self.wasToFast = toFast;
		end;
		if self.isClient then
			if not self.isTurnedOn and self.balerSoundEnabled then
				stopSample(self.balerSound);
				self.balerSoundEnabled = false;
			end;
		end;
  
  
		if self.isTurnedOn and self.fillLevel > (self.capacity * 0.93) and self.fillLevel < self.capacity then
              -- start alarm sound
			if not self.balerAlarmEnabled and self:getIsActiveForSound() then
				setSamplePitch(self.balerAlarm, self.balerAlarmPitchOffset);
				playSample(self.balerAlarm, 0, self.balerAlarmVolume, 0);
				self.balerAlarmEnabled = true;
			end;
        else
              -- stop alarm sound
			if self.balerAlarmEnabled then
				stopSample(self.balerAlarm);
				self.balerAlarmEnabled = false;
			end;
		end;
  
		if self.balerUnloadingState == McHale_F550.UNLOADING_OPENING then
			if not self.balerBaleEjectEnabled and self:getIsActiveForSound() then
				setSamplePitch(self.balerBaleEject, self.balerBaleEjectPitchOffset);
  				playSample(self.balerBaleEject, 1, self.balerBaleEjectVolume, 0);
  				self.balerBaleEjectEnabled = true;
  			end;
  			if not self.balerDoorEnabled and self:getIsActiveForSound() then
  				setSamplePitch(self.balerDoor, self.balerDoorPitchOffset);
  				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
  				self.balerDoorEnabled = true;
  			end;
			local isPlaying = self:getIsAnimationPlaying(self.baleUnloadAnimationName);
			local animTime = self:getRealAnimationTime(self.baleUnloadAnimationName);
			if not isPlaying or animTime >= self.baleDropAnimTime then
				if table.getn(self.bales) > 0 then
					McHale_F550.dropBale(self, 1);
					if self.isServer then
						self:setFillLevel(0, self.currentFillType);
					end;
                end;
				if not isPlaying then
					self.balerUnloadingState = McHale_F550.UNLOADING_OPEN;
  
					if self.balerBaleEjectEnabled then
						stopSample(self.balerBaleEject);
  						self.balerBaleEjectEnabled = false;
  					end;
  					if self.balerDoorEnabled then
  						stopSample(self.balerDoor);
  						self.balerDoorEnabled = false;
  					end;
				end;
			end;
		elseif self.balerUnloadingState == McHale_F550.UNLOADING_CLOSING then
  
  			if not self.balerDoorEnabled and self:getIsActiveForSound() then
  				setSamplePitch(self.balerDoor, self.balerDoorPitchOffset);
  				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
  				self.balerDoorEnabled = true;
  			end;
			if not self:getIsAnimationPlaying(self.baleCloseAnimationName) then
				self.balerUnloadingState = McHale_F550.UNLOADING_CLOSED;
			end;
  
  			if not self.balerDoorEnabled and self:getIsActiveForSound() then
  				setSamplePitch(self.balerDoor, self.balerDoorPitchOffset);
  				playSample(self.balerDoor, 1, self.balerDoorVolume, 0);
  				self.balerDoorEnabled = true;
  			end;

  		elseif self.balerUnloadingState == McHale_F550.UNLOADING_CLOSING then
  			if self.balerDoorEnabled then
  				stopSample(self.balerDoor);
  				self.balerDoorEnabled = false;
  			end;
		end;
		if self.isServer then
			if self.time > self.baleLastPositionTime+100 then
				for i=1, table.getn(self.bales) do
					local bale = self.bales[i];
					bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
				end;
				self.baleLastPositionTime = self.time;
			end;
		end;
		if self.isTurnedOn and self.isTransRotOn and self.movingDirection ~= 0 then
				Utils.setEmittingState(self.balerParticleSystems, true);
			else
				Utils.setEmittingState(self.balerParticleSystems, false);
		end;

        for k,v in pairs(self.speedRotatingParts) do
            if self.isTransRotOn and self.movingDirection ~= 0 then
               rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
            end;                    
        end;
		for _, part in pairs(self.balerUVScrollParts) do
			if self.isTurnedOn and self.fillLevel > (self.capacity * 0.92) and self.fillLevel < self.capacity then
				setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
			else
				setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
			end;
		end;
		if not self.PTOId then
			if self.isTransRotOn then
				setVisibility(self.wheel1, true);
				setVisibility(self.wheel2, false);
			end;
			if not self.isTurnedOn then
				if not self.isTransRotOn then
					setVisibility(self.wheel1, false);
					setVisibility(self.wheel2, true);
				else
					setVisibility(self.wheel1, true);
					setVisibility(self.wheel2, false);
				end;
			end;
		else
			if self.isTransRotOn then
				setVisibility(self.wheel1, true);
				setVisibility(self.wheel2, false);
			else
				setVisibility(self.wheel1, false);
				setVisibility(self.wheel2, true);
			end;
		end;
	end;
end;
  
function McHale_F550:draw()
	if self.isClient then
		if self.wasToFast then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
		end;
		if not self.PTOId then
			if self.isTurnedOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			end;
		end;  
		if self.baleUnloadAnimationName ~= nil then
			if self.balerUnloadingState == McHale_F550.UNLOADING_CLOSED then
				if table.getn(self.bales) > 0 then
					g_currentMission:addHelpButtonText(g_i18n:getText("baler_unload"), InputBinding.IMPLEMENT_EXTRA2);
				end;
			elseif self.balerUnloadingState == McHale_F550.UNLOADING_OPEN then
				g_currentMission:addHelpButtonText(g_i18n:getText("baler_unload_stop"), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
        if self.isTransRotOn then
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
        else
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FIELD"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
        end;
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
	
end;

function McHale_F550:onDetach()
	if self.deactivateOnDetach then
		McHale_F550.onDeactivate(self);
	else
		McHale_F550.onDeactivateSounds(self);
	end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

 function McHale_F550:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end; 

function McHale_F550:onLeave()
	if self.deactivateOnLeave then
		McHale_F550.onDeactivate(self);
	else
		McHale_F550.onDeactivateSounds(self);
	end;
	if self.balerParticleSystems ~= nil then
		Utils.setEmittingState(self.balerParticleSystems, false);
	end; 

end;
  
function McHale_F550:onDeactivate()
	for _, part in pairs(self.balerUVScrollParts) do
		setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
	end;
	self.wasToFast = false;
	self.isTurnedOn = false;
	McHale_F550.onDeactivateSounds(self)
 	if self.balerParticleSystems ~= nil then
		Utils.setEmittingState(self.balerParticleSystems, false);
	end; 
end;
  
function McHale_F550:onDeactivateSounds()
	if self.balerSoundEnabled then
		stopSample(self.balerSound);
		self.balerSoundEnabled = false;
	end;
	if self.balerAlarmEnabled then
		stopSample(self.balerAlarm);
		self.balerAlarmEnabled = false;
	end;
  	if self.balerBaleEjectEnabled then
		stopSample(self.balerBaleEject);
		self.balerBaleEjectEnabled = false;
	end;
  	if self.balerDoorEnabled then
		stopSample(self.balerDoor);
		self.balerDoorEnabled = false;
	end;
  	if self.balerKnotCleaningEnabled then
		stopSample(self.balerKnotCleaning);
		self.balerKnotCleaningEnabled = false;
	end;
end;
  
function McHale_F550:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
end;
  
function McHale_F550:setIsUnloadingBale(isUnloadingBale, noEventSend)
	if self.baleUnloadAnimationName ~= nil then
		if isUnloadingBale then
			if self.balerUnloadingState ~= McHale_F550.UNLOADING_OPENING then
				BalerSetIsUnloadingBaleEvent.sendEvent(self, isUnloadingBale, noEventSend)
				self.balerUnloadingState = McHale_F550.UNLOADING_OPENING;
				self:playAnimation(self.baleUnloadAnimationName, self.baleUnloadAnimationSpeed, nil, true);
			end;
		else
			if self.balerUnloadingState ~= McHale_F550.UNLOADING_CLOSING then
				BalerSetIsUnloadingBaleEvent.sendEvent(self, isUnloadingBale, noEventSend)
				self.balerUnloadingState = McHale_F550.UNLOADING_CLOSING;
				self:playAnimation(self.baleCloseAnimationName, self.baleCloseAnimationSpeed, nil, true);
			end;
		end;
	end;
end;
  
function McHale_F550:getTimeFromLevel(level)
      -- level = capacity -> time = firstBaleMarker
      -- level = 0           -> time = 0
	if self.firstBaleMarker ~= nil then
		return level / self.capacity * self.firstBaleMarker;
	end;
	return 0;
end;
  
function McHale_F550:moveBales(dt)
	for i=table.getn(self.bales), 1, -1 do
		self:moveBale(i, dt);
	end;
end;
  
function McHale_F550:moveBale(i, dt, noEventSend)
	local bale = self.bales[i];
	McHale_F550.setBaleTime(self, i, bale.time + dt, noEventSend)
end;
  
function McHale_F550.setBaleTime(self, i, baleTime, noEventSend)
	if self.baleAnimCurve ~= nil then
		local bale = self.bales[i];
		bale.time = baleTime;
		local v = self.baleAnimCurve:get(bale.time);
		setTranslation(bale.id, v[1], v[2], v[3]);
		setRotation(bale.id, v[4], v[5], v[6]);
		if bale.time >= 1 then
			McHale_F550.dropBale(self, i);
		end;
		if self.isServer then
			if noEventSend == nil or not noEventSend then
				g_server:broadcastEvent(BalerSetBaleTimeEvent:new(self, i, bale.time), nil, nil, self);
			end;
		end;
	end;
end;
  
  -- overwrite Fillable.allowFillType
function McHale_F550:allowFillType(fillType)
	return self.fillTypes[fillType] == true;
end;
  
function McHale_F550:allowPickingUp()
	if self.baleUnloadAnimationName == nil then
		return true;
	end;
	return table.getn(self.bales) == 0 and self.balerUnloadingState == McHale_F550.UNLOADING_CLOSED;
end;
  
function McHale_F550.createBale(self, usedFruitType)
	local baleType = self.baleTypes[usedFruitType];
	if baleType == nil then
		baleType = self.defaultBaleType;
	end;
	local baleRoot = Utils.loadSharedI3DFile(baleType.filename, self.baseDirectory);
  
	local baleId = getChildAt(baleRoot, 0);
	setRigidBodyType(baleId, "None");
	link(self.baleAnimRoot, baleId);
	delete(baleRoot);
  
	local bale = {};
	bale.id = baleId;
	bale.time = 0;
	bale.fruitType = usedFruitType;
	bale.filename = Utils.getFilename(baleType.filename, self.baseDirectory);
	bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
	table.insert(self.bales, bale);
	local i = table.getn(self.bales);
end;
   
function McHale_F550.dropBale(self, baleIndex)       local bale = self.bales[baleIndex];
	local deltaRealTime = (self.time - self.baleLastPositionTime)/1000;
	local x,y,z = getWorldTranslation(bale.id);
	local rx,ry,rz = getWorldRotation(bale.id);
      --link(getRootNode(), bale.id);
  
 
	if self.isServer then
		local baleObject = Bale:new(self.isServer, self.isClient);
		baleObject:load(bale.filename, x,y,z,rx,ry,rz);
		baleObject:register();
  
		local lx, ly, lz = bale.lastX, bale.lastY, bale.lastZ;
		setLinearVelocity(baleObject.nodeId, (x-lx)/deltaRealTime, (y-ly)/deltaRealTime, (z-lz)/deltaRealTime);
	end;
	delete(bale.id);
	table.remove(self.bales, baleIndex);
  
      -- increase bale count if variable exists (baling mission)
	if g_currentMission.baleCount ~= nil then
		g_currentMission.baleCount = g_currentMission.baleCount + 1;
	end;
end;

function McHale_F550:setTransRot(isTransRot,noEventSend)
	SetTransRotEvent.sendEvent(self, isTransRot, noEventSend);
	-- Play TransRot animation --
	self.isTransRotOn = isTransRot;
	if self.isTransRotOn then
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, 1, nil, true);
			self.TransRot = true;

		end;
	else
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, -1, nil, true);
			self.TransRot = false;
	
		end;
	end;
end;

function McHale_F550:setWheel(wheel, noEventSend)
	PickupWheelEvent.sendEvent(self, wheel, noEventSend);

	setVisibility(self.wheel1, wheel == 1);
	setVisibility(self.wheel2, wheel == 0);
	self.wheelId = wheel;
end;

function McHale_F550:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
			return superFunc(self, area) and self.isTransRotOn;
    end;
	return self.isTransRotOn;	
end;

function McHale_F550:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;