  SetTurnedOnEvent = {};
  SetTurnedOnEvent_mt = Class(SetTurnedOnEvent, Event);
  
  InitEventClass(SetTurnedOnEvent, "SetTurnedOnEvent");
  
  function SetTurnedOnEvent:emptyNew()
     local self = Event:new(SetTurnedOnEvent_mt);
      self.className="SetTurnedOnEvent";
      return self;
  end;
  
  function SetTurnedOnEvent:new(object, turnedOn)
      local self = SetTurnedOnEvent:emptyNew()
      self.object = object;
      self.turnedOn = turnedOn;
      return self;
  end;
  
  function SetTurnedOnEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.turnedOn = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function SetTurnedOnEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.turnedOn);
  end;
  
  function SetTurnedOnEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsTurnedOn(self.turnedOn, true);
  end;
  
  function SetTurnedOnEvent.sendEvent(vehicle, turnedOn, noEventSend)
      if turnedOn ~= vehicle.isTurnedOn then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetTurnedOnEvent:new(vehicle, turnedOn), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetTurnedOnEvent:new(vehicle, turnedOn));
              end;
          end;
      end;
  end;
  
  
  BalerAreaEvent = {};
  BalerAreaEvent_mt = Class(BalerAreaEvent, Event);
  
  InitEventClass(BalerAreaEvent, "BalerAreaEvent");
  
  function BalerAreaEvent:emptyNew()
      local self = Event:new(BalerAreaEvent_mt);
      self.className="BalerAreaEvent";
      return self;
  end;
  
  function BalerAreaEvent:new(cuttingAreas, fruitTypes)
      local self = BalerAreaEvent:emptyNew()
      self.cuttingAreas = cuttingAreas;
      self.fruitTypes = fruitTypes;
      assert(table.getn(self.cuttingAreas) > 0 and table.getn(self.cuttingAreas) <= 16);
      assert(table.getn(self.fruitTypes) > 0 and table.getn(self.fruitTypes) <= 16);
      return self;
  end;
  
  function BalerAreaEvent:readStream(streamId, connection)
      local numAreas = streamReadUIntN(streamId, 4)+1;
      local numFruitTypes = streamReadUIntN(streamId, 4)+1;
      local fruitTypes = {};
      for i=1, numFruitTypes do
          local fruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits)+1;
          table.insert(fruitTypes, fruitType);
      end;
  
      local refX = streamReadFloat32(streamId);
      local refY = streamReadFloat32(streamId);
      local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3 - 1, 0.01, true);
  
      for i=1, numAreas do
          for _, fruitType in ipairs(fruitTypes) do
              local desc = FruitUtil.fruitIndexToDesc[fruitType];
  
              local vi = i-1;
              local x = values[vi*3+1].x;
              local z = values[vi*3+1].y;
              local x1 = values[vi*3+2].x;
              local z1 = values[vi*3+2].y;
              local x2 = values[vi*3+3].x;
              local z2 = values[vi*3+3].y;
  
              Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
              Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
  
              -- now that we removed the cut long and windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
             if fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
                  Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
              end;
          end;
     end;
  end;
  
  function BalerAreaEvent:writeStream(streamId, connection)
      local numAreas = table.getn(self.cuttingAreas);
      local numFruitTypes = table.getn(self.fruitTypes);
      streamWriteUIntN(streamId, numAreas-1, 4);
      streamWriteUIntN(streamId, numFruitTypes-1, 4);
      for i=1, numFruitTypes do
         streamWriteUIntN(streamId, self.fruitTypes[i]-1, FruitUtil.sendNumBits);
     end;
  
      local refX, refY;
      local values = {};
      for i=1, numAreas do
          local d = self.cuttingAreas[i];
          if i==1 then
              refX = d[1];
              refY = d[2];
              streamWriteFloat32(streamId, d[1]);
              streamWriteFloat32(streamId, d[2]);
          else
              table.insert(values, {x=d[1], y=d[2]});
          end;
         table.insert(values, {x=d[3], y=d[4]});
         table.insert(values, {x=d[5], y=d[6]});
          --streamWriteFloat32(streamId, d[3]);
          --streamWriteFloat32(streamId, d[4]);
          --streamWriteFloat32(streamId, d[5]);
          --streamWriteFloat32(streamId, d[6]);
     end;
      assert(table.getn(values) == numAreas*3 - 1);
      Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
 end;
  
  function BalerAreaEvent:run(connection)
     --print("Error: do not run BalerAreaEvent locally");
  end;
  
  function BalerAreaEvent.runLocally(cuttingAreas, fruitTypes)
      local totalArea =0;
      local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
  
      local numAreas = table.getn(cuttingAreas);
  
      local refX, refY;
      local values = {};
      for i=1, numAreas do
          local d = cuttingAreas[i];
          if i==1 then
              refX = d[1];
              refY = d[2];
          else
              table.insert(values, {x=d[1], y=d[2]});
          end;
          table.insert(values, {x=d[3], y=d[4]});
          table.insert(values, {x=d[5], y=d[6]});
      end;
      assert(table.getn(values) == numAreas*3 - 1);
  
      local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
  
      for i=1, numAreas do
          for _, fruitType in ipairs(fruitTypes) do
              local desc = FruitUtil.fruitIndexToDesc[fruitType];
  
              local vi = i-1;
              local x = values[vi*3+1].x;
              local z = values[vi*3+1].y;
              local x1 = values[vi*3+2].x;
              local z1 = values[vi*3+2].y;
              local x2 = values[vi*3+3].x;
              local z2 = values[vi*3+3].y;
 
              local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
              area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
              if area > 0 then
                  -- now that we removed the cut long and windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
                  if fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
                      Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
                  end;
  
                  totalArea = totalArea+area;
                  usedFruitType = fruitType;
              end;
          end;
      end;
      return totalArea, usedFruitType;
  end;
  

   BalerCreateBaleEvent = {};
   BalerCreateBaleEvent_mt = Class(BalerCreateBaleEvent, Event);
   
   InitEventClass(BalerCreateBaleEvent, "BalerCreateBaleEvent");
  
  function  BalerCreateBaleEvent:emptyNew()
      local self = Event:new(BalerCreateBaleEvent_mt);
      self.className="BalerCreateBaleEvent";
      return self;
  end;
  
  function BalerCreateBaleEvent:new(object, usedFruitType, baleTime)
      local self = BalerCreateBaleEvent:emptyNew()
      self.usedFruitType = usedFruitType;
      self.baleTime = baleTime;
      self.object = object;
      return self;
  end;
   
  function BalerCreateBaleEvent:readStream(streamId, connection)
      self.object = networkGetObject(streamReadInt32(streamId));
      self.usedFruitType = streamReadInt8(streamId);
      self.baleTime = streamReadFloat32(streamId);
      self:run(connection);
  end;
  
  function BalerCreateBaleEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteInt8(streamId, self.usedFruitType);
      streamWriteFloat32(streamId, self.baleTime);
  end;
  
  function BalerCreateBaleEvent:run(connection)
      --print("creating bale");
      Baler.createBale(self.object, self.usedFruitType);
      Baler.setBaleTime(self.object, table.getn(self.object.bales), self.baleTime);
  end;
  

   BalerSetBaleTimeEvent = {};
   BalerSetBaleTimeEvent_mt = Class( BalerSetBaleTimeEvent, Event);
   
   InitEventClass(BalerSetBaleTimeEvent, "BalerSetBaleTimeEvent");
  
  function  BalerSetBaleTimeEvent:emptyNew()
      local self = Event:new( BalerSetBaleTimeEvent_mt);
      self.className=" BalerSetBaleTimeEvent";
      return self;
  end;
  
  function  BalerSetBaleTimeEvent:new(object, bale, baleTime)
      local self =  BalerSetBaleTimeEvent:emptyNew()
      self.bale = bale;
      self.baleTime = baleTime;
      self.object = object;
      return self;
  end;
  
  function  BalerSetBaleTimeEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.bale = streamReadInt32(streamId);
      self.baleTime = streamReadFloat32(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function  BalerSetBaleTimeEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteInt32(streamId, self.bale);
      streamWriteFloat32(streamId, self.baleTime);
  end;
  
  function  BalerSetBaleTimeEvent:run(connection)
      Baler.setBaleTime(self.object, self.bale, self.baleTime);
  end;
  
  
  BalerSetIsUnloadingBaleEvent = {};
  BalerSetIsUnloadingBaleEvent_mt = Class(BalerSetIsUnloadingBaleEvent, Event);
  
  InitEventClass(BalerSetIsUnloadingBaleEvent, "BalerSetIsUnloadingBaleEvent");
  
  function BalerSetIsUnloadingBaleEvent:emptyNew()
      local self = Event:new(BalerSetIsUnloadingBaleEvent_mt);
      self.className="BalerSetIsUnloadingBaleEvent";
      return self;
  end;
  
  function BalerSetIsUnloadingBaleEvent:new(object, isUnloadingBale)
      local self = BalerSetIsUnloadingBaleEvent:emptyNew()
      self.object = object;
      self.isUnloadingBale = isUnloadingBale;
      return self;
  end;
  
  function BalerSetIsUnloadingBaleEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.isUnloadingBale = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function BalerSetIsUnloadingBaleEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.isUnloadingBale);
  end;
  
  function BalerSetIsUnloadingBaleEvent:run(connection)
      if not connection:getIsServer() then
          g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsUnloadingBale(self.isUnloadingBale, true);
  end;
  
  function BalerSetIsUnloadingBaleEvent.sendEvent(object, isUnloadingBale, noEventSend)
      if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(BalerSetIsUnloadingBaleEvent:new(object, isUnloadingBale), nil, nil, object);
          else
              g_client:getServerConnection():sendEvent(BalerSetIsUnloadingBaleEvent:new(object, isUnloadingBale));
          end;
      end;
  end;