BaleHandlerEvent = {};
BaleHandlerEvent_mt = Class(BaleHandlerEvent, Event);

InitEventClass(BaleHandlerEvent, "BaleHandlerEvent");

function BaleHandlerEvent:emptyNew()
    local self = Event:new(BaleHandlerEvent_mt);
    self.className="BaleHandlerEvent";

    return self;
end;

function BaleHandlerEvent:new(vehicle, baleId)
    local self = BaleHandlerEvent:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function BaleHandlerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function BaleHandlerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function BaleHandlerEvent:run(connection)
	self.vehicle:setBaleLeft(self.baleId, true);
	self.vehicle:setBaleRight(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(BaleHandlerEvent:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function BaleHandlerEvent.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BaleHandlerEvent:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BaleHandlerEvent:new(vehicle, baleId));
		end;
	end;
end;