--
-- BaleHandler
--
-- @author  	David Hunt
-- @version 	v1.0
-- @date  		20/12/2010


BaleHandler = {};

function BaleHandler.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function BaleHandler:load(xmlFile)	

	self.setBaleLeft = SpecializationUtil.callSpecializationsFunction("setBaleLeft");
	self.setBaleRight = SpecializationUtil.callSpecializationsFunction("setBaleRight");
	self.objectInRangeLeft = BaleHandler.objectInRangeLeft;
	self.objectInRangeRight = BaleHandler.objectInRangeRight;

	self.lockLeft = {};
	self.lockLeft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeLeft#index"));
	self.lockLeft.child = getChildAt(self.lockLeft.node, 0);
	self.lockLeft.baleId = nil;
	
	self.lockRight = {};
	self.lockRight.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.locknodeRight#index"));
	self.lockRight.child = getChildAt(self.lockRight.node, 0);
	self.lockRight.baleId = nil;
end;

function BaleHandler:delete()
	self:setBaleLeft(nil, false);
	self:setBaleRight(nil, false);
end;

function BaleHandler:onDetach()
	self:setBaleLeft(nil, false);
	self:setBaleRight(nil, false);
end;

function BaleHandler:readStream(streamId, connection)
	self:setBaleLeft(streamReadInt32(streamId), true);
	self:setBaleRight(streamReadInt32(streamId), true);
end;

function BaleHandler:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.lockLeft.baleId);
	streamWriteInt32(streamId, self.lockRight.baleId);
end;

function BaleHandler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleHandler:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleHandler:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.lockLeft.node ~= nil then 
				if InputBinding.hasEvent(InputBinding.Toggle_Forks_Lock_Left) then
					if self.lockLeft.baleId == nil then
						local bale = self:objectInRangeLeft(self.lockLeft);
					
						if bale ~= nil then
							self:setBaleLeft(networkGetObjectId(bale), false);
						end;
					else
						self:setBaleLeft(nil, false);
					end;
				end;
			end;
			if self.lockRight.node ~= nil then
				if InputBinding.hasEvent(InputBinding.Toggle_Forks_Lock_Right) then
					if self.lockRight.baleId == nil then
						local bale = self:objectInRangeRight(self.lockRight);
					
						if bale ~= nil then
							self:setBaleRight(networkGetObjectId(bale), false);
						end;
					else
						self:setBaleRight(nil, false);
					end;
				end;
			end;
		end;
	end;
end;

function BaleHandler:draw()
	if self.lockLeft.node ~= nil then
		if self.lockLeft.baleId ~= nil then
			g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_Fork_Unlock_Left"), InputBinding.Toggle_Forks_Lock_Left);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_Fork_Lock_Left"), InputBinding.Toggle_Forks_Lock_Left);
		end;
	end;
	if self.lockRight.node ~= nil then
		if self.lockRight.baleId ~= nil then
			g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_Fork_Unlock_Right"), InputBinding.Toggle_Forks_Lock_Right);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_Fork_Lock_Right"), InputBinding.Toggle_Forks_Lock_Right);
		end;
	end;
end;

function BaleHandler:setBaleLeft(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockLeft.child ~= nil then
			local bale = nil;

			if self.lockLeft.baleId ~= nil then
				bale = networkGetObject(self.lockLeft.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockLeft.baleId = nil;
				end;
			end;

			BaleHandlerEvent.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockLeft.child, 0,0,0, 0,0,0);
				end;

				self.lockLeft.baleId = baleId;
			end;
		end;
	else
		BaleHandlerEvent.sendEvent(self, baleId, noEventSend);

		if self.lockLeft.baleId ~= nil then
			local bale = networkGetObject(self.lockLeft.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockLeft.baleId = nil;
			end;
		end;
	end;
end;

function BaleHandler:setBaleRight(baleId, noEventSend)
	if baleId ~= nil then
		if self.lockRight.child ~= nil then
			local bale = nil;

			if self.lockRight.baleId ~= nil then
				bale = networkGetObject(self.lockRight.baleId);
				if bale ~= nil then
					bale:unmount();
					self.lockRight.baleId = nil;
				end;
			end;

			BaleHandlerEvent.sendEvent(self, baleId, noEventSend);

			bale = networkGetObject(baleId);
			if bale ~= nil then
				if getUserAttribute(bale.nodeId, "isRoundbale") then
					bale:mount(self, self.lockRight.child, 0,0,0, 0,0,0);
				end;

				self.lockRight.baleId = baleId;
			end;
		end;
	else
		BaleHandlerEvent.sendEvent(self, baleId, noEventSend);

		if self.lockRight.baleId ~= nil then
			local bale = networkGetObject(self.lockRight.baleId);

			if bale ~= nil then
				bale:unmount();
				self.lockRight.baleId = nil;
			end;
		end;
	end;
end;

function BaleHandler:objectInRangeLeft(refNode)
    local nearestDistance = 0.8;
    local nearestBale = nil;
    local px, py, pz = getWorldTranslation(refNode.node);

    for index, item in pairs(g_currentMission.itemsToSave) do
        if item.item:isa(Bale) then
				local vx, vy, vz = getWorldTranslation(item.item.nodeId);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					nearestDistance = distance;
					nearestBale = item.item;
				end;
        end;
    end;

    return nearestBale;
end;

function BaleHandler:objectInRangeRight(refNode)
    local nearestDistance = 0.8;
    local nearestBale = nil;
    local px, py, pz = getWorldTranslation(refNode.node);

    for index, item in pairs(g_currentMission.itemsToSave) do
        if item.item:isa(Bale) then
				local vx, vy, vz = getWorldTranslation(item.item.nodeId);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					nearestDistance = distance;
					nearestBale = item.item;
				end;
        end;
    end;

    return nearestBale;
end;
