--
-- pesticideTrailer
-- Specialization for pesticideTrailer
--
-- @author Felix "Outlaw" Sorge
-- @date  20/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--


pesticideTrailer = {};

function pesticideTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function pesticideTrailer:load(xmlFile)

	self.fertilizerInRange = SpecializationUtil.callSpecializationsFunction("fertilizerInRange");
		
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.fillTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
    if chargeTypes ~= nil then
		self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
        local types = Utils.splitString(" ", chargeTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.chargeTypes[desc.index] = true;
            end;
        end;
    end;
		
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
    end;

	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste";	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 	
	
end;


function pesticideTrailer:update(dt)
							

	for chargeTypes,v in pairs(self.chargeTypes) do	
		if chargeTypes == self.currentFillType then
			if self.fillLevel ~= 0 then
				self:fertilizerInRange(dt);
			end; 
			
		elseif self.fillLevel == 0 then
			if self.turnOn then
				self.turnOn = not self.turnOn; 
			end; 
			if self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;
			self:setFillLevel(0, FruitUtil.FRUITTYPE_UNKNOWN); 				
		end; 	
	end; 	

end;


function pesticideTrailer:fertilizerInRange(dt)
	self.inRange = false; 
    local nearestDistance = 5.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

		if distance < nearestDistance then
			local attachable = g_currentMission.attachables[i];			
			for fruitType,v in pairs(attachable.fillTypes) do
				if fruitType == self.currentFillType and attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
				
					if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
						self.turnOn = false; 
						if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = false;
						end;
					elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0  then
					

						if self.turnOn then
							g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_2")); 
							if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON) then
								self.turnOn = not self.turnOn; 
								if self.workSoundEnabled then
									stopSample(self.workSound);
									self.workSoundEnabled = false;
								end;
							end;
														
						else
							g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_1")); 
							if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON)  then
								self.turnOn = not self.turnOn; 
								if not self.workSoundEnabled then
								     playSample(self.workSound, 0, 1, 0);
									self.workSoundEnabled = true;   
								end; 
			
							end;
						end;
						
						
						
					
						if self.turnOn then
							self.inRange = true; 
							local deltaLevel = self.literPerSecond*dt/1000.0;
							deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
							self.fillLevel = self.fillLevel-deltaLevel;
							self:setFillLevel(self.fillLevel, self.currentFillType);
							attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);	
						end; 	
								
							
						
					end; 
				end;
			end;
		end;
    end;
		
	if not self.inRange and self.turnOn and self.workSoundEnabled then
		if self.workSoundEnabled then
			self.turnOn = not self.turnOn; 
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
	
end;


function pesticideTrailer:delete()
end;


function pesticideTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;


function pesticideTrailer:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Taste"; 
		end; 
	end; 
end;


function pesticideTrailer:draw()
end;


function pesticideTrailer:onAttach()
end; 	


function pesticideTrailer:onDetach()
end;