--CASE IH 6200
--hz888
--hz888@freemail.hu


ih6200dupla = {};

function ih6200dupla.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function ih6200dupla:load(xmlFile)

    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;
    self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
    self.grainUnloading = 10;

    self.setFillLevel = SpecializationUtil.callSpecializationsFunction("setFillLevel");
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));

    self.speedViolationMaxTime = 2500;
    self.speedViolationTimer = self.speedViolationMaxTime;

    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[fruitType.index] = fruitType.index;
        end;
    end;

    self.isTurnedOn = false;

    self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;

    local sowingSound = getXMLString(xmlFile, "vehicle.sowingSound#file");
    if sowingSound ~= nil and sowingSound ~= "" then
        sowingSound = Utils.getFilename(sowingSound, self.baseDirectory);
        self.sowingSound = createSample("sowingSound");
        loadSample(self.sowingSound, sowingSound, false);
        self.sowingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#pitchOffset"), 0);
        self.sowingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#volume"), 1.0);
        self.sowingSoundEnabled = false;
    end;

    self.lastFillDelta = 0;
    self.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
    self.minThreshold = 0.05;
    self.fillTypes = {};

    local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fillTypes[desc.index] = true;
            end;
        end;
    end;

    self.grainPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);
            if self.defaultGrainPlane == nil then
                self.defaultGrainPlane = node;
            end;
            self.grainPlanes[t] = node;
        end;
        i = i +1;
    end;
    if self.defaultGrainPlane==nil then
        self.grainPlanes = nil;
    end;

    self.grainPlaneMinY, self.grainPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainPlane#minMaxY"));
    if self.grainPlaneMinY == nil or self.grainPlaneMaxY == nil then
        local grainAnimCurve = AnimCurve:new(linearInterpolator4);
        local keyI = 0;
        while true do
            local key = string.format("vehicle.grainPlane.key(%d)", keyI);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            grainAnimCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            keyI = keyI +1;
        end;
        if keyI > 0 then
            self.grainAnimCurve = grainAnimCurve;
        end;
        self.grainPlaneMinY = 0;
        self.grainPlaneMaxY = 0;
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.groundParticleSystems = {};
    local psName = "vehicle.groundParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, psName, self.components, false, nil, self.baseDirectory)

    local vono1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.vono1#index"));
    if vono1Node ~= nil then
        self.vono1 = {};
        self.vono1.node = vono1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono1#minRot"));
        self.vono1.minRot = {};
        self.vono1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono1#maxRot"));
        self.vono1.maxRot = {};
        self.vono1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.vono1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono1#rotTime"), 2)*1000;
        self.vono1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono1#touchRotLimit"), 10));
    end;

    local vono2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.vono2#index"));
    if vono2Node ~= nil then
        self.vono2 = {};
        self.vono2.node = vono2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono2#minRot"));
        self.vono2.minRot = {};
        self.vono2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono2#maxRot"));
        self.vono2.maxRot = {};
        self.vono2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.vono2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono2#rotTime"), 2)*1000;
        self.vono2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono2#touchRotLimit"), 10));
    end;

    local vetoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veto#index"));
    if vetoNode ~= nil then
        self.veto = {};
        self.veto.node = vetoNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.veto#minRot"));
        self.veto.minRot = {};
        self.veto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.veto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.veto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.veto#maxRot"));
        self.veto.maxRot = {};
        self.veto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.veto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.veto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.veto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.veto#rotTime"), 2)*1000;
        self.veto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.veto#touchRotLimit"), 10));
    end;

    local tetoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if tetoNode ~= nil then
        self.teto = {};
        self.teto.node = tetoNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#minRot"));
        self.teto.minRot = {};
        self.teto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.teto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.teto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.teto.maxRot = {};
        self.teto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.teto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.teto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.teto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.teto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;

    local nyomjelbNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nyomjelb#index"));
    if nyomjelbNode ~= nil then
        self.nyomjelb = {};
        self.nyomjelb.node = nyomjelbNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelb#minRot"));
        self.nyomjelb.minRot = {};
        self.nyomjelb.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelb.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelb.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelb#maxRot"));
        self.nyomjelb.maxRot = {};
        self.nyomjelb.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelb.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelb.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.nyomjelb.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelb#rotTime"), 2)*1000;
        self.nyomjelb.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelb#touchRotLimit"), 10));
    end;

    local nyomjeljNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nyomjelj#index"));
    if nyomjeljNode ~= nil then
        self.nyomjelj = {};
        self.nyomjelj.node = nyomjeljNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelj#minRot"));
        self.nyomjelj.minRot = {};
        self.nyomjelj.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelj.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelj.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelj#maxRot"));
        self.nyomjelj.maxRot = {};
        self.nyomjelj.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelj.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelj.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.nyomjelj.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelj#rotTime"), 2)*1000;
        self.nyomjelj.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelj#touchRotLimit"), 10));
    end;

    local kar1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kar1#index"));
    if kar1Node ~= nil then
        self.kar1 = {};
        self.kar1.node = kar1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar1#minRot"));
        self.kar1.minRot = {};
        self.kar1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar1#maxRot"));
        self.kar1.maxRot = {};
        self.kar1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.kar1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar1#rotTime"), 2)*1000;
        self.kar1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar1#touchRotLimit"), 10));
    end;

    local kar2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kar2#index"));
    if kar2Node ~= nil then
        self.kar2 = {};
        self.kar2.node = kar2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar2#minRot"));
        self.kar2.minRot = {};
        self.kar2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar2#maxRot"));
        self.kar2.maxRot = {};
        self.kar2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.kar2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar2#rotTime"), 2)*1000;
        self.kar2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar2#touchRotLimit"), 10));
    end;

    self.kerek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerek#index"));
    self.henger = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.henger#index"));
    self.kerekfel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerekfel#index"));
    self.kerekfel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerekfel2#index"));
	self.kerekfel3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerekfel3#index"));
	self.aiaktiv = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));
    self.vetoMax = false;
    self.vono2Max = true;
    self.currentSeed = 1;
    self.fillLevel = 0;
    self.stop = false; 

    local attacherJoint1 = {};
    attacherJoint1.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#index"));
    if attacherJoint1.node ~= nil then
        attacherJoint1.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#topReferenceNode"));
        attacherJoint1.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#rootNode")), self.components[1].node);
        attacherJoint1.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJoint1#fixedRotation"), false);
	attacherJoint1.transLimitScale = {0,0,0};
	attacherJoint1.rotLimitScale = {2,2,2};		
        local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint1#jointType")
        local jointType;
        if jointTypeStr ~= nil then
            jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
            if jointType == nil then
                print("Warning: invalid jointType " .. jointTypeStr);
            end;
        else
            print("Warning: missing jointType");
        end;
    	attacherJoint1.jointType = jointType;
    	self.attacherJoint1 = attacherJoint1;

    end;

    local attacherJoint2 = {};
    attacherJoint2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#index"));
    if attacherJoint2.node ~= nil then
        attacherJoint2.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#topReferenceNode"));
        attacherJoint2.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#rootNode")), self.components[1].node);
        attacherJoint2.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJoint2#fixedRotation"), false);
	attacherJoint2.transLimitScale = {0,0,0};
	attacherJoint2.rotLimitScale = {2,2,2};
        local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint2#jointType")
        local jointType;
        if jointTypeStr ~= nil then
            jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
            if jointType == nil then
                print("Warning: invalid jointType " .. jointTypeStr);
            end;
        else
            print("Warning: missing jointType");
        end;
    	attacherJoint2.jointType = jointType;
    	self.attacherJoint2 = attacherJoint2;
    end;

    self.attacherJoint = self.attacherJoint1;

end;

function ih6200dupla:delete()

    Utils.deleteParticleSystem(self.groundParticleSystems);

    if self.sowingSound ~= nil then
        delete(self.sowingSound);
    end;

end;

function ih6200dupla:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ih6200dupla:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.nyomjelb and self.vono2Max then
	self.nyomjelbMax = true;
	self.nyomjeljMax = false;
    end;

    if isDown and sym == self.keys.nyomjelj and self.vono2Max then
	self.nyomjelbMax = false;
	self.nyomjeljMax = true;
    end;

    if isDown and sym == self.keys.nyomjelk then
	self.nyomjelbMax = false;
	self.nyomjeljMax = false;
    end;

    if isDown and sym == self.keys.fedel then
	self.tetoMax = not self.tetoMax;
    end;	

    if isDown and sym == self.keys.akasztvalt and not self.vetoMax then
	if self.attacherJoint == self.attacherJoint1 then
		self.attacherJoint = self.attacherJoint2;
		self.vono1Max = true;
		self.vono2Max = false;
		self.nyomjelbMax = false;
		self.nyomjeljMax = false;
		self.aiLeftMarker = nil;
		setVisibility(self.wheels[1].repr, true);
		setVisibility(self.wheels[2].repr, true);
		setVisibility(self.wheels[3].repr, true);
		setVisibility(self.wheels[4].repr, true);
		setVisibility(self.wheels[5].repr, true);
		setVisibility(self.kerekfel, false);
		setVisibility(self.kerekfel2, false);
		setVisibility(self.kerekfel3, false);
		for k, wheel in pairs(self.wheels) do
			wheel.steeringAxleRotMax = Utils.degToRad(90);
			wheel.steeringAxleRotMin = Utils.degToRad(90);
		end;
	else
		self.attacherJoint = self.attacherJoint1;
		self.vono1Max = false;
		self.vono2Max = true;
		self.aiLeftMarker = self.aiaktiv;
		setVisibility(self.wheels[1].repr, true);
		setVisibility(self.wheels[2].repr, true);
		setVisibility(self.wheels[3].repr, false);
		setVisibility(self.wheels[4].repr, false);
		setVisibility(self.wheels[5].repr, false);
		setVisibility(self.kerekfel, true);
		setVisibility(self.kerekfel2, true);
		setVisibility(self.kerekfel3, true);
		for k, wheel in pairs(self.wheels) do
			wheel.steeringAxleRotMax = Utils.degToRad(0);
			wheel.steeringAxleRotMin = Utils.degToRad(0);
		end;
	end;
	self.attacherVehicle:detachImplementByObject(self);
    end;

    if isDown and sym == self.keys.vetes then
	if self.vono2Max then
		self.vetoMax = not self.vetoMax;
	end;
    end;

    if isDown and sym == self.keys.vetomag then
            if self.fillLevel <= 0 then
                self.currentSeed = self.currentSeed + 1;
                if self.currentSeed > table.getn(self.seeds) then
                    self.currentSeed = 1;
                end;
            end;
    end;

    if isDown and sym == 127 then
	self:setFillLevel(0, self.currentFillType);
    end;

    local trailer = g_currentMission.objectToTrailer[self.trailerFound];
    if self.trailerFound ~= 0 and trailer.currentFillType == self.currentFillType and self.tetoMax then
	if isDown and sym == self.keys.lapatol then
	            local deltaLevel = self.grainUnloading;
		    deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);

	            self.fillLevel = self.fillLevel+deltaLevel;
	            if self.fillLevel >= self.capacity then
	                self.fillLevel = self.capacity;
			self.activeUnloading = false;
	            end;
		    if trailer.fillLevel <= 0.0 then
			trailer.fillLevel = 0.0;
			trailer.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
			self.activeUnloading = false;
		    end;
	            self:setFillLevel(self.fillLevel, trailer.currentFillType);
		    trailer:setFillLevel(trailer.fillLevel-deltaLevel, trailer.currentFillType);
	end;
    end;

end;

function ih6200dupla:update(dt)

    self.currentFillType = self.seeds[self.currentSeed];
    self.trailerFound = 0;

    if self.attacherVehicle then
	local x,y,z = getWorldTranslation(self.trailerPosition);
    	raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
	if self.veto ~= nil then
		local x, y, z = getRotation(self.veto.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.veto.maxRot, self.veto.minRot, 3, self.veto.rotTime, dt, self.vetoMax);
		setRotation(self.veto.node, unpack(newRot));
	end;
    	if self.vono2Max then
		rotate(self.kerek, self.wheelRpm*self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);

		if self.teto ~= nil then
			local x, y, z = getRotation(self.teto.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.teto.maxRot, self.teto.minRot, 3, self.teto.rotTime, dt, not self.tetoMax);
			setRotation(self.teto.node, unpack(newRot));
		end;

		if self.nyomjelb ~= nil then
			local x, y, z = getRotation(self.nyomjelb.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.nyomjelb.maxRot, self.nyomjelb.minRot, 3, self.nyomjelb.rotTime, dt, not self.nyomjelbMax);
			setRotation(self.nyomjelb.node, unpack(newRot));
		end;

		if self.kar1 ~= nil then
			local x, y, z = getRotation(self.kar1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.kar1.maxRot, self.kar1.minRot, 3, self.kar1.rotTime, dt, not self.nyomjelbMax);
			setRotation(self.kar1.node, unpack(newRot));
		end;

		if self.nyomjelj ~= nil then
			local x, y, z = getRotation(self.nyomjelj.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.nyomjelj.maxRot, self.nyomjelj.minRot, 3, self.nyomjelj.rotTime, dt, not self.nyomjeljMax);
			setRotation(self.nyomjelj.node, unpack(newRot));
		end;

		if self.kar2 ~= nil then
			local x, y, z = getRotation(self.kar2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.kar2.maxRot, self.kar2.minRot, 3, self.kar2.rotTime, dt, not self.nyomjeljMax);
			setRotation(self.kar2.node, unpack(newRot));
		end;

    	end;

	if self.nyomjelbMax then
		local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
		local rotX, rotY, rotZ = getRotation(self.nyomjelb.node);
		if rotZ  <= self.nyomjelb.maxRot[3]+0.2 then		
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		end;
	end;

		
	if self.nyomjeljMax then
		local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
		local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
		local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
		local rotX, rotY, rotZ = getRotation(self.nyomjelj.node);
		if rotZ  >= self.nyomjelj.maxRot[3]-0.2 then		
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		end;
	end;

	if self.attacherVehicle.isAITractorActivated then				
    		self.attacherVehicle.turnStage3Timeout = 0;  				
		if self.fillLevel == 0 then
			AITractor.stopAITractor(self.attacherVehicle);
			self.tetoMax = true;
			self.stop = true;
		end;
		if self.attacherVehicle.turnStage == 0 then
			self.vetoMax = true;
		else
			self.vetoMax = false;
		end;	
	else
		if self.fillLevel == self.capacity and self.stop then
			AITractor.startAITractor(self.attacherVehicle);
			self.tetoMax = false;
			self.stop = false;
		end;
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.attacherVehicle.turnStage3Timeout = 20000;
		end; 	
	end
        if self.movingDirection > 0 and self.vetoMax then
               	Utils.setEmittingState(self.groundParticleSystems, self.lastSpeed*3600 > 5);
        	local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
                local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
                local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
                local area = 0;
		if self.fillLevel > 0 or self.currentSeed == 5 then
			area = Utils.updateSowingArea(self.seeds[self.currentSeed], x, z, x1, z1, x2, z2);
		else
			area = 0;
		end;

                local fruitDesc = FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed] ];

                local pixelToQm = 2048 / 8192 * 2048 / 8192;
                local qm = area*pixelToQm;
                local ha = qm/10000;
		local speedFactor = self.attacherVehicle.lastSpeed*3600/12;
                local usage = fruitDesc.seedUsagePerQm*qm*speedFactor*5;
		if self.attacherVehicle.lastSpeed*3600 > 0.1 then 
			self:setFillLevel(self.fillLevel-usage, self.currentFillType);
		end;
		if self.currentSeed == 5 then
                    local seedPrice = fruitDesc.seedPricePerLiter*usage;
                    g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + seedPrice;
                    g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + seedPrice;
		end;
                g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
                g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

                g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
                g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

                g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
                g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);

            	if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 20 then
                	self.speedViolationTimer = self.speedViolationTimer - dt;
                	if self.speedViolationTimer < 0 then
                    		if self.attacherVehicle ~= nil then
                       			self.attacherVehicle:detachImplementByObject(self);
                    		end;
                	end;
            	else
                	self.speedViolationTimer = self.speedViolationMaxTime;
           	end;

            	if not self.groundParticleSystemActive then
                	self.groundParticleSystemActive = true;
                	Utils.setEmittingState(self.groundParticleSystems, true);
            	end;

            	if self.sowingSound ~= nil and not self.sowingSoundEnabled then
                	if self.lastSpeed*3600 > 3 and self:getIsActiveForSound() then
                    		playSample(self.sowingSound, 0, self.sowingSoundVolume, 0);
                    		setSamplePitch(self.sowingSound, self.sowingSoundPitchOffset);
                    		self.sowingSoundEnabled = true;
                	end;
            	end;
        else
               	Utils.setEmittingState(self.groundParticleSystems, false);
            	self.speedViolationTimer = self.speedViolationMaxTime;
            	ih6200dupla.onDeactivateSounds(self);
        end;


    	if self.sowingSoundEnabled then
        	if self.lastSpeed*3600 < 3 then
            		ih6200dupla.onDeactivateSounds(self);
        	end;
    	end;



    end;

    if self.vono1 ~= nil then
	local x, y, z = getRotation(self.vono1.node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.vono1.maxRot, self.vono1.minRot, 3, self.vono1.rotTime, dt, not self.vono1Max);
	setRotation(self.vono1.node, unpack(newRot));
    end;
    if self.vono2 ~= nil then
	local x, y, z = getRotation(self.vono2.node);
	local rot = {x,y,z};
	if x >= self.vono2.maxRot[1] then
		setVisibility(self.vono2.node, false);
		setVisibility(self.components[4].node, true);
		setRotation(self.henger, 0, 0, 0);
	else
		setVisibility(self.vono2.node, true);
		setVisibility(self.components[4].node, false);
		setRotation(self.henger, Utils.degToRad(15), 0, 0);
	end;
	local newRot = Utils.getMovedLimitedValues(rot, self.vono2.maxRot, self.vono2.minRot, 3, self.vono2.rotTime, dt, not self.vono2Max);
	setRotation(self.vono2.node, unpack(newRot));
    end;

end;

function ih6200dupla:draw()

    g_currentMission.fruitOverlays[self.currentFillType]:render();
    local x,y,z = getWorldTranslation(self.trailerPosition);
    raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
    local trailer = g_currentMission.objectToTrailer[self.trailerFound];
    if self.trailerFound ~= 0 and trailer.currentFillType == self.currentFillType then
	if self.tetoMax and self.fillLevel < self.capacity then
		g_currentMission:addExtraPrintText("M gomb: Manulis feltlts");
	elseif self.fillLevel >= self.capacity then
		g_currentMission:addExtraPrintText("K gomb: Fedl bezr");
	else
		g_currentMission:addExtraPrintText("K gomb: Fedl kinyit");
	end;
    elseif not self.vetoMax and self.vono2Max and not self.tetoMax then
	g_currentMission:addExtraPrintText("J gomb: Vontats pont vlts");	
    end;
    if self.vono2Max then
    	if not self.vetoMax then
		g_currentMission:addExtraPrintText("B gomb: Vets indt");
    	else
		g_currentMission:addExtraPrintText("B gomb: Vets llj");
    	end;
    	if self.fillLevel <= 0 then
		g_currentMission:addExtraPrintText("N gomb: Vetmag kivlaszt");
    	else
		g_currentMission:addExtraPrintText("DELETE gomb: Magtartly kirt");
    	end;	
    	if self.nyomjelbMax and self.nyomjeljMax then
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelz balra");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelz jobbra");
    	elseif self.nyomjeljMax then
		g_currentMission:addExtraPrintText("NUM2 gomb: Nyomjelz vissza");
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelz balra");
    	elseif self.nyomjelbMax then
		g_currentMission:addExtraPrintText("NUM2 gomb: Nyomjelz vissza");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelz jobbra");
    	else
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelz balra");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelz jobbra");
    	end;
    	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        	g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
    	end;
    else
	g_currentMission:addExtraPrintText("J gomb: Vontats pont vlts");
    end;
end;

function ih6200dupla:onDetach()

    if self.deactivateOnDetach then
        ih6200dupla.onDeactivate(self);
    else
        ih6200dupla.onDeactivateSounds(self);
    end;

end;

function ih6200dupla:onLeave()

    if self.deactivateOnLeave then
        ih6200dupla.onDeactivate(self);
    end;

end;

function ih6200dupla:onDeactivate()

    self.speedViolationTimer = self.speedViolationMaxTime;
    if self.groundParticleSystemActive then
        self.groundParticleSystemActive = false;
        Utils.setEmittingState(self.groundParticleSystems, false);
    end;
    ih6200dupla.onDeactivateSounds(self);

end;

function ih6200dupla:onDeactivateSounds()

    if self.sowingSoundEnabled then
        stopSample(self.sowingSound);
        self.sowingSoundEnabled = false;
    end;

end;

function ih6200dupla:setFillLevel(fillLevel, fillType)

    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
    end;
    if self.currentGrainPlane ~= nil then
        setVisibility(self.currentGrainPlane, false);
    end;
    if self.grainPlanes ~= nil and self.defaultGrainPlane ~= nil then
        local fillTypeName = FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed]].name;
        local grainPlane = self.grainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainPlane;
        end;
        local yTranslation;
        if self.grainAnimCurve then
            local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve:get(self.fillLevel/self.capacity);
            yTranslation = yTrans;
            setScale(grainPlane, scaleX, scaleY, scaleZ);
        else
            local m = (self.grainPlaneMaxY - self.grainPlaneMinY) / self.capacity;
            yTranslation = m*self.fillLevel + self.grainPlaneMinY;
        end;
        local xPos, yPos, zPos = getTranslation(grainPlane);
        setTranslation(grainPlane, xPos, yTranslation, zPos);
        setVisibility(grainPlane, self.fillLevel > 0);
        self.currentGrainPlane = grainPlane;
    end;
end;