--CASE IH 6200
--hz888
--hz888@freemail.hu


ih6200 = {};

function ih6200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function ih6200:load(xmlFile)

    self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;

    local numkarCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.karcuttingAreas#count"), 0);
    self.karcuttingAreas = {}
    for i=1, numkarCuttingAreas do
        self.karcuttingAreas[i] = {};
        local areanamei = string.format("vehicle.karcuttingAreas.cuttingArea%d", i);
        self.karcuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.karcuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.karcuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    local vono1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.vono1#index"));
    if vono1Node ~= nil then
        self.vono1 = {};
        self.vono1.node = vono1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono1#minRot"));
        self.vono1.minRot = {};
        self.vono1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono1#maxRot"));
        self.vono1.maxRot = {};
        self.vono1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.vono1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono1#rotTime"), 2)*1000;
        self.vono1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono1#touchRotLimit"), 10));
    end;

    local vono2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.vono2#index"));
    if vono2Node ~= nil then
        self.vono2 = {};
        self.vono2.node = vono2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono2#minRot"));
        self.vono2.minRot = {};
        self.vono2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vono2#maxRot"));
        self.vono2.maxRot = {};
        self.vono2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.vono2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.vono2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.vono2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono2#rotTime"), 2)*1000;
        self.vono2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.vono2#touchRotLimit"), 10));
    end;

    local vetoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.veto#index"));
    if vetoNode ~= nil then
        self.veto = {};
        self.veto.node = vetoNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.veto#minRot"));
        self.veto.minRot = {};
        self.veto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.veto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.veto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.veto#maxRot"));
        self.veto.maxRot = {};
        self.veto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.veto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.veto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.veto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.veto#rotTime"), 2)*1000;
        self.veto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.veto#touchRotLimit"), 10));
    end;

    local tetoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if tetoNode ~= nil then
        self.teto = {};
        self.teto.node = tetoNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#minRot"));
        self.teto.minRot = {};
        self.teto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.teto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.teto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.teto.maxRot = {};
        self.teto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.teto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.teto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.teto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.teto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;

    local nyomjelbNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nyomjelb#index"));
    if nyomjelbNode ~= nil then
        self.nyomjelb = {};
        self.nyomjelb.node = nyomjelbNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelb#minRot"));
        self.nyomjelb.minRot = {};
        self.nyomjelb.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelb.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelb.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelb#maxRot"));
        self.nyomjelb.maxRot = {};
        self.nyomjelb.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelb.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelb.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.nyomjelb.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelb#rotTime"), 2)*1000;
        self.nyomjelb.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelb#touchRotLimit"), 10));
    end;

    local nyomjeljNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nyomjelj#index"));
    if nyomjeljNode ~= nil then
        self.nyomjelj = {};
        self.nyomjelj.node = nyomjeljNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelj#minRot"));
        self.nyomjelj.minRot = {};
        self.nyomjelj.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelj.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelj.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.nyomjelj#maxRot"));
        self.nyomjelj.maxRot = {};
        self.nyomjelj.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.nyomjelj.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.nyomjelj.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.nyomjelj.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelj#rotTime"), 2)*1000;
        self.nyomjelj.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.nyomjelj#touchRotLimit"), 10));
    end;

    local kar1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kar1#index"));
    if kar1Node ~= nil then
        self.kar1 = {};
        self.kar1.node = kar1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar1#minRot"));
        self.kar1.minRot = {};
        self.kar1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar1#maxRot"));
        self.kar1.maxRot = {};
        self.kar1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.kar1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar1#rotTime"), 2)*1000;
        self.kar1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar1#touchRotLimit"), 10));
    end;

    local kar2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kar2#index"));
    if kar2Node ~= nil then
        self.kar2 = {};
        self.kar2.node = kar2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar2#minRot"));
        self.kar2.minRot = {};
        self.kar2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar2#maxRot"));
        self.kar2.maxRot = {};
        self.kar2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kar2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kar2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.kar2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar2#rotTime"), 2)*1000;
        self.kar2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar2#touchRotLimit"), 10));
    end;

    self.kerek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerek#index"));
    self.henger = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.henger#index"));
    self.kerekfel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kerekfel#index"));
    self.vetoMax = false;
    self.vono2Max = true;
    self.stop = false; 

    local attacherJoint1 = {};
    attacherJoint1.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#index"));
    if attacherJoint1.node ~= nil then
        attacherJoint1.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#topReferenceNode"));
        attacherJoint1.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint1#rootNode")), self.components[1].node);
        attacherJoint1.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJoint1#fixedRotation"), false);        local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint1#jointType");
	attacherJoint1.transLimitScale = {0,0,0};
	attacherJoint1.rotLimitScale = {2,2,2};
        local jointType;
        if jointTypeStr ~= nil then
            jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
            if jointType == nil then
                print("Warning: invalid jointType " .. jointTypeStr);
            end;
        else
            print("Warning: missing jointType");
        end;
    	attacherJoint1.jointType = jointType;
    	self.attacherJoint1 = attacherJoint1;

    end;

    local attacherJoint2 = {};
    attacherJoint2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#index"));
    if attacherJoint2.node ~= nil then
        attacherJoint2.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#topReferenceNode"));
        attacherJoint2.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint2#rootNode")), self.components[1].node);
        attacherJoint2.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJoint2#fixedRotation"), false);
	attacherJoint2.transLimitScale = {0,0,0};
	attacherJoint2.rotLimitScale = {2,2,2};
        local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint2#jointType")
        local jointType;
        if jointTypeStr ~= nil then
            jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
            if jointType == nil then
                print("Warning: invalid jointType " .. jointTypeStr);
            end;
        else
            print("Warning: missing jointType");
        end;
    	attacherJoint2.jointType = jointType;
    	self.attacherJoint2 = attacherJoint2;
    end;

    self.attacherJoint = self.attacherJoint1;

end;

function ih6200:delete()

end;

function ih6200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ih6200:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.nyomjelb and self.vono2Max then
	self.nyomjelbMax = true;
	self.nyomjeljMax = false;
    end;

    if isDown and sym == self.keys.nyomjelj and self.vono2Max then
	self.nyomjelbMax = false;
	self.nyomjeljMax = true;
    end;

    if isDown and sym == self.keys.nyomjelk then
	self.nyomjelbMax = false;
	self.nyomjeljMax = false;
    end;

    if isDown and sym == self.keys.fedel then
	self.tetoMax = not self.tetoMax;
    end;	

    if isDown and sym == self.keys.akasztvalt and not self.vetoMax then
	if self.attacherJoint == self.attacherJoint1 then
		self.attacherJoint = self.attacherJoint2;
		self.vono1Max = true;
		self.vono2Max = false;
		self.nyomjelbMax = false;
		self.nyomjeljMax = false;
		self.aiLeftMarker = nil;
		setVisibility(self.wheels[2].repr, true);
		setVisibility(self.kerekfel, false);
		for k, wheel in pairs(self.wheels) do
			wheel.steeringAxleRotMax = Utils.degToRad(90);
			wheel.steeringAxleRotMin = Utils.degToRad(90);
		end;
	else
		self.attacherJoint = self.attacherJoint1;
		self.vono1Max = false;
		self.vono2Max = true;
		self.aiLeftMarker = self.aiaktiv;
		setVisibility(self.wheels[2].repr, false);
		setVisibility(self.kerekfel, true);
		for k, wheel in pairs(self.wheels) do
			wheel.steeringAxleRotMax = Utils.degToRad(0);
			wheel.steeringAxleRotMin = Utils.degToRad(0);
		end;
	end;
	self.attacherVehicle:detachImplementByObject(self);
    end;

    if isDown and sym == self.keys.vetes then
	if self.vono2Max then
		self.vetoMax = not self.vetoMax;
	end;
    end;

    if isDown and sym == self.keys.vetomag then
            if self.fillLevel <= 0 then
                self.currentSeed = self.currentSeed + 1;
                if self.currentSeed > table.getn(self.seeds) then
                    self.currentSeed = 1;
                end;
            end;
    end;

end;

function ih6200:update(dt)

    if self.attacherVehicle then

	if self.veto ~= nil then
		local x, y, z = getRotation(self.veto.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.veto.maxRot, self.veto.minRot, 3, self.veto.rotTime, dt, self.vetoMax);
		setRotation(self.veto.node, unpack(newRot));
	end;
    	if self.vono2Max then
		rotate(self.kerek, self.wheelRpm*self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);

		if self.nyomjelb ~= nil then
			local x, y, z = getRotation(self.nyomjelb.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.nyomjelb.maxRot, self.nyomjelb.minRot, 3, self.nyomjelb.rotTime, dt, not self.nyomjelbMax);
			setRotation(self.nyomjelb.node, unpack(newRot));
		end;

		if self.kar1 ~= nil then
			local x, y, z = getRotation(self.kar1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.kar1.maxRot, self.kar1.minRot, 3, self.kar1.rotTime, dt, not self.nyomjelbMax);
			setRotation(self.kar1.node, unpack(newRot));
		end;

		if self.nyomjelj ~= nil then
			local x, y, z = getRotation(self.nyomjelj.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.nyomjelj.maxRot, self.nyomjelj.minRot, 3, self.nyomjelj.rotTime, dt, not self.nyomjeljMax);
			setRotation(self.nyomjelj.node, unpack(newRot));
		end;

		if self.kar2 ~= nil then
			local x, y, z = getRotation(self.kar2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.kar2.maxRot, self.kar2.minRot, 3, self.kar2.rotTime, dt, not self.nyomjeljMax);
			setRotation(self.kar2.node, unpack(newRot));
		end;

    	end;

	if self.teto ~= nil then
		local x, y, z = getRotation(self.teto.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.teto.maxRot, self.teto.minRot, 3, self.teto.rotTime, dt, not self.tetoMax);
		setRotation(self.teto.node, unpack(newRot));
	end;

	if self.nyomjelbMax then
		local x,y,z = getWorldTranslation(self.karcuttingAreas[2].start);
		local x1,y1,z1 = getWorldTranslation(self.karcuttingAreas[2].width);
		local x2,y2,z2 = getWorldTranslation(self.karcuttingAreas[2].height);
		local rotX, rotY, rotZ = getRotation(self.nyomjelb.node);
		if rotZ  <= self.nyomjelb.maxRot[3]+0.2 then		
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		end;
	end;

		
	if self.nyomjeljMax then
		local x,y,z = getWorldTranslation(self.karcuttingAreas[1].start);
		local x1,y1,z1 = getWorldTranslation(self.karcuttingAreas[1].width);
		local x2,y2,z2 = getWorldTranslation(self.karcuttingAreas[1].height);
		local rotX, rotY, rotZ = getRotation(self.nyomjelj.node);
		if rotZ  >= self.nyomjelj.maxRot[3]-0.2 then		
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		end;
	end;

	if self.attacherVehicle.isAITractorActivated then				 				
		if self.fillLevel == 0 then
			AITractor.stopAITractor(self.attacherVehicle);
			self.stop = true;
		end;
		if self.attacherVehicle.turnStage == 0 then
			self.vetoMax = true;
		else
			self.vetoMax = false;
		end;
	end


    end;

    if self.vono1 ~= nil then
	local x, y, z = getRotation(self.vono1.node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.vono1.maxRot, self.vono1.minRot, 3, self.vono1.rotTime, dt, not self.vono1Max);
	setRotation(self.vono1.node, unpack(newRot));
    end;
    if self.vono2 ~= nil then
	local x, y, z = getRotation(self.vono2.node);
	local rot = {x,y,z};
	if x >= self.vono2.maxRot[1] then
		setVisibility(self.vono2.node, false);
		setVisibility(self.components[3].node, true);
		setRotation(self.henger, 0, 0, 0);
	else
		setVisibility(self.vono2.node, true);
		setVisibility(self.components[3].node, false);
		setRotation(self.henger, Utils.degToRad(15), 0, 0);
	end;
	local newRot = Utils.getMovedLimitedValues(rot, self.vono2.maxRot, self.vono2.minRot, 3, self.vono2.rotTime, dt, not self.vono2Max);
	setRotation(self.vono2.node, unpack(newRot));
    end;

end;

function ih6200:draw()

    if self.vono2Max then	
    	if self.nyomjelbMax and self.nyomjeljMax then
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelzo balra");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelzo jobbra");
    	elseif self.nyomjeljMax then
		g_currentMission:addExtraPrintText("NUM2 gomb: Nyomjelzo vissza");
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelzo balra");
    	elseif self.nyomjelbMax then
		g_currentMission:addExtraPrintText("NUM2 gomb: Nyomjelzo vissza");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelzo jobbra");
    	else
		g_currentMission:addExtraPrintText("NUM1 gomb: Nyomjelzo balra");
		g_currentMission:addExtraPrintText("NUM3 gomb: Nyomjelzo jobbra");
    	end;
    end;
    g_currentMission:addExtraPrintText("J gomb: Vontatas pont valtas");
    if self.tetoMax then
	g_currentMission:addExtraPrintText("K gomb: Fedel bezar");
    else
	g_currentMission:addExtraPrintText("K gomb: Fedel kinyit");
    end;
end;