
-- xyzspain
Agroluxx = {};

function Agroluxx.prerequisitesPresent(specializations)
  return true;
end;

function Agroluxx:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.9);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
-------------------------
    local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	--------------
	local ploughTurnSound = getXMLString(xmlFile, "vehicle.ploughTurnSound#file");
    if ploughTurnSound ~= nil and ploughTurnSound ~= "" then
        ploughTurnSound = Utils.getFilename(ploughTurnSound, self.baseDirectory); 
        self.ploughTurnSound = createSample("ploughTurnSound");
        self.ploughTurnSoundEnabled = false;
        loadSample(self.ploughTurnSound, ploughTurnSound, false);
        self.ploughTurnSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#pitchOffset"), 1);
        self.ploughTurnSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#volume"), 1);
    end;
	
	----------
	local ploughSound = getXMLString(xmlFile, "vehicle.ploughSound#file");
    if ploughSound ~= nil and ploughSound ~= "" then
        ploughSound = Utils.getFilename(ploughSound, self.baseDirectory); 
        self.ploughSound = createSample("ploughSound");
        self.ploughSoundEnabled = false;
        loadSample(self.ploughSound, ploughSound, false);
        self.ploughSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#pitchOffset"), 1);
        self.ploughSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#volume"), 1);
    end;
	-------------
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	
	--------------
local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
      
    end;
 local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
     
    end;
	 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	    self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
      
    end;
	local rotationNode20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation20#index"));
    if rotationNode20 ~= nil then
        self.rotation20 = {};
        self.rotation20.node = rotationNode20;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation20#minRot"));
        self.rotation20.minRot = {};
        self.rotation20.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation20.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation20.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation20#maxRot"));
        self.rotation20.maxRot = {};
        self.rotation20.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation20.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation20.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation20.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation20#rotTime"), 2)*1000;
      
    end;
 local rotationNode30 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation30#index"));
    if rotationNode30 ~= nil then
        self.rotation30 = {};
        self.rotation30.node = rotationNode30;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation30#minRot"));
        self.rotation30.minRot = {};
        self.rotation30.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation30.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation30.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation30#maxRot"));
        self.rotation30.maxRot = {};
        self.rotation30.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation30.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation30.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.rotation30.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation30#rotTime"), 2)*1000;
     
    end;
	 local rotationNode40 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation40#index"));
    if rotationNode40 ~= nil then
        self.rotation40 = {};
        self.rotation40.node = rotationNode40;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation40#minRot"));
        self.rotation40.minRot = {};
        self.rotation40.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation40.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation40.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation40#maxRot"));
        self.rotation40.maxRot = {};
        self.rotation40.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation40.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation40.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	    self.rotation40.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation40#rotTime"), 2)*1000;
      
    end;
	 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
     
    end;
	 local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

          self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
      
    end;
	 local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

       self.rotation7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#rotTime"), 2)*1000;
     
    end;
	 local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
       
    end;
  local rotationNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation9#index"));
    if rotationNode9 ~= nil then
        self.rotation9 = {};
        self.rotation9.node = rotationNode9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#minRot"));
        self.rotation9.minRot = {};
        self.rotation9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#maxRot"));
        self.rotation9.maxRot = {};
        self.rotation9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		
        self.rotation9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#rotTime"), 2)*1000;
    
    end;
	
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
         end;
	local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      end;
	

	---strobelight
	
	
	self.rundumleuchten1 = {};
    self.rundumleuchten1.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten1#rotNode"));
    self.rundumleuchten1.light = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten1#light"));
	self.strobelight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strobelight1#index"));
	self.rundumleuchten1.source = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten1#lightsource"));
    self.rundumleuchten1.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten1#rotSpeed"), 1)/1000;

	-- setVisibility(self.strobelight1, false);
	self.rundumleuchten2 = {};
    self.rundumleuchten2.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten2#rotNode"));
    self.rundumleuchten2.light = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten2#light"));
	self.strobelight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strobelight2#index"));
	self.rundumleuchten2.source = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rundumleuchten2#lightsource"));
    self.rundumleuchten2.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten2#rotSpeed"), 1)/1000;
	
	-- setVisibility(self.strobelight2, false);
	
	
	---- particulas
	self.groundParticleSystems = {};
    local groundParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.groundParticleSystems#count"), 0);
    for i=1, groundParticleSystemCount do
        local namei = string.format("vehicle.groundParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	self.groundParticleSystems1 = {};
    local groundParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.groundParticleSystems1#count"), 0);
    for i=1, groundParticleSystemCount do
        local namei = string.format("vehicle.groundParticleSystems1.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.groundParticleSystems1, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	
	----- deep wheel
	self.deepWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deepWheel#index"));
	
	----------
	
	
	 self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
	self.AIon = false;
	
	
	self.rotation1Max=false;
	self.prueba=false;
   self.transport =false;
 
end;

function Agroluxx:delete()

    if self.workSound ~= nil then
        delete(self.workSound);
    end;
 if self.ploughTurnSound ~= nil then
        delete(self.ploughTurnSound);
    end;
if self.ploughSound ~= nil then
        delete(self.ploughSound);
    end;	
end;

function Agroluxx:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Agroluxx:keyEvent(unicode, sym, modifier, isDown)
	if  self.go  then
		if isDown and sym == Input.KEY_x  then
		self.transport = not self.transport;
		
		end;
	end;

		

end;

function Agroluxx:update(dt)
	if self.attacherVehicle then
	
	---ai---
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.AIon = self.attacherVehicle.isAITractorActivated;
			
		end; 
			
	-----strobe light
		if self.transport then
		
			local x, y, z = getRotation(self.rotation20.node);
			if self.rotation1Max then
				if y < Utils.degToRad(14) then
				 self.playSoundHidraulic=true;
				end;
				if y > Utils.degToRad(14) then
				rotate(self.rundumleuchten2.rotNode, 0, dt*self.rundumleuchten2.speed, 0);
				setVisibility(self.rundumleuchten2.light, true);
				setVisibility(self.strobelight2, true);
				 self.playSoundHidraulic=false;
				end;
			end;
			if not self.rotation1Max then
				if y < Utils.degToRad(14) then
				 self.playSoundHidraulic=true;
				end;
				if y > Utils.degToRad(14) then
				rotate(self.rundumleuchten1.rotNode, 0, dt*self.rundumleuchten1.speed, 0);
				setVisibility(self.rundumleuchten1.light, true);
				setVisibility(self.strobelight1, true);
				self.playSoundHidraulic=false;
				end;
			end;
		else
			 local x, y, z = getRotation(self.rotation20.node);
			 
			 if y > Utils.degToRad(1) then
				 self.playSoundHidraulic=true;
				end;
				if y < Utils.degToRad(1) then
				 self.playSoundHidraulic=false;
				end;
						
			setVisibility(self.strobelight1, false);
			setVisibility(self.rundumleuchten1.light, false);
			setVisibility(self.strobelight2, false);
			setVisibility(self.rundumleuchten2.light, false);
		end;
		
		if self.playSoundHidraulic and not self.AIon then
		
						if not self.ploughSoundEnabled and self:getIsActiveForSound() then
							setSamplePitch(self.ploughSound, self.ploughSoundPitchOffset);
							playSample(self.ploughSound, 0, self.ploughSoundVolume, 0);
							self.ploughSoundEnabled = true;
						end;
		else
							if self.ploughSoundEnabled then
							stopSample(self.ploughSound);
							self.ploughSoundEnabled = false;
							end;
		end;
		if self.playSoundHidraulic1 and not self.AIon then
		
						if not self.ploughTurnSoundEnabled and self:getIsActiveForSound() then
							setSamplePitch(self.ploughTurnSound, self.ploughTurnSoundPitchOffset);
							playSample(self.ploughTurnSound, 0, self.ploughTurnSoundVolume, 0);
							self.ploughTurnSoundEnabled = true;
						end;
		else
							if self.ploughTurnSoundEnabled then
							stopSample(self.ploughTurnSound);
							self.ploughTurnSoundEnabled = false;
							end;
		end;
 ------ work
	
	
			
			
	
 self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.go  and not self.transport then
           self.rotation1Max = not self.rotation1Max ;
		      
		   self.playSoundHidraulic1=true;
        end;
    end;
	local x, y, z = getRotation(self.rotation1.node);
			
			if z > Utils.degToRad(-5)  then
			self.right=true;
			self.left=false;
			end;
			if z < Utils.degToRad(-175)  then
			self.right=false;
			self.left=true;
			
			
			end;
		
			if self.rotation1Max then
			
				if z > Utils.degToRad(-85)  then
				self.alineacion=true;
				end;
				if z < Utils.degToRad(-115)  then
				self.alineacion=false;
				end;
				if z < Utils.degToRad(-90)  then
				self.rotation5Max=true;
				self.rotation6Max=true;
				self.rotation7Max=true;
				end;
				if z < Utils.degToRad(-179)  then
				self.playSoundHidraulic1=false;
				end;
			end;
			if  not self.rotation1Max then
			
				if z > Utils.degToRad(-85)  then
				self.alineacion=false;
				end;
				if z < Utils.degToRad(-115)  then
				self.alineacion=true;
				end;
				if z > Utils.degToRad(-90)  then
				self.rotation5Max=false;
				self.rotation6Max=false;
				self.rotation7Max=false;
				end;
				if z > Utils.degToRad(-1)  then
				self.playSoundHidraulic1=false;
				end;
				
			end;
		
			---deep wheel
			if self.right then
			local x,y,z = getRotation(self.wheels[1].repr);	
			setRotation(self.deepWheel, x, y, z);
			end; 
			if self.left then
			local x,y,z = getRotation(self.wheels[1].repr);	
			setRotation(self.deepWheel, x*-1, y, z);
			end; 
			
			---alineacion
			if self.alineacion then 
				self.rotation2Max=true;
				self.rotation3Max=true;
				self.rotation4Max=true;
			else
				self.rotation2Max=false;
				self.rotation3Max=false;
				self.rotation4Max=false;
			end;
			---transporte
			if self.transport then 
				self.rotation20Max=true;
				self.rotation30Max=true;
				self.rotation40Max=true;
			else
				self.rotation20Max=false;
				self.rotation30Max=false;
				self.rotation40Max=false;
			end;
			-----------------
					if self.right then
						self.translation1Max = true;
						self.translation2Max = false;
						
					end;
					if self.left then
						self.translation1Max = false;
						self.translation2Max = true;
						
					end;
			
 
	 ----------------
			
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 18;
			if not toFast then
					
					local x,y,z = getWorldTranslation(self.groundReferenceNode);
					local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				if terrainHeight+self.groundReferenceThreshold >= y then 
					self.go=false;
					
			
					if table.getn(self.cuttingAreas) > 0 then
					local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
					Utils.updatePloughArea(x, z, x1, z1, x2, z2);
					if self.attacherVehicle.lastSpeed*3600 > 3 then
						if self.right then
						Utils.setEmittingState(self.groundParticleSystems, true)
						end;
						if self.left then
						Utils.setEmittingState(self.groundParticleSystems1, true)
						end;
					end;
					end;
				
					if self.attacherVehicle.lastSpeed*3600 > 2 and not self.AIon then
						if not self.workSoundEnabled and self:getIsActiveForSound() then
							setSamplePitch(self.workSound, self.workSoundPitchOffset);
							playSample(self.workSound, 0, self.workSoundVolume, 0);
							self.workSoundEnabled = true;
						end;
						
					end;
						if self.attacherVehicle.lastSpeed*3600 < 2 then
							 if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = false;
							end;
							Utils.setEmittingState(self.groundParticleSystems, false)
							Utils.setEmittingState(self.groundParticleSystems1, false)
						end;
				else
					
							self.go=true;
						if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = false;
						end;
							Utils.setEmittingState(self.groundParticleSystems, false)
							Utils.setEmittingState(self.groundParticleSystems1, false)
                end;
				
				end;
         

            

            self.wasToFast = toFast;
	
		

   
	
end;---attacher
	
	
	--rotaciones y translaciones

	if self.rotation1Max ~= nil  then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	if self.rotation2Max ~= nil then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.rotation3Max ~= nil then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	if self.rotation4Max ~= nil then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	if self.rotation20Max ~= nil then
        local x, y, z = getRotation(self.rotation20.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation20.maxRot, self.rotation20.minRot, 3, self.rotation20.rotTime, dt, not self.rotation20Max);
        setRotation(self.rotation20.node, unpack(newRot));
    end;
	if self.rotation30Max ~= nil then
        local x, y, z = getRotation(self.rotation30.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation30.maxRot, self.rotation30.minRot, 3, self.rotation30.rotTime, dt, not self.rotation30Max);
        setRotation(self.rotation30.node, unpack(newRot));
    end;
	if self.rotation40Max ~= nil then
        local x, y, z = getRotation(self.rotation40.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation40.maxRot, self.rotation40.minRot, 3, self.rotation40.rotTime, dt, not self.rotation40Max);
        setRotation(self.rotation40.node, unpack(newRot));
    end;
	if self.rotation5Max ~= nil then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;
	if self.rotation6Max ~= nil then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;
	if self.rotation7Max ~= nil then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7Max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;
if self.rotation8Max ~= nil then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
	
	if self.rotation9Max ~= nil then
        local x, y, z = getRotation(self.rotation9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation9.maxRot, self.rotation9.minRot, 3, self.rotation9.rotTime, dt, not self.rotation9Max);
        setRotation(self.rotation9.node, unpack(newRot));
		
    end;

	if self.translation1Max ~= nil then
	local x, y, z = getTranslation(self.translation1.node);
	local trans = {x,y,z};
	local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max);
	setTranslation(self.translation1.node, unpack(newTrans));
	end;
	if self.translation2Max ~= nil then
	local x, y, z = getTranslation(self.translation2.node);
    local trans = {x,y,z};
     local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2Max);
      setTranslation(self.translation2.node, unpack(newTrans));
	end;		

	-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		
		
		
	
		
		
		self:setHydraulicDirection();
end;

function Agroluxx:draw()

	if self.AIon == false then
		g_currentMission:addExtraPrintText("Rear plough :x transport, b turn");
	end;
 end;
function Agroluxx:onAttach()
	Utils.setEmittingState(self.groundParticleSystems, false)
	Utils.setEmittingState(self.groundParticleSystems1, false)



	if not self.rotation1Max then
			self.rotation8Max=true;
	elseif self.rotation1Max then
			self.rotation8Max=true;
			self.rotation9Max=false;
	end;

end;
function Agroluxx:onDetach()
Utils.setEmittingState(self.groundParticleSystems, false)
Utils.setEmittingState(self.groundParticleSystems1, false)

    if self.deactivateOnDetach then
        Agroluxx.onDeactivate(self);
    else
        Agroluxx.onDeactivateSounds(self)
    end;
	self.translation1Max = false;
	self.translation2Max = false;

	
	self.rotation20Max=false;
	self.rotation30Max=false;
	self.rotation40Max=false;
	setVisibility(self.strobelight1, false);
	setVisibility(self.strobelight2, false);
		if not self.rotation1Max then
			self.rotation8Max=false;
		elseif self.rotation1Max then
			self.rotation8Max=true;
			self.rotation9Max=true;
		end;
end;

function Agroluxx:onLeave()

    if self.deactivateOnLeave then
        Agroluxx.onDeactivate(self);
    else
        Agroluxx.onDeactivateSounds(self)
    end;

end;

function Agroluxx:onDeactivate()

    Agroluxx.onDeactivateSounds(self)
   

end;

function Agroluxx:onDeactivateSounds()

    if self.workSoundEnabled then
        stopSample(self.workSound);
        self.workSoundEnabled = false;
    end;
	 if self.ploughTurnSoundEnabled then
		stopSample(self.ploughTurnSound);
		self.ploughTurnSoundEnabled = false;
	end;
	if self.ploughSoundEnabled then
		stopSample(self.ploughSound);
		self.ploughSoundEnabled = false;
	end;
	
end;

function Agroluxx:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
function Agroluxx :aiLower()

end; 


function Agroluxx:aiRaise()
 self.rotation1Max = not self.rotation1Max ;

end; 