--
-- HL80
-- Class for all Dolly Trailers
--
-- @author  Jack
-- @date  25/04/09
--
-- Copyright (C) Jack

HL80 = {};

function HL80.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function HL80:load(xmlFile)

    self.setFillLevel = SpecializationUtil.callSpecializationsFunction("setFillLevel");

-- KippFunktion
    local tipAnimRootNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tipAnimation#rootNode"));
    self.tipAnimCharSet = 0;
    if tipAnimRootNode ~= nil and tipAnimRootNode ~= 0 then
        self.tipAnimCharSet = getAnimCharacterSet(tipAnimRootNode);
        if self.tipAnimCharSet ~= 0 then
		-- Nach Rechts kippen
            self.clip = getAnimClipIndex(self.tipAnimCharSet, getXMLString(xmlFile, "vehicle.tipAnimation#clip"));
		-- Nach Links kippen
            self.clipleft = getAnimClipIndex(self.tipAnimCharSet, getXMLString(xmlFile, "vehicle.tipAnimation#clipleft"));
		-- assignAnimTrackClip(self.tipAnimCharSet, 0, self.clip);
            setAnimTrackLoopState(self.tipAnimCharSet, 0, false);
            self.tipAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tipAnimation#speedScale"), 1);
            self.tipAnimDuration = getAnimClipDuration(self.tipAnimCharSet, self.clip);
            if self.tipDischargeEndTime == nil then
                self.tipDischargeEndTime = self.tipAnimDuration*2.0;
            end;
        end;
    end;

-- nach Rechts kippen

    self.tipReferencePointright = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tipReferencePointright#index"));

-- ParticleSystemright
    self.dischargeParticleSystemsright = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.dischargeParticleSystemsright.dischargeParticleSystemright(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "", self.baseDirectory);
            self.dischargeParticleSystemsright[desc.index] = currentPS;
            if self.defaultdischargeParticleSystems == nil then
                self.defaultdischargeParticleSystems = currentPS;
            end;
        end;
        i = i + 1;
    end;

-- nach Rechts kippen (ende)


-- nach Links kippen

    self.tipReferencePointleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tipReferencePointleft#index"));

-- ParticleSystemleft
    self.dischargeParticleSystemsleft = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.dischargeParticleSystemsleft.dischargeParticleSystemleft(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "", self.baseDirectory);
            self.dischargeParticleSystemsleft[desc.index] = currentPS;
            if self.defaultdischargeParticleSystems == nil then
                self.defaultdischargeParticleSystems = currentPS;
            end;
        end;
        i = i + 1;
    end;

-- nach Links kippen (ende)
--Kippfunktion (ende)		

	
  	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	

-- Bremslichter
    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

    self.hudBasePoxX = 0.8325;
    self.hudBasePoxY = (1-0.72);
    self.hudBaseWidth = 0.16;
    self.hudBaseHeight = 0.1825;

    self.hudTrailerpath = Utils.getFilename("fliegl_hud_gross2.png", self.baseDirectory);
    self.hudTrailerPoxX = 0.8325;
    self.hudTrailerPoxY = (1-0.62);
    self.hudTrailerWidth = 0.16;
    self.hudTrailerHeight = 0.165;
    self.hudTrailerOverlay = Overlay:new("hudTrailerDisplay", self.hudTrailerpath, self.hudTrailerPoxX, self.hudTrailerPoxY, self.hudTrailerWidth, self.hudTrailerHeight);

    self.helpPanel = false;
    self.tipright = true;
    self.tipleft = false;

    self.brakelightsActive = false;
    self.braking = false;
    self.attached = true;
    self.isHL80 = true;
end;

function HL80:delete()
	Utils.deleteParticleSystem(self.dischargeParticleSystemsright);
	Utils.deleteParticleSystem(self.dischargeParticleSystemsleft);
       
end;


function HL80:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HL80:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym==self.keys.links then
		self.Go.links = not self.Go.links; 
		self.Done.links = true; 
		end;

	if isDown and sym==self.keys.rechts then
		self.Go.rechts = not self.Go.rechts; 
		self.Done.rechts = true; 
		end;

	if isDown and sym == self.keys.HELP then
		self.helpPanel = not self.helpPanel;
	end;
		if isDown and sym == self.keys.RIGHT then
		self.tipright = not self.tipright;
		self.tipleft = false;
	end;
		if isDown and sym == self.keys.LEFT then
		self.tipleft = not self.tipleft;
		self.tipright = false;
	end;

end;

function HL80:setFillLevel(fillLevel, fillType)
    if not self:allowFillType(fillType, false) then
        return;
    end;

    self.currentFillType = fillType;
    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
        -- reset fill type as the trailer is empty
        Utils.setEmittingState(self.dischargeParticleSystemsleft[self.currentFillType], false);
        Utils.setEmittingState(self.dischargeParticleSystemsright[self.currentFillType], false);
        self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
    end;
end;


function HL80:update(dt)

	-- Bremslicht
		local inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);

		if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.attacherVehicle.movingDirection*self.attacherVehicle.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;

		end;

-- Fillsound abschalten

        if self.fillSoundEnabled and self.fillLevel == 0 or self.tipState == Trailer.TIPSTATE_CLOSING then
            stopSample(self.fillSound);
            self.fillSoundEnabled = false;   
        end;

-- KippFunktion
if self.tipState == Trailer.TIPSTATE_CLOSED then

-- nach Rechts kippen (standart)
	if self.tipright then
	self.tipReferencePoint = self.tipReferencePointright;
	assignAnimTrackClip(self.tipAnimCharSet, 0, self.clip);
	end;
-- nach Rechts kippen (ende)

-- Nach Links kippen
if self.tipleft then
	self.tipReferencePoint = self.tipReferencePointleft;
	assignAnimTrackClip(self.tipAnimCharSet, 0, self.clipleft);
end;
-- nach Links kippen (ende)
end;
-- Kippfunktion (ende)	

-- Discharge Systems
-- rechts
if self.tipright then
        Utils.setEmittingState(self.dischargeParticleSystemsright[self.currentFillType], self.lastFillDelta < 0);
end;
-- rechts (ende)

--links
if self.tipleft then
        Utils.setEmittingState(self.dischargeParticleSystemsleft[self.currentFillType], self.lastFillDelta < 0);
    end;
-- links (ende)

--[[if self.fillLevel == 0 then
        Utils.setEmittingState(self.dischargeParticleSystemsleft[self.currentFillType], false);
        Utils.setEmittingState(self.dischargeParticleSystemsright[self.currentFillType], false);
    end;]]

-- renderText(0.01, 0.06, 0.02, string.format("%d", self.lastFillDelta));


-- Discharge Systems (ende)

end;


function HL80:draw()

		if g_currentMission.currentVehicle ~= nil then
            for i=1, table.getn(g_currentMission.currentVehicle.attachedImplements) do
                if g_currentMission.currentVehicle.attachedImplements[i].object and g_currentMission.currentVehicle.attachedImplements[i].object.isSelected then
		trailer = g_currentMission.currentVehicle.attachedImplements[i].object;

	self.attached = true;

end;
end;
end;
            for i=1, table.getn(self.attachedImplements) do
                if self.attachedImplements[i].object and self.attachedImplements[i].object.isSelected then
		trailer1 = self.attachedImplements[i].object;

	self.attached = false;
end;
end;


	-- SchriftFarbe und Gre
		setTextBold(true);
		setTextColor(1.0, 1.0, 1.0, 1.0);


if self.attached and self.isHL80 then
	self.hudTrailerOverlay:render();
--   renderText(0.01, 0.08, 0.02, string.format("%d", trailer.fillLevel));
       local percent = trailer.fillLevel/trailer.capacity*100;
    renderText(self.hudTrailerPoxX+0.02, self.hudTrailerPoxY+0.097, 0.028, string.format("%.0f(%d%%)", trailer.fillLevel, percent));

else
	if trailer1.isHL80 then
 --    renderText(0.01, 0.06, 0.02, string.format("%d", trailer1.fillLevel));
       local percent = trailer1.fillLevel/trailer1.capacity*100;
    renderText(self.hudTrailerPoxX+0.02, self.hudTrailerPoxY+0.065, 0.028, string.format("%.0f(%d%%)", trailer1.fillLevel, percent));
end;
end;


	-- HelpPanel Anhnger1+2

		if self.attached and self.isHL80 then
		if not self.helpPanel then		
	    	renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.17, 0.02, "Wcisnij "..key_convert(self.keys.HELP)..": Wyswietl info");		
		else
		renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.17, 0.02, "Wcisnij "..key_convert(self.keys.HELP)..": Ukryj info");
		end;
			if self.helpPanel then
			renderText(self.hudTrailerPoxX+0.015, self.hudTrailerPoxY+0.30, 0.03, "- HL 80 Info -");		

-- Anhnger1 tip
			renderText(self.hudTrailerPoxX+0.025, self.hudTrailerPoxY+0.27, 0.02, "- Kiprowanie -");
			renderText(self.hudTrailerPoxX+0.042, self.hudTrailerPoxY+0.25, 0.02, "Przyczepa 1+2");
			if self.tipright and self.tipleft == false then
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.22, 0.02, "Wcisnij "..key_convert(self.keys.RIGHT)..": W prawo wl");
			else
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.22, 0.02, "Wcisnij "..key_convert(self.keys.RIGHT)..": W prawo wyl");
			end;

			if self.tipright == false and self.tipleft then
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.20, 0.02, "Wcisnij "..key_convert(self.keys.LEFT)..": W lewo wl");
			else
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.20, 0.02, "Wcisnij "..key_convert(self.keys.LEFT)..": W lewo wyl");
			end;
			
			end;

	--		end;
end;
       

		-- 2nd trailer

--[[	-- HelpPanel Anhnger1
		
		if self.attached then
		if not self.helpPanel then		
	    	renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.17, 0.02, "Wcisnij "..key_convert(self.keys.HELP)..": Wyswietl info");		
		else
		renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.17, 0.02, "Wcisnij "..key_convert(self.keys.HELP)..": Ukryj info");
		end;
		--	if not self.SchneckenSystemActive then
			if self.helpPanel then
			renderText(self.hudTrailerPoxX+0.015, self.hudTrailerPoxY+0.31, 0.03, "- HL 80 Info -");

-- Anhnger1 tip
			renderText(self.hudTrailerPoxX+0.025, self.hudTrailerPoxY+0.28, 0.02, "- Kiprowanie -");
			renderText(self.hudTrailerPoxX+0.042, self.hudTrailerPoxY+0.26, 0.02, "Przyczepa 1");
			if self.tipright and self.tipleft == false then
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.24, 0.02, "Wcisnij "..key_convert(self.keys.RIGHT)..": W prawo wl");
			else
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.24, 0.02, "Wcisnij "..key_convert(self.keys.RIGHT)..": W prawo wyl");
			end;

			if self.tipright == false and self.tipleft then
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.22, 0.02, "Wcisnij "..key_convert(self.keys.LEFT)..": W lewo wl");
			else
				renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.22, 0.02, "Wcisnij "..key_convert(self.keys.LEFT)..": W lewo wyl");
			end;

		--	renderText(self.hudTrailerPoxX+0.001, self.hudTrailerPoxY+0.20, 0.02, "Wcisnij "..key_convert(self.keys.SCHNECKENSYSTEM))..": SchneckenSystem an");
			end;
	-- end;


end;
-- end; ]]

	--[[	if self.planeActive and self.attachedTrailer and not self.attachedTrailer1 then
		self.hudTrailerpath = Utils.getFilename("fliegl_hud_gross_1_zu.png", self.baseDirectory);
	    self.hudTrailerOverlay = Overlay:new("hudTrailerDisplay", self.hudTrailerpath, self.hudTrailerPoxX, self.hudTrailerPoxY, self.hudTrailerWidth, self.hudTrailerHeight);
		else
		self.hudTrailerpath = Utils.getFilename("fliegl_hud_gross_1_offen.png", self.baseDirectory);
   	 self.hudTrailerOverlay = Overlay:new("hudTrailerDisplay", self.hudTrailerpath, self.hudTrailerPoxX, self.hudTrailerPoxY, self.hudTrailerWidth, self.hudTrailerHeight);
		end;]]


		if self.attached then	
		-- if not self.attachedImplements.SchneckenSystemActive then
		if self.tipright then
			setTextBold(true);
			setTextColor(5.3, 8.3, 0.6, 1.0);			
	    	renderText(self.hudTrailerPoxX+0.07, self.hudTrailerPoxY+0.020, 0.03, "R");
			setTextColor(1.0, 1.0, 1.0, 1.0);
		end;

		if self.tipleft then
			setTextBold(true);
			setTextColor(5.3, 8.3, 0.6, 1.0);			
	    	renderText(self.hudTrailerPoxX+0.07, self.hudTrailerPoxY+0.020, 0.03, "L");
			setTextColor(1.0, 1.0, 1.0, 1.0);
		end;

	-- end;
	end;
		-- Dolly & Dolly Trailer (ende)
	

end;

function key_convert(key)
	if key < 256 then
		return string.upper(""..string.char(key).."");
	elseif key > 255 and key < 266 then
		return string.upper("KP"..string.char(key-208));
	else
		return "n/a";
	end;
end;


function HL80:mouseEvent(posX, posY, isDown, isUp, button)
end;


