--by xyzspain
HESSTON4322 = {};

function HESSTON4322.prerequisitesPresent(specializations)   
return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;
function HESSTON4322:load(xmlFile)
 
 self.groundCheck = {};
	self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));
	
self.setCilindroDirection = SpecializationUtil.callSpecializationsFunction("setCilindroDirection");	
	local cilindrosCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cilindros#count"), 0);	
	self.cilindros = {};	
	for i=1, cilindrosCount do
		local cilindroName = string.format("vehicle.cilindros.cilindro%d", i);		
		self.cilindros[i] = {};		
		self.cilindros[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#index"));
		self.cilindros[i].part = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#part"));
		self.cilindros[i].cilindroFixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#cilindroFixpoint"));
		self.cilindros[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#fixpoint"));
		local ax, ay, az = getWorldTranslation(self.cilindros[i].part);
		local bx, by, bz = getWorldTranslation(self.cilindros[i].cilindroFixpoint);		
		self.cilindros[i].partDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;	
local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

           self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
      
    end;
 local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
      self.rotation3.rotTime =self.rotation2.rotTime;
     
    end;
	 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
	
          self.rotation4.rotTime = self.rotation1.rotTime;
      
    end;
	 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

	
       self.rotation5.rotTime = self.rotation1.rotTime;
     
    end;
	 local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		
          self.rotation6.rotTime = self.rotation1.rotTime;
      
    end;
	 local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		
       self.rotation7.rotTime = self.rotation1.rotTime;
     
    end;
	 local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

           self.rotation8.rotTime = self.rotation1.rotTime;
       
    end;
  local rotationNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation9#index"));
    if rotationNode9 ~= nil then
        self.rotation9 = {};
        self.rotation9.node = rotationNode9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#minRot"));
        self.rotation9.minRot = {};
        self.rotation9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#maxRot"));
        self.rotation9.maxRot = {};
        self.rotation9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

           self.rotation9.rotTime = self.rotation1.rotTime;
       
    end;
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	

        self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
		local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

	

        self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      
    end;
		local translationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation3#index"));
    if translationNode3 ~= nil then
        self.translation3 = {};
        self.translation3.node = translationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#minTrans"));
        self.translation3.minTrans = {};
        self.translation3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#maxTrans"));
        self.translation3.maxTrans = {};
        self.translation3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translation3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation3#transTime"), 2)*1000;
        end;
	local translationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation4#index"));
    if translationNode4 ~= nil then
        self.translation4 = {};
        self.translation4.node = translationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#minTrans"));
        self.translation4.minTrans = {};
        self.translation4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#maxTrans"));
        self.translation4.maxTrans = {};
        self.translation4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translation4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation4#transTime"), 2)*1000;
        end;
		 local translationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation5#index"));
    if translationNode5 ~= nil then
        self.translation5 = {};
        self.translation5.node = translationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#minTrans"));
        self.translation5.minTrans = {};
        self.translation5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation5#maxTrans"));
        self.translation5.maxTrans = {};
        self.translation5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation5.maxTrans[3] = Utils.getNoNil(z, 0);

		
        self.translation5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation5#transTime"), 2)*1000;
      end;
	  		 local translationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation6#index"));
    if translationNode6 ~= nil then
        self.translation6 = {};
        self.translation6.node = translationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#minTrans"));
        self.translation6.minTrans = {};
        self.translation6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation6#maxTrans"));
        self.translation6.maxTrans = {};
        self.translation6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation6.maxTrans[3] = Utils.getNoNil(z, 0);

		
        self.translation6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation6#transTime"), 2)*1000;
      end;
	  		 local translationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation7#index"));
    if translationNode7 ~= nil then
        self.translation7 = {};
        self.translation7.node = translationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation7#minTrans"));
        self.translation7.minTrans = {};
        self.translation7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation7#maxTrans"));
        self.translation7.maxTrans = {};
        self.translation7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation7.maxTrans[3] = Utils.getNoNil(z, 0);

		
        self.translation7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation7#transTime"), 2)*1000;
      end;
	local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;	

	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
 self.pie1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie1#index"));
	self.pie2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie2#index"));
 self.pie3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie3#index"));
 self.numSol = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sol#count"), 0); 
 self.sol = {}; 
 for i=1, self.numSol do 
     local partnamei = string.format("vehicle.sol.part" .. "%d", i); 
     self.sol[i] = {}; 
     self.sol[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
     self.sol[i].speed = Utils.getNoNil(getXMLInt(xmlFile, partnamei.."#rotSpeed"), 1); 
 end; 
 self.numSol1 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sol1#count"), 0); 
 self.sol1 = {}; 
 for i=1, self.numSol1 do 
     local partnamei = string.format("vehicle.sol1.part" .. "%d", i); 
     self.sol1[i] = {}; 
     self.sol1[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
     self.sol1[i].speed = Utils.getNoNil(getXMLInt(xmlFile, partnamei.."#rotSpeed"), 1); 
 end; 
  local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;

    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;
self.lastSpeed = 0; 

self.controlpath = Utils.getFilename("4322.jpg", self.baseDirectory);
   
    self.hud4322PoxX = 0.01;
    self.hud4322PoxY = 1-0.204;
    self.hud4322Width = 0.240;
    self.hud4322Height = 0.240;
    self.hud4322PoxX = 0.75;
    self.hud4322PoxY = 0.60
    self.hud4322Overlay = Overlay:new("hud4322", self.controlpath, self.hud4322PoxX, self.hud4322PoxY, self.hud4322Width, self.hud4322Height);
     self.bcActive = false;
 setVisibility(self.pie1, true);
 setVisibility(self.pie2, true);
 setVisibility(self.pie3, false);
 
end;

function HESSTON4322:delete()
if self.workSound ~= nil then
        delete(self.workSound);
    end;
 end;


function HESSTON4322:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HESSTON4322:keyEvent(unicode, sym, modifier, isDown)
   if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;

    if sym == Input.KEY_KP_9 then
		self.translation1max = isDown;
	
	end;
	if sym == Input.KEY_KP_7 then
		self.translation1min = isDown;
		
	end;
	 if sym == Input.KEY_KP_8 then
		self.translation2max = isDown;
		self.translation3max = isDown;
		self.rotation7max = isDown;
	end;
	if sym == Input.KEY_KP_2 then
		self.translation2min = isDown;
		self.translation3min = isDown;
		self.rotation7min = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.rotation2max = isDown;
		self.rotation3max = isDown;
		self.rotation4max = isDown;
		self.rotation5max = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.rotation2min = isDown;
		self.rotation3min = isDown;
		self.rotation4min = isDown;
		self.rotation5min = isDown;
	end;
	
	if sym == Input.KEY_KP_3 then
		self.rotation1max = isDown;
		self.translation6max = isDown;
		self.translation7max = isDown;
		self.rotation6max = isDown;
		self.rotation8max = isDown;
		self.rotation9max = isDown;
		
	end;
	if sym == Input.KEY_KP_1 then
		self.rotation1min = isDown;
		self.translation6min = isDown;
		self.translation7min = isDown;
		self.rotation6min = isDown;
		self.rotation8min = isDown;
		self.rotation9min = isDown;
	end;
	  if isDown and sym == Input.KEY_x then 
		self.rotParts = not self.rotParts;
		self.translation4max = not self.translation4max;
		self.translation5max = not self.translation5max;
	end; 



end;


function HESSTON4322:update(dt)

	if self.attacherVehicle then
		if self.attacherVehicle.lastSpeed*3600 > 2 and self.rotParts then
			 for i=1, self.numSol do 
          rotate(self.sol[i].index,self.sol[i].speed/0.2*dt,0,0);
		  end;
		 	 for i=1, self.numSol1 do 
          rotate(self.sol1[i].index,self.sol1[i].speed/-0.2*dt,0,0);
		  end;
			if not self.workSoundRunning then
                print("start");
                playSample(self.workSound, 0, 1.6, 0);
                self.workSoundRunning = true;
			end;
			 local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    local foldAnimTime = self.foldAnimTime;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[i];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;

				if self.rotParts then

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
                                    end;
                                end;
                           
                            end;
                        end;
                    end;
                end;
end;
			if self.attacherVehicle.lastSpeed*3600 < 2 or  not self.rotParts  then
			if self.workSoundRunning then
                print("end");
                stopSample(self.workSound, 0, 1.6, 0);
                self.workSoundRunning = false;
			end;
			end;
end;

local doTranslate = self.translation1max or self.translation1min 
	if self.translation1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end; 
	local doTranslate = self.translation2max or self.translation2min 
	if self.translation2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2max); 
		setTranslation(self.translation2.node, unpack(newTrans)); 
	end;
local doTranslate = self.translation3max or self.translation3min 
	if self.translation3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation3.maxTrans, self.translation3.minTrans, 3, self.translation3.transTime, dt, not self.translation3max); 
		setTranslation(self.translation3.node, unpack(newTrans)); 
	end;
local doTranslate = self.translation6max or self.translation6min 
	if self.translation6 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation6.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation6.maxTrans, self.translation6.minTrans, 3, self.translation6.transTime, dt, not self.translation6max); 
		setTranslation(self.translation6.node, unpack(newTrans)); 
	end;
	local doTranslate = self.translation7max or self.translation7min 
	if self.translation7 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation7.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation7.maxTrans, self.translation7.minTrans, 3, self.translation7.transTime, dt, not self.translation7max); 
		setTranslation(self.translation7.node, unpack(newTrans)); 
	end;
	local doRotate = self.rotation1max or self.rotation1min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation2max or self.rotation2min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
    local doRotate = self.rotation3max or self.rotation3min 
	if self.rotation3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
	 local doRotate = self.rotation4max or self.rotation4min 
	if self.rotation4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	 local doRotate = self.rotation5max or self.rotation5min 
	if self.rotation5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;
	
	 local doRotate = self.rotation6max or self.rotation6min 
	if self.rotation6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;
	 local doRotate = self.rotation7max or self.rotation7min 
	if self.rotation7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;
	 local doRotate = self.rotation8max or self.rotation8min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
	 local doRotate = self.rotation9max or self.rotation9min 
	if self.rotation9 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation9.maxRot, self.rotation9.minRot, 3, self.rotation9.rotTime, dt, not self.rotation9max);
        setRotation(self.rotation9.node, unpack(newRot));
    end;
	

	
	
	if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;
	if self.translation4max ~= nil then
		local x, y, z = getTranslation(self.translation4.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translation4.maxTrans, self.translation4.minTrans, 3, self.translation4.transTime, dt, not self.translation4max);
        setTranslation(self.translation4.node, unpack(newTrans));
		end;	
if self.translation5max ~= nil then
		local x, y, z = getTranslation(self.translation5.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translation5.maxTrans, self.translation5.minTrans, 3, self.translation5.transTime, dt, not self.translation5max);
        setTranslation(self.translation5.node, unpack(newTrans));
		end;	




		
	local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);						
	self:setCilindroDirection();

end;
function HESSTON4322:draw()
	 if self.hud4322Overlay ~= nil then
  if self.bcActive then
    self.hud4322Overlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("play 0: memu Off");
		else
			g_currentMission:addExtraPrintText("play 0: memu On");
		end;
end;
function HESSTON4322:onAttach()	

setVisibility(self.pie3, true);
setVisibility(self.pie1, false);
setVisibility(self.pie2, false);		

end;

function HESSTON4322:onDetach()
 


   if self.workSoundRunning then
                print("end");
                stopSample(self.workSound, 0, 1.6, 0);
                self.workSoundRunning = false;
	end;
	
    	setVisibility(self.pie3, false);
    	setVisibility(self.pie1, true);
    	setVisibility(self.pie2, true);		
end;
function HESSTON4322:onLeave()
   
	
end;

function HESSTON4322:setCilindroDirection()
	for i=1, table.getn(self.cilindros) do
		local ax, ay, az = getWorldTranslation(self.cilindros[i].node);
		local bx, by, bz = getWorldTranslation(self.cilindros[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.cilindros[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.cilindros[i].node, x, y, z, 0, 1, 0);
		if self.cilindros[i].part ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.cilindros[i].part,0 ,0 ,distance-self.cilindros[i].partDistance);
		end;	
	end;
end;




