-- SetFillLevelEvent
-- Specialisation to send the fillLevel of MapWaterTriggers
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  10/09/2011

SetFillLevelEvent = {};
SetFillLevelEvent_mt = Class(SetFillLevelEvent, Event);

InitEventClass(SetFillLevelEvent, "SetFillLevelEvent");

function SetFillLevelEvent:emptyNew()
    local self = Event:new(SetFillLevelEvent_mt);
    self.className = "SetFillLevelEvent";
    return self;
end;

function SetFillLevelEvent:new(object, newfillLevel)
    local self = SetFillLevelEvent:emptyNew()
    self.object = object;
	self.fillLevel = newfillLevel;
    return self;
end;

function SetFillLevelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fillLevel = streamReadFloat32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetFillLevelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.fillLevel);
end;

function SetFillLevelEvent:run(connection)
	self.object:setFillLevel(self.fillLevel, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFillLevelEvent:new(self.object, self.fillLevel), nil, connection, self.object);
    end;
end;

function SetFillLevelEvent.sendEvent(object, newfillLevel, noEventSend)
	if object.fillLevel ~= newfillLevel then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetFillLevelEvent:new(object, newfillLevel), nil, nil, object);
			else
				g_client:getServerConnection():sendEvent(SetFillLevelEvent:new(object, newfillLevel));
			end;
		end;
	end;
end;

