--
-- isBogged
-- Specialization for Vaderstad Carrier allowing to have part bogged if the tool is working too deep.
-- @uthor : Bayn - www.tsforum3.com
-- D@te : 23.09.2010
--
-- This script has been made under "OpenSource rules". 
-- That means you can use it without asking authorization, but also without forgetting to quote the author's name.

isBogged = {};

function isBogged.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function isBogged:load(xmlFile)
	-- Generate a random event --
	self.boggedRandomEvent = SpecializationUtil.callSpecializationsFunction("boggedRandomEvent");
	
	local StuckMudNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.StuckMud#index"));
    if StuckMudNode ~= nil then
        self.StuckMud = {};
        self.StuckMud.node = StuckMudNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StuckMud#minTrans"));
        self.StuckMud.minTrans = {};
        self.StuckMud.minTrans[1] = Utils.getNoNil(x, 0);
        self.StuckMud.minTrans[2] = Utils.getNoNil(y, 0);
        self.StuckMud.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StuckMud#maxTrans"));
        self.StuckMud.maxTrans = {};
        self.StuckMud.maxTrans[1] = Utils.getNoNil(x, 0);
        self.StuckMud.maxTrans[2] = Utils.getNoNil(y, 0);
        self.StuckMud.maxTrans[3] = Utils.getNoNil(z, 0);

        self.StuckMud.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.StuckMud#transTime"), 2)*1000;
        self.StuckMud.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.StuckMud#touchTransLimit"), 10);
    end;
	setVisibility(self.StuckMud.node,false);
	
	self.BoggedPart = {};
	self.BoggedPart.Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BoggedPart#index"));
	self.BoggedPart.Mass = getMass(self.BoggedPart.Node);
	
	-- Independent Variables --	
	self.isBogged = false;
	self.RandomEventNumber = 420000;
	self.StuckMudMin = true;
end;

function isBogged:delete()
end;

function isBogged:mouseEvent(posX, posY, isDown, isUp, button)
end;

function isBogged:keyEvent(unicode, sym, modifier, isDown)
end;

function isBogged:update(dt)
    if self.attacherVehicle then
		if self.isActive then
		local toFast = false;
		toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 16;
			
			-- if the Carrier is working deep and if working time = breakdown time, a part will be bogged and the mud will be visible --			
			if self.AdjusterNumber <= 5 and self.CWorkingTime >= self.RandomEventNumber and self.movingDirection == 1 and not self.MovingPartsMax or toFast and not self.MovingPartsMax then
				self.isBogged = true;
				setVisibility(self.StuckMud.node, true);
				self.StuckMudMax = true;
			else
				self.StuckMudMax = false;
			end;

			-- if the Carrier is bogged and if player is moving backward with moving parts up, then the mud slowly disappear --
			local newMass = self.BoggedPart.Mass * 600;
			if self.isBogged then				
				if self.movingDirection == -1 and self.MovingPartsMax then
					local newMass2 = self.BoggedPart.Mass * 6;
					setMass(self.BoggedPart.Node, newMass2);					
					local x, y, z = getTranslation(self.StuckMud.node);					
					if x >= 0.50 then
						self.isBogged = false;
						self.CWorkingTime = 0;
					end;
					self.StuckMudMin = true;
					self:boggedRandomEvent();
				else
					setMass(self.BoggedPart.Node, newMass);
					self.StuckMudMin = false;
				end;
			else
				setMass(self.BoggedPart.Node, self.BoggedPart.Mass);
				setVisibility(self.StuckMud.node, false);					
			end;
			
			local doTranslate = self.StuckMudMax or self.StuckMudMin 
			if self.StuckMud ~= nil and doTranslate then	
				local x, y, z = getTranslation(self.StuckMud.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.StuckMud.maxTrans, self.StuckMud.minTrans, 3, self.StuckMud.transTime, dt, not self.StuckMudMax);
				setTranslation(self.StuckMud.node, unpack(newTrans));
			end;
		end;
	end;
	

end;

function isBogged:draw()
end;
function isBogged:boggedRandomEvent()
	-- the probability of having the Carrier bogged gets higher as it is working deeper --
	if self.AdjusterNumber <= 5 then
		self.RandomEventNumber = (math.random(500,1550))*1000;
	end;
	if self.AdjusterNumber <= 3 then
		self.RandomEventNumber = (math.random(300,950))*1000;
	end;

end;



