--
-- hasObjectStuck
-- Specialization for all Vehicles allowing to have an object stuck in the implement digging the ground while working. [especially for cultivator and seeder - see the " Vaderstad Cultus" is scripts for a similar specialization for plough. ]
-- @uthor : Bayn - www.tsforum3.com
-- D@te : 04.10.2010
--
-- This script has been made under "OpenSource rules". 
-- That means you can use it without asking authorization, but also without forgetting to quote the author's name.

hasObjectStuck = {};

function hasObjectStuck.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function hasObjectStuck:load(xmlFile)
	-- Generate a random event --
	self.StuckObjectRandomEvent = SpecializationUtil.callSpecializationsFunction("StuckObjectRandomEvent");
	
	-- new working area --
    self.numBrokenAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.BrokenAreas#count"), 0);
	if self.numBrokenAreas ~= nil then
    self.BrokenAreas = {}
    for i=1, self.numBrokenAreas do
        self.BrokenAreas[i] = {};
        local areanamei = string.format("vehicle.BrokenAreas.BrokenArea%d", i);
        self.BrokenAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.BrokenAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.BrokenAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	end;
	
	-- stuck objects --
	self.numStuckObjects = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.StuckObjects#count"), 0);	
	if self.numStuckObjects ~= nil then
    self.StuckObjects = {};
    for i=1, self.numStuckObjects do
        local StuckObjectsnamei = string.format("vehicle.StuckObjects.StuckObject" .. "%d", i);
        self.StuckObjects[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, StuckObjectsnamei .. "#index"));
    end;
	end;
	
	-- Sounds --
	local hammerHitSound = getXMLString(xmlFile, "vehicle.hammerHitSound#file");
	hammerHitSoundFile = Utils.getFilename(hammerHitSound, self.baseDirectory);
    self.hammerHitSoundId = createSample("hammerHitSound");
    loadSample(self.hammerHitSoundId, hammerHitSoundFile, false);
    self.hammerHitSoundPlaying = false;
	
	-- Independent Variables --	
	self.hasObjectStuck = false;
	self.SoundPlayed = false;
	self.RandomEventStuckObjectNumber = 350000;
	
end;

function hasObjectStuck:delete()
    delete(self.hammerHitSoundId);
end;

function hasObjectStuck:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hasObjectStuck:keyEvent(unicode, sym, modifier, isDown)
end;

function hasObjectStuck:update(dt)
	if self.attacherVehicle then
		if self.inRangeStuckObject then
			g_currentMission:addExtraPrintText(string.format("%s: uvolni kamen", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERREMOVEOBJECT)));
		end;
			if self.C2WorkingTime >= self.RandomEventStuckObjectNumber then	
				self.hasObjectStuck = true;
			else
				self.hasObjectStuck = false;
			end;
		
			if self.hasObjectStuck then
				-- display stuck objects --
			    for i=1, self.numStuckObjects do
					setVisibility(self.StuckObjects[i],true);
				end;
				-- change working area into plough area to simulate the digged soil --
				if not self.MovingPartsMax then -- especially for the Carrier --
					for k, BrokenArea in pairs(self.BrokenAreas) do
						local x,y,z = getWorldTranslation(BrokenArea.start);
						local x1,y1,z1 = getWorldTranslation(BrokenArea.width);
						local x2,y2,z2 = getWorldTranslation(BrokenArea.height);
						Utils.updatePloughArea(x, z, x1, z1, x2, z2);
					end;
				end;
				-- detect the player's proximity to allow the objects to be removed --
				for i=1, self.numStuckObjects do
				local px, py, pz = getWorldTranslation(self.StuckObjects[i]);				
				local nearestDistance = 2.0; 				
	local vx, vy, vz = getWorldTranslation(getCamera());
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
					if distance < nearestDistance then
						self.inRangeStuckObject = true;
						if InputBinding.hasEvent(InputBinding.CARRIERREMOVEOBJECT) then	
							self:StuckObjectRandomEvent();
							self.C2WorkingTime = 0;
							if not self.hammerHitSoundPlaying then
								playSample(self.hammerHitSoundId, 1, 1, 0);
								self.hammerHitSoundPlaying = true;
							end;
							self.hasObjectStuck = false;
						end;
					else
						if self.hammerHitSoundPlaying then
							stopSample(self.hammerHitSoundId);
							self.hammerHitSoundPlaying = false;
						end;
						self.inRangeStuckObject = false;
					end;
				end;				
			else
			    for i=1, self.numStuckObjects do
					setVisibility(self.StuckObjects[i],false);
				end;
				self.inRangeStuckObject = false;
			end;
	end;
end;

function hasObjectStuck:draw()
end;

function hasObjectStuck:StuckObjectRandomEvent()
	-- Generate a random number --
		self.RandomEventStuckObjectNumber = (math.random(300,900))*1000;


end;


