--
-- VaderstadCarrier
-- Specialization for Vaderstad Carrier cultivators.
-- @uthor : Bayn - www.tsforum3.com
-- D@te : 09.09.2010
--
-- This script has been made under "OpenSource rules". 
-- That means you can use it without asking authorization, but also without forgetting to quote the author's name.

VaderstadCarrier = {};

function VaderstadCarrier.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function VaderstadCarrier:load(xmlFile)

	self.CarrierWorkingTime = SpecializationUtil.callSpecializationsFunction("CarrierWorkingTime");
self.safeMode = false
	self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel; 
	self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel; 
	self.AIon=false;

	-- Hydraulics ( Script from Face )
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		if self.hydraulics[i].punch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;

	-- Middle part rotation --
	local MiddlePartXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MiddlePart#index"));
    if MiddlePartXNode ~= nil then
        self.MiddlePart = {};
        self.MiddlePart.node = MiddlePartXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MiddlePart#minRot"));
        self.MiddlePart.minRot = {};
        self.MiddlePart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MiddlePart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MiddlePart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MiddlePart#maxRot"));
        self.MiddlePart.maxRot = {};
        self.MiddlePart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MiddlePart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MiddlePart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.MiddlePart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MiddlePart#rotTime"), 2)*1000;
        self.MiddlePart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MiddlePart#touchRotLimit"), 10));
    end;
	
	-- Left and right parts joints rotation --
	local LeftJointXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.LeftJoint#index"));
    if LeftJointXNode ~= nil then
        self.LeftJoint = {};
        self.LeftJoint.node = LeftJointXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.LeftJoint#minRot"));
        self.LeftJoint.minRot = {};
        self.LeftJoint.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.LeftJoint.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.LeftJoint.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.LeftJoint#maxRot"));
        self.LeftJoint.maxRot = {};
        self.LeftJoint.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.LeftJoint.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.LeftJoint.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.LeftJoint.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.LeftJoint#rotTime"), 2)*1000;
        self.LeftJoint.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.LeftJoint#touchRotLimit"), 10));
    end;
	local RightJointXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RightJoint#index"));
    if RightJointXNode ~= nil then
        self.RightJoint = {};
        self.RightJoint.node = RightJointXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RightJoint#minRot"));
        self.RightJoint.minRot = {};
        self.RightJoint.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RightJoint.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RightJoint.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RightJoint#maxRot"));
        self.RightJoint.maxRot = {};
        self.RightJoint.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RightJoint.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RightJoint.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.RightJoint.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.RightJoint#rotTime"), 2)*1000;
        self.RightJoint.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.RightJoint#touchRotLimit"), 10));
    end;
	local CrochetsXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Crochets#index"));
    if CrochetsXNode ~= nil then
        self.Crochets = {};
        self.Crochets.node = CrochetsXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Crochets#minRot"));
        self.Crochets.minRot = {};
        self.Crochets.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Crochets.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Crochets.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Crochets#maxRot"));
        self.Crochets.maxRot = {};
        self.Crochets.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Crochets.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Crochets.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Crochets.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Crochets#rotTime"), 2)*1000;
        self.Crochets.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Crochets#touchRotLimit"), 10));
    end;	
	
    self.MovingParts = {};
    self.MovingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.MovingParts#count"), 0);	
	for i=1, self.MovingPartsCount do
		local namei = string.format("vehicle.MovingParts.MovingPart%d", i);
		local MovingPart = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		self.MovingParts[i] = {};
		self.MovingParts[i].node = MovingPart;		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.MovingParts[i].minRot = {};
        self.MovingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MovingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MovingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));  
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.MovingParts[i].maxRot = {};
        self.MovingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MovingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MovingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));		
		self.MovingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
		self.MovingParts[i].touchRotLimit = Utils.getNoNil(getXMLString(xmlFile, namei .. "#touchRotLimit"), 2);
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
		self.MovingParts[i].RotBackup = Utils.degToRad(Utils.getNoNil(x, 0));
	end;
	
	local SupportAttacherNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SupportAttacher#index"));
    if SupportAttacherNode ~= nil then
        self.SupportAttacher = {};
        self.SupportAttacher.node = SupportAttacherNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportAttacher#minTrans"));
        self.SupportAttacher.minTrans = {};
        self.SupportAttacher.minTrans[1] = Utils.getNoNil(x, 0);
        self.SupportAttacher.minTrans[2] = Utils.getNoNil(y, 0);
        self.SupportAttacher.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportAttacher#maxTrans"));
        self.SupportAttacher.maxTrans = {};
        self.SupportAttacher.maxTrans[1] = Utils.getNoNil(x, 0);
        self.SupportAttacher.maxTrans[2] = Utils.getNoNil(y, 0);
        self.SupportAttacher.maxTrans[3] = Utils.getNoNil(z, 0);

        self.SupportAttacher.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportAttacher#transTime"), 2)*1000;
        self.SupportAttacher.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportAttacher#touchTransLimit"), 10);
    end;	
	local SupportFrameNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SupportFrame#index"));
    if SupportFrameNode ~= nil then
        self.SupportFrame = {};
        self.SupportFrame.node = SupportFrameNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportFrame#minTrans"));
        self.SupportFrame.minTrans = {};
        self.SupportFrame.minTrans[1] = Utils.getNoNil(x, 0);
        self.SupportFrame.minTrans[2] = Utils.getNoNil(y, 0);
        self.SupportFrame.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportFrame#maxTrans"));
        self.SupportFrame.maxTrans = {};
        self.SupportFrame.maxTrans[1] = Utils.getNoNil(x, 0);
        self.SupportFrame.maxTrans[2] = Utils.getNoNil(y, 0);
        self.SupportFrame.maxTrans[3] = Utils.getNoNil(z, 0);

        self.SupportFrame.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportFrame#transTime"), 2)*1000;
        self.SupportFrame.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportFrame#touchTransLimit"), 10);
    end;
	
	self.numRollers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Rollers#count"), 0);	
    self.Rollers = {};
    for i=1, self.numRollers do
        local Rollersnamei = string.format("vehicle.Rollers.Roller" .. "%d", i);
        self.Rollers[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, Rollersnamei .. "#index"));
    end;	
		
	self.numWorkingDiscs = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.WorkingDiscs#count"), 0);	
    self.WorkingDiscs = {};
    for i=1, self.numWorkingDiscs do
        local WorkingDiscsnamei = string.format("vehicle.WorkingDiscs.WorkingDisc" .. "%d", i);
        self.WorkingDiscs[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, WorkingDiscsnamei .. "#index"));
    end;	
	
	self.numAdjusters = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Adjusters#count"), 0);	
    self.Adjusters = {};
    for i=1, self.numAdjusters do
        local Adjustersnamei = string.format("vehicle.Adjusters.Adjuster" .. "%d", i);
        self.Adjusters[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, Adjustersnamei .. "#index"));
    end;
	
	-- Animation for working discs --
	self.charIdAnim = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animWorkingDiscs#Node"));
	self.clipIndexAnim = getXMLString(xmlFile, "vehicle.animWorkingDiscs#animationClip");	
	
	-- Sounds --
	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
    if cultivatorSound ~= nil and cultivatorSound ~= "" then
        cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory);
        self.cultivatorSound = createSample("cultivatorSound");
        loadSample(self.cultivatorSound, cultivatorSound, false);
        self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 0);
        self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1.0);
        self.cultivatorSoundEnabled = false;
    end;
	
	-- Particles --
	
    self.groundParticleSystems = {};
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, "vehicle.LeftParticleSystem", self.components[3].node, false, nil, self.baseDirectory)
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, "vehicle.RightParticleSystem", self.components[4].node, false, nil, self.baseDirectory)
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, "vehicle.MiddleParticleSystem", self.components[1].node, false, nil, self.baseDirectory)
    self.groundParticleSystemActive = false;	
	
	self.CarrierWorkingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.CarrierWorkingParticleSystems.CarrierWorkingParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.CarrierWorkingParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;	
	
	-- Independent Variables --
	self.LeftDetector = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.LeftPartDetector#index"));
	self.RightDetector = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RightPartDetector#index"));
	self.LeftPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.LeftPart#index"));
	self.RightPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RightPart#index"));
	
	self.MovingPartsMax = true;
	self.isReadyToWork = false;
	self.CarrierIsDown = false;
	self.SupportAttacherMax = true;
	self.SupportFrameMax = true;
	self.AdjusterNumber = 0;
	self.CWorkingTime = 0;
	self.C2WorkingTime = 0;
end;

function VaderstadCarrier:delete()
    if self.cultivatorSound ~= nil then
        delete(self.cultivatorSound);
    end;
    Utils.deleteParticleSystem(self.groundParticleSystems);
end;

function VaderstadCarrier:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VaderstadCarrier:keyEvent(unicode, sym, modifier, isDown)
end;

function VaderstadCarrier:update(dt)
		if self.inrangeAdjusters and self.MovingPartsMax then
			g_currentMission:addExtraPrintText(string.format("%s/%s: +/- Serizeni hloubky", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERADDADJUSTER), InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERREMOVEADJUSTER)));
		end;
		if self.inrange then	
			g_currentMission:addExtraPrintText(string.format("Podpera %s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERSUPPORT)));
		end;	
    if self.attacherVehicle then
		if self.isActive then
		
		-- DEPLOYMENT MANAGEMENT --
		-- Rotate the rear middle part to unfold the Carrier when the two parts are deployed --
		if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA) and self:getIsActiveForInput() then 
		self.safeMode = not self.safeMode 
		end;
		if InputBinding.isPressed(InputBinding.CARRIERWORKMODEON) then
			self.MiddlePartMax = true;
		else
			self.MiddlePartMax = false;
		end;
		if InputBinding.isPressed(InputBinding.CARRIERWORKMODEOFF) then
			self.MiddlePartMin = true;
		else
			self.MiddlePartMin = false;
		end;
		
		---ai---
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.AIon = self.attacherVehicle.isAITractorActivated;
			
		end; 
		
	if self.attacherVehicle.isAITractorActivated then				
    	self.attacherVehicle.turnStage3Timeout = 0;
		
			if self.attacherVehicle.turnStage == 0 then
			self.MovingPartsMax=false;
			
			else
			self.MovingPartsMax=true;
			end;
	else
		
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.attacherVehicle.turnStage3Timeout = 35000;
		end; 	
	end;

---------ai end----	
 		local doRotate = self.MiddlePartMax or self.MiddlePartMin 
		if self.MiddlePart ~= nil and doRotate then
			local x, y, z = getRotation(self.MiddlePart.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.MiddlePart.maxRot, self.MiddlePart.minRot, 3, self.MiddlePart.rotTime, dt, not self.MiddlePartMax);
			setRotation(self.MiddlePart.node,unpack(newRot));
		end;
		
		-- When middle part is 2 rotated, unlock the componentJoints to allow deployment while driving back --
		local x, y, z = getRotation(self.MiddlePart.node);
		local maxRot = self.MiddlePart.maxRot;
		local eps = self.MiddlePart.touchRotLimit;
		if  (math.abs(x-maxRot[1]) < eps) then
			self.LeftJointMax = true;
			self.RightJointMax = true;
			self.LeftJointMin = false;
			self.RightJointMin = false;
			self.CrochetsMax = true;
			self.CrochetsMin = false;
			setJointRotationLimit(self.componentJoints[3].jointIndex, 1, true, math.rad(-45), math.rad(45));
			setJointRotationLimit(self.componentJoints[2].jointIndex, 1, true, math.rad(-45), math.rad(45));
		end;
		if  (math.abs(x-maxRot[1]) < math.rad(1)) then
			self.CarrierIsDown = true;
		else
			self.CarrierIsDown = false;
		end;
		
 		local doRotate = self.RightJointMax or self.RightJointMin or not self.RightJointMax
		if self.RightJoint ~= nil and doRotate then
			local x, y, z = getRotation(self.componentJoints[3].jointNode);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.RightJoint.maxRot, self.RightJoint.minRot, 3, self.RightJoint.rotTime, dt, not self.RightJointMax);
			setRotation(self.componentJoints[3].jointNode,unpack(newRot));
		end;			
 		local doRotate = self.LeftJointMax or self.LeftJointMin or not self.LeftJointMax
		if self.LeftJoint ~= nil and doRotate then
			local x, y, z = getRotation(self.componentJoints[2].jointNode);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.LeftJoint.maxRot, self.LeftJoint.minRot, 3, self.LeftJoint.rotTime, dt, not self.LeftJointMax);
			setRotation(self.componentJoints[2].jointNode,unpack(newRot));
		end;			
 		local doRotate = self.CrochetsMax or self.CrochetsMin or not self.CrochetsMax
		if self.Crochets ~= nil and doRotate then
			local x, y, z = getRotation(self.Crochets.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.Crochets.maxRot, self.Crochets.minRot, 3, self.Crochets.rotTime, dt, not self.CrochetsMax);
			setRotation(self.Crochets.node,unpack(newRot));
		end;
		
		-- Detecting when left part is in transport position then lock this one --		
		local nearestDistance = 0.6; 
		local px, py, pz = getWorldTranslation(self.LeftDetector); 
		local vx, vy, vz = getWorldTranslation(self.LeftPart);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.LeftJointMin = true;
			self.LeftJointMax = false;
		end;
		local x, y, z = getRotation(self.componentJoints[2].jointNode);
		local minRot = self.LeftJoint.minRot;
		local eps = self.LeftJoint.touchRotLimit;
		if  (math.abs(y-minRot[2]) < eps) then
			setJointRotationLimit(self.componentJoints[2].jointIndex, 1, true, math.rad(-0), math.rad(0));
		end;		
		
		-- Detecting when right part is in transport position then lock this one --		
		local qx, qy, qz = getWorldTranslation(self.RightDetector); 
		local ux, uy, uz = getWorldTranslation(self.RightPart);
		local distance2 = Utils.vector3Length(qx-ux, qy-uy, qz-uz);	
		if distance2 < nearestDistance then
			self.RightJointMin = true;
			self.RightJointMax = false;
			self.CrochetsMax = false;
			self.CrochetsMin = true;
		end;
		local x, y, z = getRotation(self.componentJoints[3].jointNode);
		local minRot = self.RightJoint.minRot;
		local eps = self.RightJoint.touchRotLimit;
		if  (math.abs(y-minRot[2]) < eps) then
			setJointRotationLimit(self.componentJoints[3].jointIndex, 1, true, math.rad(-0), math.rad(0));
		end;		
		
		-- Update Joints --
		setJointFrame(self.componentJoints[2].jointIndex, 1,self.componentJoints[2].jointNode);
		setJointFrame(self.componentJoints[3].jointIndex, 1,self.componentJoints[3].jointNode);	
		
		-- HYDRAULICS ( Script from Face )
		
		for i=1, table.getn(self.hydraulics) do
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			
			setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].doScale then
				local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
				local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
				setScale(self.hydraulics[i].punch, 1, 1, newScale);
			else
				if self.hydraulics[i].punch ~= nil then
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				else
					setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
				end;
			end;
		end;
		
		-- WORKING MANAGEMENT --
		-- Rise/Lower working discs--
		if InputBinding.hasEvent(InputBinding.CARRIERMOVINGPARTS) then
			if self.CarrierIsDown then
				self.MovingPartsMax = not self.MovingPartsMax;
			end;
		end;

		local doRotate = self.MovingPartsMax or self.MovingPartsMin or not self.MovingPartsMax or not self.MovingPartsMin
		for i=1, self.MovingPartsCount do
			if self.MovingParts[i] ~= nil and doRotate then
				local x, y, z = getRotation(self.MovingParts[i].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.MovingParts[i].maxRot, self.MovingParts[i].minRot, 3, self.MovingParts[i].rotTime, dt, not self.MovingPartsMax);
				setRotation(self.MovingParts[i].node, unpack(newRot));
			end;
		end;
		
		-- Rotate rollers if Carrier is down --
		if self.CarrierIsDown then
			for i=1, self.numRollers do
				local Roller = self.Rollers[i];
				rotate(Roller, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
			end;
		end;
		
		-- Updating terrain detail + rotate and animate woking discs if Carrier is down and moving parts are almost at max position -- 
		local toFast = false;
		toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 16;
		if self.CarrierIsDown and not toFast then
			local x, y, z = getRotation(self.MovingParts[2].node);
			local maxRot = self.MovingParts[2].maxRot;
			local charId = getAnimCharacterSet(self.charIdAnim);
			local clipIndex = getAnimClipIndex(charId, self.clipIndexAnim);
			if  (math.abs(x-maxRot[1]) > math.rad(25)) and self.movingDirection ~= 0  then	
				-- terrain detail --
				for k, cuttingArea in pairs(self.cuttingAreas) do
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							if self.safeMode then
							Utils.updateCultivatorArea (x, z, x1, z1, x2, z2, false);  
							else 
							Utils.updateCultivatorArea (x, z, x1, z1, x2, z2); 
							end;
				end;
				-- rotate working discs --
				for i=1, self.numWorkingDiscs do
					local WorkingDisc = self.WorkingDiscs[i];
					rotate(WorkingDisc, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
				end;
				-- animate working discs support --
				if self.lastSpeed*3600 > 8 then
					assignAnimTrackClip(charId , 0, clipIndex);
					setAnimTrackLoopState(charId, 0, true);
					setAnimTrackSpeedScale(charId, 0, 6);
					enableAnimTrack(charId, 0);
				else
					disableAnimTrack(charId, 0);
				end;
				-- cultivator sounds --
				if self.cultivatorSound ~= nil and not self.cultivatorSoundEnabled and self:getIsActiveForSound() then
					if self.lastSpeed*3600 > 3 then
						playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
						setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
						self.cultivatorSoundEnabled = true;
					end;
				end;
				-- Particles --
	            if self.lastSpeed*3600 > 5 and not self.groundParticleSystemActive then
					self.groundParticleSystemActive = true;
					Utils.setEmittingState(self.groundParticleSystems, true);
					Utils.setEmittingState(self.CarrierWorkingParticleSystems, true)
				end;
				if self.lastSpeed*3600 < 5 and self.groundParticleSystemActive then
					self.groundParticleSystemActive = false;
					Utils.setEmittingState(self.groundParticleSystems, false);
					Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)
				end;
				if self.movingDirection == 1 then
					self:CarrierWorkingTime(dt);
				end;
			else
				disableAnimTrack(charId, 0);
				if self.cultivatorSoundEnabled then
					stopSample(self.cultivatorSound);
					self.cultivatorSoundEnabled = false;
				end;
				if self.groundParticleSystemActive then
	                self.groundParticleSystemActive = false;
					Utils.setEmittingState(self.groundParticleSystems, false);
				end;
				Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)
			end;
		end;	
		if self.cultivatorSoundEnabled then
			if self.lastSpeed*3600 < 3 then
				stopSample(self.cultivatorSound);
				self.cultivatorSoundEnabled = false;
			end;
		end;

		end;
	end;		
		
	--  ADJUSTERS MANAGEMENT --
	-- Increase/Decrease the number of adjusters if player is in range.
		local nearestDistance = 1.4; 
		local px, py, pz = getWorldTranslation(self.Adjusters[1]); 
	local vx, vy, vz = getWorldTranslation(getCamera());
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
			if distance < nearestDistance then
				self.inrangeAdjusters = true; 
			else
				self.inrangeAdjusters = false; 
			end;
	if self.attacherVehicle and self.inrangeAdjusters and self.MovingPartsMax then
		if InputBinding.hasEvent(InputBinding.CARRIERADDADJUSTER) then
			if self.AdjusterNumber < 8 then
				self.AdjusterNumber = self.AdjusterNumber +1;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.CARRIERREMOVEADJUSTER) then
			if self.AdjusterNumber > 0 then
				self.AdjusterNumber = self.AdjusterNumber -1;
			end;
		end;
	end;

	-- Display/hide the adjusters on the hydraulics and on the receiver.
	if self.AdjusterNumber > 0 then
		for i = 1, self.AdjusterNumber do
			setVisibility(self.Adjusters[i], true);
			if self.AdjusterNumber < 8 then
				for i = self.AdjusterNumber+1, 8 do
					setVisibility(self.Adjusters[i],false);
					v = i+8
					setVisibility(self.Adjusters[v], true);
				end;
			end;
			v = i+8
			setVisibility(self.Adjusters[v], false);
		end;
	else
		for i = 1, 8 do
			setVisibility(self.Adjusters[i], false);
			v = i+8
			setVisibility(self.Adjusters[v], true);
		end;	
	end;
	
	-- According to the adjusters, set the working depth.
	if self.AdjusterNumber == 1 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 1.15;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 1.2;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 1.2;
	elseif 	self.AdjusterNumber == 2 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 1.64;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 2.1;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 2.1;
	elseif 	self.AdjusterNumber == 3 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 2.0625;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 2.2;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 2.2;
	elseif 	self.AdjusterNumber == 4 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 3.15;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 6.1;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 6.1;
	elseif 	self.AdjusterNumber == 5 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 5.6;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 26;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 26;
	elseif 	self.AdjusterNumber == 6 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / 19.3;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / 47;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / 47;
	elseif 	self.AdjusterNumber == 7 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / -29;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / -3;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / -3;
	elseif 	self.AdjusterNumber == 8 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup / -5;
		end;
		self.MovingParts[5].minRot[1] = self.MovingParts[5].RotBackup / -2;
		self.MovingParts[6].minRot[1] = self.MovingParts[6].RotBackup / -2;
	elseif 	self.AdjusterNumber == 0 then
		for i=1, self.MovingPartsCount do
			self.MovingParts[i].minRot[1] = self.MovingParts[i].RotBackup;
		end;
	end;
	
	-- DETACH MANAGEMENT --
	-- Detecting when the farmer is close to the support's attacher. When it's the case and IF the Carrier is attached, he can lower/raise the support.
	if self.attacherVehicle then 
		local nearestDistance = 2.5; 
		local px, py, pz = getWorldTranslation(self.SupportAttacher.node); 
	local vx, vy, vz = getWorldTranslation(getCamera());
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
			if distance < nearestDistance then
				self.inrange = true; 
			else
				self.inrange = false; 
			end;
		
		if self.inrange then	
			if InputBinding.hasEvent(InputBinding.CARRIERSUPPORT)  then
				self.SupportAttacherMax = not self.SupportAttacherMax;
				self.SupportFrameMax = not self.SupportFrameMax;
			end;
		end;	
		local doTranslate = self.SupportAttacherMax or self.SupportAttacherMin or not self.SupportAttacherMax
		if self.SupportAttacher ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.SupportAttacher.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.SupportAttacher.maxTrans, self.SupportAttacher.minTrans, 3, self.SupportAttacher.transTime, dt, not self.SupportAttacherMax);
			setTranslation(self.SupportAttacher.node, unpack(newTrans));
		end;
		local doTranslate = self.SupportFrameMax or self.SupportFrameMin or not self.SupportFrameMax
		if self.SupportFrame ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.SupportFrame.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.SupportFrame.maxTrans, self.SupportFrame.minTrans, 3, self.SupportFrame.transTime, dt, not self.SupportFrameMax);
			setTranslation(self.SupportFrame.node, unpack(newTrans));
		end;
		setJointFrame(self.componentJoints[1].jointIndex, 1,self.componentJoints[1].jointNode);
		

	end;
	
end;

function VaderstadCarrier:draw()
	g_currentMission:addExtraPrintText(string.format("Key %s/%s: Slozit/rozlozit Carrier", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERWORKMODEOFF), InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERWORKMODEON)));
	if self.CarrierIsDown then
		if self.MovingPartsMax then
			g_currentMission:addExtraPrintText(string.format("Key %s: Spustit disky", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERMOVINGPARTS)));
		else
			g_currentMission:addExtraPrintText(string.format("Key %s: Zvednout disky", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERMOVINGPARTS)));
		end;
	end;
	if self.safeMode then
		g_currentMission:addHelpButtonText("Prepnout na normalni Mod", InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText("Prepnout na SafeMod", InputBinding.IMPLEMENT_EXTRA);
	end; 
end;

function VaderstadCarrier:onDetach()
    if self.cultivatorSoundEnabled then
        stopSample(self.cultivatorSound);
        self.cultivatorSoundEnabled = false;
    end;
	Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)
end;

function VaderstadCarrier:onAttach()
end; 
function VaderstadCarrier:onLeave()
	if self.cultivatorSoundEnabled then
		stopSample(self.cultivatorSound);
		self.cultivatorSoundEnabled = false;
	end;
	if self.groundParticleSystemActive then
	    self.groundParticleSystemActive = false;
		Utils.setEmittingState(self.groundParticleSystems, false);
	end;
	Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)
	local charId = getAnimCharacterSet(self.charIdAnim);
	local clipIndex = getAnimClipIndex(charId, self.clipIndexAnim);
	disableAnimTrack(charId, 0);
end;

function VaderstadCarrier:onActivate()
end;

function VaderstadCarrier:onDeactivate()
	if self.cultivatorSoundEnabled then
		stopSample(self.cultivatorSound);
		self.cultivatorSoundEnabled = false;
	end;
	if self.groundParticleSystemActive then
	    self.groundParticleSystemActive = false;
		Utils.setEmittingState(self.groundParticleSystems, false);
	end;
	Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)
	local charId = getAnimCharacterSet(self.charIdAnim);
	local clipIndex = getAnimClipIndex(charId, self.clipIndexAnim);
	disableAnimTrack(charId, 0);
end;

function VaderstadCarrier:CarrierWorkingTime(diffTime)
	local value = math.max(diffTime);
	self.CWorkingTime = (self.CWorkingTime + value);
	self.C2WorkingTime = (self.C2WorkingTime + value);
	if self.CWorkingTime >= 2000*1000 then
		self.CWorkingTime = 0;
	end;
	if self.C2WorkingTime >= 2000*1000 then
		self.C2WorkingTime = 0;
	end;
end; 
VaderstadCarrier.updateSafeArea = function(l_18_0, l_18_1, l_18_2, l_18_3, l_18_4, l_18_5)
  local cultiId = g_currentMission.cultivatorChannel
  local sowingId = g_currentMission.sowingChannel
  local detailId = g_currentMission.terrainDetailId
  local ploughId = g_currentMission.ploughChannel
  local sprayId = g_currentMission.sprayChannel
  local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(detailId, l_18_0, l_18_1, l_18_2, l_18_3, l_18_4, l_18_5)
  Utils.updateDestroyCommonArea(l_18_0, l_18_1, l_18_2, l_18_3, l_18_4, l_18_5)
  setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, cultiId, 1, detailId, sowingId, 1, 1)
  setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, cultiId, 1, detailId, ploughId, 1, 1)
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sowingId, 1, 0)
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, ploughId, 1, 0)
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sprayId, 1, 0)
end;


