--
-- Odometer
-- Specialization for counting the miles driven in a vehicle
--
-- @author:	 	Robert Hostens
-- @date:		2011/04/10
-- @version:	v1.0
-- @history:	v1.0 - Initial Release
--

Odometer = {};

function Odometer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Odometer:load(xmlFile)
	self.Odometer = {};
	self.Odometer.Ratio = 15;
	self.Odometer.Trip = 0;
	self.Odometer.Reading = 0;
	self.Odometer.posX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posX"), 0.7543); -- 0.7543
	self.Odometer.posY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posY"), 0.2140); -- 0.1715
	self.Odometer.HUD = Overlay:new("OdometerOverlay", Utils.getFilename("odometer_hud.png", self.baseDirectory), self.Odometer.posX, self.Odometer.posY, 0.2371, 0.039525);
end;

function Odometer:delete()
end;

function Odometer:readStream(streamId, connection)
	self.Odometer.Trip = streamReadFloat32(streamId);
	self.Odometer.Reading = streamReadFloat32(streamId);
end;

function Odometer:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.Odometer.Trip);
	streamWriteFloat32(streamId, self.Odometer.Reading);
end;

function Odometer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Odometer:keyEvent(unicode, sym, modifier, isDown)
end;

function Odometer:update(dt)
end;

function Odometer:updateTick(dt)
	if self:getIsActive() or self.isHired then
		self.Odometer.Trip = self.Odometer.Trip + self.lastMovedDistance;
		self.Odometer.Reading = self.Odometer.Reading + self.lastMovedDistance;
	end;
end;

function Odometer:draw()
	local Trip = math.floor(self.Odometer.Trip / self.Odometer.Ratio);
	local Distance = math.floor(self.Odometer.Reading / self.Odometer.Ratio);

	self.Odometer.HUD:render();

	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	setTextColor(1,1,1,1);
		
	renderText(self.Odometer.posX + 0.0770, self.Odometer.posY + 0.009800, 0.02, tostring(Trip));
	renderText(self.Odometer.posX + 0.2170, self.Odometer.posY + 0.009800, 0.02, tostring(Distance));

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
end;

function Odometer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local Distance = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#odometer"), self.Odometer.Reading);
		self.Odometer.Reading = Distance;
	end;
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Odometer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'odometer="' .. tostring((math.floor(self.Odometer.Reading))) ..'"';
	return attributes, nil;
end;