--
-- Combine
-- This is the specialization for combines
--
-- @author	Stefan Geiger
-- @date	30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.



CombineSetWorkModeEvent = {};
CombineSetWorkModeEvent_mt = Class(CombineSetWorkModeEvent, Event);

InitEventClass(CombineSetWorkModeEvent, "CombineSetWorkModeEvent");


function CombineSetWorkModeEvent:emptyNew()
	local self = Event:new(CombineSetWorkModeEvent_mt);

	self.className="CombineSetWorkModeEvent";

	return self;
end;


function CombineSetWorkModeEvent:new(object, enabled, turbo)
	local self = CombineSetWorkModeEvent:emptyNew()

	self.object = object;
	self.enabled = enabled;
	self.turbo = turbo;

	return self;
end;


function CombineSetWorkModeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);

	self.enabled = streamReadBool(streamId);
	self.turbo = streamReadBool(streamId);
	self.object = networkGetObject(id);

	self:run(connection);
end;


function CombineSetWorkModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.enabled);
	streamWriteBool(streamId, self.turbo);
end;


function CombineSetWorkModeEvent:run(connection)
	self.object:setWorkMode(self.enabled, true, self.turbo);

	if not connection:getIsServer() then
		g_server:broadcastEvent(CombineSetWorkModeEvent:new(self.object, self.enabled, self.turbo), nil, connection, self.object);
	end;
end;



CombineSetCrusherEvent = {};
CombineSetCrusherEvent_mt = Class(CombineSetCrusherEvent, Event);

InitEventClass(CombineSetCrusherEvent, "CombineSetCrusherEvent");


function CombineSetCrusherEvent:emptyNew()
	local self = Event:new(CombineSetCrusherEvent_mt);

	self.className="CombineSetCrusherEvent";

	return self;
end;


function CombineSetCrusherEvent:new(object, enabled)
	local self = CombineSetCrusherEvent:emptyNew()

	self.object = object;
	self.enabled = enabled;

	return self;
end;


function CombineSetCrusherEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);

	self.enabled = streamReadBool(streamId);
	self.object = networkGetObject(id);

	self:run(connection);
end;


function CombineSetCrusherEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.enabled);
end;

function CombineSetCrusherEvent:run(connection)
	self.object:setCrusher(self.enabled, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(CombineSetCrusherEvent:new(self.object, self.enabled), nil, connection, self.object);
	end;
end;



Lexion_770_SetChopperEnableEvent = {};
Lexion_770_SetChopperEnableEvent_mt = Class(Lexion_770_SetChopperEnableEvent, Event);

InitEventClass(Lexion_770_SetChopperEnableEvent, "Lexion_770_SetChopperEnableEvent");


function Lexion_770_SetChopperEnableEvent:emptyNew()
	local self = Event:new(Lexion_770_SetChopperEnableEvent_mt);

	self.className="Lexion_770_SetChopperEnableEvent";

	return self;
end;


function Lexion_770_SetChopperEnableEvent:new(object, enabled, fruitType)
	local self = Lexion_770_SetChopperEnableEvent:emptyNew()

	self.object = object;
	self.enabled = enabled;
	self.fruitType = fruitType;

	return self;
end;


function Lexion_770_SetChopperEnableEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.enabled = streamReadBool(streamId);
	self.fruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);

	self:run(connection);
end;

function Lexion_770_SetChopperEnableEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.enabled);
	streamWriteUIntN(streamId, self.fruitType, FruitUtil.sendNumBits);
end;


function Lexion_770_SetChopperEnableEvent:run(connection)
	Lexion_770_SetChopperEnableEvent.execute(self.object, self.enabled, self.fruitType);
end;


function Lexion_770_SetChopperEnableEvent.execute(object, enabled, fruitType)
	if object.currentChopperParticleSystem ~= nil then
		Utils.setEmittingState(object.currentChopperParticleSystem, false);
	end;

	object.currentChopperParticleSystem = object.chopperParticleSystems[fruitType];

	if object.currentChopperParticleSystem == nil then
		object.currentChopperParticleSystem = object.defaultChopperParticleSystem;
	end;

	if object.currentGrainTankParticleSystem ~= nil then
		Utils.setEmittingState(object.currentGrainTankParticleSystem, false);
	end;

	object.currentGrainTankParticleSystem = object.grainTankParticleSystems[fruitType];

	if object.currentGrainTankParticleSystem == nil then
		object.currentGrainTankParticleSystem = object.defaultGrainTankParticleSystem;
	end;

	if enabled then
		Utils.setEmittingState(object.currentChopperParticleSystem, true);
		Utils.setEmittingState(object.currentGrainTankParticleSystem, true);
	else
		Utils.setEmittingState(object.currentChopperParticleSystem, false);
		Utils.setEmittingState(object.currentGrainTankParticleSystem, false);
	end;
end;



Lexion_770_SetStrawEnableEvent = {};
Lexion_770_SetStrawEnableEvent_mt = Class(Lexion_770_SetStrawEnableEvent, Event);

InitEventClass(Lexion_770_SetStrawEnableEvent, "Lexion_770_SetStrawEnableEvent");


function Lexion_770_SetStrawEnableEvent:emptyNew()
	local self = Event:new(Lexion_770_SetStrawEnableEvent_mt);

	self.className="Lexion_770_SetStrawEnableEvent";

	return self;
end;


function Lexion_770_SetStrawEnableEvent:new(object, enabled, fruitType)
	local self = Lexion_770_SetStrawEnableEvent:emptyNew()

	self.object = object;
	self.enabled = enabled;
	self.fruitType = fruitType;

	return self;
end;


function Lexion_770_SetStrawEnableEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.enabled = streamReadBool(streamId);
	self.fruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);

	self:run(connection);
end;


function Lexion_770_SetStrawEnableEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.enabled);
	streamWriteUIntN(streamId, self.fruitType, FruitUtil.sendNumBits);
end;


function Lexion_770_SetStrawEnableEvent:run(connection)
	Lexion_770_SetStrawEnableEvent.execute(self.object, self.enabled, self.fruitType);
end;


function Lexion_770_SetStrawEnableEvent.execute(object, enabled, fruitType)
	if object.currentStrawParticleSystem ~= nil then
		Utils.setEmittingState(object.currentStrawParticleSystem, false);
	end;

	object.currentStrawParticleSystem = object.strawParticleSystems[fruitType];

	if object.currentStrawParticleSystem == nil then
		object.currentStrawParticleSystem = object.defaultStrawParticleSystem;
	end;

	if object.currentGrainTankParticleSystem ~= nil then
		Utils.setEmittingState(object.currentGrainTankParticleSystem, false);
	end;

	object.currentGrainTankParticleSystem = object.grainTankParticleSystems[fruitType];

	if object.currentGrainTankParticleSystem == nil then
		object.currentGrainTankParticleSystem = object.defaultGrainTankParticleSystem;
	end;

	if enabled then
		Utils.setEmittingState(object.currentStrawParticleSystem, true);
		Utils.setEmittingState(object.currentGrainTankParticleSystem, true);
	else
		Utils.setEmittingState(object.currentStrawParticleSystem, false);
		Utils.setEmittingState(object.currentGrainTankParticleSystem, false);
	end;
end;