--
--
--

MapWeightstationMod = {};
MapWeightstationMod.stations = {};
MapWeightstationMod.totalStats = {};

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapWeightstationMod:saveWeightStationStats();
end;

function MapWeightstationMod:loadMap(name)
	self.oldPlayerCount = 0;
	local dir = getUserProfileAppPath() .. "mods/MapWeightstationMod/";
	self.hud = {};
	self.hud.dir = dir;
	self.hud.overlay1 = Overlay:new("hudEins", dir.."grau.png", 0.2, 0.65, 0.6, 0.25);
	self.hud.visible = false;
	self.hud.height = 0.25;
	self.hud.oldHeight = 0.25;
	
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapWeighStstationStats_xml = dir .. "/mapWeightstationStats.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapWeighStstationStats_xml);
		self.firstTimeRun = false;
	end;	

	-- x = "Testr";
	--local y = asciiToUtf8(x);
	--local utf8Len = utf8Strlen(y);
	--local strLen = string.len(x);
	--streamWriteInt8(streamId, strLen);
	--print("->"..x.." "..strLen);
	--print("->"..y.." "..utf8Len);
	--for r=1,strLen do 
		--streamWriteInt8(streamId, string.byte(x, r));
		--print(string.byte(x, r).." "..string.char(string.byte(x, r)).."  -  "..string.byte(y, r).." "..string.char(string.byte(y, r)));
	--end;	
	--for r=1,utf8Len do 
		--print(string.byte(y, r).." "..string.char(string.byte(y, r)));
	--end;	
	
	
end;

function MapWeightstationMod:deleteMap()
end;

function MapWeightstationMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapWeightstationMod:keyEvent(unicode, sym, modifier, isDown)
	if bitAND(modifier, Input.MOD_CTRL) > 0 and bitAND(modifier, Input.MOD_ALT) > 0 and InputBinding.isPressed(InputBinding.MAPWEIGHTSTATION_SHOW) then
		for i,j in pairs(self.stations) do
			if self.stations[i] ~= nil then
				self.stations[i].showStats = true;
			end;
		end;
	end;
end;

function MapWeightstationMod:update(dt)
	if g_server ~= nil and self.firstTimeRun then
		self:loadWeightStationStats();
		self.firstTimeRun = false;
	end;
	if g_server ~= nil then
		local cnt = 0;
		for i,j in pairs(g_currentMission.players) do
			cnt = cnt + 1;
		end;

		if cnt ~= self.oldPlayerCount then
			self.oldPlayerCount = cnt;
			g_server:broadcastEvent(WeightstationEvent:new(self.stations[1], self.stations, self.totalStats), nil, nil, nil);
		end;
	end;
	if self.hud.height ~= self.hud.oldHeight then
		self.hud.oldHeight = self.hud.height;
		self.hud.overlay1:delete();
		--print("self.hud.height="..tostring(self.hud.height));
		self.hud.overlay1 = Overlay:new("hudEins", self.hud.dir.."grau.png", 0.2, 0.9-self.hud.height, 0.6, self.hud.height);
	end;
end;

function MapWeightstationMod:updateTick(dt)

end;

function MapWeightstationMod:draw()
	if self.hud.visible then
		self.hud.overlay1:render();
		local x=0.2;
		--[[local y=0.65;
		local width=0.6;
		renderOverlay(self.hud.overlay1, x, y, width, self.hud.height);]]--
	end;
end;

function MapWeightstationMod:addWeightstation(station)
	local doInsert = true;
	for i,j in pairs(self.stations) do
		if j ~= nil then
			if string.len(j.weightStation.name) == string.len(station.weightStation.name) and
				string.match(j.weightStation.name, station.weightStation.name) then
				doInsert = false
				break;
			end;
		end;
	end;
	if doInsert then
		table.insert(self.stations, station);
	end;
end;

function MapWeightstationMod:updateStats(stationName, playerName, fill, weight, nrBales, idTable)

	local statioIdx = nil;
	for i,j in pairs(self.stations) do 
		if string.match(j.weightStation.name, stationName) and string.len(j.weightStation.name) == string.len(stationName) then
			stationIdx = i;
		end;
	end;
	
	if stationIdx ~= nil then

		local station = self.stations[stationIdx];
		
		local playerFound = false;
		for i,j in pairs(station.plStats) do
			if i ~= nil then
				if string.len(i) == string.len(playerName) then
					if string.match(i, playerName) then
						playerFound = true;
						break;
					end;
				end;
			end;
		end;
		
		if playerName ~= nil then
			local retVal = 0;
			
			if playerFound == false then
				local entry = {};
				entry.fill = 0;
				entry.weight = 0;
				entry.fillTmp = fill;
				entry.weightTmp = weight;
				entry.drops = 0
				entry.idTable = idTable;
				station.plStats[playerName] = entry;
				retVal = 0;
			else
				if (fill > 0 and station.plStats[playerName].fillTmp > 0) or 
					(weight > 0 and station.plStats[playerName].weightTmp > 0) then
					local sameSet = true;
					for i, j in pairs(idTable) do
						if station.plStats[playerName].idTable == nil then
							sameSet = false;
							break;
						end;
						if station.plStats[playerName].idTable[i] == nil then 
							sameSet = false;
							break;
						elseif j ~= station.plStats[playerName].idTable[i] then
							sameSet = false;
							break;
						end;
					end;
					if station.plStats[playerName].idTable == nil then
						sameSet = false;
					else
						for i,j in pairs(station.plStats[playerName].idTable ) do
							if idTable[i] == nil then
								sameSet = false;
								break;
							elseif j ~= idTable[i] then
								sameSet = false;
								break;
							end;
						end;
					end;
					if not sameSet then
						--print("->1.1");
						station.plStats[playerName].fillTmp = fill;
						station.plStats[playerName].weightTmp = weight;
						station.plStats[playerName].idTable = idTable;
						retVal = 0;	
					else
						--print("->1.2");
						retVal = 11;
					end;
				end;
				
				if (fill == 0 and station.plStats[playerName].fillTmp > 0) or 
					(weight == 0 and station.plStats[playerName].weightTmp > 0) then
					local sameSet = true;
					for i, j in pairs(idTable) do
						if station.plStats[playerName].idTable == nil then
							sameSet = false;
							break;
						end;
						if station.plStats[playerName].idTable[i] == nil then
							sameSet = false;
							break;
						elseif j ~= station.plStats[playerName].idTable[i] then
							sameSet = false;
							break;
						end;
					end;
					if sameSet then
						--print("->2.1");
						station.plStats[playerName].fill = station.plStats[playerName].fill + station.plStats[playerName].fillTmp;
						station.plStats[playerName].weight = station.plStats[playerName].weight + station.plStats[playerName].weightTmp;
						station.plStats[playerName].drops = station.plStats[playerName].drops + 1;
						retVal = 1;
						if self.totalStats[playerName] == nil then
							self.totalStats[playerName] = {};
							self.totalStats[playerName].fill = station.plStats[playerName].fillTmp;
							self.totalStats[playerName].weight = station.plStats[playerName].weightTmp;
							self.totalStats[playerName].drops = 1;
						else
							self.totalStats[playerName].fill = self.totalStats[playerName].fill + station.plStats[playerName].fillTmp;
							self.totalStats[playerName].weight = self.totalStats[playerName].weight + station.plStats[playerName].weightTmp;
							self.totalStats[playerName].drops = self.totalStats[playerName].drops + 1;
						end;
						station.plStats[playerName].fillTmp = 0;
						station.plStats[playerName].weightTmp = 0;
					else
						--print("->2.2");
						retVal = 11;
					end;
				end;			

				if (fill == 0 and station.plStats[playerName].fillTmp == 0) and retVal == 0 then 
					-- ?!
					--(nrBales == 0 and MapWeightstationMod.playerLastStats[playerName].nrBales == 0) then
					--print("->3");
					retVal = 11;
				end;

				
				if (fill > 0 and station.plStats[playerName].fillTmp == 0) then
					--(nrBales > 0 and MapWeightstationMod.playerLastStats[playerName].nrBales == 0) then
					--print("->4");
					station.plStats[playerName].fillTmp = fill;
					station.plStats[playerName].weightTmp = weight;
					station.plStats[playerName].idTable = idTable;
					retVal = 0;
				end;
				

			end;
		
			return retVal;
		else
			return -1;
		end;
	else
		print("ERROR, no station found !!!");
		return -1;
	end;
	
end;

function MapWeightstationMod:setPlayerStats(object, stations, totalStats)

	for r,s in pairs(stations) do
		
		for i,j in pairs(s.plStats) do
			if MapWeightstationMod.stations[r].plStats[i] == nil then 
				MapWeightstationMod.stations[r].plStats[i] = {};
			end;
			--[[MapWeightstationMod.stations[r].plStats[i].plId = j.plId;
			for x,y in pairs(g_currentMission.players) do
				if j.plId == y.id then
					MapWeightstationMod.stations[r].plStats[i].plName = y.controllerName;
					break;
				end;
			end;]]--
			MapWeightstationMod.stations[r].plStats[i].drops = j.drops;
			MapWeightstationMod.stations[r].plStats[i].fill = j.fill;
			MapWeightstationMod.stations[r].plStats[i].fillTmp = j.fillTmp;
			MapWeightstationMod.stations[r].plStats[i].weight = j.weight;
			MapWeightstationMod.stations[r].plStats[i].weightTmp = j.weight;		
		end;
	end;
	
	--MapWeightstationMod.totalStats = totalStats;
	for i,j in pairs(totalStats) do
		if MapWeightstationMod.totalStats[i] == nil then
			MapWeightstationMod.totalStats[i] = {};
		end;
		--[[MapWeightstationMod.totalStats[i].plId = j.plId;
		for x,y in pairs(g_currentMission.players) do
			if j.plId == y.id then
				MapWeightstationMod.totalStats[i].plName = y.controllerName;
				break;
			end;
		end;]]--
		MapWeightstationMod.totalStats[i].drops = j.drops;
		MapWeightstationMod.totalStats[i].fill = j.fill;
		MapWeightstationMod.totalStats[i].weight = j.weight;
	end
	
end;

function MapWeightstationMod:saveWeightStationStats()
	local existDir = io.open (self.mapWeighStstationStats_xml, "w");	
	if existDir == nil then
		createXMLFile("createWeightStation", self.mapWeighStstationStats_xml, "saveWeightStation");
	end;
    local xmlFile = io.open (self.mapWeighStstationStats_xml, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<weightStations>\n');
		for n,station in pairs(self.stations) do
			xmlFile:write( string.format('	<station name="%s"> \n', station.weightStation.name) );
			for i,j in pairs(station.plStats) do
				local idT = "";
				--for x,y in pairs(j.idTable) do
					--idT = idT .. tostring(y) .." ";
				--end;
				xmlFile:write( string.format('		<player name="%s" drops="%d" fill="%d" fillTmp="%d" weight="%f" weightTmp="%f"/> \n', 
					--i, j.drops, j.fill, j.fillTmp, j.weight, j.weightTmp, idT) );
					i, j.drops, j.fill, 0, j.weight, 0) );
			end;
			xmlFile:write("	</station> \n");
		end;
		xmlFile:write( string.format('	<totalStats> \n') );
		for i,j in pairs(self.totalStats) do
			--local idT = "";
			--for x,y in pairs(j.idTable) do
				--idT = idT .. tostring(y) .." ";
			--end; 
			xmlFile:write( string.format('		<player name="%s" drops="%d" fill="%d" weight="%f"/> \n', 
				i, j.drops, j.fill, j.weight) );
		end;
		xmlFile:write( string.format('	</totalStats> \n') );
        xmlFile:write("</weightStations> \n");
        xmlFile:close();
    end;		
end;

function MapWeightstationMod:loadWeightStationStats()
	local existDir = io.open (self.mapWeighStstationStats_xml, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.mapWeighStstationStats_xml);
		local i = 1;
		while true do
			local key = string.format("weightStations.station(%d)", i-1);
			local stationName = getXMLString(xmlFile, key.."#name");
			if stationName == nil then 
				break;
			end;
			if self.stations[i] == nil then
				self.stations[i] = {};
				self.stations[i].plStats = {};
				self.stations[i].weightStation = {};
				self.stations[i].weightStation.name = stationName;
			end;
			local j = 0;
			while true do
				local name = getXMLString(xmlFile, key..".player("..j..")#name");
				if name == nil then
					break;
				end;
				local drops = getXMLInt(xmlFile, key..".player("..j..")#drops");
				local fill = getXMLInt(xmlFile, key..".player("..j..")#fill");
				local fillTmp = getXMLInt(xmlFile, key..".player("..j..")#fillTmp");
				local weight = getXMLFloat(xmlFile, key..".player("..j..")#weight");
				local weightTmp = getXMLFloat(xmlFile, key..".player("..j..")#weightTmp");
				local idT = getXMLString(xmlFile, key..".player("..j..")#idT");
				--print("-----> "..tostring(drops).." "..tostring(fill).." "..tostring(fillTmp).." "..tostring(weight).." "..tostring(weightTmp).." "..tostring(idT));
				if self.stations[i].plStats[name] == nil then
					self.stations[i].plStats[name] = {};
				end;
				self.stations[i].plStats[name].drops = drops;
				self.stations[i].plStats[name].fill = fill;
				self.stations[i].plStats[name].fillTmp = fillTmp;
				self.stations[i].plStats[name].weight = weight;
				self.stations[i].plStats[name].weightTmp = weightTmp;
				self.stations[i].plStats[name].idTable = nil; --idTable;
				
				j = j + 1;
			end;
			i = i + 1;
		end;
		local j = 0;
		while true do
			local key = string.format("weightStations.totalStats");
			local name = getXMLString(xmlFile, key..".player("..j..")#name");
			--print("name="..tostring(name));
			if name == nil then
				break;
			end;
			local drops = getXMLInt(xmlFile, key..".player("..j..")#drops");
			local fill = getXMLInt(xmlFile, key..".player("..j..")#fill");
			local weight = getXMLFloat(xmlFile, key..".player("..j..")#weight");
			if self.totalStats[name] == nil then
				self.totalStats[name] = {};
			end;
			self.totalStats[name].drops = drops;
			self.totalStats[name].fill = fill;
			self.totalStats[name].weight = weight;
			j = j + 1;
		end;
		delete(xmlFile);
	else
		print("Warning: ", self.mapWeighStstationStats_xml, " can not be found, Door Trigger States not loaded.");
	end;
end;

addModEventListener(MapWeightstationMod);




--
--
--

WeightstationEvent = {};
WeightstationEvent_mt = Class(WeightstationEvent, Event);

InitEventClass(WeightstationEvent, "WeightstationEvent");

function WeightstationEvent:emptyNew()
    local self = Event:new(WeightstationEvent_mt);
    self.className="WeightstationEvent";
    return self;
end;

function WeightstationEvent:new(object, stations, totalStats)
    local self = WeightstationEvent:emptyNew()
	self.object = object;
    self.stations = stations;
	self.totalStats = totalStats;
    return self;
end;

function WeightstationEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	local cnt = streamReadInt8(streamId);
	self.stations = {};
	for j=1,cnt do
		if self.stations[j] == nil then
			self.stations[j] = {};
			self.stations[j].plStats = {};
		end;
		local cnt2 = streamReadInt8(streamId);
		for i=1,cnt2 do
			--local strLen = streamReadInt8(streamId);
			--local str = "";
			--for r=1,strLen do
			--	local input = streamReadInt8(streamId);
			--	str = str .. string.char(input);
			--end;
			local str = streamReadString(streamId);
			--print(">str="..tostring(str));		
			self.stations[j].plStats[str] = {};
			self.stations[j].plStats[str].drops = streamReadInt32(streamId);
			self.stations[j].plStats[str].fill = streamReadInt32(streamId);
			self.stations[j].plStats[str].fillTmp = streamReadInt32(streamId);
			self.stations[j].plStats[str].weight = streamReadFloat32(streamId);
			self.stations[j].plStats[str].weightTmp = streamReadFloat32(streamId);
			--print(">"..i..":"..str.." "..self.stations[j].plStats[str].drops.." "..self.stations[j].plStats[str].fill..
			--	" "..self.stations[j].plStats[str].fillTmp.." "..self.stations[j].plStats[str].weight.." "..self.stations[j].plStats[str].weightTmp);
		end;
	end;
	cnt = streamReadInt8(streamId);
	if self.totalStats == nil then
		self.totalStats = {};
	end;
	for i=1,cnt do
		--local strLen = streamReadInt8(streamId);
		--local str = "";
		--for r=1,strLen do
		--	str = str .. string.char(streamReadInt8(streamId));
		--end;
		local str = streamReadString(streamId);
		if self.totalStats[str] == nil then
			self.totalStats[str] = {};
		end;
		self.totalStats[str].drops = streamReadInt32(streamId);
		self.totalStats[str].fill = streamReadInt32(streamId);
		self.totalStats[str].weight = streamReadFloat32(streamId);
	end;
	
	self:run(connection);
end;

function WeightstationEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	local cnt = 0;
	for t,u in pairs(self.stations) do	
		cnt = cnt + 1;
	end;
	streamWriteInt8(streamId, cnt);
	for j=1,cnt do
		local station = self.stations[j];
		local cnt2 = 0;
		for x,y in pairs(station.plStats) do
			cnt2 = cnt2 + 1;
		end;
		streamWriteInt8(streamId, cnt2);
		for x,y in pairs(station.plStats) do
			--local y = asciiToUtf8(x);
			--local strLen = utf8Strlen(y);
			--streamWriteInt8(streamId, strLen);
			--for r=1,strLen do 
			--	streamWriteInt8(streamId, string.byte(y, r));
			--end;
			streamWriteString(streamId, x);
			streamWriteInt32(streamId, y.drops);
			streamWriteInt32(streamId, y.fill);
			streamWriteInt32(streamId, y.fillTmp);
			streamWriteFloat32(streamId, y.weight);
			streamWriteFloat32(streamId, y.weightTmp);
		end;
	end;
	cnt = 0;
	for i,j in pairs(self.totalStats) do
		cnt = cnt + 1;
	end;
	streamWriteInt8(streamId, cnt);
	for x,y in pairs(self.totalStats) do
		--local strLen = string.len(x);
		--streamWriteInt8(streamId, strLen);
		--for r=1,strLen do 
		--	streamWriteInt8(streamId, string.byte(x, r));
		--end;	
		streamWriteString(streamId, x);
		streamWriteInt32(streamId, y.drops);
		streamWriteInt32(streamId, y.fill);
		streamWriteFloat32(streamId, y.weight);
	end;
end;

function WeightstationEvent:run(connection)
	MapWeightstationMod:setPlayerStats(self.object, self.stations, self.totalStats);
end;



--
--
--

function onCreate(self, id)
	local instance = Weightstation:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

Weightstation = {};

local Weightstation_mt = Class(Weightstation, Object);

function Weightstation:new(isServer, isClient)
	local self = Object:new(isServer, isClient, Weightstation_mt);
	self.className = "Weightstation";
	return self;
end;

function Weightstation:load(name)
	
	local dir = getUserProfileAppPath() .. "mods/MapWeightstationMod/";
	local file = dir .. "MapWeightstationMod.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		self.firstTimeRun = false;
	end;	
	
	local xmlFile = loadXMLFile("Weightstation", file);
	
	self.fruitHectoliters = {};
	local i=0;
	while true do
		local key = string.format("vehicle.fruitHectoliters.fruit(%d)", i);
        local fruitNameStr = getXMLString(xmlFile, key .. "#name");
        if fruitNameStr == nil then
            break;
        end;
		self.fruitHectoliters[Fillable.fillTypeNameToInt[fruitNameStr]] = {};
		self.fruitHectoliters[Fillable.fillTypeNameToInt[fruitNameStr]].hectoliter = getXMLFloat(xmlFile, key .. "#hectoliter")/100;
		i=i+1;
	end;
	
	self.weightStation = {};
	self.weightStation.trigger = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.weightTrigger#index"));
	addTrigger(self.weightStation.trigger, "onVehicleCallback", self);
	self.weightStation.isEnabled = true;
	self.weightStation.name = getUserAttribute(name, "name");
	self.weightStation.digits = {};
	self.weightStation.digits[1] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit1"));
	self.weightStation.digits[2] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit2"));
	self.weightStation.digits[3] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit3"));
	self.weightStation.digits[4] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit4"));
	
	self.weightStation.digitPosition = {};
	self.weightStation.digitPosition["0"] = -1.000;
	self.weightStation.digitPosition["1"] = -0.105;
	self.weightStation.digitPosition["2"] = -0.208;
	self.weightStation.digitPosition["3"] = -0.306;
	self.weightStation.digitPosition["4"] = -0.410;
	self.weightStation.digitPosition["5"] = -0.517;
	self.weightStation.digitPosition["6"] = -0.613;
	self.weightStation.digitPosition["7"] = -0.719;
	self.weightStation.digitPosition["8"] = -0.817;
	self.weightStation.digitPosition["9"] = -0.926;
	self.hasBeenSet = false;
	
	self.vehiclesInTrigger = {};
	self.allVehicleMass = 0;
	self.lastAllVehicleMass = 0;
	self.playerToWeight = {};
	self.balesToWeight = {};
	

	self.hasBeenEntered = false;
	self.hasBeenLeft = false;
	self.vehicleIsStill = false;
	self.massIsSteady = false;
	self.doMeasure = false;
	self.doneMeasure = false;
	self.measuringTime = 0;
	self.validMeasurement = true;
	self.measureState = 0;	--	0:nothing, 1:vehicleEntered, 2:Measuring, 3:finish 
	self.statsRetVal = -1;	-- -1:not valid, 0:ok, 1:saved
	self.showStats = false;
	self.showStatsTimer = 0;
	self.lastPlayerName = nil;
	
	self.lights = {};
	self.lights[1] = {};
	self.lights[1].node = getChild(name, "Ampel1");
	self.lights[1].red = Utils.indexToObject(self.lights[1].node, "2|0");
	self.lights[1].yellow = Utils.indexToObject(self.lights[1].node, "2|1");
	self.lights[1].green = Utils.indexToObject(self.lights[1].node, "2|2");
	
	self.lights[2] = {};
	self.lights[2].node = getChild(name, "Ampel2");
	self.lights[2].red = Utils.indexToObject(self.lights[2].node, "2|0");
	self.lights[2].yellow = Utils.indexToObject(self.lights[2].node, "2|1");
	self.lights[2].green = Utils.indexToObject(self.lights[2].node, "2|2");
	
	self.plStats = {};
	
	MapWeightstationMod:addWeightstation(self);
end;

function Weightstation:delete()
	if self.weightStation.trigger ~= nil then
		removeTrigger(self.weightStation.trigger);
	end;
end;


function Weightstation:loadMap(name)
end;

function Weightstation:deleteMap()
end;


function Weightstation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Weightstation:keyEvent(unicode, sym, modifier, isDown)

end;

function Weightstation:update(dt)
	
	if self.showStats then 

		local idx = nil;
		for k, vehicle in pairs(self.vehiclesInTrigger) do
			if SpecializationUtil.hasSpecialization(Steerable, vehicle.specializations) then
				idx = k;
			end;
		end;

		local playerName;
		if idx ~= nil then
			playerName = self.vehiclesInTrigger[idx].controllerName;
			self.lastPlayerName = playerName;
			
			--[[ local isValid = false;
			for i,j in pairs(g_currentMission.players) do
				--if string.len(g_currentMission.player.controllerName) == string.len(playerName) then	-- only on host
				if string.len(j.controllerName) == string.len(playerName) then
					--if string.match(g_currentMission.player.controllerName, playerName) then
						isValid = true;
					--end;
				end;
			end;
			if not isValid then 
				self.showStats = false;
				return;
			end;	]]--		
			
		else
			if self.lastPlayerName ~= nil then
				playerName = self.lastPlayerName;
			end;
		end;
		
		
		MapWeightstationMod.hud.visible = true;
		self.showStatsTimer = self.showStatsTimer + dt;
		if self.showStatsTimer > 10000 then
			self.showStatsTimer = 0;
			self.showStats = false;
			MapWeightstationMod.hud.visible = false;
		else			
			local xpos = 0.2;
			local ypos = 0.9 - 0.02;
			local cnt = 0;
			setTextColor(0.3, 0.3, 0.3, 0.9); setTextBold(true);
			renderText(xpos, ypos, 0.018, string.format("%15s      %4s           %10s               %10s", "Playername", "tips", "CHECK-IN", "TOTAL"));
			ypos = ypos - 0.02;
			for k,l in pairs(MapWeightstationMod.stations) do
				ypos = ypos - 0.01;
				--setTextBold(true);
				setTextColor(1.0, 1.0, 1.0, 0.9); 
				renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("Station: %s ", l.weightStation.name));
				setTextColor(0.8, 0.8, 0.8, 0.9);
				--setTextBold(false);
				cnt = cnt + 1;
				for i,j in pairs(l.plStats) do
					--renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("%-15s  \t     %04d \t\t %06d l   %06.2f t \t\t %010d l   %08.2f t ", i, j.drops, j.fillTmp, j.weightTmp, j.fill, j.weight ));
					renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("%s ", i));
					renderText(xpos + 0.12, ypos-(cnt+1)*0.02, 0.018, string.format(" %04d \t\t %06d l   %06.2f t \t\t %010d l   %09.2f t ",  j.drops, j.fillTmp, j.weightTmp, j.fill, j.weight ));
					cnt = cnt + 1;
				end;
			end;
			ypos = ypos - 0.01;
			--setTextBold(true);
			setTextColor(1.0, 1.0, 1.0, 0.9); 
			cnt = cnt + 1;
			renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("TOTAL"));
			setTextColor(0.8, 0.8, 0.8, 0.9);
			--setTextBold(false);
			local cnt2=0;
			local cnt3=0;
			for i,j in pairs(MapWeightstationMod.totalStats) do
				cnt2=cnt2+1;
			end;
			cnt = cnt + 1;
			for i,j in pairs(MapWeightstationMod.totalStats) do
				setTextColor(cnt3/(cnt2-1), 1.0-(cnt3/cnt2), 0.2, 0.9);
				--renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("%-15s  \t     %04d \t\t \t\t\t  \t\t  \t\t\t \t\t %10d l   %08.2f t ", i, j.drops, j.fill, j.weight ));
				renderText(xpos, ypos-(cnt+1)*0.02, 0.018, string.format("%s", i));
				renderText(xpos + 0.12, ypos-(cnt+1)*0.02, 0.018, string.format("%04d \t\t \t\t\t  \t\t  \t\t\t \t\t %10d l   %09.2f t ",  j.drops, j.fill, j.weight ));
				cnt = cnt + 1;
				cnt3 = cnt3 + 1;
			end;
			MapWeightstationMod.hud.height = 0.9 - (ypos - cnt*0.02) + 0.04;
			setTextBold(false);
		end;
	end;	
end;

function Weightstation:updateTick(dt)
			
	if self.weightStation.isEnabled then
		if table.getn(self.vehiclesInTrigger) > 0 or table.getn(self.playerToWeight) > 0 and self.hasBeenSet == false then
			self:getVehicleMass(dt);
			self:getPlayerStats(dt);
		elseif table.getn(self.vehiclesInTrigger) == 0 then
			self:setDigitNumbers(0);
			self.hasBeenSet = true;
		end;
	end;

end;

function Weightstation:draw()
			
end;

function Weightstation:setDigitNumbers(mass)
	local mass = mass;
	local massUnits = string.format("%d", mass);
	local digit1 = "0";
	local digit2 = "0";
	local digit3 = "0";
	local digit4 = "0"
	if mass >= 10 then
		digit4 = string.sub(massUnits, 1, 1);
	end;
	if mass >= 100 then
		digit3 = string.sub(massUnits, 1, 1);
		digit4 = string.sub(massUnits, 2, 2);
	end;
	if mass >= 1000 then
		digit2 = string.sub(massUnits, 1, 1);
		digit3 = string.sub(massUnits, 2, 2);
		digit4 = string.sub(massUnits, 3, 3);
	end;
	if mass >= 10000 then
		digit1 = string.sub(massUnits, 1, 1);
		digit2 = string.sub(massUnits, 2, 2);
		digit3 = string.sub(massUnits, 3, 3);
		digit4 = string.sub(massUnits, 4, 4);
	end;
	setShaderParameter(self.weightStation.digits[4], "Position", self.weightStation.digitPosition[digit4], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[3], "Position", self.weightStation.digitPosition[digit3], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[2], "Position", self.weightStation.digitPosition[digit2], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[1], "Position", self.weightStation.digitPosition[digit1], 0, 0, 0, false);
end;

function Weightstation:onVehicleCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.weightStation.isEnabled then
		if onStay then
			local doInsertVehicle = true;
			local doInsertPlayer = true;
			local doInsertBale = true;
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			for k, vehicles in pairs(self.vehiclesInTrigger) do
				if vehicle == vehicles then
					doInsertVehicle = false;
				end;
			end;
			for k, player in pairs(self.playerToWeight) do
				if otherId == player.rootNode then
					doInsertPlayer = false;
				end;
			end;
			for k, bale in pairs(self.balesToWeight) do
				if otherId == bale.nodeId then
					doInsertBale = false;
				end;
			end;
			
			if doInsertVehicle then
				table.insert(self.vehiclesInTrigger, vehicle);
				self.hasBeenEntered = true;
			end;
			if doInsertPlayer then
				for i, misssionPlayers in pairs(g_currentMission.players) do
					if otherId == misssionPlayers.rootNode then
						table.insert(self.playerToWeight, misssionPlayers);
					end;
				end;
			end;
			if doInsertBale then
				for index, item in pairs(g_currentMission.itemsToSave) do
					if item.item:isa(Bale) then
						if item.item.nodeId == otherId then
							table.insert(self.balesToWeight, item.item);
						end;
					end;
				end;
			end;
			
			if doInsertVehicle or doInsertPlayer or doInsertBale then
				self.hasBeenEntered = true;
				self.hasBeenLeft = false;
				self.measuringDone = false;
				self.hasBeenSet = false;
			end;
		elseif onLeave then
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			for k, v in pairs(self.vehiclesInTrigger) do
				if vehicle == v then
					table.remove(self.vehiclesInTrigger, k);
				end;
			end;
			for k, player in pairs(self.playerToWeight) do
				if player.rootNode == otherId then
					table.remove(self.playerToWeight, k);
				end;
			end;
			for k, bale in pairs(self.balesToWeight) do
				if bale.nodeId == otherId then
					table.remove(self.balesToWeight, k);
				end;
			end;
			if table.getn(self.vehiclesInTrigger) == 0 or
				table.getn(self.playerToWeight) == 0 or
				table.getn(self.balesToWeight) == 0 then
				self.hasBeenEntered = false;
				self.hasBeenLeft = false;
				self.vehicleIsStill = false;
				self.massIsSteady = false;
				self.doMeasure = false;
				self.doneMeasure = false;
				self.measuringTime = 0;
				self.validMeasurement = true;
			end;
		end;
	end;
end;

function Weightstation:getVehicleMass(dt)
	local mass = 0;
	for k, vehicle in pairs(self.vehiclesInTrigger) do
		for k, component in pairs(vehicle.components) do
			mass = mass + getMass(component.node);	
		end;
	end;
	mass = mass*1000;
	for k, vehicle in pairs(self.vehiclesInTrigger) do
		if vehicle.fillLevelMax == nil then
			if vehicle.fillLevel ~= nil then
				mass = mass-(vehicle.fillLevel*vehicle.massScale);
				local massScale = 0.70;
				for k, fruit in pairs(self.fruitHectoliters) do
					if k == vehicle.currentFillType and fruit then
						massScale = fruit.hectoliter;
					end;
				end;
				mass = mass+(vehicle.fillLevel*massScale);
			end;
			if vehicle.grainTankFillLevel ~= nil then
				local massScale = 0.70;
				for k, fruit in pairs(self.fruitHectoliters) do
					if k == vehicle.currentGrainTankFruitType and fruit then
						massScale = fruit.hectoliter;
					end;
				end;
				mass = mass+(vehicle.grainTankFillLevel*massScale);
				--print("mass 2="..mass);
			end;
		elseif vehicle.fillLevelMax ~= nil then
			mass = mass+(633*vehicle.fillLevel);
			--print("mass m="..mass);
		end;
		if vehicle.fuelFillLevel ~= nil then
			mass = mass+vehicle.fuelFillLevel;
			--print("mass f="..mass);
		end;
		if vehicle.isControlled then
			mass = mass+80;
		end;
	end;
	local numPlayers = table.getn(self.playerToWeight);
	mass = mass+(80*numPlayers);
	local numBales = table.getn(self.balesToWeight);
	mass = mass+(633*numBales);
	if mass > self.allVehicleMass then
		self.allVehicleMass = math.min(self.allVehicleMass+(dt*5), mass);
	elseif mass < self.allVehicleMass then
		self.allVehicleMass = math.max(self.allVehicleMass-(dt*15), mass);
	end;
	self:setDigitNumbers(self.allVehicleMass);
	
	if math.abs(self.allVehicleMass - self.lastAllVehicleMass) < 0.001 then
		self.massIsSteady = true;
	else
		self.massIsSteady = false;
	end;
	self.lastAllVehicleMass = self.allVehicleMass;
end;

function Weightstation:getPlayerStats(dt)
	local vehByPl = false;
	
	if self.hasBeenEntered then
	
		local cnt = 0;
		local idx = 0;
		for k, vehicle in pairs(self.vehiclesInTrigger) do
			if SpecializationUtil.hasSpecialization(Steerable, vehicle.specializations) then
				cnt = cnt + 1;
				idx = k;
			end;
		end;
		self.doMeasure = false;
		if cnt == 1 then
			if self.massIsSteady then
				local lastSpeed = self.vehiclesInTrigger[idx].lastSpeed*3600;
				local toFast = self.vehiclesInTrigger[idx]:doCheckSpeedLimit() and lastSpeed > 0.1;			
				if not toFast then
					self.doMeasure = true;
				end;
			end;
		end;
		--print("self.doMeasure="..tostring(self.doMeasure));
		if self.doMeasure and not self.doneMeasure then
			self.measuringTime = self.measuringTime + dt;
			if self.measuringTime > 1000 then
				self.measuringTime = 0;
				local playerName = self.vehiclesInTrigger[idx].controllerName;
				local plId = 0;
				for i,j in pairs(g_currentMission.players) do
					if string.len(playerName) == string.len(j.controllerName) then
						if string.match(playerName, j.controllerName) then
							plId = j.id;
						end;
					end;
				end;
				
				local vehT = {};
				local idT = {};
				table.insert(vehT, self.vehiclesInTrigger[idx]);
				table.insert(idT, networkGetObjectId(self.vehiclesInTrigger[idx]));
				for i,j in pairs(vehT) do
					for k,l in pairs(self.vehiclesInTrigger) do
						if l.attacherVehicle ~= nil then
							if l.attacherVehicle == j then
								table.insert(vehT, l);
								table.insert(idT, networkGetObjectId(l));
								break;
							end;
						end;
					end;
				end;
				--local idT = {};
				--for i,j in pairs(vehT) do
					--table.insert(idT, j.id);
					--print("j.id="..j.id);					
				--end;
				
				if self.vehiclesInTrigger[idx] == g_currentMission.controlledVehicle then 
					vehByPl = true;
				end;
	
				local weight = 0;
				local fillLevel = 0;
				for i, vehicle in pairs(self.vehiclesInTrigger) do
					if SpecializationUtil.hasSpecialization(Fillable, vehicle.specializations) then
						local massScale = 0.70;
						for k, fruit in pairs(self.fruitHectoliters) do
							if k == vehicle.currentFillType and fruit then
								massScale = fruit.hectoliter;
							end;
						end;
						weight = weight + (vehicle.fillLevel*massScale)/1000; -- + vehicle.fillLevel*vehicle.massScale;
						fillLevel = fillLevel + vehicle.fillLevel;
					end;
				end;
				local nrBales = 0;
				self.statsRetVal = MapWeightstationMod:updateStats(self.weightStation.name, playerName, fillLevel, weight, nrBales, idT);
				self.doneMeasure = true;
			end;
		else
			self.measuringTime = 0;
		end;
		
	end;
	
	local measureState = 0;
	if self.hasBeenEntered then
		measureState = 1;
		if self.doMeasure then
			measureState = 2;
		end;
		if self.doneMeasure then 
			measureState = 3;
		end;
	else
		measureState = 0;
	end;
	
	if self.measureState ~= measureState then
		for i=1,2 do
			if measureState == 0 then
				setVisibility(self.lights[i].red, false);
				setVisibility(self.lights[i].yellow, false);
				setVisibility(self.lights[i].green, false);
			elseif measureState == 1 then
				setVisibility(self.lights[i].red, true);
				setVisibility(self.lights[i].yellow, false);
				setVisibility(self.lights[i].green, false);
			elseif measureState == 2 then
				setVisibility(self.lights[i].red, false);
				setVisibility(self.lights[i].yellow, true);
				setVisibility(self.lights[i].green, false);
			elseif measureState == 3 then
				--print(".....self.statsRetVal...."..tostring(self.statsRetVal));
				if self.statsRetVal == 0 then
					setVisibility(self.lights[i].red, false);
					setVisibility(self.lights[i].yellow, true);
					setVisibility(self.lights[i].green, true);
				elseif self.statsRetVal == 1 then
					setVisibility(self.lights[i].red, false);
					setVisibility(self.lights[i].yellow, false);
					setVisibility(self.lights[i].green, true);
				elseif self.statsRetVal == 11 then
					setVisibility(self.lights[i].red, true);
					setVisibility(self.lights[i].yellow, true);
					setVisibility(self.lights[i].green, true);
				end;
				if vehByPl then
					self.showStats = true;
				end;
			end;
		end;
		self.measureState = measureState;
	end;
	
		

end;
