-- MapDoorTrigger
-- Script for MapDoorTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  13/02/2012

MapDoorTrigger = {};
MapDoorTrigger.doorTriggers = {};
MapDoorTrigger.nodeToDoorTrigger = {};
MapDoorTrigger.nameToDoorTrigger = {};
MapDoorTrigger.saveTable = {};
MapDoorTrigger.baseDirectory = g_currentModDirectory;

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapDoorTrigger:saveDoorTriggerStates();
end;

local Server_sendObjects_old = Server.sendObjects;
function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
	for _,doorTrigger in pairs(MapDoorTrigger.doorTriggers) do
		connection:sendEvent(SetDoorStateEvent:new(doorTrigger, doorTrigger.doorIsOpened));
	end;
    Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;

--Fixing Steerable
SteerableDoorTrigger = {}
function SteerableDoorTrigger:load(configFile, positionX, offsetY, positionZ, yRot, typeName)
	self.onEnteredMapDoorTrigger = SteerableDoorTrigger.onEnteredMapDoorTrigger;
	self.onLeavedMapDoorTrigger = SteerableDoorTrigger.onLeavedMapDoorTrigger;
	self.currentMapDoorTrigger = nil;
end;

function SteerableDoorTrigger:onEnteredMapDoorTrigger(trigger)
	self.currentMapDoorTrigger = trigger;
end;

function SteerableDoorTrigger:onLeavedMapDoorTrigger()
	self.currentMapDoorTrigger = nil;
end;

function SteerableDoorTrigger:update(dt)
	if not MapDoorTrigger.chatDialogOpened then
		if self.currentMapDoorTrigger ~= nil and self:getIsActiveForInput() then
			local trigger = self.currentMapDoorTrigger;	
			if InputBinding.hasEvent(trigger.inputKey)and trigger.isEnabled then
				trigger:setDoorState(not trigger.doorIsOpened);
			end;
		end;
	end;
end;

function SteerableDoorTrigger:draw()
	if not MapDoorTrigger.chatDialogOpened then
		if self.currentMapDoorTrigger ~= nil then
			local trigger = self.currentMapDoorTrigger;
			if trigger.isEnabled then
				if not trigger.doorIsOpened then
					g_currentMission:addHelpButtonText(g_i18n:getText(trigger.posText), trigger.inputKey);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText(trigger.negText), trigger.inputKey);
				end;
				if MapDoorTrigger.hudDoorTriggerOverlay ~= nil then
					MapDoorTrigger.hudDoorTriggerOverlay:render();
				end;
			end;
		end;
	end;
end;
Steerable.load   = Utils.appendedFunction(Steerable.load, SteerableDoorTrigger.load);
Steerable.update   = Utils.appendedFunction(Steerable.update, SteerableDoorTrigger.update);
Steerable.draw   = Utils.appendedFunction(Steerable.draw, SteerableDoorTrigger.draw);

--Fixing player
if g_currentMission ~= nil then
	if g_currentMission.player ~= nil then
		g_currentMission.player.activeMapDoorTrigger =  nil;
	end;
end;

function MapDoorTrigger:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapDoorTriggers_xml = dir .. "/mapDoorTriggers.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapDoorTriggers_xml);
		self.firstTimeRun = false;
	end;
	
	local x = g_currentMission.hudAttachmentOverlay.x;
	local y = g_currentMission.hudAttachmentOverlay.y;
	local width = g_currentMission.hudAttachmentOverlay.width;
	local height = g_currentMission.hudAttachmentOverlay.height;
	local filename = Utils.getFilename("OpenDoorTrigger_hud.png", self.baseDirectory);
	self.hudDoorTriggerOverlay = Overlay:new("hudDoorTriggerOverlay", filename, x, y, width, height);
	
	self.chatDialogOpened = false;
	self.updateIntervallTimeOut = 0;
end;

function MapDoorTrigger:deleteMap()
end;

function MapDoorTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapDoorTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapDoorTrigger:update(dt)
	if g_server ~= nil and self.firstTimeRun then
		self:loadDoorTriggerStates();
		self.firstTimeRun = false;
	end;
	if self.updateIntervallTimeOut < g_currentMission.time then
		if self.hudDoorTriggerOverlay ~= nil then
			if g_currentMission.hudAttachmentOverlay.x ~= self.hudDoorTriggerOverlay.x or g_currentMission.hudAttachmentOverlay.y ~= self.hudDoorTriggerOverlay.y then
				self.hudDoorTriggerOverlay:setPosition(g_currentMission.hudAttachmentOverlay.x, g_currentMission.hudAttachmentOverlay.y);
			end;
		end;
		self.updateIntervallTimeOut = g_currentMission.time+300000;
	end;
	
	self.chatDialogOpened = g_gui.currentGui == g_gui.guis["ChatDialog"];
end;

function MapDoorTrigger:draw()
	for _, doorTrigger in pairs(self.doorTriggers) do
		doorTrigger:draw();
	end;
end;

function MapDoorTrigger:addDoorTrigger(doorTrigger)
	table.insert(self.doorTriggers, doorTrigger)
	self.nodeToDoorTrigger[doorTrigger.triggerId] = doorTrigger;
	self.nameToDoorTrigger[doorTrigger.savingName] = doorTrigger;
end;

function MapDoorTrigger:saveDoorTriggerStates()
	local existDir = io.open (self.mapDoorTriggers_xml, "w");	
	if existDir == nil then
		createXMLFile("createDoorTrigger", self.mapDoorTriggers_xml, "saveDoorTrigger");
	end;
    local xmlFile = io.open (self.mapDoorTriggers_xml, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<doorTriggers>\n');
		for _,doorTrigger in pairs(self.doorTriggers) do
			xmlFile:write('    <doorTrigger savingName="'..doorTrigger.savingName..'" trackTime="'..doorTrigger.trackTime..'"  />\n');
		end;
        xmlFile:write("</doorTriggers>");
        xmlFile:close();
    end;	
end;

function MapDoorTrigger:loadDoorTriggerStates()
	local existDir = io.open (self.mapDoorTriggers_xml, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.mapDoorTriggers_xml);
		local i = 0;
		while true do
			local key = string.format("doorTriggers.doorTrigger(%d)", i);
			local savingName = getXMLString(xmlFile, key.."#savingName");
			local trackTime = getXMLFloat(xmlFile, key.."#trackTime");
			if (savingName or trackTime) == nil then
				break;
			end;
			local entry = {};
			entry.savingName = savingName;
			entry.trackTime = trackTime;
			self.saveTable[i] = entry;
			i = i + 1;
		end;
		delete(xmlFile);
	else
		print("Warning: ", self.mapDoorTriggers_xml, " can not be found, Door Trigger States not loaded.");
	end;
	for _, doorTrigger in pairs(self.doorTriggers) do
		for _,save in pairs(self.saveTable) do
			if doorTrigger.savingName == save.savingName then
				if save.trackTime > 0 then
					doorTrigger.doorIsOpened = true;
				else
					doorTrigger.doorIsOpened = false;
				end;
				doorTrigger.trackTime = save.trackTime;
			end;
		end;
	end;
end;
addModEventListener(MapDoorTrigger);

-- DoorTrigger
-- Script for DoorTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  13/02/2012

function onCreate(self, id)
	local instance = DoorTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

DoorTrigger = {};

local DoorTrigger_mt = Class(DoorTrigger, Object);

function DoorTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, DoorTrigger_mt);
	self.className = "DoorTrigger";
	return self;
end;

function DoorTrigger:load(name)
	self.triggerId = name;
	addTrigger(name, "triggerCallback", self);
	self.isEnabled = true;
	for i=0, getNumOfChildren(name)-1 do
		local child = getChildAt(name, i);
		setCollisionMask(child, 0);
	end;
	self.assignRigidType = true;
	self.assignRigidTypeTimeOut = g_currentMission.time+4000;
	local inputKey = getUserAttribute(name, "inputKey");--string
	self.inputKey = InputBinding[inputKey];
	self.posText = getUserAttribute(name, "posText");--string
	self.negText =  getUserAttribute(name, "negText");--string
	self.savingName =  getUserAttribute(name, "savingName");--string			
	self.trackTime = 0;				
	self.lastTrackTime = 0;		
	self.doorIsOpened = false;
	local rootNodeName = getUserAttribute(name, "rootNodeName");--string
	if rootNodeName ~= nil then
		local rootNode = getChild(name, rootNodeName)
		self.animCharSet = 0;
		if rootNode ~= nil then	
			self.animCharSet = getAnimCharacterSet(rootNode);
			if self.animCharSet ~= 0 then					
				local clipSource = getUserAttribute(name, "animationClip");--string
				if clipSource ~= nil then
					self.clip = getAnimClipIndex(self.animCharSet, clipSource);
					if self.clip ~= nil then
						if self.clip >= 0 then
							assignAnimTrackClip(self.animCharSet, 0, self.clip);
							setAnimTrackLoopState(self.animCharSet, 0, false);
							self.speedScale = Utils.getNoNil(getUserAttribute(name, "animSpeedScale"), 1.0);--float
							self.animDuration = getAnimClipDuration(self.animCharSet, self.clip);
							MapDoorTrigger:addDoorTrigger(self)
						else
							print("Error: Can't find animationClip in MapDoorTrigger: "..getName(name).." with clipSource: "..clipSource);
						end;
					else
						print("Error: Can't find animationClip in MapDoorTrigger: "..getName(name).." with clipSource: "..clipSource);
					end;
				else
					print("Error: Can't find clipSource in MapDoorTrigger: "..getName(name));
				end;
			else
				print("Error: Can't find animationCharacterSet in MapDoorTrigger: "..getName(name).." on rootNode: "..rootNodeName.."\n       Sure that thats part of the animation?");
			end;
		else
			print("Error: Can't find rootNode in MapDoorTrigger: "..getName(name).." with rootNodeName: "..rootNodeName);
		end;
	else
		print("Error: Can't find rootNodeName in MapDoorTrigger: "..getName(name));
	end;
end;

function DoorTrigger:delete()
	removeTrigger(self.triggerId);
end;

function DoorTrigger:update()
	if self.assignRigidType and self.assignRigidTypeTimeOut <= g_currentMission.time then
		for i=0, getNumOfChildren(self.triggerId)-1 do
			local child = getChildAt(self.triggerId, i)
			setCollisionMask(child, 2102);
		end;
		self.assignRigidType = false;
	end;
	if self.isEnabled and not MapDoorTrigger.chatDialogOpened then
		if g_currentMission ~= nil and g_currentMission.player ~= nil and g_currentMission.player.activeMapDoorTrigger ~= nil then
			if g_currentMission.player.activeMapDoorTrigger == self.triggerId then
				if InputBinding.hasEvent(self.inputKey) then
					self:setDoorState(not self.doorIsOpened);
				end;
			end;
		end;
	end;
end;

function DoorTrigger:draw()
	if self.isEnabled and not MapDoorTrigger.chatDialogOpened then
		if g_currentMission ~= nil and g_currentMission.player ~= nil and g_currentMission.player.activeMapDoorTrigger ~= nil then
			if g_currentMission.player.activeMapDoorTrigger == self.triggerId then
				if not self.doorIsOpened then
					g_currentMission:addHelpButtonText(g_i18n:getText(self.posText), self.inputKey);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText(self.negText), self.inputKey);
				end;
				if MapDoorTrigger.hudDoorTriggerOverlay ~= nil then
					MapDoorTrigger.hudDoorTriggerOverlay:render();
				end;
			end;
		end;
	end;
end;

function DoorTrigger:updateTick()
	if self.animDuration ~= nil then
		if self.trackTime < 1 then 
			self.trackTime = 0;
		end;
		if self.trackTime > self.animDuration then
			self.trackTime = self.animDuration;
		end;
		if self.doorIsOpened then
			if self.trackTime < self.animDuration then
				self.trackTime = self.trackTime +10*self.speedScale;
			end;
		else
			if self.trackTime > 0 then
				self.trackTime = self.trackTime -10*self.speedScale;
			end;
		end;	
		if self.lastTrackTime ~= self.trackTime then
			enableAnimTrack(self.animCharSet, self.clip);
			setAnimTrackTime(self.animCharSet, self.clip, self.trackTime, true);
			disableAnimTrack(self.animCharSet, self.clip);
			self.lastTrackTime = self.trackTime;
		end;
	end;
end;

function DoorTrigger:setDoorState(state, noEventSend)
	SetDoorStateEvent.sendEvent(self, state, noEventSend);
	self.doorIsOpened = state;
end;

function DoorTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled and (onEnter or onLeave) then
		local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
		if vehicle ~= nil and vehicle.onEnteredMapDoorTrigger ~= nil and SpecializationUtil.hasSpecialization(Steerable, vehicle.specializations) then
			if onEnter then
				vehicle:onEnteredMapDoorTrigger(self);
			else
				vehicle:onLeavedMapDoorTrigger();
			end;
		end;
		if g_currentMission.player ~= nil then
			if g_currentMission.controlPlayer and otherId == g_currentMission.player.rootNode then
				if onEnter then
					g_currentMission.player.activeMapDoorTrigger =  triggerId;
				else
					g_currentMission.player.activeMapDoorTrigger =  nil;			
				end;
			else
				g_currentMission.player.activeMapDoorTrigger =  nil;	
			end;
		end;
	end;
end;