-- Register fruits
function RegisterFruits()
local fruitList = {};

    -- Notes:
    -- "type" is not accurate. It were an attempt to group the fruits, so they may be easier selected at silos/sell-points.
    -- "fruitName" must be the same as in the FoliageSubLayers.
    table.insert(fruitList, {type="lettuce" ,fruitName="blumkohl"       ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=5   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="root"    ,fruitName="carrot"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=3 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="flower"  ,fruitName="cotton"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="grain"   ,fruitName="greenwheat"     ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.42 ,literPerQm=1   ,seedUsagePerQm=0.01    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="flower"  ,fruitName="mohn"           ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="grain"   ,fruitName="oat"            ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=4 ,pricePerLiter=0.42 ,literPerQm=1   ,seedUsagePerQm=0.01    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="fruit"   ,fruitName="pea"            ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="root"    ,fruitName="potato"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=1 ,pricePerLiter=0.40 ,literPerQm=0.8 ,seedUsagePerQm=0.02    ,seedPricePerLiter=0.1} );
    table.insert(fruitList, {type="grain"   ,fruitName="rice"           ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=4 ,pricePerLiter=0.25 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="grain"   ,fruitName="rye"            ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="fruit"   ,fruitName="soybean"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="root"    ,fruitName="sugarbeet"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=3 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="root"    ,fruitName="sugarcane"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.20 ,literPerQm=4   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="flower"  ,fruitName="sunflower"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.30 ,literPerQm=1   ,seedUsagePerQm=0.01    ,seedPricePerLiter=0.1} );
    table.insert(fruitList, {type="grain"   ,fruitName="maizev2"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true  ,minHarvestingGrowthState=4 ,pricePerLiter=0.42 ,literPerQm=1   ,seedUsagePerQm=0.01    ,seedPricePerLiter=0.5} );

    --
    -- Can not seed or harvest! Only for transport!
    -- Make sure that 'allowsSeeding' is FALSE. If not, they would also show up in the sowing-machine!
    table.insert(fruitList, {type="none"    ,fruitName="manure"         ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="liquidManure"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="fertilizer"     ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="milk"           ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="strawbale"      ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="haybale"        ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );


    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "map01/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding    (ARGH! I spent 3-4 days trying to find out why the new crop autogrows. Then I noticed an 's' were missing, so 'needSeeding' returned nil.)
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();

--
--
--
local origSowingMachineLoad = SowingMachine.load;
SowingMachine.load = function(self, xmlFile)
    if origSowingMachineLoad ~= nil then
        origSowingMachineLoad(self, xmlFile);
    end;

    --
    local msg = "Info. Added seeds to '".. Utils.getNoNil(self.name, "SowingMachine") .."': ";
    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        -- Check if FruitType have a FoliageSubLayer-/TerrainId.
        local terrainId = 0;
        if g_currentMission.fruits[fruitType.index] ~= nil then
            terrainId = g_currentMission.fruits[fruitType.index].id;
        end;
        -- Only add FruitType if its allowed to be seeded, AND have a FoliageSubLayer-/TerrainId.
        if fruitType.allowsSeeding and terrainId > 0 then
            table.insert(self.seeds, fruitType.index);
            msg = msg .. FruitUtil.fruitIndexToDesc[ fruitType.index ].name .." ";
        end;
    end;
    print(msg);
    -- Sort the seedable fruits by generic-name.
    table.sort(self.seeds, function(l,r) return (FruitUtil.fruitIndexToDesc[l].name < FruitUtil.fruitIndexToDesc[r].name); end);
end;