--
-- BGAControl
--
-- (c) by Wagenheber
-- > 28.04.2011 < --
--

print("  BGAControl loaded");

BGAControl = {};
BGAControl.modDirectory = g_currentModDirectory;

function BGAControl:loadMap(name)

	self.BGAHUD = createImageOverlay(BGAControl.modDirectory .. "HUD.png");
	self.BGACount = 1
	BGAControl:getAllBGACount();
	
	-- Festlegen der Positionen
	self.textDistance = 0.025;
	self.substratStringY = 0.725
	self.substratValueY = self.substratStringY - self.textDistance;
	self.bunkerStringY = self.substratValueY - self.textDistance;
	self.bunkerValueY = self.bunkerStringY - self.textDistance;
	self.paragraphY = self.bunkerValueY - self.textDistance;
	self.moneyStringY = self.paragraphY - self.textDistance;
	self.moneyValueY = self.moneyStringY - self.textDistance;
	self.yesterdayMoneyStringY = self.moneyValueY - self.textDistance;
	self.yesterdayMoneyValueY = self.yesterdayMoneyStringY - self.textDistance;
	
	if g_server ~= nil then 
		self.priceStringY = self.yesterdayMoneyValueY - self.textDistance; 	-- normale Variante
	else
		self.priceStringY = self.paragraphY - self.textDistance; 			-- gekrzte Variante
	end;

	self.priceValueY = self.priceStringY - self.textDistance;	
	
end;

function BGAControl:getAllBGACount()

	self.gesBGA = 1
	local ready = false
    repeat
        if MapBGA.ModEvent.bunkers[self.gesBGA] ~= nil then
			self.gesBGA = self.gesBGA + 1;
		else
			ready = true;
			self.gesBGA = self.gesBGA - 1;
		end;
    until ready == true;
	
end;

function BGAControl:deleteMap()
end;

function BGAControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BGAControl:keyEvent(unicode, sym, modifier, isDown)
	
	if InputBinding.isPressed(InputBinding.BGAControl_switch) then
		if self.BGACount < self.gesBGA then 
			self.BGACount = self.BGACount + 1;
		else
			self.BGACount = 1;
		end;
	end;
	
end;

function BGAControl:update(dt)
		if InputBinding.hasEvent(InputBinding.SHOW_BGAC) then
			self.BGAControl = not self.BGAControl;
		end;
end;


function BGAControl:draw()
	
	if MapBGA.ModEvent.bunkers[1] ~= nil then
		if MapBGA.ModEvent.bunkers[self.BGACount].manure.fillLevel < 0 then
			self.correctManureFilllevel = 0;
		else
			self.correctManureFilllevel = MapBGA.ModEvent.bunkers[self.BGACount].manure.fillLevel;
		end;
		if self.BGAControl then
			setTextColor(0, 0, 0, 1);
			setTextBold(false);
			renderOverlay(self.BGAHUD, 0.0, 0.0, 1, 1);
			renderText(0.05, self.substratStringY, 0.020, "Liquidmanure:");
			renderText(0.05, self.substratValueY, 0.020, tostring(math.floor(self.correctManureFilllevel)) .. " / " .. tostring(MapBGA.ModEvent.bunkers[self.BGACount].manure.capacity) .. " Liter");
			renderText(0.05, self.bunkerStringY, 0.020, "Silo:");
			renderText(0.05, self.bunkerValueY, 0.020, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].fillLevel)) .. " / " .. tostring(MapBGA.ModEvent.bunkers[self.BGACount].capacity) .. " Liter");
			renderText(0.05, self.paragraphY, 0.020, "-------------------------------");

			if g_server ~= nil then
				renderText(0.05, self.moneyStringY, 0.020, "Outstand Payment :");
				renderText(0.05, self.moneyValueY, 0.020, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].money)) .. " Euro");
				renderText(0.05, self.yesterdayMoneyStringY, 0.020, "Last Payment:");
				renderText(0.05, self.yesterdayMoneyValueY, 0.020, tostring(math.floor(MapBGA.ModEvent.bunkers[self.BGACount].yesterDayMoney )) .. " Euro");
			end;
			
			renderText(0.05, self.priceStringY, 0.020, "Price / kWh:");
			renderText(0.05,self.priceValueY, 0.020, tostring((math.floor(MapBGA.ModEvent.bunkers[self.BGACount].electricityPrice*100))/100) .. " Euro");
			renderText(0.18, 0.450, 0.015, tostring(self.BGACount .. " / " .. self.gesBGA));
		end;
		
		if  g_currentMission.missionPDA.showPDA == false then
			self.emptyBunkers = ""
			for i = 1, self.gesBGA, 1 do
				if MapBGA.ModEvent.bunkers[i].fillLevel == 0 then
					self.emptyBunkers = self.emptyBunkers .. "[" .. i .. "] ";
				end;
			end;
			
			if self.emptyBunkers ~= "" then
				setTextColor(0, 0, 0, 1);	
				setTextBold(false);
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(0.5, 0.05, 0.03, "! Warning - BGA feeder is " .. self.emptyBunkers .. "Empty !");
				setTextAlignment(RenderText.ALIGN_Left);
			end;
		end;
	end;
	
end;

addModEventListener(BGAControl);