-- pipelights
-- Specialization for pipelights.
--
-- @author  Tr3n3rO	
-- @date  11/06/2010
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

pipelights = {};

function pipelights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function pipelights:load(xmlFile)
	self.setPipelightsActive = SpecializationUtil.callSpecializationsFunction("setPipelightsActive");
	self.pipelight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipelights#index"));
	self.pipelightVis = false;
end;

function pipelights:readStream(streamId, connection)
	self:setPipelightsActive(streamReadBool(streamId), true);
end;

function pipelights:writeStream(streamId, connection)
	streamWriteBool(streamId, self.pipelightVis);
end;

function pipelights:delete()
end;

function pipelights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pipelights:keyEvent(unicode, sym, modifier, isDown)
end;

function pipelights:update(dt)
	if self.isEntered then
		if self.pipelight ~= nil then
			if InputBinding.hasEvent(InputBinding.pipelight) then
				self:setPipelightsActive(not self.pipelightVis);
			end;
		end;
	end;
end;

function pipelights:draw()
end;

function pipelights:setPipelightsActive(isActive, noEventSend)
	self.pipelightVis = isActive;
	if self.pipelight ~= nil then
		setVisibility(self.pipelight, self.pipelightVis);
		
		if noEventSend ~= true then
			PipelightsEvent.sendEvent(self, isActive);
		end;
	end;
end;