--
-- fc_trailer
-- Specialization for fc_trailer mod
--
-- @author  Defender
-- @date  20/08/2011
--


fc_trailer = {};

function fc_trailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function fc_trailer:load(xmlFile)
  print("fruitConverting Mod Trailer Loading...")
  self.setFillLevel = Utils.appendedFunction(self.setFillLevel, fc_trailer.setFillLevel);
end;

function fc_trailer:delete()
end;

function fc_trailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fc_trailer:keyEvent(unicode, sym, modifier, isDown)
end;

function fc_trailer:update(dt)
end;

function fc_trailer:draw()
end;

function fc_trailer:setFillLevel(fillLevel, fillType, force)
  if self.isClient then
    if (self.currentFillPlane ~= nil) and (self.currentFillPlane.nodes[1]~=nil) and self.currentFillPlane.nodes[1].node ~= nil then
       local c = getNumOfChildren(self.currentFillPlane.nodes[1].node);
       local p =  math.floor(fillLevel/(self.capacity/c));
       for i=0, c-1 do
         setVisibility(getChildAt(self.currentFillPlane.nodes[1].node, i), (i<=p));
       end;
    end;
  end;
end;