--
-- Farmville
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Farmville = {}

local Farmville_mt = Class(Farmville, Mission00);

function Farmville:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Farmville_mt;
    end;
    local self = Farmville:superClass():new(baseDirectory, mt);
    return self;
end;

function Farmville:delete()
    Farmville:superClass().delete(self);
end;

function Farmville:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    Farmville:superClass().load(self);
end
function Farmville:loadFinished()
    Farmville:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Farmville:mouseEvent(posX, posY, isDown, isUp, button)
    Farmville:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Farmville:keyEvent(unicode, sym, modifier, isDown)
    Farmville:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Farmville:update(dt)
    Farmville:superClass().update(self, dt);
end;

function Farmville:draw()
    Farmville:superClass().draw(self);
end;
