--
-- hops_trailer
-- Specialization for hops_trailer mod
--
-- @author  Defender
-- @date  20/08/2011
--


hops_trailer = {};

function hops_trailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function hops_trailer:load(xmlFile)
  print("LiveStock Trailer Loading...")
  self.setFillLevel = Utils.appendedFunction(self.setFillLevel, hops_trailer.setFillLevel);
end;

function hops_trailer:delete()
end;

function hops_trailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hops_trailer:keyEvent(unicode, sym, modifier, isDown)
end;

function hops_trailer:update(dt)
end;

function hops_trailer:draw()
end;

function hops_trailer:setFillLevel(fillLevel, fillType, force)
  if self.isClient then
    if (self.currentFillPlane ~= nil) and (self.currentFillPlane.nodes[1]~=nil) and self.currentFillPlane.nodes[1].node ~= nil then
       local c = getNumOfChildren(self.currentFillPlane.nodes[1].node);
       local p =  math.floor(fillLevel/(self.capacity/c));
       for i=0, c-1 do
         setVisibility(getChildAt(self.currentFillPlane.nodes[1].node, i), (i<=p));
       end;
    end;
  end;
end;