-- fruitsConvertingMod
-- version 1.0
--
-- by Defender
--
-- DO NOT MODIFY THIS FILE WITHOUT PERMISSION!!!
-- mail: defender@kingsofmetal.cz

local baseDirectory = g_currentModDirectory;

local SteerableDrawBackup = Steerable.draw;
local SteerableDrawGrainLevel = Steerable.drawGrainLevel;

function Steerable:draw()
  local canDraw = (g_currentMission.fruitsConvertingPresenter==nil) or (not g_currentMission.fruitsConvertingPresenter.show);
  if canDraw then
    SteerableDrawBackup(self);
  end;   
end;

function Steerable:drawGrainLevel(level, capacity, warnPercent)
  local canDraw = (g_currentMission.fruitsConvertingPresenter==nil) or (not g_currentMission.fruitsConvertingPresenter.show);
  if canDraw then
    SteerableDrawGrainLevel(self, level, capacity, warnPercent);
  end;
end;

fruitsConvertingPresenter = {};

function fruitsConvertingPresenter:loadMap(name)
  print("fruitsConvertingPresenter loaded");
  self.baseDirectory = baseDirectory;
  if g_currentMission.fruitsConvertingPresenter == nil then
     g_currentMission.fruitsConvertingPresenter = {};
  end;
  self.panelPath = Utils.getFilename("mods/fruitsConvertingMod/panel.png", self.baseDirectory);
  self.panelHud = Overlay:new("panelHud",self.panelPath, 0, 0, 1, 1);--0.3, 0.2, 0.4, 0.6);
  self.ledPath = Utils.getFilename("mods/fruitsConvertingMod/dioda.png", self.baseDirectory);
  self.ledHud = Overlay:new("ledHud",self.ledPath, 0.763, 0.634, 0.011, 0.018);
  local sBOP=Utils.getFilename("mods/fruitsConvertingMod/button.png", self.baseDirectory);
  self.switchButtonOverlay = createImageOverlay(sBOP);
  local sBSOP=Utils.getFilename("mods/fruitsConvertingMod/glow.png", self.baseDirectory);
  self.switchButtonSelectedOverlay = createImageOverlay(sBSOP);
  local sBGO=Utils.getFilename("mods/fruitsConvertingMod/glow.png", self.baseDirectory);
  self.switchButtonGlowOverlay = createImageOverlay(sBGO);
  self.show = false;
  self.index = 0;
  self.panelsCount = 0;
  self.runOnce = true;
  self.changeIP = false;
  g_currentMission.fruitsConvertingPresenter = self;
  self.switchButtonsPos = {{x=0.220, y=0.250},{x=0.220, y=0.310},{x=0.220, y=0.370},{x=0.220, y=0.430},{x=0.220, y=0.490},{x=0.220, y=0.550},{x=0.220, y=0.610},{x=0.220, y=0.670},{x=0.220, y=0.730},{x=0.220, y=0.790},{x=0.220, y=0.850}};
  self.switchButtonsCount = 0;
  self.switchButtonTofruitsConvertingTrigger = {};
  self.switchButtonWidth = 0.0395;
  self.switchButtonHeight = 0.054;
end;

function fruitsConvertingPresenter:deleteMap()
end;

function fruitsConvertingPresenter:mouseEvent(posX, posY, isDown, isUp, button)
  if self.show then
    self.activeSwitchButton=0;
    for i=1, self.switchButtonsCount do
      if (posX>=self.switchButtonsPos[i].x) and (posX<=self.switchButtonsPos[i].x+self.switchButtonWidth) and
         (posY<=1-self.switchButtonsPos[i].y+self.switchButtonHeight) and (posY>=1-self.switchButtonsPos[i].y) then
         self.activeSwitchButton = i;
         if isDown and button==Input.MOUSE_BUTTON_LEFT then
           self.index=self.switchButtonTofruitsConvertingTrigger[i];
         end;
      end;
    end;
  end;
end;

function fruitsConvertingPresenter:keyEvent(unicode, sym, modifier, isDown)
  if self.switchButtonsCount>0 then
    if (InputBinding.isPressed(InputBinding.SHOW_FC_PANEL)) then
      --self.changeIP = true;
      self.show = not self.show;
      if self.show then
        g_mouseControlsHelp.active = false;
        InputBinding.setShowMouseCursor(true);
        InputBinding.wrapMousePositionEnabled = false;
        if (g_currentMission.player.isEntered) then
          g_currentMission.player.isFrozen = true;
        end;
      else
        g_mouseControlsHelp.active = true;
        InputBinding.setShowMouseCursor(false);
        if (g_currentMission.player.isEntered) then
          g_currentMission.player.isFrozen = false;
        end;
      end;
    end;
  end;
end;

function fruitsConvertingPresenter:update(dt)
  if self.runOnce then
    self.runOnce = false;
    if g_currentMission.fruitsConvertingTriggers~=nil then
      self.panelsCount = table.maxn(g_currentMission.fruitsConvertingTriggers);
      for i=1, self.panelsCount do
        if (g_currentMission.fruitsConvertingTriggers[i]~=nil) and (g_currentMission.fruitsConvertingTriggers[i].infoPanelFile~=nil) then
          if self.index==0 then
            self.index=i;
          end;
          self.switchButtonsCount = self.switchButtonsCount + 1;
          self.switchButtonTofruitsConvertingTrigger[self.switchButtonsCount]=i;
        end;
      end;
    else
      self.panelsCount = 0;
    end;
  end;

 --[[if self.changeIP then
    self.changeIP = false;
    self.show = false;
    repeat
      self.index = self.index + 1;
    until ((self.index > self.panelsCount) or (g_currentMission.fruitsConvertingTriggers[self.index].infoPanelFile ~= nil));
    if self.index > self.panelsCount then
      self.index = 0;
    end;
    if self.index > 0 then
      self.show = true;
    else
      self.show = false;
    end;
  end;]]
end;

function fruitsConvertingPresenter:draw()
  if g_currentMission.fruitsConvertingTriggers~=nil then
    if self.show and (self.index > 0) then
      g_mouseControlsHelp.active = false;
      InputBinding.setShowMouseCursor(true);
      InputBinding.wrapMousePositionEnabled = false;

      if g_currentMission.fruitsConvertingTriggers[self.index]~=nil and g_currentMission.fruitsConvertingTriggers[self.index].draw~=nil then
        self.panelHud:render();
        setTextAlignment(RenderText.ALIGN_CENTER);
        for i=1, self.switchButtonsCount do
          if self.activeSwitchButton==i then
            renderOverlay(self.switchButtonGlowOverlay, self.switchButtonsPos[i].x-0.002, (1-self.switchButtonsPos[i].y)-0.0019, self.switchButtonWidth+0.002, self.switchButtonHeight+0.005);
          end;
          if self.switchButtonTofruitsConvertingTrigger[i]==self.index then
            renderOverlay(self.switchButtonSelectedOverlay, self.switchButtonsPos[i].x, 1-self.switchButtonsPos[i].y, self.switchButtonWidth, self.switchButtonHeight);
            setTextColor(1,1,1,1);
          else
            renderOverlay(self.switchButtonOverlay, self.switchButtonsPos[i].x, 1-self.switchButtonsPos[i].y, self.switchButtonWidth, self.switchButtonHeight);
            setTextColor(1,1,1,1);
          end;
          renderText(self.switchButtonsPos[i].x+(self.switchButtonWidth/2.5), 1-self.switchButtonsPos[i].y+0.015, 0.025, tostring(i));
        end;
        setTextAlignment(RenderText.ALIGN_LEFT);
        setTextColor(1,1,1,1);
        if g_currentMission.fruitsConvertingTriggers[self.index].running then
          self.ledHud:render();
        end;
        g_currentMission.fruitsConvertingTriggers[self.index]:draw();
      end;
    end;
    for i=1, table.maxn(g_currentMission.fruitsConvertingTriggers) do
      if g_currentMission.fruitsConvertingTriggers[i]~=nil then
        local fct = g_currentMission.fruitsConvertingTriggers[i];
        for a=1, table.maxn(fct.tipTriggers) do
          if (fct.tipTriggers[a] ~= nil) and (fct.tipTriggers[a].draw~=nil) then
            fct.tipTriggers[a]:draw();
          end;
        end;
      end;
    end;
  end;
end;

addModEventListener(fruitsConvertingPresenter);


function FCTriggerInRange(self)
  local nearestObject = false;
  local itemNode;
  local nearestDistance = 10;
  local objectCopy = self.tipReferencePoint;
  if objectCopy ~= nil then	
    local px, py, pz = getWorldTranslation(objectCopy);
    for k,v in pairs(g_currentMission.fruitsConvertingTriggers) do
      local fCT = g_currentMission.fruitsConvertingTriggers[k];
      for a, b in pairs(fCT.tipTriggers) do
        itemNode = fCT.tipTriggers[a].triggerId;
        local vx, vy, vz = getWorldTranslation(itemNode);
        local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
        if distance < nearestDistance then
          nearestObject = true;
          nearestDistance = distance;
        end;
      end;
    end;
  end;
  return nearestObject;
end;

fcSynchronizeEvent = {};
fcSynchronizeEvent_mt = Class(fcSynchronizeEvent, Event);

InitEventClass(fcSynchronizeEvent, "fcSynchronizeEvent");

function fcSynchronizeEvent:emptyNew()
    local self = Event:new(fcSynchronizeEvent_mt);
    self.className="fcSynchronizeEvent";
    return self;
end;

function fcSynchronizeEvent:new(object)
    local self = fcSynchronizeEvent:emptyNew()
    self.object = object;
    return self;
end;

function fcSynchronizeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function fcSynchronizeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function fcSynchronizeEvent:run(connection)
    self.object:raiseDirtyFlags(self.object.myDirtyFlag);
    if not connection:getIsServer() then
        g_server:broadcastEvent(fcSynchronizeEvent:new(self.object), nil, connection, self.object);
    end;
end;

fcSetManualStepEvent = {};
fcSetManualStepEvent_mt = Class(fcSetManualStepEvent, Event);

InitEventClass(fcSetManualStepEvent, "fcSetManualStepEvent");

function fcSetManualStepEvent:emptyNew()
    local self = Event:new(fcSetManualStepEvent_mt);
    self.className="fcSetManualStepEvent";
    return self;
end;

function fcSetManualStepEvent:new(object, step)
    local self = fcSetManualStepEvent:emptyNew()
    self.object = object;
    self.step = step;
    return self;
end;

function fcSetManualStepEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.step = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function fcSetManualStepEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.step);
end;

function fcSetManualStepEvent:run(connection)
    self.object:setManualStep(self.step, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(fcSetManualStepEvent:new(self.object, self.step), nil, connection, self.object);
    end;
end;

fruitsConverting = {};

local fruitsConverting_mt = Class(fruitsConverting, Object);

function fruitsConverting:OnCreate(id)
  print("Pridavam objekt fruitsConverting");
  local trigger = fruitsConverting:new(g_server ~= nil, g_client ~= nil);
  local index = g_currentMission:addOnCreateLoadedObject(trigger);
  trigger:load(id);
  trigger:register(true);
  trigger.runOnce = true;
  if g_currentMission.fruitsConvertingTriggers == nil then
    g_currentMission.fruitsConvertingTriggers = {};
  end;
  --table.insert(g_currentMission.fruitsConvertingTriggers, trigger.ID, trigger);
  g_currentMission.fruitsConvertingTriggers[trigger.ID] = trigger;
end;

fruitsConvertingOnCreate = fruitsConverting.OnCreate;

function fruitsConverting:new(isServer, isClient)
    local self = Object:new(isServer, isClient, fruitsConverting_mt);
    self.className = "fruitsConverting";
    self.triggerId = 0;
    return self;
end;


function fruitsConverting:load(id)
  self.isActive = true;
  self.triggerId = id;
  self.fillLevel1 = 0;
  self.running = false;
  self.manualStep = 0;
  self.manualWait = 0;
  self.manualRecalculationTime = 0;
  self.ID = getUserAttribute(id, "fcID");
  self.stationName = Utils.getNoNil(getUserAttribute(id, "stationName"), "Station");
  self.recalculationTime = Utils.getNoNil(getUserAttribute(id, "recalculationTime"),1);
  self.lossesRatio = Utils.getNoNil(getUserAttribute(id, "lossesRatio"), 1);
  self.nearestDistance = Utils.getNoNil(getUserAttribute(id, "vzdalenost"), 5.0);
  self.baseDirectory = baseDirectory;
  self.mapDirectory = g_currentMission.missionInfo.map.baseDirectory;
  self.infoPanelFile = getUserAttribute(id, "infoPanelXML");
  self.targetFruitsCount=0;
  local targetFruits = getUserAttribute(id, "targetFruits");
  if targetFruits ~= nil then
    local types = Utils.splitString(" ", targetFruits);
    local key = "targetFruit";
    for k,v in pairs(types) do
      self[key..tostring(k)] = Fillable.fillTypeNameToInt[v];
      self["capacity"..tostring(k)] = 10000000;
      self["fillLevel"..tostring(k)] = 0;
      self["targetFruitRatio"..tostring(k)] = 1;
      self.targetFruitsCount=k;
    end;
  else
    self.isActive = false;
    print("ERROR: fruitsConvertingOnCreate - userAttribute targetFruits not set!");
  end;

  local targetFruitsRatio = getUserAttribute(id, "targetFruitsRatio");
  if targetFruitsRatio ~= nil then
    local ratios = Utils.splitString(" ", targetFruitsRatio);
    local key = "targetFruitRatio";
    for k,v in pairs(ratios) do      
      self[key..tostring(k)] = v;
    end;
  end;
  self.targetFruitRatio1 = 1; -- prvni plodina je vzdycky nekracena :)

  local capacity = getUserAttribute(id, "capacity");
  if capacity ~= nil then
    local capacitys = Utils.splitString(" ", capacity);
    for k,v in pairs(capacitys) do
      self["capacity"..tostring(k)] = tonumber(v);      
    end;
  end;

  self.manualStart = Utils.getNoNil(getUserAttribute(id, "manualStart"), false);
  if self.manualStart then
    self.manualRecalculationTime = self.recalculationTime;
    self.recalculationTime = 0;
  end;
  
  for i=1, self.targetFruitsCount do
    self["movingIndex"..tostring(i)] = getUserAttribute(id,"movingIndex"..tostring(i));
    if self["movingIndex"..tostring(i)] ~= nil then
      self["movePart"..tostring(i)] = getChildAt(id, tonumber(self["movingIndex"..tostring(i)]));
      self["moveMaxY"..tostring(i)] = Utils.getNoNil(getUserAttribute(id, "moveMaxY"..tostring(i)),0);
      self["moveMinY"..tostring(i)] = Utils.getNoNil(getUserAttribute(id, "moveMinY"..tostring(i)),0);
      self["moveScale"..tostring(i)] = Utils.getNoNil(getUserAttribute(id, "moveScale"..tostring(i)),0);
    end;
  end;    
    
  self.needUpdate = false;
  self.tipTriggers = {};
  self.myDirtyFlag = self:getNextDirtyFlag();
end;

function fruitsConverting:loadInfoPanel()
  self.infoPanel = {};
  if self.infoPanelFile~=nil then
    local infoPanelFile = Utils.getFilename(self.infoPanelFile, self.mapDirectory);
    self.infoXML = loadXMLFile("InfoPanelXML", infoPanelFile);
    self.infoPanel.backgroung = {};
    local path = getXMLString(self.infoXML, "infoPanel#background");
    if path~=nil then
      self.infoPanel.backgroung.path = Utils.getFilename(path, self.mapDirectory);
      self.infoPanel.backgroung.img = Overlay:new("background", self.infoPanel.backgroung.path, 0, 0, 1, 1);--0.3, 0.2, 0.4, 0.6);
    end;    
    self.infoPanel.caption = Utils.getNoNil(getXMLString(self.infoXML, "infoPanel.caption#text"), self.stationName);
    
    self.infoPanel.staticTexts = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.staticTexts.staticText(%d)", i);
      local text = getXMLString(self.infoXML, sttkey.."#text");
      if text == nil then
        break;
      end;
      local staticText = {};
      staticText.text = text;
      staticText.x, staticText.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      staticText.y = 1 - staticText.y;
      local align = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#align"),"left");
      if align == "left" then
        staticText.align = RenderText.ALIGN_LEFT;
      elseif align == "center" then
        staticText.align = RenderText.ALIGN_CENTER;
      elseif align == "right" then
        staticText.align = RenderText.ALIGN_RIGHT;
      end;
      if staticText.align == nil then 
        staticText.align = RenderText.ALIGN_LEFT;
      end;
      staticText.size = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#size"), 0.02);
      staticText.red, staticText.green, staticText.blue, staticText.alpha  = Utils.getVectorFromString(Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#color"),"1 1 1 1"));
      staticText.bold = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#bold"), false);
      staticText.shadow = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#shadow"), false);
      table.insert(self.infoPanel.staticTexts, staticText);
      i = i + 1;
    end;

    self.infoPanel.valueTexts = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.valueTexts.valueText(%d)", i);
      local value = getXMLString(self.infoXML, sttkey.."#value");
      if value == nil then
        break;
      end;
      local valueText = {};
      valueText.value = value;
      local object = getXMLInt(self.infoXML, sttkey.."#object");
      if object == nil then
        valueText.object = self;
      else
        valueText.object = self.tipTriggers[object];
      end;      
      valueText.x, valueText.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      valueText.y = 1 - valueText.y;
      local align = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#align"),"left");
      if align == "left" then
        valueText.align = RenderText.ALIGN_LEFT;
      elseif align == "center" then
        valueText.align = RenderText.ALIGN_CENTER;
      elseif align == "right" then
        valueText.align = RenderText.ALIGN_RIGHT;
      end;
      if valueText.align == nil then 
        valueText.align = RenderText.ALIGN_LEFT;
      end;
      valueText.size = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#size"), 0.02);
      valueText.red, valueText.green, valueText.blue, valueText.alpha  = Utils.getVectorFromString(Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#color"),"1 1 1 1"));
      valueText.bold = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#bold"), false);
      valueText.shadow = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#shadow"), false);
      valueText.format = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#format"), "%d");      
      table.insert(self.infoPanel.valueTexts, valueText);
      i = i + 1;
    end;

    self.infoPanel.percentTexts = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.percentTexts.percentText(%d)", i);
      local value = getXMLString(self.infoXML, sttkey.."#value");
      if value == nil then
        break;
      end;
      local percentText = {};
      percentText.value = value;
      local object = getXMLInt(self.infoXML, sttkey.."#object");
      if object == nil then
        percentText.object = self;
      else
        percentText.object = self.tipTriggers[object];
      end;      
      percentText.x, percentText.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      percentText.y = 1 - percentText.y;
      local align = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#align"),"left");
      if align == "left" then
        percentText.align = RenderText.ALIGN_LEFT;
      elseif align == "center" then
        percentText.align = RenderText.ALIGN_CENTER;
      elseif align == "right" then
        percentText.align = RenderText.ALIGN_RIGHT;
      end;
      if percentText.align == nil then 
        percentText.align = RenderText.ALIGN_LEFT;
      end;
      percentText.size = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#size"), 0.02);
      percentText.red, percentText.green, percentText.blue, percentText.alpha  = Utils.getVectorFromString(Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#color"),"1 1 1 1"));
      percentText.bold = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#bold"), false);
      percentText.shadow = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#shadow"), false);
      percentText.format = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#format"), "%d");
      percentText.min = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#min"),0); 
      percentText.max = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#max"),1000000);      
      table.insert(self.infoPanel.percentTexts, percentText);
      i = i + 1;
    end;
    
    self.infoPanel.images = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.images.image(%d)", i);
      local src = getXMLString(self.infoXML, sttkey.."#src");
      if src == nil then
        break;
      end;
      local image = {};
      image.src = Utils.getFilename(src, self.mapDirectory);      
      image.x, image.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      image.y = 1 - image.y;
      image.width = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#width"), 0.02);
      image.height = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#height"), 0.02);
      image.showOnlyWithHelp = Utils.getNoNil(getXMLBool(self.infoXML, sttkey.."#showOnlyWithHelp"), false);
      image.id = createImageOverlay(image.src);
      table.insert(self.infoPanel.images, image);
      i = i + 1;
    end;
    
    self.infoPanel.fruitImages = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.fruitImages.fruitImage(%d)", i);
      local src = getXMLString(self.infoXML, sttkey.."#fruitName");
      if src == nil then
        break;
      end;
      local pth = "";
      local image = {};
      if src == "milk" or src=="liquidManure" or src=="manure" or src=="fertilizer" then
        src="huds/"..src..".png";
        pth=self.baseDirectory;
      else
        local fi = FruitUtil["FRUITTYPE_"..string.upper(src)];
        src=FruitUtil.fruitIndexToDesc[fi].hudFruitOverlayFilename;
      end;
      image.src = Utils.getFilename(src, pth);
      image.x, image.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      image.y = 1 - image.y;
      image.width = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#width"), 0.02);
      image.height = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#height"), 0.02);
      image.id = createImageOverlay(image.src);
      table.insert(self.infoPanel.fruitImages, image);
      i = i + 1;
    end;    

    self.infoPanel.progressBars = {};
    local i = 0;
    while true do      
      local sttkey = string.format("infoPanel.form.progressBars.progressBar(%d)", i);
      local value = getXMLString(self.infoXML, sttkey.."#value");
      if value == nil then
        break;
      end;
      local progressBar = {};
      progressBar.value = value;
      local object = getXMLInt(self.infoXML, sttkey.."#object");
      if object == nil then
        progressBar.object = self;
      else
        progressBar.object = self.tipTriggers[object];
      end;      
      local src = getXMLString(self.infoXML, sttkey.."#img");
      progressBar.imgsrc = Utils.getFilename(src, self.mapDirectory);      
      progressBar.x, progressBar.y = Utils.getVectorFromString(getXMLString(self.infoXML, sttkey.."#position"));
      progressBar.y = 1 - progressBar.y;
      progressBar.maxWidth = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#width"), 0.02);
      progressBar.maxHeight = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#height"), 0.02);
      progressBar.min = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#min"),0); 
      progressBar.max = Utils.getNoNil(getXMLFloat(self.infoXML, sttkey.."#max"),1000000);
      local type = Utils.getNoNil(getXMLString(self.infoXML, sttkey.."#type"),"horizontal");
      progressBar.horizontal = (type=="horizontal");
      progressBar.id = createImageOverlay(progressBar.imgsrc);
      table.insert(self.infoPanel.progressBars, progressBar);
      i = i + 1;
    end;

  end;       
end;

function fruitsConverting:delete()
  self.isActive = false;
end;

function fruitsConverting:readStream(streamId, connection)
--  print("fruitsConverting:readStream");
  fruitsConverting:superClass().readStream(self, streamId);
  if connection:getIsServer() then
    self.isActive = streamReadBool(streamId);
    self.running = streamReadBool(streamId);
    local prevStep = self.manualStep;
    self.manualStep = streamReadInt8(streamId);
    if self.manualStart and prevStep ~= self.manualStep then
      self:setManualStep(self.manualStep);
    end;
    self.manualWait = streamReadFloat32(streamId);
    for i=1, self.targetFruitsCount do
      self["fillLevel"..tostring(i)] = streamReadFloat32(streamId);
      self:updateMoving(0, i);
    end;
  end;
end;

function fruitsConverting:writeStream(streamId, connection)
--  print("fruitsConverting:writeStream");
  fruitsConverting:superClass().writeStream(self, streamId);
  if not connection:getIsServer() then
    streamWriteBool(streamId, self.isActive);
    streamWriteBool(streamId, self.running);
    streamWriteInt8(streamId, self.manualStep);
    streamWriteFloat32(streamId, self.manualWait);
    for i=1, self.targetFruitsCount do
      streamWriteFloat32(streamId, self["fillLevel"..tostring(i)]);
    end;
  end;
end;

function fruitsConverting:readUpdateStream(streamId, timestamp, connection)
    self:readStream(streamId, connection);
end;

function fruitsConverting:writeUpdateStream(streamId, connection, dirtyMask)
    self:writeStream(streamId, connection);
end;



function fruitsConverting:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fruitsConverting:keyEvent(unicode, sym, modifier, isDown)
end;

function fruitsConverting:setManualStep(step, noEventSend)
  --print("setManualStep("..tostring(step)..")");
  local prevStep = self.manualStep;
  if step == 0 then
    self.manualStep = 0;
    if self.isClient then
      for i = 1, table.maxn(self.tipTriggers) do
        if self.tipTriggers[i] ~= nil then
          local plane0 = self.tipTriggers[i].movePartStep0;
          local plane1 = self.tipTriggers[i].movePartStep1;
          if plane0 ~= nil then
            setVisibility(plane0, true);
          end;
          if plane1 ~= nil then
            setVisibility(plane1, false);
          end;
        end;
      end;
    end;
  elseif step == 1 then
    self.manualStep = 1;
    self.manualWait=self.manualRecalculationTime;
    if self.isClient then
      for i = 1, table.maxn(self.tipTriggers) do
        if self.tipTriggers[i] ~= nil then
          local plane0 = self.tipTriggers[i].movePartStep0;
          local plane1 = self.tipTriggers[i].movePartStep1;
          if plane0 ~= nil then
            setVisibility(plane0, false);
          end;
          if plane1 ~= nil then
            setVisibility(plane1, true);
          end;
        end;
      end;
    end;
  elseif step == 2 then
    self.manualStep = 2;
    self.manualWait=0;
    if self.isClient then
      for i = 1, table.maxn(self.tipTriggers) do
        if self.tipTriggers[i] ~= nil then
          local plane0 = self.tipTriggers[i].movePartStep0;
          local plane1 = self.tipTriggers[i].movePartStep1;
          if plane0 ~= nil then
            setVisibility(plane0, false);
          end;
          if plane1 ~= nil then
            setVisibility(plane1, false);
          end;
        end;
      end;
    end;
  end;
  if self.manualStep ~= prevStep then
    if noEventSend == nil or noEventSend == false then
      if g_server ~= nil then
        g_server:broadcastEvent(fcSetManualStepEvent:new(self, step), nil, nil, self);
      else
       g_client:getServerConnection():sendEvent(fcSetManualStepEvent:new(self, step));
      end;
    end;
  end;
end;


function fruitsConverting:update(dt)
  if self.runOnce then
    self.runOnce = false;
    if (g_server ~= nil) then
      -- nactu save
      self:loadSave();
    else
      -- pozadam server o synchronizaci
      g_client:getServerConnection():sendEvent(fcSynchronizeEvent:new(self));
    end;
    self:loadInfoPanel();
    
    self.groupsCount = {};
    for i = 1, table.maxn(self.tipTriggers) do
      if self.tipTriggers[i] ~= nil then
         if self.tipTriggers[i].groupId>=0 then
           if self.groupsCount[self.tipTriggers[i].groupId]~=nil then             
             self.groupsCount[self.tipTriggers[i].groupId].count=self.groupsCount[self.tipTriggers[i].groupId].count+1;
             table.insert(self.groupsCount[self.tipTriggers[i].groupId].list,i);
           else
             self.groupsCount[self.tipTriggers[i].groupId]={};
             self.groupsCount[self.tipTriggers[i].groupId].count=1;
             self.groupsCount[self.tipTriggers[i].groupId].list={};
             table.insert(self.groupsCount[self.tipTriggers[i].groupId].list,i);
           end;
         end;
      end;
    end;
  end;
  if self.isClient and self.manualStart and (self.manualStep==0 or self.manualStep==1) then
    local nearestDistance = self.nearestDistance;
    local podminka = true;
    if (g_currentMission.player ~= nil) and (g_currentMission.player.isEntered) then
      local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
      local px, py, pz = getWorldTranslation(self.triggerId);
      local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
      podminka = (distance < nearestDistance);
      if podminka and self.manualStep==0 then
        local minp = 10000000;
        for i = 1, table.maxn(self.tipTriggers) do
          if self.tipTriggers[i] ~= nil then
            local lminp = minp;
            minp = math.min(minp,(self.tipTriggers[i].fillLevel));
            if minp == 0 and lminp>0 and self.tipTriggers[i].groupId>=0 then
              local groupId = self.tipTriggers[i].groupId;
              for a = 1, table.maxn(self.tipTriggers) do
                if (self.tipTriggers[a] ~= nil) and (i~=a) and (self.tipTriggers[a].groupId==groupId) then
                  local tmp = (self.tipTriggers[a].fillLevel);
                  if tmp>0 then
                    minp = lminp;
                  end;
                end;
              end;
            end;
          end;
        end;
       
        if minp>0 then
          g_currentMission:addExtraPrintText("Klavesa B : spustit proces");
          if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
            self:setManualStep(1);
          end;
        end;
      end;
      if podminka and self.manualStep==1 then
        local cas = string.format("%d:%02d", math.floor(self.manualWait/60000), math.floor((self.manualWait % 60000)/1000));
        g_currentMission:addWarning("\nProbíhá proces, hotovo bude za "..cas, 0.092, 0.048);
      end;
    end;
  end;
  if self.isActive and self.isServer and (self.manualStart and self.manualStep==1) then
    local lastWait = math.floor((self.manualWait % 60000)/1000);
    self.manualWait = self.manualWait - dt;
    if self.manualWait<=0 then
      self:setManualStep(2);
    else
      if math.floor((self.manualWait % 60000)/1000)~=lastWait then
        --doplneno posilani casu do zmeny - pouze kazdou vterinu, at to nevytezuje sit       
        self:raiseDirtyFlags(self.myDirtyFlag);
      end;
    end;
  end;
  if self.isActive and self.isServer and ((self.manualStart and self.manualStep==2) or not self.manualStart) then
    -- prepocet na novou plodinu
    local minp = dt * (0.5/self.recalculationTime);
    if self.manualStart then
      minp = 10000000;
    end;
    for i = 1, table.maxn(self.tipTriggers) do
      if self.tipTriggers[i] ~= nil then
        local lminp = minp;
        minp = math.min(minp,(self.tipTriggers[i].fillLevel/self.tipTriggers[i].ratio));
        if minp == 0 and lminp>0 and self.tipTriggers[i].groupId>=0 then
          local groupId = self.tipTriggers[i].groupId;
          for a = 1, table.maxn(self.tipTriggers) do
            if (self.tipTriggers[a] ~= nil) and (i~=a) and (self.tipTriggers[a].groupId==groupId) then
              local tmp = (self.tipTriggers[a].fillLevel/self.tipTriggers[a].ratio);
              if tmp>0 then
                minp = lminp;
              end;
            end;
          end;
        end;
      end;
    end;
    local capacityCheck = true;
    for i = 1, self.targetFruitsCount do
      local level = self["fillLevel"..tostring(i)];
      local capacity = self["capacity"..tostring(i)];
      
      if (level==nil) or (capacity == nil) or (level >= capacity) then
        capacityCheck = false;
        break;
      end;
    end;
    if (minp > 0) and capacityCheck then
      self.running = true;
      for i = 1, table.maxn(self.tipTriggers) do
        if self.tipTriggers[i] ~= nil then
          self:setFillLevel(((minp * self.tipTriggers[i].ratio)*(self.lossesRatio)));
          local multiply = 1;
          if self.tipTriggers[i].groupId>=0 then
            local c = 0;
            if self.tipTriggers[i].fillLevel>0 then
              c = 1;
            end;
            for b = 1, self.groupsCount[self.tipTriggers[i].groupId].count do
              local d = self.groupsCount[self.tipTriggers[i].groupId].list[b];
              if (self.tipTriggers[d]~=nil) and (i~=d) and (self.tipTriggers[d].fillLevel>0) then
                c = c + 1;
              end;
            end;
            if c>0 then
              multiply=1/c;
            else
              multiply=0;
            end;
          end;
          local delta = (minp * self.tipTriggers[i].ratio * multiply);
          self.tipTriggers[i]:setFillLevel(self.tipTriggers[i].fillLevel - delta);
          self.tipTriggers[i]:updateMoving(-delta);
        end;
      end;
    else
      if self.running then
        -- poslu info o tom, ze prepocet uz nebezi
        self.running = false;
        self:raiseDirtyFlags(self.myDirtyFlag);
      end;
      self.running = false;
    end;
    -- konec prepoctu
  end;
  if (self.isServer and self.manualStart and self.manualStep==2) then
    local b = true;
    for i=1, self.targetFruitsCount do
      b=b and (self["fillLevel"..tostring(i)]<=0);
      if not b then
        break;
      end;
    end;
    if b then
      self:setManualStep(0);
    end;
  end;
end;

function fruitsConverting:draw()
  if (self.infoPanel~=nil) then
    setTextAlignment(RenderText.ALIGN_CENTER);
    setTextColor(0,0,0,0.85);
    setTextBold(true);
    renderText(0.5, 0.84, 0.0275, self.infoPanel.caption);

    if self.infoPanel.backgroung ~= nil and self.infoPanel.backgroung.img ~= nil then
      self.infoPanel.backgroung.img:render();
    end;

    for ii=1, table.maxn(Utils.getNoNil(self.infoPanel.images, {})) do
      local img = self.infoPanel.images[ii];
      if (img ~= nil) and (img.id ~= nil) and (not img.showOnlyWithHelp or g_currentMission.showHelpText) then
        renderOverlay(img.id, img.x, img.y, img.width, img.height);
      end;      
    end;

    for ii=1, table.maxn(Utils.getNoNil(self.infoPanel.fruitImages, {})) do
      local img = self.infoPanel.fruitImages[ii];
      if (img ~= nil) and (img.id ~= nil) then
        renderOverlay(img.id, img.x, img.y, img.width, img.height);
      end;      
    end;

    for pbi=1, table.maxn(Utils.getNoNil(self.infoPanel.progressBars, {})) do
      local pb = self.infoPanel.progressBars[pbi];
      if (pb ~= nil) and (pb.id ~= nil) then
        local value = pb.object[pb.value];
        if value ~= nil then
          if value< pb.min then
            value = 0;
          elseif value>pb.max then
            value = 1;
          else
            value = ((value-pb.min)/pb.max);
          end;
          if pb.horizontal then
            renderOverlay(pb.id, pb.x, pb.y, pb.maxWidth*value, pb.maxHeight);
          else
            renderOverlay(pb.id, pb.x, pb.y, pb.maxWidth, pb.maxHeight*value);
          end;          
        else 
          print("chyba");
        end;        
      end;      
    end;
    
    local shadowX = 0.0001;
    local shadowY = -0.002;

    for sti=1, table.maxn(Utils.getNoNil(self.infoPanel.staticTexts, {})) do
      local stt = self.infoPanel.staticTexts[sti];
      if stt ~= nil then
        setTextAlignment(stt.align);
        setTextBold(stt.bold);
        if stt.shadow then
          setTextColor(0,0,1,0.8);
          renderText(stt.x+shadowX, stt.y+shadowY, stt.size, stt.text);
        end;
        setTextColor(stt.red, stt.green, stt.blue, stt.alpha);
        renderText(stt.x, stt.y, stt.size, stt.text);
      end;      
    end;
    
    for vti=1, table.maxn(Utils.getNoNil(self.infoPanel.valueTexts, {})) do
      local vtt = self.infoPanel.valueTexts[vti];
      if vtt ~= nil then
        setTextBold(vtt.bold);
        setTextAlignment(vtt.align);
        local value = vtt.object[vtt.value];
        if value ~= nil then
          if vtt.shadow then
            setTextColor(0,0,1,0.8);
            renderText(vtt.x+shadowX, vtt.y+shadowY, vtt.size, string.format(vtt.format, value));
          end;
          setTextColor(vtt.red, vtt.green, vtt.blue, vtt.alpha);
          renderText(vtt.x, vtt.y, vtt.size, string.format(vtt.format, value));
        else 
          print("chyba");
        end;
      end;      
    end;    
    
    for pti=1, table.maxn(Utils.getNoNil(self.infoPanel.percentTexts, {})) do
      local ptt = self.infoPanel.percentTexts[pti];
      if ptt ~= nil then
        setTextBold(ptt.bold);
        setTextAlignment(ptt.align);
        local value = ptt.object[ptt.value];
        if value ~= nil then
          if value< ptt.min then
            value = 0;
          elseif value>ptt.max then
            value = 100;
          else
            value = ((value-ptt.min)/ptt.max)*100;
          end;
          if ptt.shadow then
            setTextColor(0,0,1,0.8);
            renderText(ptt.x+shadowX, ptt.y+shadowY, ptt.size, string.format(ptt.format, value));
          end;
          setTextColor(ptt.red, ptt.green, ptt.blue, ptt.alpha);
          renderText(ptt.x, ptt.y, ptt.size, string.format(ptt.format, value));          
        else 
          print("chyba");
        end;
      end;      
    end;
    
    -- uklidim po sobe :)
    setTextColor(1, 1, 1, 1);
    setTextBold(false);
    setTextAlignment(RenderText.ALIGN_LEFT);    
  end;
end;

function fruitsConverting:loadSave()
  local siloSaveDir = g_currentMission.missionInfo.savegameDirectory;
  local siloSaveXML = siloSaveDir .. "/fruitsConvertingSave.xml";
  if g_currentMission.missionStats.playTime == 0 then
    print("vytvarim "..siloSaveXML);
    local existDir0 = io.open (siloSaveXML, "r");
    if existDir0 ~= nil then
      local siloFile = io.open (siloSaveXML, "w");
      if siloFile ~= nil then
        siloFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
        siloFile:write('<fruitsConvertingSave>\n');
        siloFile:write("</fruitsConvertingSave>");
        siloFile:close();
      end;
    end;
  else
    print("nacitam "..siloSaveXML.." pro ID="..tostring(self.ID));
    local existDir = io.open (siloSaveXML, "r");
    if existDir ~= nil then
      self.xmlFile = loadXMLFile("TAConfig", siloSaveXML);
      local keyI = 0;
      while true do
        local key = string.format("fruitsConvertingSave.fruitsConvertingObject(%d)", keyI);
        local mID = getXMLInt(self.xmlFile, key.."#ID");
        if mID == nil then
          break;
        end;
        if self.ID == mID then
           if self.manualStart then
             local step = Utils.getNoNil(getXMLInt(self.xmlFile, key.."#step"),0);
             self:setManualStep(step);
             local wait = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#wait"),0);
             self.manualWait = wait;
           end;
           for i=1, self.targetFruitsCount do
             local value = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#fillLevel"..tostring(i)),0.0);
             self["fillLevel"..tostring(i)]=value;
           end;
           local keyA = 0;
           while true do
             local keyT = string.format("fruitsConvertingSave.fruitsConvertingObject(%d).fcTipTrigger(%d)", keyI, keyA);
             local tID = getXMLInt(self.xmlFile, keyT.."#ID");
             if tID == nil then
                break;
             end;
             for i=1, table.maxn(self.tipTriggers) do
               if (self.tipTriggers[i].ID ~= nil) and (self.tipTriggers[i].ID == tID) then
                 local fill = Utils.getNoNil(getXMLFloat(self.xmlFile, keyT.."#fillLevel"),0.0);
                 self.tipTriggers[i].fillLevel = fill;
                 break;
               end;
             end;
             keyA = keyA + 1;
           end;
           break;
        end;
        keyI = keyI + 1;
      end;
    end;
  end;
  for i=1, table.maxn(self.tipTriggers) do
    self.tipTriggers[i]:updateMoving(self.tipTriggers[i].fillLevel);
  end;
  for i=1, self.targetFruitsCount do
      self:updateMoving(0, i);
  end;
end;

function fruitsConverting:updateMoving(delta, index)
  if self.isClient and self["movingIndex"..tostring(index)] ~= nil then
    local x, y, z = getTranslation(self["movePart"..tostring(index)]);
    y = self["moveMinY"..tostring(index)] + (((self["moveMaxY"..tostring(index)] - self["moveMinY"..tostring(index)])/self["capacity"..tostring(index)])*self["fillLevel"..tostring(index)]);
    setTranslation(self["movePart"..tostring(index)], x, y, z);
  end;
end;


function fruitsConverting:setFillLevel(fillLevel, index)
  local recountAll = false;
  if index == nil then
    index = 1;
    recountAll = true;
  end; 
  local prevfillLevel = self["fillLevel"..tostring(index)];
  self["fillLevel"..tostring(index)] = self["fillLevel"..tostring(index)] + fillLevel;

  if self["fillLevel"..tostring(index)] > self["capacity"..tostring(index)] then
    self["fillLevel"..tostring(index)] = self["capacity"..tostring(index)];
  end;
  if self["fillLevel"..tostring(index)] < 0 then
    self["fillLevel"..tostring(index)] = 0;
  end;
  self:updateMoving(fillLevel, index);
  if recountAll then
    for i=2, self.targetFruitsCount do
      if self["fillLevel"..tostring(i)]==nil then
        self["fillLevel"..tostring(i)]=0;
      end;
      local delta = (fillLevel * self["targetFruitRatio"..tostring(i)]);
      self["fillLevel"..tostring(i)] = self["fillLevel"..tostring(i)] + delta;
      self:updateMoving(delta, i); 
    end;
  end;
  if prevfillLevel ~= self["fillLevel"..tostring(index)] then
    self:raiseDirtyFlags(self.myDirtyFlag);
  end;
end;


fcTipSynchronizeEvent = {};
fcTipSynchronizeEvent_mt = Class(fcTipSynchronizeEvent, Event);

InitEventClass(fcTipSynchronizeEvent, "fcTipSynchronizeEvent");

function fcTipSynchronizeEvent:emptyNew()
    local self = Event:new(fcTipSynchronizeEvent_mt);
    self.className="fcTipSynchronizeEvent";
    return self;
end;

function fcTipSynchronizeEvent:new(object)
    local self = fcTipSynchronizeEvent:emptyNew()
    self.object = object;
    return self;
end;

function fcTipSynchronizeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function fcTipSynchronizeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function fcTipSynchronizeEvent:run(connection)
    self.object:raiseDirtyFlags(self.object.myDirtyFlag);
    if not connection:getIsServer() then
        g_server:broadcastEvent(fcTipSynchronizeEvent:new(self.object), nil, connection, self.object);
    end;
end;


fcTipTrigger = {};

local fcTipTrigger_mt = Class(fcTipTrigger, Object);


function fcTipTrigger:OnCreate(id)
  print("Pridavam fcTipTrigger");
  local trigger = fcTipTrigger:new(g_server ~= nil, g_client ~= nil);
  local index = g_currentMission:addOnCreateLoadedObject(trigger);
  trigger:load(id);
  trigger:register(true);
  trigger.runOnce = (g_server == nil);
end;

fcTipTriggerOnCreate = fcTipTrigger.OnCreate;

function fcTipTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, fcTipTrigger_mt);
    self.className = "fcTipTrigger";
    self.triggerId = 0;
    return self;
end;


function fcTipTrigger:load(id)
  self.baseDirectory = baseDirectory;
  self.drawIcon = false;
  self.isActive = true;
  self.triggerId = id;
  self.acceptedFruitTypes = {};
  self.ID = getUserAttribute(id, "fcID");
  self.parentID = getUserAttribute(getParent(id), "fcID");
  local fruitType = getUserAttribute(id, "fruitTypes");
  if fruitType == "bale" then
    self.currentFillType = "bale";
    setCollisionMask(id, 4096); -- kolize pro dynamicke objekty
  else
    local types = Utils.splitString(" ", fruitType);

    for k,v in pairs(types) do
      local desc = Fillable.fillTypeNameToInt[v];
      if desc ~= nil then
        self.acceptedFruitTypes[desc] = true;
      end;
    end;

    --self.currentFillType = Fillable.fillTypeNameToInt[fruitType];
    setCollisionMask(id, 8388608); -- kolize pro fillable
  end;
  self.ratio = Utils.getNoNil(getUserAttribute(id, "targetRatio"),1);
--  self.isNeeded = Utils.getNoNil(getUserAttribute(id, "isNeeded"),true);
  self.groupId = Utils.getNoNil(getUserAttribute(id, "groupId"),-1);
  if fruitType ~= "bale" then
    self.isFarmTrigger = false;
    self.isTipAnywhereTrigger = true;
    self.isDefendersTrigger = true;
  end;
  
  
  local iconPath = Utils.getFilename("mods/fruitsConvertingMod/uncharge.png", self.baseDirectory);
  self.tipIcon =Overlay:new("unchargeIcon", iconPath, g_currentMission.hudTipperOverlay.x, g_currentMission.hudTipperOverlay.y , g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);
  self.fillLevel = 0;
  self.capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 10000000);
  self.lumpMaterial = Utils.getNoNil(getUserAttribute(id, "lumpMaterial"), false);
  self.maxDistance = Utils.getNoNil(getUserAttribute(id, "maxDistance"), 10000);
  
  self.movingIndex = getUserAttribute(id,"movingIndex");
  if self.movingIndex ~= nil then
    self.movePart = getChildAt(getParent(id), tonumber(self.movingIndex));    
    if self.capacity == 10000000 then
      self.moveBackTime = Utils.getNoNil(getUserAttribute(id, "moveBackTime"),0);
    else
      self.moveBackTime = 0;
    end;
    self.moveMaxY = Utils.getNoNil(getUserAttribute(id, "moveMaxY"),0);
    self.moveMinY = Utils.getNoNil(getUserAttribute(id, "moveMinY"),0);  
    self.moveScale = Utils.getNoNil(getUserAttribute(id, "moveScale"),0);
    local parent = g_currentMission.fruitsConvertingTriggers[self.parentID];
    if parent.manualStart then
      self.movePartStep0 = getChildAt(self.movePart, 0);
      self.movePartStep1 = getChildAt(self.movePart, 1);
    end;
  end;    
  
  self.minThreshold = 0.00000;

  self.trailerInTrigger = 0;
  self.CiziId = {};

  if self.parentID==nil or g_currentMission.fruitsConvertingTriggers[self.parentID]==nil then
    print("ERROR: fcTipTriggerOnCreate - fcTipTrigger created before fruitsConverting! Check yours userAttribures sequence in map01.i3d!");
  else
    if fruitType ~= "bale" then
      addTrigger(id, "fcTipTriggerCallback", self);
    else
      addTrigger(id, "fcBaleDestroyerTriggerCallback", self);
    end;
    --table.insert(g_currentMission.fruitsConvertingTriggers[self.parentID].tipTriggers,self);
    g_currentMission.fruitsConvertingTriggers[self.parentID].tipTriggers[self.ID] = self;
  end;
  self.myDirtyFlag = self:getNextDirtyFlag();
end;

function fcTipTrigger:delete()
  self.isActive = false;
  removeTrigger(self.triggerId);
end;

function fcTipTrigger:readStream(streamId, connection)
--  print("fcTipTrigger:readStream");
  fcTipTrigger:superClass().readStream(self, streamId);
  if connection:getIsServer() then
    self.isActive = streamReadBool(streamId);
    local lastFill = self.fillLevel; 
    self.fillLevel = streamReadFloat32(streamId);
    self:updateMoving(self.fillLevel - lastFill);
  end;
end;

function fcTipTrigger:writeStream(streamId, connection)
--  print("fcTipTrigger:writeStream");
  fcTipTrigger:superClass().writeStream(self, streamId);
  if not connection:getIsServer() then
    streamWriteBool(streamId, self.isActive);
    streamWriteFloat32(streamId, self.fillLevel);
  end;
end;

function fcTipTrigger:readUpdateStream(streamId, timestamp, connection)
    self:readStream(streamId, connection);
end;

function fcTipTrigger:writeUpdateStream(streamId, connection, dirtyMask)
    self:writeStream(streamId, connection);
end;


function fcTipTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fcTipTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function fcTipTrigger:update(dt)
  self.drawIcon = false;
  if self.runOnce then
    self.runOnce = false;
    g_client:getServerConnection():sendEvent(fcTipSynchronizeEvent:new(self));
  end;
  if self.isActive and self.currentFillType==nil then
    if self.trailerInTrigger>0 then
      local vlek=g_currentMission.objectToTrailer[self.trailerInTrigger];
      if vlek ~= nil and vlek:getIsActiveForInput() and (vlek.currentFillType~=nil) then
        self.drawIcon = (self:allowFillType(vlek.currentFillType)) or (vlek.currentFillType==Fillable.FILLTYPE_UNKNOW);
        if (vlek.tipState == Trailer.TIPSTATE_CLOSED) and (self.fillLevel<self.capacity) and (self:allowFillType(vlek.currentFillType)) then
          g_currentMission:addHelpButtonText("vysypat", InputBinding.DUMP_TO_FC);
          if InputBinding.hasEvent(InputBinding.DUMP_TO_FC) then
            vlek:toggleTipState(self);
          end;
        elseif ((vlek.tipState ~= Trailer.TIPSTATE_CLOSED) and (vlek.tipState ~= Trailer.TIPSTATE_CLOSING)) and (self.fillLevel<self.capacity) then
          g_currentMission:addHelpButtonText("ukoncit vysypavani", InputBinding.DUMP_TO_FC);
          if InputBinding.hasEvent(InputBinding.DUMP_TO_FC) then
            vlek:toggleTipState(self);
          end;
        end;
      end;
    end;
  end;
end;

function fcTipTrigger:draw()
  if self.drawIcon then
    self.tipIcon:render();
  end;
end;

function fcTipTrigger:updateMoving(delta)
  if self.isClient and self.movingIndex ~= nil then
    if self.lumpMaterial then
      local c = getNumOfChildren(self.movePart);
      if (c>0) and (self.capacity>0) then
        local p =  math.floor(self.fillLevel/(self.capacity/c));
        for i=0, c-1 do
          setVisibility(getChildAt(self.movePart, i), (i<=p));
        end;
      end;
    else
      local x, y, z = getTranslation(self.movePart);
      if self.capacity == 10000000 then
        y = math.min((y + ((self.moveMaxY - self.moveMinY) * (self.moveScale * (delta) * 0.01))),self.moveMaxY);
      else
        y = self.moveMinY + (((self.moveMaxY - self.moveMinY)/self.capacity)*self.fillLevel);
      end;
      setTranslation(self.movePart, x, y, z);
    end;
  end;
end;

function fcTipTrigger:allowFillType(fillType, allowEmptying)
  local parent = g_currentMission.fruitsConvertingTriggers[self.parentID];
  local allowed = (parent.manualStep == 0) and Utils.getNoNil(self.acceptedFruitTypes[fillType], false);
  return allowed;
end;

function fcTipTrigger:setFillLevel(fillLevel, fillType)
  if fillType~=nil then
    if not self:allowFillType(fillType, false) then
      return;
    end;
  end;
  local prevfillLevel = self.fillLevel;
  self.fillLevel = fillLevel;
  
  if self.fillLevel > self.capacity then
    self.fillLevel = self.capacity;
  end;
  if self.fillLevel < 0 then
    self.fillLevel = 0;
  end;
  if prevfillLevel ~= self.fillLevel then
    self:raiseDirtyFlags(self.myDirtyFlag);
  end;
end;

function fcTipTrigger:fcTipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter then
    if otherId ~= nil then
      local nalezeno=false;
      for a=1, table.maxn(self.CiziId) do
        if self.CiziId[a]~= nil and self.CiziId[a]==otherId then
          nalezeno=true;
          break;
        end;
      end;
      if not nalezeno then
        table.insert(self.CiziId,otherId);
      end;
		end;
	elseif onLeave then
	  for a=1, table.maxn(self.CiziId) do
      if self.CiziId[a]~= nil and self.CiziId[a]==otherId then
        if self.trailerInTrigger == otherId then
          local vlek=g_currentMission.objectToTrailer[otherId];
          if (vlek ~= nil) and ((vlek.tipState ~= Trailer.TIPSTATE_CLOSED) and (vlek.tipState ~= Trailer.TIPSTATE_CLOSING)) then
            vlek:toggleTipState(self);
          end;
        end;
        table.remove(self.CiziId,a);
        break;
      end;
    end;
	elseif onStay then
		if otherId ~= nil then
		end;
	end;
	local nearestDistance = self.maxDistance;
  local tr = 0;
	for a=1, table.maxn(self.CiziId) do
	  local index = self.CiziId[a];
    if index ~= nil then
      local vlek=g_currentMission.objectToTrailer[index];
      if vlek ~= nil and vlek:getIsActiveForInput() then
        local tipPoint = Utils.getNoNil(vlek.tipReferencePoint, vlek.components[1].node);
        local px, py, pz = getWorldTranslation(triggerId);
        local vx, vy, vz = getWorldTranslation(tipPoint);
  	    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
        if distance<nearestDistance then
          nearestDistance = distance;
          tr = index;
        end;
      end;
    end;
	end;
	self.trailerInTrigger = tr;
end;

function fcTipTrigger:fcBaleDestroyerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter then
    if otherId ~= 0 then
      local object = g_currentMission:getNodeObject(otherId);
      if object ~= nil then
        if object:isa(Bale) then
          if g_currentMission:getIsServer() then
            self:setFillLevel(self.fillLevel+1);
            self:updateMoving(1);
            object:delete();
          end;
        end;
      end;
    end;
  end;
end;



function Trailer:updateTick(dt)

    if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then

        if self.isServer then

            if self.currentFillType ~= Fillable.FILLTYPE_UNKNOW and self.currentTipTrigger ~= nil and (g_currentMission:getIsTrailerInTipRange(self, self.currentTipTrigger) or (self.currentTipTrigger.isDefendersTrigger~=nil and self.currentTipTrigger.isDefendersTrigger)) then
                local fillType = self.currentFillType;
                local m = self.capacity/(self.tipDischargeEndTime/self.tipAnimSpeedScale);
                local curFill = self.fillLevel;
                self:setFillLevel(self.fillLevel - (m* dt), self.currentFillType);
                local fillDelta = self.fillLevel - curFill;
                self.lastFillDelta = fillDelta;

                if self.currentTipTrigger.isFarmTrigger then
                    -- put load into storage
                    local siloFillType = fillType;
                    if fillType == Fillable.FILLTYPE_DRYGRASS then
                        siloFillType = Fillable.FILLTYPE_GRASS
                    end;

                    g_currentMission:setSiloAmount(siloFillType, g_currentMission:getSiloAmount(siloFillType)- fillDelta);
              
                elseif self.currentTipTrigger.isDefendersTrigger~=nil and self.currentTipTrigger.isDefendersTrigger then
                    if self.currentTipTrigger.setFillLevel ~= nil then
                      local fill = (self.currentTipTrigger.fillLevel-self.lastFillDelta);
                      if self.currentTipTrigger.capacity~= nil then
                        fill = math.min((self.currentTipTrigger.fillLevel-self.lastFillDelta),self.currentTipTrigger.capacity);
                      end;
                      self.currentTipTrigger:setFillLevel(fill, self.currentFillType);
                      if self.currentTipTrigger.capacity~= nil and fill == self.currentTipTrigger.capacity then
                        self:toggleTipState(self.currentTipTrigger);                        
                      end;
                    end;
                else
                    -- increase money according to price of current fill type
                    local fruitType = FruitUtil.fillTypeToFruitType[fillType];
                    if fruitType ~= nil then
                        local priceMultiplier = self.currentTipTrigger.priceMultipliers[fruitType];

                        --local difficultyMultiplier = 2 ^ (3 - g_currentMission.missionStats.difficulty);
                        local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  3  6
                        local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * priceMultiplier * difficultyMultiplier * -fillDelta;
                        --g_currentMission.missionStats.money = g_currentMission.missionStats.money + money;
                        g_currentMission:addSharedMoney(money);
                    end;
                end;

                if fillDelta < 0 then
                    if self.currentTipTrigger ~= nil and self.currentTipTrigger.updateMoving~=nil then 
                      self.currentTipTrigger:updateMoving(-fillDelta);
                    end;
                end;
            else
                self:onEndTip();
            end;
        end;

        if self.isClient then
            if self.tipState == Trailer.TIPSTATE_OPENING then
                if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
                    playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
                    setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset-0.4);
                    self.hydraulicSoundEnabled = true;
                end;
            end;

            -- check if we still are in opening/open state. Maybe we ended tipping before.
            if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) and self.fillLevel > 0 then
                if not self.fillSoundEnabled and self.fillSound ~= nil and self:getIsActiveForSound() then
                    playSample(self.fillSound, 0, self.fillSoundVolume, 0);
                    self.fillSoundEnabled = true;
                end;
            else
                if self.fillSoundEnabled then
                    stopSample(self.fillSound);
                    self.fillSoundEnabled = false;
                end;
            end;
        end;

        if self.tipState == Trailer.TIPSTATE_OPENING then
            if getAnimTrackTime(self.tipAnimCharSet, 0) > self.tipAnimDuration then
                self.tipState = Trailer.TIPSTATE_OPEN;
                if self.hydraulicSoundEnabled then
                    stopSample(self.hydraulicSound);
                    self.hydraulicSoundEnabled = false;
                end;
            end;
        else
            if getAnimTrackTime(self.tipAnimCharSet, 0) > self.tipDischargeEndTime then
                self:onEndTip(true);
            end;
        end;

    elseif self.tipState == Trailer.TIPSTATE_CLOSING then

        if self.isClient then
            if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
                playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
                setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset);
                self.hydraulicSoundEnabled = true;
            end;
        end;

        if getAnimTrackTime(self.tipAnimCharSet, 0) <= 0.0 then
            if self.hydraulicSoundEnabled then
                stopSample(self.hydraulicSound);
                self.hydraulicSoundEnabled = false;
            end;
            disableAnimTrack(self.tipAnimCharSet, 0);
            self.tipState = Trailer.TIPSTATE_CLOSED;
        end;
    end;

    if self.isClient then
        if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) and self.fillLevel > 0 then
            Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], true);
        else
            Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], false);
        end;
    end;
end;

fsSiloTrigger = {};

local fsSiloTrigger_mt = Class(fsSiloTrigger, Object);

function fsSiloTrigger:onCreate(id)
  local trigger = fsSiloTrigger:new(g_server ~= nil, g_client ~= nil);
  local index = g_currentMission:addOnCreateLoadedObject(trigger);
  trigger:load(id);
  trigger:register(true);
end;

fsSiloTriggerOnCreate = fsSiloTrigger.onCreate;

function fsSiloTrigger:new(isServer, isClient)
  local self = Object:new(isServer, isClient, fsSiloTrigger_mt);
  self.className = "fsSiloTrigger";
  self.rootNode = 0;

  self.fsSiloTriggerDirtyFlag = self:getNextDirtyFlag();
  return self;
end;


function fsSiloTrigger:load(id)
  self.rootNode = id;
  self.mapDirectory = g_currentMission.missionInfo.map.baseDirectory;
  if self.isServer then
    self.triggerIds = {};
    table.insert(self.triggerIds, id);
    addTrigger(id, "fsSiloTriggerCallback", self);
    for i=1, 3 do
      local child = getChildAt(id, i-1);
      table.insert(self.triggerIds, child);
      addTrigger(child, "fsSiloTriggerCallback", self);
    end;
  end;

  self.parentID = getUserAttribute(getParent(id), "fcID");
  self.targetFruitIndex = Utils.getNoNil(getUserAttribute(id, "targetFruitIndex"),1);
  self.fillType = g_currentMission.fruitsConvertingTriggers[self.parentID]["targetFruit"..tostring(self.targetFruitIndex)];

  local particlePositionStr = getUserAttribute(id, "particlePosition");
  if particlePositionStr ~= nil then
    local x,y,z = Utils.getVectorFromString(particlePositionStr);
    if x ~= nil and y ~= nil and z ~= nil then
      self.particlePosition = {x,y,z};
    end;
  end;

  self.isEnabled = true;

  self.fill = 0;
  self.siloTrailerId = 0;
  self.fillDone = false;

  self.isFilling = false;

  self.fillLitersPerSecond = Utils.getNoNil(tonumber(getUserAttribute(id, "fillLitersPerSecond")), 1500);

  if self.isClient and self.particlePosition ~= nil then
    local particleSystem = Utils.getNoNil(getUserAttribute(id, "particleSystem"), "wheatParticleSystemLong")
    if particleSystem == "wheatParticleSystemLong" then
      particleSystem="data/vehicles/particleSystems/" .. particleSystem .. ".i3d";
    else
      particleSystem = Utils.getFilename(particleSystem, self.mapDirectory);
    end;
    self.siloParticleSystemRoot = loadI3DFile(particleSystem);
    local x,y,z = getTranslation(id);
    if self.particlePosition ~= nil then
      x = x + self.particlePosition[1];
      y = y + self.particlePosition[2];
      z = z + self.particlePosition[3];
    end;
    setTranslation(self.siloParticleSystemRoot, x,y,z);
    link(getParent(id), self.siloParticleSystemRoot);

    for i=0, getNumOfChildren(self.siloParticleSystemRoot)-1 do
      local child = getChildAt(self.siloParticleSystemRoot, i);
      if getClassName(child) == "Shape" then
        local geometry = getGeometry(child);
        if geometry ~= 0 then
          if getClassName(geometry) == "ParticleSystem" then
            self.siloParticleSystem = geometry;
          end;
        end;
      end;
    end;

    if self.siloParticleSystem ~= nil then
      setEmittingState(self.siloParticleSystem, false);
    end;

    self.siloFillSound = createSample("siloFillSound");
    loadSample(self.siloFillSound, "data/maps/sounds/siloFillSound.wav", false);
  end;
end;

function fsSiloTrigger:delete()
  if self.isClient and self.siloFillSound~=nil then
    delete(self.siloFillSound);
    self.siloFillSound = nil;
  end;

  if self.isServer then
    for i=1, table.getn(self.triggerIds) do
      removeTrigger(self.triggerIds[i]);
    end;
  end;

  if self.siloParticleSystemRoot ~= nil then
    delete(self.siloParticleSystemRoot);
    self.siloParticleSystemRoot = nil;
  end;

  delete(self.rootNode);
  SiloTrigger:superClass().delete(self);
end;

function fsSiloTrigger:readStream(streamId, connection)
  fsSiloTrigger:superClass().readStream(self, streamId);
  if connection:getIsServer() then
    local isFilling = streamReadBool(streamId);
    if isFilling then
      self:startFill();
    else
      self:stopFill();
    end;
  end;
end;

function fsSiloTrigger:writeStream(streamId, connection)
  fsSiloTrigger:superClass().writeStream(self, streamId);
  if not connection:getIsServer() then
    streamWriteBool(streamId, self.isFilling);
  end;
end;

function fsSiloTrigger:readUpdateStream(streamId, timestamp, connection)
  if connection:getIsServer() then
    local isFilling = streamReadBool(streamId);
    if isFilling then
      self:startFill();
    else
      self:stopFill();
    end;
  end;
end;

function fsSiloTrigger:writeUpdateStream(streamId, connection, dirtyMask)
  if not connection:getIsServer() then
    streamWriteBool(streamId, self.isFilling);
  end;
end;

function fsSiloTrigger:update(dt)
  if self.isServer then
    if self.fill >= 4 and self.siloTrailer ~= nil and not self.fillDone then
      local trailer = self.siloTrailer;
      local fillLevel = trailer.fillLevel;
      local siloAmount = g_currentMission.fruitsConvertingTriggers[self.parentID]["fillLevel"..tostring(self.targetFruitIndex)];
      if siloAmount > 0 then
        local deltaFillLevel = math.min(self.fillLitersPerSecond*0.001*dt, siloAmount);
        trailer:setFillLevel(fillLevel+deltaFillLevel, self.fillType);
        local newFillLevel = trailer.fillLevel;
        g_currentMission.fruitsConvertingTriggers[self.parentID]:setFillLevel(-(newFillLevel-fillLevel), self.targetFruitIndex);
        if fillLevel ~= newFillLevel then
          self:startFill();
        else
          self.fillDone = true;
          self:stopFill();
        end;
      else
        self.fillDone = true;
        self:stopFill();
      end;
    end;
  end;
end;

function fsSiloTrigger:stopFill()
  if self.isFilling then
    self.isFilling = false;
    if self.isServer then
      self:raiseDirtyFlags(self.fsSiloTriggerDirtyFlag);
    end;
    if self.isClient then
      if self.siloFillSoundEnabled then
        stopSample(self.siloFillSound);
        self.siloFillSoundEnabled = false;
      end;
      if self.siloParticleSystem ~= nil then
        setEmittingState(self.siloParticleSystem, false);
      end;
    end;
  end;
end;

function fsSiloTrigger:startFill()
  if not self.isFilling then
    self.isFilling = true;
    if self.isServer then
      self:raiseDirtyFlags(self.fsSiloTriggerDirtyFlag);
    end;
    if self.isClient then
      if not self.siloFillSoundEnabled and self.siloFillSound~= nil then
        playSample(self.siloFillSound, 0, 1.0, 0);
        self.siloFillSoundEnabled = true;
      end;
      if self.siloParticleSystem ~= nil then
        setEmittingState(self.siloParticleSystem, true);
      end;
    end;
  end;
end;

function fsSiloTrigger:fsSiloTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
  assert(self.isServer);
  if self.isEnabled then
    local trailer = g_currentMission.objectToTrailer[otherShapeId];
    if trailer ~= nil and trailer:allowFillType(self.fillType, true) and (trailer.allowFillFromAir or self.fillType==Fillable.FILLTYPE_LIQUIDMANURE or self.fillType==Fillable.FILLTYPE_MILK) then
      if onEnter then
        self.fill = self.fill+1;
        self.siloTrailer = trailer;
        self.fillDone = false;
      elseif onLeave then
        self.fill = math.max(self.fill-1, 0);
        self.siloTrailer = nil;
        self.fillDone = false;
        self:stopFill();
      end;
    end;
  end;
end;

local oldSaveSelectedGame = CareerScreen.saveSelectedGame;

CareerScreen.saveSelectedGame = function(self)
  oldSaveSelectedGame(self);
  if g_currentMission.fruitsConvertingTriggers ~= nil then
    if table.maxn(g_currentMission.fruitsConvertingTriggers)>0 then
      local siloSaveDir = g_currentMission.missionInfo.savegameDirectory;
      local siloSaveXML = siloSaveDir .. "/fruitsConvertingSave.xml";
	    local existDir = io.open (siloSaveXML, "w");
	    if existDir == nil then
		    createXMLFile("fruitsConvertingSave", siloSaveXML, "fruitsConvertingSave");
	    end;
      local siloFile = io.open (siloSaveXML, "w");
      if siloFile ~= nil then
        siloFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
        siloFile:write('<fruitsConvertingSave>\n');
        for i=1, table.maxn(g_currentMission.fruitsConvertingTriggers) do
          local tmp = g_currentMission.fruitsConvertingTriggers[i];
          if tmp~=nil then
            if tmp.isActive then
              local fillLevels = "";
              for b=1, tmp.targetFruitsCount do
                fillLevels = fillLevels..string.format('fillLevel%d="%f" ', b, tmp["fillLevel"..tostring(b)]);
              end; 
              if tmp.manualStart then
                fillLevels = fillLevels..string.format('step="%d" wait="%f" ', tmp.manualStep, tmp.manualWait);
              end;
              siloFile:write(string.format('  <fruitsConvertingObject ID="%d" %s>\n', tmp.ID, fillLevels));
              for a=1, table.maxn(tmp.tipTriggers) do
                local tt = tmp.tipTriggers[a];
                if tt~=nil then
                  if tt.isActive then
                    siloFile:write(string.format('    <fcTipTrigger ID="%d" fillLevel="%f" />\n', tt.ID, tt.fillLevel));
                  end;
                end;
              end;
              siloFile:write("  </fruitsConvertingObject>\n");
            end;
          end;
        end;
        siloFile:write("</fruitsConvertingSave>");
        siloFile:close();
      end;
    end;
  end;
end;