
Compass = {};

function Compass.prerequisitesPresent(specializations)
    print("loaded specialization compass v0.2 by Pete");
    return true;
end;

function Compass:load(xmlFile)
		self.directions = {};
		self.directions[0] = "N";
		self.directions[1] = "NO";
		self.directions[2] = "O";
		self.directions[3] = "SO";
		self.directions[4] = "S";
		self.directions[5] = "SW";
		self.directions[6] = "W";
		self.directions[7] = "NW";		
		self.directions[8] = "N";
		
		self.degree = 0;
		self.direction = "N";
end;

function Compass:delete()
end;

function Compass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Compass:keyEvent(unicode, sym, modifier, isDown)
end;

function Compass:update(dt)

end;

function Compass:updateTick(dt)

	local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local degree = math.deg(math.atan2(dX,dZ));

	degree = 180 - degree;

	if degree < 0  then 
		degree = 360 - (degree * -1);
	end;

	self.direction = self.directions[math.floor(degree/45 + 0.5)];	

	--round
	degree = math.floor(degree + 0.5);

	self.degree = degree;	
	
end;

function Compass:draw()
	
	renderText(0.89,0.855,0.03,string.format("%3d - %2s", self.degree, self.direction));	
	
end;
