--
-- cloonty
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

cloonty = {}

local cloonty_mt = Class(cloonty, Mission00);

function cloonty:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = cloonty_mt;
    end;
    local self = cloonty:superClass():new(baseDirectory, mt);
    return self;
end;

function cloonty:delete()
    cloonty:superClass().delete(self);
end;

function cloonty:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    -- self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    -- self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    cloonty:superClass().load(self);
end
function cloonty:loadFinished()
    cloonty:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function cloonty:mouseEvent(posX, posY, isDown, isUp, button)
    cloonty:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function cloonty:keyEvent(unicode, sym, modifier, isDown)
    cloonty:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function cloonty:update(dt)
    cloonty:superClass().update(self, dt);
end;

function cloonty:draw()
    cloonty:superClass().draw(self);
end;
