--
-- cliafuaine
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

cliafuaine = {}

local cliafuaine_mt = Class(cliafuaine, Mission00);

function cliafuaine:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = cliafuaine_mt;
    end;
    local self = cliafuaine:superClass():new(baseDirectory, mt);
    return self;
end;

function cliafuaine:delete()
    cliafuaine:superClass().delete(self);
end;

function cliafuaine:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    -- self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    -- self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    cliafuaine:superClass().load(self);
end
function cliafuaine:loadFinished()
    cliafuaine:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function cliafuaine:mouseEvent(posX, posY, isDown, isUp, button)
    cliafuaine:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function cliafuaine:keyEvent(unicode, sym, modifier, isDown)
    cliafuaine:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function cliafuaine:update(dt)
    cliafuaine:superClass().update(self, dt);
end;

function cliafuaine:draw()
    cliafuaine:superClass().draw(self);
end;
