--
-- Tractor hours
--
-- @author  Jack
-- @date  01/05/09
--
-- Copyright (C) Jack

hours_schlepper = {};

function hours_schlepper.prerequisitesPresent(specializations)
    return true;
end;

function hours_schlepper:load(xmlFile)

self.GetSaveAttributesAndNodes = self.getSaveAttributesAndNodes;
self.LoadFromAttributesAndNodes = self.loadFromAttributesAndNodes;
self.setstd = SpecializationUtil.callSpecializationsFunction("setstd");

-- its a test for a new trigger
    self.stdh = 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    self:setstd(0);
end;

function hours_schlepper:getSaveAttributesAndNodes(nodeIdent)
    local attributes, nodes;
    local modStr = 'std="'..self.std..'"';
    if attributes == nil then
        attributes = modStr;
    else
        attributes = attributes .. " "..modStr;
    end;
    return attributes, nodes;
end;

function hours_schlepper:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

    if not resetVehicles then
        local std = getXMLFloat(xmlFile, key.."#std");
        if std ~= nil then
            self:setstd(std);
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function hours_schlepper:keyEvent(unicode, sym, modifier, isDown)
end;

function hours_schlepper:update(dt)
    if self.isEntered or self.isHired then 

		local time = (g_currentMission.environment.dayTime/(3600000000000/g_settingsTimeScale));

		self:setstd(self.std + time);
end;

end;

function hours_schlepper:draw()
	setTextBold(true);
	renderText(self.hudBasePoxX, self.hudBasePoxY+0.185, 0.021, string.format("%s%d" , "Uzemora:", self.std));
	setTextBold(false);
end;

function hours_schlepper:onEnter()
end;

function hours_schlepper:onLeave()
end;

function hours_schlepper:delete()
end;

function hours_schlepper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hours_schlepper:setstd(newstd)
    self.std = math.max(math.min(newstd, self.stdh), 0);
end;






