--JD820
--hz888


JD820 = {}

function JD820.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function JD820:load(xmlFile)

    local fogNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fog#index"));
    if fogNode ~= nil then
        self.fog = {};
        self.fog.node = fogNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.fog#minTrans"));
        self.fog.minTrans = {};
        self.fog.minTrans[1] = Utils.getNoNil(x, 0);
        self.fog.minTrans[2] = Utils.getNoNil(y, 0);
        self.fog.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.fog#maxTrans"));
        self.fog.maxTrans = {};
        self.fog.maxTrans[1] = Utils.getNoNil(x, 0);
        self.fog.maxTrans[2] = Utils.getNoNil(y, 0);
        self.fog.maxTrans[3] = Utils.getNoNil(z, 0);

        self.fog.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.fog#transTime"), 2)*1000;
        self.fog.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.fog#touchTransLimit"), 10);
    end;
	
end;

function JD820:delete()
end;

function JD820:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD820:keyEvent(unicode, sym, modifier, isDown)
end;

function JD820:update(dt)

    if self.reelStarted then
    	if self.fog ~= nil then 
		local x, y, z = getTranslation(self.fog.node); 
		local trans = {x,y,z};
		if x <= self.fog.minTrans[1] then
			self.fogMax = true;
		elseif x >= self.fog.maxTrans[1] then
			self.fogMax = false;
		end;
		local newTrans = Utils.getMovedLimitedValues(trans, self.fog.maxTrans, self.fog.minTrans, 3, self.fog.transTime, dt, not self.fogMax); 
		setTranslation(self.fog.node, unpack(newTrans));
	end;
    end;
end;

function JD820:draw()
end;
