--
-- Combine
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

farmerCar2 = {};

function farmerCar2.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function farmerCar2:load(xmlFile)

	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
    self.numWorklights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights2#count"), 0);
    self.worklights2 = {};
    for i=1, self.numWorklights2 do
        local worklightnamei2 = string.format("vehicle.worklights2.worklight" .. "%d", i);
        self.worklights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei2 .. "#index"));
        setVisibility(self.worklights2[i], false);
    end;	
	self.worklightsActive2 = false;
	
    self.numWorklights3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights3#count"), 0);
    self.worklights3 = {};
    for i=1, self.numWorklights3 do
        local worklightnamei3 = string.format("vehicle.worklights3.worklight" .. "%d", i);
        self.worklights3[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei3 .. "#index"));
        setVisibility(self.worklights3[i], false);
    end;	
	self.worklightsActive3 = false;
	
    self.numWorklights4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights4#count"), 0);
    self.worklights4 = {};
    for i=1, self.numWorklights4 do
        local worklightnamei4 = string.format("vehicle.worklights4.worklight" .. "%d", i);
        self.worklights4[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei4 .. "#index"));
        setVisibility(self.worklights4[i], false);
    end;	
	self.worklightsActive4 = false;
	
	self.wysypywanie = false;
	self.hydraulicSoundAllow = false;
	self.klaksonAllow = false;
	self.combineName = getXMLString(xmlFile, "vehicle.name.de");
	self.warningPlayed = false;
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
		
	hydraulicSoundFile = Utils.getFilename("Sounds/hydraulicUp.wav", self.baseDirectory);
    self.hydraulicSoundId = createSample("hydraulicSound");
    loadSample(self.hydraulicSoundId, hydraulicSoundFile, false);
    self.hydraulicPlaying = false;
	
	klaksonFile = Utils.getFilename("Sounds/klakson.wav", self.baseDirectory);
    self.klaksonId = createSample("klakson");
    loadSample(self.klaksonId, klaksonFile, false);
    self.klaksonPlaying = false;
	
	turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
	
	warningSoundFile = Utils.getFilename("Sounds/warning.wav", self.baseDirectory);
    self.warningSoundId = createSample("warningSound");
    loadSample(self.warningSoundId, warningSoundFile, false);
    self.warningPlaying = false;
	
    local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft5#index"));
    if rotationPartNodeLeft5 ~= nil then
        self.rotationPartLeft5 = {};
        self.rotationPartLeft5.node = rotationPartNodeLeft5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#minRot"));
        self.rotationPartLeft5.minRot = {};
        self.rotationPartLeft5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#maxRot"));
        self.rotationPartLeft5.maxRot = {};
        self.rotationPartLeft5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#rotTime"), 2)*1000;
        self.rotationPartLeft5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft6#index"));
    if rotationPartNodeLeft6 ~= nil then
        self.rotationPartLeft6 = {};
        self.rotationPartLeft6.node = rotationPartNodeLeft6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#minRot"));
        self.rotationPartLeft6.minRot = {};
        self.rotationPartLeft6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#maxRot"));
        self.rotationPartLeft6.maxRot = {};
        self.rotationPartLeft6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#rotTime"), 2)*1000;
        self.rotationPartLeft6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft7#index"));
    if rotationPartNodeLeft7 ~= nil then
        self.rotationPartLeft7 = {};
        self.rotationPartLeft7.node = rotationPartNodeLeft7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft7#minRot"));
        self.rotationPartLeft7.minRot = {};
        self.rotationPartLeft7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft7#maxRot"));
        self.rotationPartLeft7.maxRot = {};
        self.rotationPartLeft7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft7#rotTime"), 2)*1000;
        self.rotationPartLeft7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft7#touchRotLimit"), 10));
    end;
	
	self.rullight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rullight#index"));
    self.allowGrainTankFruitType = farmerCar2.allowGrainTankFruitType;
    self.emptyGrainTankIfLowFillLevel = farmerCar2.emptyGrainTankIfLowFillLevel;
    self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
    self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
    self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
    self.openPipe = SpecializationUtil.callSpecializationsFunction("openPipe");
    self.closePipe = SpecializationUtil.callSpecializationsFunction("closePipe");
    self.findTrailerRaycastCallback = farmerCar2.findTrailerRaycastCallback;

    local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if threshingStartSound ~= nil and threshingStartSound ~= "" then
        threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory); 
        self.threshingStartSound = createSample("threshingStartSound");
        loadSample(self.threshingStartSound, threshingStartSound, false);
        self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);
        self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
        self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
    end;

    local cutterthreshingSound = getXMLString(xmlFile, "vehicle.cutterthreshingSound#file");
    if cutterthreshingSound ~= nil and cutterthreshingSound ~= "" then
        cutterthreshingSound = Utils.getFilename(cutterthreshingSound, self.baseDirectory); 
        self.cutterthreshingSound = createSample("cutterthreshingSound");
        loadSample(self.cutterthreshingSound, cutterthreshingSound, false);
        self.cutterthreshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchOffset"), 1);
        self.cutterthreshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchScale"), 0);
        self.cutterthreshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchMax"), 2.0);
    end;
	
    local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if threshingSound ~= nil and threshingSound ~= "" then
        threshingSound = Utils.getFilename(threshingSound, self.baseDirectory); 
        self.threshingSound = createSample("threshingSound");
        loadSample(self.threshingSound, threshingSound, false);
        self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
        self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
        self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
    end;

    local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if threshingStopSound ~= nil and threshingStopSound ~= "" then
        threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory); 
        self.threshingStopSound = createSample("threshingStopSound");
        loadSample(self.threshingStopSound, threshingStopSound, false);
        self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
        self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
        self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
    end;

    local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if pipeSound ~= nil and pipeSound ~= "" then
        pipeSound = Utils.getFilename(pipeSound, self.baseDirectory); 
        self.pipeSound = createSample("pipeSound");
        loadSample(self.pipeSound, pipeSound, false);
        self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
        self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
        self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
    end;

    self.chopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    self.pipeParticleSystems = {};
    self.pipe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
    if self.pipe ~= nil then

        self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));

        -- load the pipe particle system for each fruit type
        local i = 0;
        while true do
            local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;

            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};

                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.pipe, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
                self.pipeParticleSystems[desc.index] = currentPS;
                if self.defaultPipeParticleSystem == nil then
                    self.defaultPipeParticleSystem = currentPS;
                end;

                if self.pipeRaycastNode == nil then
                    self.pipeRaycastNode = particleNode;
                end;
            end;
            i = i + 1;
        end;

        if self.pipeRaycastNode == nil then
            self.pipeRaycastNode = self.components[1].node;
        end;

    end;

    self.allowsThreshing = true;

    self.isThreshingStarted = false;

    self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));

    self.pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));

    self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));

    self.grainTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 200);
    self.grainTankUnloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankUnloadingCapacity"), 10);
    self.grainTankCrowded = false;

    self.grainTankPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainTankPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);

            local entry = {};
            entry.node = node;
            local windowNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#windowIndex"));
            if windowNode ~= nil then
                entry.windowNode = windowNode;
                setVisibility(windowNode, false);
            end;

            if self.defaultGrainTankPlane == nil then
                self.defaultGrainTankPlane = entry;
            end;
            self.grainTankPlanes[t] = entry;
        end;
        i = i +1;
    end;
    if self.defaultGrainTankPlane==nil then
        self.grainTankPlanes = nil;
    end;

    --self.grainPlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainPlane#index"));
    --self.grainPlaneWindow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainTankPlane#windowIndex"));

    self.grainTankPlaneMinY, self.grainTankPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#minMaxY"));
    if self.grainTankPlaneMinY == nil or self.grainTankPlaneMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolator4);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.key(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            animCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneAnimCurve = animCurve;
        end;
        self.grainTankPlaneMinY = 0;
        self.grainTankPlaneMaxY = 0;
    end;


    self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#windowMinMaxY"));
    if self.grainTankPlaneWindowMinY == nil or self.grainTankPlaneWindowMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolatorN);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.windowKey(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local visibility = getXMLBool(xmlFile, key.."#visibility");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil or visibility == nil then
                break;
            end;
            animCurve:addKeyframe({v={scaleX, scaleY, scaleZ, yValue, }, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneWindowAnimCurve = animCurve;
        end;
        self.grainTankPlaneWindowMinY = 0;
        self.grainTankPlaneWindowMaxY = 0;
    end;
    self.grainTankPlaneWindowStartY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankPlane#windowStartY"), 0.0);


    self.chopperParticleSystems = {};
    --Utils.loadParticleSystem(xmlFile, self.chopperParticleSystems, "vehicle.chopperParticleSystem", self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
    local i = 0;
    while true do
        local key = string.format("vehicle.chopperParticleSystems.chopperParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
            self.chopperParticleSystems[desc.index] = currentPS;
            if self.defaultChopperParticleSystem == nil then
                self.defaultChopperParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.chopperToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperParticleSystems#toggleTime"), 2500);
    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;


    self.strawParticleSystems = {};
    --Utils.loadParticleSystem(xmlFile, self.strawParticleSystems, "vehicle.strawParticleSystem", self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
    local i = 0;
    while true do
        local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
            self.strawParticleSystems[desc.index] = currentPS;
            if self.defaultStrawParticleSystem == nil then
                self.defaultStrawParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 2500);
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;

    self.strawEmitState = false;


    self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);

    local numStrawAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawAreas#count"), 0);
    self.strawAreas = {}
    for i=1, numStrawAreas do
        local area = {};
        local areanamei = string.format("vehicle.strawAreas.strawArea%d", i);
        area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
        table.insert(self.strawAreas, area);
    end;

    self.isThreshing = false;
    self.chopperActivated = false;
    self.defaultChopperState = false;
    self.pipeOpening = false;
    self.pipeOpen = false;
    self.pipeClose = true;
    self.pipeParticleActivated = false;

    self.threshingScale = 1;

    self.grainTankFruitTypes = {};
    self.grainTankFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;

    local fruitTypes = getXMLString(xmlFile, "vehicle.grainTankFruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.grainTankFruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.grainTankFillLevel = 0;
    self:setGrainTankFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN);

    self.minThreshold = 0.05;

    self.speedDisplayScale = 1.0;
    self.drawFillLevel = true;

    self.attachedCutters = {};
    self.numAttachedCutters = 0;

    self.lastLastArea = 0;
    self.lastArea = 0;
end;

function farmerCar2:delete()

    for k,v in pairs(self.pipeParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;

    if self.threshingStartSound ~= nil then
        delete(self.threshingStartSound);
    end;
    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;
    if self.cutterthreshingSound ~= nil then
        delete(self.cutterthreshingSound);
    end;
    if self.threshingStopSound ~= nil then
        delete(self.threshingStopSound);
    end;
    if self.pipeSound ~= nil then
        delete(self.pipeSound);
    end;

end;

function farmerCar2:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local fillLevel = getXMLFloat(xmlFile, key.."#grainTankFillLevel");
    local fruitType = getXMLString(xmlFile, key.."#grainTankFruitType");
    if fillLevel ~= nil and fruitType ~= nil then
        local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
        if fruitTypeDesc ~= nil then
            self:setGrainTankFillLevel(fillLevel, fruitTypeDesc.index);
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function farmerCar2:getSaveAttributesAndNodes(nodeIdent)
    local fruitType = "unknown";
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
    end;
    local attributes = 'grainTankFillLevel="'..self.grainTankFillLevel..'" grainTankFruitType="'..fruitType..'"';
    return attributes, nil;
end;

function farmerCar2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function farmerCar2:keyEvent(unicode, sym, modifier, isDown)
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
	
	if isDown and sym == Input.KEY_x then
		self.worklightsActive3 = not self.worklightsActive3;
		self.reverseLight = not self.reverseLight;
	end;

	
	if isDown and sym == Input.KEY_l then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.worklightsActive2 = false;
		self.flashWarner = false;
	end;
	
	if isDown and sym == Input.KEY_k then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	
	if isDown and sym == Input.KEY_j then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.worklightsActive = false;
		self.flashWarner = false;
	end;

	if isDown and sym == Input.KEY_z then
		if self.pipeOpen then
			self.wysypywanie = not self.wysypywanie;
		end;
	end;
	
	if isDown and self.numAttachedCutters > 0 then
		if sym == Input.KEY_KP_1 or sym == Input.KEY_KP_2 or sym == Input.KEY_KP_3 or sym == Input.KEY_KP_4 or sym == Input.KEY_KP_6 or sym == Input.KEY_KP_8 then
			self.hydraulicSoundAllow = true;
		end;
	else
		self.hydraulicSoundAllow = false;
	end;
	
	if isDown then
		if sym == Input.KEY_KP_0 then
			self.klaksonAllow = true;
		end;
	else
		self.klaksonAllow = false;
	end;
	
    if isDown and sym == Input.KEY_o then
		self.rotationMaxRight = not self.rotationMaxRight;
		self.sieczkarnia = not self.sieczkarnia;
	end;
	
    if isDown and sym == Input.KEY_n then
		self.rotationMaxLeft = not self.rotationMaxLeft;
	end;
	
    if isDown and sym == Input.KEY_m then
		self.rotationMaxLeft2 = not self.rotationMaxLeft2;
		self.rotationMaxLeft3 = not self.rotationMaxLeft3;
		self.rotationMaxLeft4 = not self.rotationMaxLeft4;
		self.rotationMaxLeft5 = not self.rotationMaxLeft5;
		self.rotationMaxLeft6 = not self.rotationMaxLeft6;
		self.rotationMaxLeft7 = not self.rotationMaxLeft7;
	end;
	
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;

function farmerCar2:update(dt)
	
	if not self.reverseLight then
		if self.movingDirection < 0 then
			self.worklightsActive3 = true;
		else
			self.worklightsActive3 = false;
		end;
	end;
	
	   if self.worklightsActive4 then
			for i=1, self.numWorklights4 do
				local worklight4 = self.worklights4[i];
				setVisibility(worklight4, self.worklightsActive4);
			end;
		else
			for i=1, self.numWorklights4 do
				local worklight4 = self.worklights4[i];
				setVisibility(worklight4, self.worklightsActive4, false);
			end;
		end;
		
	   if self.worklightsActive3 then
			for i=1, self.numWorklights3 do
				local worklight3 = self.worklights3[i];
				setVisibility(worklight3, self.worklightsActive3);
			end;
		else
			for i=1, self.numWorklights3 do
				local worklight3 = self.worklights3[i];
				setVisibility(worklight3, self.worklightsActive3, false);
			end;
		end;
		
		
	if not self.isEntered then
		self.wysypywanie = true;
	end;
	
	--*********************************************************************************************************
	
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.worklightsActive2 = true;
				self.worklightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.worklightsActive2 = false;
				self.worklightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.worklightsActive2 = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.worklightsActive2 = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.worklightsActive2 = false;
		end;
	end;
	
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.worklightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.worklightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.worklightsActive = false;
			end;
		end;

	

	   if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
		end;

	
	   if self.worklightsActive2 then
			for i=1, self.numWorklights2 do
				local worklight2 = self.worklights2[i];
				setVisibility(worklight2, self.worklightsActive2);
			end;
		else
			for i=1, self.numWorklights2 do
				local worklight2 = self.worklights2[i];
				setVisibility(worklight2, self.worklightsActive2, false);
			end;
		end;
	
	--*********************************************************************************************************************************
	
	if self.klaksonAllow and not self.klaksonPlaying then
		playSample(self.klaksonId,0,1,0);
		self.klaksonPlaying = true;
	elseif not self.klaksonAllow and self.klaksonPlaying then
		stopSample(self.klaksonId);
		self.klaksonPlaying = false;
	end;
	
	if self.hydraulicSoundAllow and not self.hydraulicPlaying then
		playSample(self.hydraulicSoundId,0,1,0);
		self.hydraulicPlaying = true;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;
	
    local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
	if procent >= 80 then
		if not self.rundumleuchtenAn then
			self.rundumleuchtenAn = true;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
	end;
	
	if self.isEntered then
		if self.warningPlayed == false then
			if procent >= 70 and procent < 71 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
			if procent >= 90 and procent < 91 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
			if procent >= 100 and procent < 101 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
		end;

		if procent < 70 and procent > 70 then
			self.warningPlayed = false;
		end;
		if procent < 90 and procent > 90 then
			self.warningPlayed = false;
		end;
		if procent < 100 and procent > 100 then
			self.warningPlayed = false;
		end;
	end;
	
		if self.rundumleuchtenAn == true then
			setVisibility(self.rullight, true);
		else
			setVisibility(self.rullight, false);
	    end;
		
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;

  
		if self.rotationPartLeft ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
			setRotation(self.rotationPartLeft.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft2 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
			setRotation(self.rotationPartLeft2.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft3 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, not self.rotationMaxLeft3);
			setRotation(self.rotationPartLeft3.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft4 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, not self.rotationMaxLeft4);
			setRotation(self.rotationPartLeft4.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft5 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft5.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft5.maxRot, self.rotationPartLeft5.minRot, 3, self.rotationPartLeft5.rotTime, dt, not self.rotationMaxLeft5);
			setRotation(self.rotationPartLeft5.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft6 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft6.maxRot, self.rotationPartLeft6.minRot, 3, self.rotationPartLeft6.rotTime, dt, not self.rotationMaxLeft6);
			setRotation(self.rotationPartLeft6.node, unpack(newRot));
		end;
		
		if self.rotationPartLeft7 ~= nil then

			local x, y, z = getRotation(self.rotationPartLeft7.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft7.maxRot, self.rotationPartLeft7.minRot, 3, self.rotationPartLeft7.rotTime, dt, not self.rotationMaxLeft7);
			setRotation(self.rotationPartLeft7.node, unpack(newRot));
		end;
	
		if self.rotationPartRight ~= nil then

			local x, y, z = getRotation(self.rotationPartRight.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
			setRotation(self.rotationPartRight.node, unpack(newRot));
		end;

    
	
    if self:getIsActive() then

        if self.isThreshingStarted then
            if self.playThreshingSound then
                if self:getIsActiveForSound() then
                    if self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                        playSample(self.threshingSound, 0, 1, 0);
						playSample(self.cutterthreshingSound, 0, 1, 0);
                        self.playThreshingSound = false;
                        self.threshingSoundActive = true;
                    end;
                end;
            end;
        end;

        if self:getIsActiveForInput() then

            if self.grainTankFillLevel < self.grainTankCapacity then
                if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
                    if self.isThreshing then
                        self:stopThreshing();
                    else
                        self:startThreshing();
                    end;
                end;
            end;

            if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
                if self.pipeOpening then
                    self:closePipe();
                else
                    self:openPipe();
                end;
            end;
        end;

        if self.grainTankFillLevel >= self.grainTankCapacity then
            self:stopThreshing();
        end;

		if self.isThreshing and self.rotorFan ~= nil then
			rotate(self.rotorFan, dt*0.005, 0, 0);
		end;

        local disableChopperEmit = true;
        local disableStrawEmit = true;

        if self.isThreshing then
            local lastArea = 0;
            local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
                    if cutter.lastArea > 0 then
                        for cutter,implement in pairs(self.attachedCutters) do
                            cutter:setFruitType(cutter.currentFruitType);
                            self.currentGrainTankFruitType = cutter.currentFruitType;
                        end;
                        fruitType = cutter.currentFruitType;
                        lastArea = lastArea + cutter.lastArea;
                    end;
                end;
            end;
            self.lastArea = lastArea;
            if lastArea > 0 then
                local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
                if fruitDesc.hasStraw then
                    self.chopperActivated = false;
                else
                    self.chopperActivated = true;
                end;

                if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
                else
                    if self.strawEnableTime == nil then
                        self.strawEnableTime = self.time + self.strawToggleTime;
                    else
                        self.strawDisableTime = nil;
                    end;
                    disableStrawEmit = false;
                end;
                -- 8000/1200 = 6.66 liter/meter
                -- 8000/1200 / 6 = 1.111 liter/m^2
                -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
                local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
                local literPerQm = 1;
                if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                    literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerQm * (1 + 0.5 * (3 - g_currentMission.missionStats.difficulty));
                end;

                --local literPerPixel = 8000/1200 / 6 / (2*2);

                --literPerPixel = literPerPixel*1.5;
                local qm = lastArea*pixelToQm;

                local newFillLevel = self.grainTankFillLevel+qm*literPerQm*self.threshingScale;
                self:setGrainTankFillLevel(newFillLevel, fruitType);
            end;
        end;

        if disableChopperEmit and self.chopperDisableTime == nil then
            self.chopperDisableTime = self.time + self.chopperToggleTime;
        end;
        if disableStrawEmit and self.strawDisableTime == nil then
            self.strawDisableTime = self.time + self.strawToggleTime;
        end;

        if self.grainTankFillLevel <= 0 then
            for cutter,implement in pairs(self.attachedCutters) do
                cutter:resetFruitType();
            end;
            self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        end;

        local chopperBlindRotationSpeed = 0.001;
        local minRotX = -83*3.1415/180.0;
        if self.chopperBlind ~= nil then
            local x,y,z = getRotation(self.chopperBlind);
            if self.chopperActivated then
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
            else
                x = x+dt*chopperBlindRotationSpeed;
                if x > 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.chopperBlind, x, y, z);
        end;

        local pipeRotationSpeed = 0.0006;
        local pipeMinRotY = -90*3.1415/180.0;
        local pipeMaxRotX = 25*3.1415/180.0;
        local pipeXRotationSpeed = 0.0002;
        if self.pipe ~= nil then
            local x,y,z = getRotation(self.pipe);

            if self.pipeOpening then
                y = y-dt*pipeRotationSpeed;
                if y < pipeMinRotY then
                    y = pipeMinRotY;
                end;
                x = x+dt*pipeXRotationSpeed;
                if x > pipeMaxRotX then
                    x = pipeMaxRotX;
                end;
            else
                y = y+dt*pipeRotationSpeed;
                if y > 0.0 then
                    y = 0.0;
                end;
                x = x-dt*pipeXRotationSpeed;
                if x < 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.pipe, x, y, z);
            setRotation(self.pipeFlapLid, 0, y, 0);

            self.pipeOpen = (math.abs(pipeMinRotY-y) < 0.01);
            self.pipeClose =  ((x == 0) and (y == 0) );

        end;

        --[[if self.pipeLight ~= nil then
            local pipeLightActive = self.lightsActive and self.pipeOpening;
            setVisibility(self.pipeLight, pipeLightActive);
        end;]]

        if self.motor ~= nil then
            if self.motor.speedLevel == 1 then
                self.speedDisplayScale = 0.5;
            elseif self.motor.speedLevel == 2 then
                self.speedDisplayScale = 0.6;
            else
                self.speedDisplayScale = 1.0;
            end;
        end;

        if not self.pipeOpen or not self.pipeClose then
            if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                    playSample(self.pipeSound, 0, 1, 0);
                    self.pipeSoundEnabled = true;
                end;
            end;
        end;

        if self.pipeOpen then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;

        if self.pipeClose then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;

        if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
            if self.currentChopperParticleSystem ~= nil then
                Utils.setEmittingState(self.currentChopperParticleSystem, false);
            end;
            self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
            if self.currentChopperParticleSystem == nil then
                self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
            end;
            Utils.setEmittingState(self.currentChopperParticleSystem, true);
			self.rotationMaxRight = true;
            self.chopperEnableTime = nil;
        end;
        if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
            if self.currentStrawParticleSystem ~= nil then
                Utils.setEmittingState(self.currentStrawParticleSystem, false);
				Utils.setEmittingState(self.dustParticleSystems, false);
            end;
            self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
            if self.currentStrawParticleSystem == nil then
                self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
            end;
			if self.sieczkarnia then
				Utils.setEmittingState(self.currentStrawParticleSystem, true);
			else
				Utils.setEmittingState(self.dustParticleSystems, true);
			end;
            self.strawEnableTime = nil;
            self.strawEmitState = true;
        end;
		if not self.sieczkarnia then
			if self.strawEmitState then
				for k, strawArea in pairs(self.strawAreas) do
					local x,y,z = getWorldTranslation(strawArea.start);
					local x1,y1,z1 = getWorldTranslation(strawArea.width);
					local x2,y2,z2 = getWorldTranslation(strawArea.height);
					local old, total = Utils.getFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2);
					local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
					value = math.min(value, g_currentMission.maxWindrowValue);
					Utils.updateFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2, value, true);
				end;
			end;
		end;

    end;

    if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
        if self.currentChopperParticleSystem ~= nil then
            Utils.setEmittingState(self.currentChopperParticleSystem, false);
        end;
        self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
        if self.currentChopperParticleSystem == nil then
            self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
        end;
        Utils.setEmittingState(self.currentChopperParticleSystem, false);
        self.chopperDisableTime = nil;
    end;
    if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
        if self.currentStrawParticleSystem ~= nil then
			Utils.setEmittingState(self.currentStrawParticleSystem, false);
			Utils.setEmittingState(self.dustParticleSystems, false);
        end;
        self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
        if self.currentStrawParticleSystem == nil then
            self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
        end;
        Utils.setEmittingState(self.currentStrawParticleSystem, false);
		Utils.setEmittingState(self.dustParticleSystems, false);
        self.strawDisableTime = nil;
        self.strawEmitState = false;
    end;

    self.lastUnloadingTrailer = nil;
    self.pipeParticleActivated = false;
    if self.pipeOpen and self.wysypywanie then
        if self.grainTankFillLevel > 0 then
            self.pipeParticleActivated = true;
            -- test if we should drain the grain tank
            self.trailerFound = 0;
            local x,y,z = getWorldTranslation(self.pipeRaycastNode);
            raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);

            local trailer = g_currentMission.objectToTrailer[self.trailerFound];
            self.lastUnloadingTrailer = trailer;
            if self.trailerFound == 0 or trailer == nil or not trailer:allowFillType(self.currentGrainTankFruitType, true) or not trailer.allowFillFromAir then
                self.pipeParticleActivated = false;
            else
                local deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
                deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);

                self.grainTankFillLevel = self.grainTankFillLevel-deltaLevel;
                if self.grainTankFillLevel <= 0.0 then
                    deltaLevel = deltaLevel+self.grainTankFillLevel;
                    self.grainTankFillLevel = 0.0;
                    self.pipeParticleActivated = false;
                end;
                if deltaLevel == 0 then
                    self.pipeParticleActivated = false;
                end;
                self:setGrainTankFillLevel(self.grainTankFillLevel, self.currentGrainTankFruitType);
                trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentGrainTankFruitType);
            end;
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        if self.currentPipeParticleSystem ~= nil then
            Utils.setEmittingState(self.currentPipeParticleSystem, false);
        end;
        if self.pipeParticleActivated then
            self.currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
            if self.currentPipeParticleSystem == nil then
                self.currentPipeParticleSystem = self.defaultPipeParticleSystem;
            end;
            Utils.setEmittingState(self.currentPipeParticleSystem, true);
        end;
    end;
	if procent > 0 then
		renderText(0.78, 0.185, 0.02,""..string.format("%s: %.0f (%d%%)", self.combineName, self.grainTankFillLevel, procent).."");
	end;
end;

function farmerCar2:draw()
		if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "Tasto 0: Info Be");

		else
			renderText(0.8335, 0.17, 0.02, "Tasto 0: Info Ki");

		end;
		if self.helpPanel then
			renderText(0.7, 0.84, 0.025, "- Claas Avero 240 -");
			renderText(0.7, 0.815, 0.02, "Tasto U: Villogo");
			renderText(0.7, 0.8, 0.02, "Tasto O: Szecskazo");
			renderText(0.7, 0.785, 0.02, "Tasto N: Letra");
			renderText(0.7, 0.77, 0.02, "Tasto M: Magtartaly");
			renderText(0.7, 0.755, 0.02, "Tasto Z: Hatso munkalampa");
			renderText(0.7, 0.74, 0.02, "Tasto J: Bal iranyjelzo");
			renderText(0.7, 0.725, 0.02, "Tasto K: Elakadasjelzo");
			renderText(0.7, 0.71, 0.02, "Tasto L: Jobb iranyjelzo");
			if self.numAttachedCutters > 0 then
				renderText(0.7, 0.695, 0.02, "Tasti KP 7/KP 9: Motolla sebesseg");
				renderText(0.7, 0.68, 0.02, "Tasti KP 1/KP 3: Hillmaster");
				renderText(0.7, 0.665, 0.02, "Tasti KP 8/KP 2: Motolla fel/le");
				renderText(0.7, 0.65, 0.02, "Tasti KP 4/KP 6: Motolla elore/hatra");
			end;
		end;
		
		
    local percent = self.grainTankFillLevel/self.grainTankCapacity*100;
    if self.drawFillLevel then
        self:drawGrainLevel(self.grainTankFillLevel, self.grainTankCapacity, 95);
    end;
    if self.pipeOpen and not self.pipeParticleActivated and self.grainTankFillLevel > 0 then
        g_currentMission:addExtraPrintText(g_i18n:getText("Move_the_pipe_over_a_trailer"));
    elseif self.grainTankFillLevel == self.grainTankCapacity then
        g_currentMission:addExtraPrintText(g_i18n:getText("Dump_corn_to_continue_threshing"));
    end;
    if self.numAttachedCutters > 0 then
        if self.isThreshing then
            g_currentMission:addHelpButtonText(g_i18n:getText("Turn_off_cutter"), InputBinding.ACTIVATE_THRESHING);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("Turn_on_cutter"), InputBinding.ACTIVATE_THRESHING);
        end;
    end;
    if self.pipeOpening then
        g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
    else
        if percent > 80 then
            g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        g_currentMission.fruitOverlays[self.currentGrainTankFruitType]:render();
    end;

	if not self.isEntered then
	g_currentMission:addExtraPrintText("" .. tostring(self.combineName) .. ": " .. tostring(percent) .. "% (" .. tostring(grainTankFillLevel) .. ")");
	end;
end;

function farmerCar2:onEnter()
    if self.isThreshingStarted then
        self.playThreshingSound = true;
    end;
	self.wysypywanie = false;
end;

function farmerCar2:onLeave()
	
    if self.deactivateOnLeave then
        farmerCar2.onDeactivate(self);
    else
        farmerCar2.onDeactivateSounds(self)
    end;
end;

function farmerCar2:onDeactivate()
    self:stopThreshing();
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.setEmittingState(v, false);
    end;

    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
    self.strawEmitState = false;
    farmerCar2.onDeactivateSounds(self)
end;

function farmerCar2:onDeactivateSounds()
    if self.pipeSound ~= nil and self.pipeSoundEnabled then
        stopSample(self.pipeSound);
        self.pipeSoundEnabled = false;
    end;
    if self.threshingSound ~= nil then
        stopSample(self.threshingSound);
		stopSample(self.cutterthreshingSound);
    end;
end;

function farmerCar2:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
        -- cutter assumes the thresher's loaded fruit type
        object:setFruitType(self.currentGrainTankFruitType);
    end;
end;

function farmerCar2:detachImplement(implementIndex)
    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
        end;
        self.attachedCutters[object] = nil;
    end;
end;

function farmerCar2:allowGrainTankFruitType(fruitType)
    local allowed = false;

    if self.grainTankFruitTypes[fruitType] then -- is fruit type accepted by combine?
        if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then -- is combine currently not empty?
            if self.currentGrainTankFruitType ~= fruitType then -- is there another fill type in the tank?
                if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
                    allowed = true; -- fill level is low enough to be overridden
                end;
            else
                allowed = true; -- fill type is the same as the combine's current fill type
            end;
        else
            allowed = true; -- combine is empty --> FruitUtil.FRUITTYPE_UNKNOWN
        end;
    end;

    return allowed;
end;

function farmerCar2:emptyGrainTankIfLowFillLevel()
    if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
        self.grainTankFillLevel = 0; -- empty the combine
        --return true;
    end;
    --return false;
end;

function farmerCar2:setGrainTankFillLevel(fillLevel, fruitType)
    if not self:allowGrainTankFruitType(fruitType) then
        return;
    end;

    --self:emptyGrainTankIfLowFillLevel();

    self.grainTankFillLevel = Utils.clamp(fillLevel, 0, self.grainTankCapacity);

    if self.currentGrainTankFruitType ~= fruitType then
        self.currentGrainTankFruitType = fruitType;
        if self.currentGrainTankPlane ~= nil then
            setVisibility(self.currentGrainTankPlane, false);
        end;
        if self.currentGrainTankPlaneWindow ~= nil then
            setVisibility(self.currentGrainTankPlaneWindow, false);
        end;
    end;

    if self.grainTankPlanes ~= nil and self.defaultGrainTankPlane ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
        local grainPlane = self.grainTankPlanes[fruitTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainTankPlane;
        end;
        if grainPlane.node ~= nil then
            local yTranslation = 0;
            if self.grainTankPlaneAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans = self.grainTankPlaneAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(grainPlane.node, scaleX, scaleY, scaleZ);
            else
                local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
                yTranslation = m*self.grainTankFillLevel + self.grainTankPlaneMinY;
            end;
            local xPos, yPos, zPos = getTranslation(grainPlane.node);
            setTranslation(grainPlane.node, xPos, yTranslation, zPos);
            setVisibility(grainPlane.node, self.grainTankFillLevel > 0);
            self.currentGrainTankPlane = grainPlane.node;
        end;
        if grainPlane.windowNode ~= nil then
            local yTranslation = 0;
            if self.grainTankPlaneWindowAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans, visiblity = self.grainTankPlaneWindowAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(grainPlane.windowNode, scaleX, scaleY, scaleZ);
                setVisibility(self.grainPlaneWindow, visiblity);
            else
                local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
                local startFillLevel = (self.grainTankPlaneWindowStartY-self.grainTankPlaneMinY)/m;
                local yTranslation = math.min(m*(self.grainTankFillLevel-startFillLevel)+self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY);
                setVisibility(grainPlane.windowNode, self.grainTankFillLevel >= startFillLevel);
            end;
            local xPos, yPos, zPos = getTranslation(grainPlane.windowNode);
            setTranslation(grainPlane.windowNode, xPos, yTranslation, zPos);
            self.currentGrainTankPlaneWindow = grainPlane.windowNode;
        end;
    end;
end;

function farmerCar2:startThreshing()

    if not self.isThreshing then
        if self.numAttachedCutters > 0 then
            self.chopperActivated = self.defaultChopperState;
            self.isThreshing = true;
            for cutter,implement in pairs(self.attachedCutters) do
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                jointDesc.moveDown = true;

                cutter:setReelSpeed(0.003);
                cutter:onStartReel();
            end;
            if self.cutterthreshingSound ~= nil then
                setSamplePitch(self.cutterthreshingSound, math.min(self.cutterthreshingSoundPitchOffset + self.cutterthreshingSoundPitchScale*math.abs(self.lastSoundSpeed), self.cutterthreshingSoundPitchMax));
               playSample(self.cutterthreshingSound, 0, 1, 0);
            end;


            if not self.isThreshingStarted then

                self.isThreshingStarted = true;

                local threshingSoundOffset = 0;
                if self.threshingStartSound ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
                    playSample(self.threshingStartSound, 1, 1, 0);
					playSample(self.warningSoundId, 1, 1, 0);
                    threshingSoundOffset = getSampleDuration(self.threshingStartSound);
                end;

                self.playThreshingSound = true;
                self.playThreshingSoundTime = self.time+threshingSoundOffset;

            end;
        end;
    end;
end;

function farmerCar2:stopThreshing()

    if self.isThreshing then
        self.isThreshingStarted = false;
        self.playThreshingSound = false;

        if self.threshingSound ~= nil then
            stopSample(self.threshingSound);
			stopSample(self.cutterthreshingSound);
        end;

        if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
            setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
            playSample(self.threshingStopSound, 1, 1, 0);
			playSample(self.warningSoundId, 1, 1, 0);
            self.threshingSoundActive = false;
        end;

        self.chopperActivated = false;
        self.isThreshing = false;
        for cutter,implement in pairs(self.attachedCutters) do
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            jointDesc.moveDown = false;

            cutter:onStopReel();
        end;
    end;

end;

function farmerCar2:findTrailerRaycastCallback(transformId, x, y, z, distance)

    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;

    return false;

end;

function farmerCar2:openPipe()
	if not self.pipeOpening then
		playSample(self.warningSoundId, 1, 1, 0);
		self.worklightsActive4 = true;
	end;
    self.pipeOpening = true;
end;

function farmerCar2:closePipe()
	if self.pipeOpening then
		playSample(self.warningSoundId, 1, 1, 0);
		self.worklightsActive4 = false;
	end;
    self.pipeOpening = false;
end;

