AutoAttachMod = {};

function AutoAttachMod:loadMap(name)
	self.firstAttachedAllImplements = false;
end;

function AutoAttachMod:deleteMap()

end;

function AutoAttachMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutoAttachMod:keyEvent(unicode, sym, modifier, isDown)
end;

function AutoAttachMod:update(dt)
	if not self.firstAttachedAllImplements then
		local nearestDistance = 1.3;
		for k, vehicle in pairs(g_currentMission.vehicles) do
			for j=1, table.getn(vehicle.attacherJoints) do
				local jointDesc = vehicle.attacherJoints[j];
				if jointDesc.jointIndex ~= 0 then
					local attached = vehicle.attachedImplements[vehicle:getAttachedIndexFromJointDescIndex(j)].object;
					local a, index, v, d = BaseMission:getAttachableInRange(attached, nearestDistance);
					if a ~= nil then
						attached:attachImplement(a, index);
					end;
				else
					local px, py, pz = getWorldTranslation(jointDesc.jointTransform);
					for k,attachable in pairs(g_currentMission.attachables) do
						local attacherJoint = attachable.attacherJoint;
						if attachable.attacherVehicle == nil and attacherJoint.jointType == jointDesc.jointType then
							local vx, vy, vz = getWorldTranslation(attacherJoint.node);
							local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
							if distance < nearestDistance then
								vehicle:attachImplement(attachable, j);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	self.firstAttachedAllImplements = true;
end;

function AutoAttachMod:draw()
end;

addModEventListener(AutoAttachMod);