cat966g2 = {}

function cat966g2.prerequisitesPresent(specializations)
     Vehicle.registerJointType("shovel");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function cat966g2:load(xmlFile)

    local jointDesc = {};

   local shovelAttacher = {};
	local jointTypeStr = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#jointType");
	shovelAttacher.joint = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#index");
	shovelAttacher.index = 0;
	self.shovel = shovelAttacher;
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];

		if jointType == nil then
      		Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;

		if jointType ~= nil then
			self.attacherJoints[1].jointType = jointType;
		end;
	end;



    local rotationPartNodebras1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#index"));
    if rotationPartNodebras1 ~= nil then
        self.bras1 = {};
        self.bras1.node = rotationPartNodebras1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#minRot"));
        self.bras1.minRot = {};
        self.bras1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#maxRot"));
        self.bras1.maxRot = {};
        self.bras1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bras1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bras1#rotTime"), 2)*1000;
     
     
	    self.bras1.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#pivotverin"));
    end;
    
        local rotationPartNodebras2= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras2#index"));
    if rotationPartNodebras2 ~= nil then
        self.bras2 = {};
        self.bras2.node = rotationPartNodebras2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras2#minRot"));
        self.bras2.minRot = {};
        self.bras2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras2#maxRot"));
        self.bras2.maxRot = {};
        self.bras2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bras2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bras2#rotTime"), 2)*1000;


	    self.bras2.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras2#pivotverin"));
    end;
    
    local rotationPartNodegodet = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.godet#index"));
    if rotationPartNodegodet ~= nil then
        self.godet = {};
        self.godet.node = rotationPartNodegodet;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.godet#minRot"));
        self.godet.minRot = {};
        self.godet.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.godet.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.godet.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.godet#maxRot"));
        self.godet.maxRot = {};
        self.godet.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.godet.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.godet.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.godet.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.godet#rotTime"), 2)*1000;


	    self.godet.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.godet#pivotverin"));
    end;
    
    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
        self.verin2 = {};
	self.verin2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indexverin"));
	self.verin2.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indextige"));
	self.verin2.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin2.tige);
    local bx, by, bz = getWorldTranslation(self.verin2.translationtige);
    self.verin2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
  
            self.verin3= {};
	self.verin3.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin3#indexverin"));
	self.verin3.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin3#indextige"));
	self.verin3.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin3#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin3.tige);
    local bx, by, bz = getWorldTranslation(self.verin3.translationtige);
    self.verin3.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
    	local objectAttacher = {};
	objectAttacher.joint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.anchor#index"));
	objectAttacher.index = 0;
	self.object = objectAttacher;
	self.attachedObject = nil;
	self.objectAttachable = false;
	self.objectInRange = nil;
    

end;

function cat966g2:delete()

end;


function cat966g2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cat966g2:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_KP_8 then
		self.rotationMaxbras2 = isDown;
        self.rotationMingodet = isDown;
                self.playHidraulic2 = not self.playHidraulic2;	 
         end;
	if sym == Input.KEY_KP_5 then
		self.rotationMinbras2 = isDown;
		self.rotationMaxgodet = isDown;
	    self.playHidraulic3 = not self.playHidraulic3;
        end;
        	if sym == Input.KEY_KP_7 then
		self.rotationMinbras1= isDown;
        self.playHidraulic2 = not self.playHidraulic2;
         end;
	if sym == Input.KEY_KP_4 then
		self.rotationMaxbras1 = isDown;
	    self.playHidraulic3 = not self.playHidraulic3;
        end;
        



end;


function cat966g2:update(dt)

	self.bras1Moving = 0; 
	self.bras2Moving = 0;
	self.godetMoving = 0;
	
	
	

           	local doRotate = self.rotationMaxbras1 or self.rotationMinbras1
    	if self.bras1 ~= nil and doRotate then
		local x, y, z = getRotation(self.bras1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bras1.maxRot, self.bras1.minRot, 3, self.bras1.rotTime, dt, not self.rotationMaxbras1);
		setRotation(self.bras1.node, unpack(newRot));
		
	end;
	           	local doRotate = self.rotationMaxbras2 or self.rotationMinbras2
    	if self.bras2 ~= nil and doRotate then
		local x, y, z = getRotation(self.bras2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bras2.maxRot, self.bras2.minRot, 3, self.bras2.rotTime, dt, not self.rotationMaxbras2);
		setRotation(self.bras2.node, unpack(newRot));

	end;
	           	local doRotate = self.rotationMaxgodet or self.rotationMingodet
    	if self.godet ~= nil and doRotate then
		local x, y, z = getRotation(self.godet.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.godet.maxRot, self.godet.minRot, 3, self.godet.rotTime, dt, not self.rotationMaxgodet);
		setRotation(self.godet.node, unpack(newRot));

	end;
	
   	if self.verin1 ~= nil and self.bras1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.bras1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, 0, (distance-self.verin1.tigeDistance)*-1);
		end;
	end;
	   	if self.verin2 ~= nil and self.bras2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin2.node);
		local bx, by, bz = getWorldTranslation(self.bras2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin2.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin2.tige, 0, 0, (distance-self.verin2.tigeDistance)*-1);
		end;
	end;
		   	if self.verin3 ~= nil and self.godet ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin3.node);
		local bx, by, bz = getWorldTranslation(self.godet.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin3.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin3.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin3.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin3.tige, 0, 0, (distance-self.verin3.tigeDistance)*-1);
		end;
	end;

end;
      


function cat966g2:draw()

g_currentMission:addExtraPrintText("Touche KP_7/KP_4: bras");
g_currentMission:addExtraPrintText("Touche KP_8/KP_5: godet");



end;

function cat966g2:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
