---@author  Manuel Leithner
---thanks all


---adaptation for swadro 2000 by xyzspain



Swadro2000= {};


function Swadro2000.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Swadro2000:load(xmlFile)
 
	
	
	
---flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	  
	self.lightswarnings = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.extra_lights.warnings#index"));
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
	 turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	
	-----
	self.lightsbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakelights#index"));
	

	self.braking = false;
	
	-----
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
		-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	
			---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	
	
	----------
	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	
	
	
	
	
	-- control steering
	
	self.steeringAnimations = {};
	self.steeringAnimations.axes = {};
	local i = 0;
    while true do
        local partName = string.format("vehicle.steeringAnimation.axis(%d)", i);
		local axis = {};
        local index = getXMLString(xmlFile, partName .. "#index");
        if index == nil then
            break;
        end;
		axis.node = Utils.indexToObject(self.components, index);
		axis.wheel = self.wheels[getXMLInt(xmlFile, partName .. "#wheelIndex")];
		if axis.wheel ~= nil then
			table.insert(self.steeringAnimations.axes, axis);
		else
			print("Error: Could not found wheel index!");
		end;		
        i = i+1;
	end;
	self.steeringAnimations.steering2 = {};
	self.steeringAnimations.steering2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringAnimation#steering2"));
	self.steeringAnimations.steering2.minRot = getXMLFloat(xmlFile, "vehicle.steeringAnimation#minRot");
	self.steeringAnimations.steering2.maxRot = getXMLFloat(xmlFile, "vehicle.steeringAnimation#maxRot");
	self.steeringAnimations.steering3 = {};
	self.steeringAnimations.steering3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringAnimation#steering3"));
	
	self.updateSteeringAxleAngle = false;
	
	---------------------
	
	--rotaciones y translaciones
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

          self.rotation2.rotTime = self.rotation1.rotTime;
      
    end;
	---lift and work
	    local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
		    local numRotParts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts2#count"), 0);
    self.RotParts2 = {};
    for i=1, numRotParts2 do
      local partnamei = string.format("vehicle.RotParts2.part" .. "%d", i);
      self.RotParts2[i] = {};
      self.RotParts2[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts2[i].minRot = {};
      self.RotParts2[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts2[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts2[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts2[i].maxRot = {};
      self.RotParts2[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts2[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts2[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts2[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
 
	local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
	
      self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
     
    end;
	 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
	
          self.rotation4.rotTime = self.rotation3.rotTime;
      
    end;
			 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation5.rotTime = self.rotation3.rotTime;
      
    end;
	
	local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

       self.rotation6.rotTime = self.rotation3.rotTime;
     
    end;
	local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation7.rotTime = self.rotation3.rotTime;
     
    end;
	 local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = self.rotation3.rotTime;
     
    end;
	
	
	
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      
    end;
	local translationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation3#index"));
    if translationNode3 ~= nil then
        self.translation3 = {};
        self.translation3.node = translationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#minTrans"));
        self.translation3.minTrans = {};
        self.translation3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#maxTrans"));
        self.translation3.maxTrans = {};
        self.translation3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation3#transTime"), 2)*1000;
      
    end;
	
	--------------------------------sounds
	 local windrowerSound = getXMLString(xmlFile, "vehicle.windrowerSound#file");
    if windrowerSound ~= nil and windrowerSound ~= "" then
        windrowerSound = Utils.getFilename(windrowerSound, self.baseDirectory);
        self.windrowerSound = createSample("windrowerSound");
        self.windrowerSoundEnabled = false;
        loadSample(self.windrowerSound, windrowerSound, false);
        self.windrowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#pitchOffset"), 1);
        self.windrowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#volume"), 1.0);
    end;
	
   

	
	--------------
	local sound1 = getXMLString(xmlFile, "vehicle.sound1#file");
    if sound1 ~= nil and sound1 ~= "" then
        sound1 = Utils.getFilename(sound1, self.baseDirectory); 
        self.sound1 = createSample("sound1");
        self.sound1Enabled = false;
        loadSample(self.sound1, sound1, false);
        self.sound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#pitchOffset"), 1);
        self.sound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#volume"), 1);
    end;
		----------
	local sound2 = getXMLString(xmlFile, "vehicle.sound2#file");
    if sound2 ~= nil and sound2 ~= "" then
        sound2 = Utils.getFilename(sound2, self.baseDirectory); 
        self.sound2 = createSample("sound2");
        self.sound2Enabled = false;
        loadSample(self.sound2, sound2, false);
        self.sound2PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#pitchOffset"), 1);
        self.sound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#volume"), 1);
    end;
	local sound3 = getXMLString(xmlFile, "vehicle.sound3#file");
    if sound3 ~= nil and sound3 ~= "" then
        sound3 = Utils.getFilename(sound3, self.baseDirectory); 
        self.sound3 = createSample("sound3");
        self.sound3Enabled = false;
        loadSample(self.sound3, sound3, false);
        self.sound3PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound3#pitchOffset"), 1);
        self.sound3Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound3#volume"), 1);
    end;
	
	--------------------- rotor
	
	
	 self.animation = {};
    self.animation.animCharSet = 0;
    self.animationEnabled = false;
	self.animationSpeed = 0;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
    if rootNode ~= nil then
        self.animation.animCharSet = getAnimCharacterSet(rootNode);
        if self.animation.animCharSet ~= 0 then
            self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
            if self.animation.clip >= 0 then
                assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
                self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
                setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
                setAnimTrackLoopState(self.animation.animCharSet, 0, true);
            end;
        end;
		
    end;

	-------------------
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	--revoluciones tractor
		 self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
		--------------------------
---------------ground cutting areas
local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	
		self.cuttingAreas[i].groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundReferenceNode"));
    end;
	
    local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
 self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
----------------
	self.wheatParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.wheatParticleSystems.wheatParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.wheatParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
		self.wheatParticleSystemsdisableTime=0;		
		i = i +1;		
    end;
	
	self.barleyParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.barleyParticleSystems.barleyParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.barleyParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
			self.barleysParticleSystemsdisableTime =0;
		i = i +1;		
    end;
	
	self.grassParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.grassParticleSystems.grassParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.grassParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		self.grassParticleSystemsdisableTime=0;
		i = i +1;		
    end;
	
	self.drygrassParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.drygrassParticleSystems.drygrassParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.drygrassParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
		self.drygrassParticleSystemsdisableTime=0;
		i = i +1;		
    end;
	
	
	
	-------------------------
	
	self.isTransport = true;
	self.isReadyToTransport = true;
	self.soundOffset = 0;
	self.time=0;
	 self.isTurnedOn = false;
    self.wasToFast = false;
	
	 self.rotParts =false;
	self.rotParts2 =false;	
	self.translation1max= false;
	self.translation2max= false;
	self.translation3max= false;
	self.rotation3max=false;
	self.rotation4max=false;
	self.rotation5max=false;
	self.rotation6max=false;
	self.rotation7max=false;
	self.rotation8max=false;
	
end;	
function Swadro2000:delete()
	if self.windrowerSound ~= nil then
        delete(self.windrowerSound);
	 end;
	
 if self.sound1 ~= nil then
        delete(self.sound1);
    end;
 if self.sound2 ~= nil then
        delete(self.sound2);
    end;
 if self.sound3 ~= nil then
        delete(self.sound3);
    end;

 self:lowerRmp();	
end;
function Swadro2000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Swadro2000:keyEvent(unicode, sym, modifier, isDown)

---flashlights
	
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;
	

	
end;

function Swadro2000:update(dt)
if self.attacherVehicle then
	if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
end;
---- control steering
	if self.attacherVehicle ~= nil then	
			if self.rotation2Max then
				local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
				local dot = z; -- 0*x + z*1;
				dot = dot / Utils.vector2Length(x,z);
				local angle = math.acos(dot);
				if x < 0 then
					angle = -angle;
				end;
				local startSpeed = self.steeringAxleAngleScaleStart;
				local endSpeed = self.steeringAxleAngleScaleEnd;
				local scale = Utils.clamp(1 + (self.lastSpeed*3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
				self.steeringAxleAngle = angle*scale;
				
				for _, axis in pairs(self.steeringAnimations.axes) do
					setRotation(axis.node, getRotation(axis.wheel.repr));
				end;
				local x,y,z = getRotation(self.wheels[1].repr);
				local maxAngle = self.wheels[1].steeringAxleRotMax;
				local minAngle = self.wheels[1].steeringAxleRotMin;
				local percentage = (y - minAngle) / (maxAngle + math.abs(minAngle));
				local a,b,c = getRotation(self.steeringAnimations.steering2.node);
				a = (self.steeringAnimations.steering2.minRot + percentage * (self.steeringAnimations.steering2.maxRot - self.steeringAnimations.steering2.minRot))/100;
				setRotation(self.steeringAnimations.steering2.node, a, b, c);
				setRotation(self.steeringAnimations.steering3.node, a, b, c);
			else
			self.steeringAxleAngle = 0;
		
			end;
	else
			self.steeringAxleAngle = 0;
	end;		
	------------------		
if self.attacherVehicle then
	if self:getIsActive() then
---------------	
		if InputBinding.hasEvent(InputBinding.TOGGLE_BEACON_LIGHTS) then
				self.rundumleuchtenAn = not self.rundumleuchtenAn;
				for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
				end;
		end;
	
		  if self.isReadyToTransport and  self.animationSpeed < 0.01  then
				 if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self.isTransport = not self.isTransport;
			---	renderText(0.1, 0.14, 0.03," autorizacion   ooooo ");
				 end;
		   end;
			
			if not self.isTransport then
			local x, y, z = getTranslation(self.translation1.node);
				if z <0.2  then
				---renderText(0.1, 0.08, 0.03," autorizacion ");
				
					 if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					 self.rotation2Max = not self.rotation2Max ;
						
					end;
					
					 
					if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
							self.isLower=not self.isLower;
					end;
				end;
			end;
			
	if self.isTransport then
				if not self.backupRmp then
					self.backupRmp = self.attacherVehicle.motor.minRpm;
				end; 			
				if self.attacherVehicle.motor.minRpm >= -500 then
					self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 500; 
				end; 
		self.rotation2Max=false;	
				---renderText(0.1, 0.05, 0.03," transport ");
		self.rotParts2 =false;
		self.translation1max= false;
		self.translation2max= false;
		self.translation3max= false;
		if not self.sound1Enabled   and self:getIsActiveForSound() then
			setSamplePitch(self.sound1, self.sound1PitchOffset);
			playSample(self.sound1, 0, self.sound1Volume, 0);
			self.sound1Enabled = true;
			end;
		
		local x, y, z = getTranslation(self.translation1.node);
		if z >2.59  then
		self.rotParts =false;
			if self.sound1Enabled then
			stopSample(self.sound1);
			self.sound1Enabled = false;
			end;
			self:lowerRmp();
		end;
		if z >0.1  then
		self.isOpen=false;
		end;
	else 
		-- if self.animationSpeed < 0.01 then
		
			if not self.backupRmp then
				self.backupRmp = self.attacherVehicle.motor.minRpm;
			end; 			
			if self.attacherVehicle.motor.minRpm >= -500 then
				self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 500; 
			end; 
		------renderText(0.1, 0.07, 0.03,"n transport ");
			if not self.sound1Enabled   and self:getIsActiveForSound() then
				setSamplePitch(self.sound1, self.sound1PitchOffset);
				playSample(self.sound1, 0, self.sound1Volume, 0);
				self.sound1Enabled = true;
			end;
		self.rotParts =true	;
		if self.rotParts then	
		self.rotParts2 =true;
		self.translation1max= true;
		local x, y, z = getTranslation(self.translation1.node);
			if z < 0.3  then
			self.translation2max= true;
			self.translation3max= true;
			end;
			if z < 0.1  then
				if self.sound1Enabled then
				stopSample(self.sound1);
				self.sound1Enabled = false;
				end;
			self.isOpen=true;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			 self.isTurnedOn=not self.isTurnedOn;
			
			end;
			self:lowerRmp();
			end;
			
			
		end;
			if self.isLower then
					 self.isReadyToTransport=false;
						---renderText(0.1, 0.12, 0.03," lower ");
						if not self.sound2Enabled   and self:getIsActiveForSound() then
							setSamplePitch(self.sound2, self.sound2PitchOffset);
							playSample(self.sound2, 0, self.sound2Volume, 0);
							self.sound2Enabled = true;
						end;
						self.rotation3max=true;
						self.rotation4max=true;
						local x, y, z = getRotation(self.rotation4.node);
						if z > Utils.degToRad(15)  then
							self.rotation5max=true;
							self.rotation6max=true;
						end;
						local x, y, z = getRotation(self.rotation5.node);
						if z > Utils.degToRad(15)  then
							self.rotation7max=true;
							self.rotation8max=true;
						end;
						local x, y, z = getRotation(self.rotation7.node);
						if z > Utils.degToRad(39.9)  then
							if self.sound2Enabled then
								stopSample(self.sound2);
								self.sound2Enabled = false;
							end;
						end;
						
						
			else
				---	renderText(0.1, 0.10, 0.03," raise ");
							if not self.sound2Enabled   and self:getIsActiveForSound() then
								setSamplePitch(self.sound2, self.sound2PitchOffset);
								playSample(self.sound2, 0, self.sound2Volume, 0);
								self.sound2Enabled = true;
							end;
							self.rotation3max=false;
							self.rotation4max=false;
							local x, y, z = getRotation(self.rotation4.node);
							if z < Utils.degToRad(28)  then
								self.rotation5max=false;
								self.rotation6max=false;
							end;
							local x, y, z = getRotation(self.rotation5.node);
							if z < Utils.degToRad(28)  then
								self.rotation7max=false;
								self.rotation8max=false;
								
							end;
							local x, y, z = getRotation(self.rotation7.node);
							if z < Utils.degToRad(0.1)  then
									if self.sound2Enabled then
									stopSample(self.sound2);
									self.sound2Enabled = false;
									end;
								 self.isReadyToTransport=true;	
								
							end;
					
			end;
			
		end; ----transport

		
			-----  windrower animation
			self.wasToFast = false;
		
			if self.time > self.drygrassParticleSystemsdisableTime then
           Utils.setEmittingState(self.drygrassParticleSystems, false);
		end;
		if self.time > self.grassParticleSystemsdisableTime then
           Utils.setEmittingState(self.grassParticleSystems, false);
		end;
		if self.time > self.wheatParticleSystemsdisableTime then
           Utils.setEmittingState(self.wheatParticleSystems, false);
		end;
		if self.time > self.barleysParticleSystemsdisableTime then
           Utils.setEmittingState(self.barleysParticleSystems, false);
		end;						
							
	
					
		
		
			
		
	
				
		
	---------------
		if self.isTurnedOn then	
		
			local toFast = false;						
			toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;				
			if not toFast then
				local numDropAreas = table.getn(self.windrowerDropAreas);
				local numAreas = table.getn(self.cuttingAreas);
				local sum = 0;
				local fruitType = FruitUtil.FRUITTYPE_GRASS;					
				local fruitTypeFix = false;
				for i=1, 3 do 					
					if i==2 then
						fruitType = FruitUtil.FRUITTYPE_WHEAT;
							
							
					elseif i==3 then
						fruitType = FruitUtil.FRUITTYPE_BARLEY;
					
					end;						
					for j=1, numAreas  do
						local cuttingArea = self.cuttingAreas[j];
						
							local x,y,z = getWorldTranslation(cuttingArea.groundReferenceNode);
							local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);	
							
							if terrainHeight+self.groundReferenceThreshold >= y then
							
								
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

								local ratio = g_currentMission.windrowCutLongRatio;

									if not fruitTypeFix and i==1 then
										fruitType = FruitUtil.FRUITTYPE_GRASS;
										
									end;

								local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
								area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
								
								if area == 0 and not fruitTypeFix and i==1 then
									fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
								
									area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
									area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
								end;

								if area > 0 then
									fruitTypeFix = true;
										
								end;

								if numDropAreas >= numAreas then
									if area > 0 then
										local dropArea = self.windrowerDropAreas[j];
										---renderText(0,0.45,0.05,"fruitType: " .. fruitType);	
										local x,y,z = getWorldTranslation(dropArea.start);
										local x1,y1,z1 = getWorldTranslation(dropArea.width);
										local x2,y2,z2 = getWorldTranslation(dropArea.height);
										local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
										area = area + old;
										local value = area / total;
										if value < 1 and value > 0.08 then
											value = 1;
										else
											value = math.floor(value + 0.7); -- round, biased to the bigger value
										end;
										if value >= 1 then
											value = math.min(value, g_currentMission.maxWindrowValue);
											Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
										
						
												---renderText(0.1, 0.15, 0.03," particle ");
												if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
										
													if fruitType== FruitUtil.FRUITTYPE_DRYGRASS then
													---renderText(0.1, 0.22, 0.03,"fruitType: " .. fruitType);
													self.drygrassParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.drygrassParticleSystems, true)
													elseif fruitType== FruitUtil.FRUITTYPE_GRASS then
													---renderText(0.1, 0.18, 0.03,"fruitType: " .. fruitType);----5---
														self.grassParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.grassParticleSystems, true)
													elseif fruitType== FruitUtil.FRUITTYPE_WHEAT then------2-----
													---renderText(0.1, 0.25, 0.03,"fruitType: " .. fruitType);
														self.wheatParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.wheatParticleSystems, true)
													elseif fruitType==FruitUtil.FRUITTYPE_BARLEY then
													---renderText(0.1, 0.28, 0.03,"fruitType: " .. fruitType);
														self.barleysParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.barleysParticleSystems, true)
													end; 
												end;		
										end;									
												
										
									end;
								 else
									 sum = sum + area;
								 end;
							else
							Utils.setEmittingState(self.drygrassParticleSystems, false)
							Utils.setEmittingState(self.grassParticleSystems, false)
							Utils.setEmittingState(self.wheatParticleSystems, false)
							Utils.setEmittingState(self.barleysParticleSystems, false)
							end;
						---------
					end;
					if sum > 0 and numDropAreas > 0 then
						local dropArea = self.windrowerDropAreas[6];
						local x,y,z = getWorldTranslation(dropArea.start);
						local x1,y1,z1 = getWorldTranslation(dropArea.width);
						local x2,y2,z2 = getWorldTranslation(dropArea.height);
						local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
						sum = sum + old;
						local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
						if value >= 1 then
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
							----renderText(0.5, 0.1, 0.03,"fruitType: " .. fruitType);
						end;					
					end;
					
				end;
			end;
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
            if not self.windrowerSoundEnabled and self:getIsActiveForSound() and self.time > self.soundOffset then
                playSample(self.windrowerSound, 0, self.windrowerSoundVolume, 0);
                setSamplePitch(self.windrowerSound, self.windrowerSoundPitchOffset);
                self.windrowerSoundEnabled = true;
            end;

			
			self.wasToFast = toFast ;			
        else
			
            if self.animationEnabled and self.animationSpeed < 0.01 then
                disableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = false;
			else
				local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
				self.animationSpeed = newSpeed[1];
				setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
            end;
        end;
	
		if not self.isTurnedOn and self.windrowerSoundEnabled then
        stopSample(self.windrowerSound);
        self.windrowerSoundEnabled = false;
		end;
	
		
			
	


	end;					

		--- flashLights
		if self:getIsActive() then --aislarlo de otros objetos
			if self.FlashLightLeft ~= nil then
					if self.flashLightLeftActive then
						setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
						
				else
						setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
				end;
				end;

			if self.FlashLightRight ~= nil then
					if self.FlashLightRightActive then
						setVisibility(self.FlashLightRight, self.flashLightRightActive);
				else
						setVisibility(self.FlashLightRight, self.flashLightRightActive);
				end;
				end;

			if self.flashLeft then
				if self.delayOnLeft >= -1 then
					self.delayOnLeft = self.delayOnLeft -dt;
				end;
				if not self.flashLightLeftActive then
					if self.delayOnLeft < 0 then
						self.delayOffLeft = 500;
						self.flashLightLeftActive = true;
						playSample(self.turnSoundId, 1, 0.7, 0);
					end;
				end;
				if self.delayOffLeft >= 0 then
					self.delayOffLeft = self.delayOffLeft -dt;
				end;
				if self.flashLightLeftActive then
					if self.delayOffLeft < 0 then
						self.delayOnLeft = 500;
						self.flashLightLeftActive = false;
					end;
				end;
			end;

			if self.flashRight then
				if self.delayOnRight >= 0 then
					self.delayOnRight = self.delayOnRight -dt;
				end;
				if not self.flashLightRightActive then
					if self.delayOnRight < 0 then
						self.delayOffRight = 500;
						self.flashLightRightActive = true;
						playSample(self.turnSoundId, 1, 0.7, 0);
					end;
				end;
				if self.delayOffRight >= 0 then
					self.delayOffRight = self.delayOffRight -dt;
				end;
				if self.flashLightRightActive then
					if self.delayOffRight < 0 then
						self.delayOnRight = 500;
						self.flashLightRightActive = false;
					end;
				end;
			end;

			if self.flash then
			
				if self.delayOn >= 0 then
					self.delayOn = self.delayOn -dt;
				end;
				if not self.flashLightRightActive then
					if self.delayOn < 0 then
						self.delayOff = 500;
						
						self.flashLightRightActive = true;
						self.flashLightLeftActive = true;
						playSample(self.turnSoundId, 1, 0.7, 0);
						
					end;
				end;
				if self.delayOff >= 0 then
					self.delayOff = self.delayOff -dt;
				end;
				if self.flashLightRightActive then
					if self.delayOff < 0 then
						self.delayOn = 500;
					
						self.flashLightLeftActive = false;
						self.flashLightRightActive = false;
					end;
				end;
				else
				
			end;

			if not self.flashLeft and not self.flashRight then
				if not self.flash then
					self.flashLightRightActive = false;
					self.flashLightLeftActive = false;
				end;
			end;
				
			if not self.flash and not self.flashLeft then
				if not self.flashRight then
					self.flashLightRightActive = false;
				end;
			end;

			if not self.flash and not self.flashRight then
				if not self.flashLeft then
					self.flashLightLeftActive = false;
				end;
			end;
		end;
	-----------

	--------------------brake------------------------

  inputAxis_2 = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxis_2) then
        inputAxis_2 = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
	
		if (self.movingDirection*self.lastSpeed*(-inputAxis_2)) < -0.001 then
			setVisibility(self.lightsbrake, true);
		
			self.braking = true;
			
		else
		     setVisibility(self.lightsbrake, false);
		
			self.braking = false;
			
		end;
	
	
	--------------
	   if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
	

end;
	----rotaciones y translaciones
	if self.rotation1Max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	if self.rotation2Max ~= nil then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
		end;
		if self.rotParts2 ~= nil   then
			for i=1, table.getn(self.RotParts2) do
					local rot = {getRotation(self.RotParts2[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts2[i].maxRot, self.RotParts2[i].minRot, 3, self.RotParts2[i].rotTime, dt, not self.rotParts2);
					setRotation(self.RotParts2[i].index, unpack(newRot));
			end; 
		end;

	if self.rotation3 ~= nil  then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;

	if self.rotation4 ~= nil then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
 
	if self.rotation5 ~= nil  then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;

	if self.rotation6 ~= nil  then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;	

	if self.rotation7 ~= nil then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;

	if self.rotation8 ~= nil then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;	
	
	
	if self.translation1 ~= nil  then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end;
	

	if self.translation2 ~= nil then 
		local x, y, z = getTranslation(self.translation2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2max); 
		setTranslation(self.translation2.node, unpack(newTrans)); 
	end;

	if self.translation3 ~= nil  then 
		local x, y, z = getTranslation(self.translation3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation3.maxTrans, self.translation3.minTrans, 3, self.translation3.transTime, dt, not self.translation3max); 
		setTranslation(self.translation3.node, unpack(newTrans)); 
	end;
	
	
	
	
	
	
	
	
	
	
		--- asignacion de libertad ejes de rotacion segun condiciones de emsamblage  0 x, 2 y ,1 z 
		
		
	 self:setJointRotLimit(self.componentJoints[1],0, 12, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	 self:setJointRotLimit(self.componentJoints[2],0, 12, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	 self:setJointRotLimit(self.componentJoints[7],0, 15, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	 self:setJointRotLimit(self.componentJoints[8],0, 15, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	 self:setJointRotLimit(self.componentJoints[9],0, 15, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	 self:setJointRotLimit(self.componentJoints[10],0, 15, 1000,self.isTransport == true or not self.isLower, 2,dt);	
	
	
	
	-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[8];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[9];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[10];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[11];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[12];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[13];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[14];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[15];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[16];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[17];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[18];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[19];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[20];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[21];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[22];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[23];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[24];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[25];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[26];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[27];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[28];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[29];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[30];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[31];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[32];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[33];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[34];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[35];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[36];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[37];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[38];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[39];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[40];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[41];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[42];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[43];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[44];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[45];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[46];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[47];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[48];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[49];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[50];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[51];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[52];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[53];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[54];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[55];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[56];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[57];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		
		
		
		
		
		self:setHydraulicDirection();

end;



function Swadro2000:draw()  

 if self.isTransport then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
    else
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".5"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".6"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		if self.isReadyToTransport then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
		end;
	if self.isOpen then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".4"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    else
		if self.isTurnedOn then	
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		else
		g_currentMission:addExtraPrintText(" ");
		end;
	end;
   if self.rundumleuchtenAn then
			 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".8"), self.typeDesc), InputBinding.TOGGLE_BEACON_LIGHTS); 
	else
			 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".7"), self.typeDesc), InputBinding.TOGGLE_BEACON_LIGHTS); 
	end; 
end;
function Swadro2000:onAttach()

self.fixAttacher = true; 
self.rotation1Max = true;

 self.isReadyToTransport = true;
   self.isTransport = true;
  
end;
function Swadro2000:onDetach()
	self.rotation1Max = false;
	self.steeringAxleAngle = 0;
	self.rotation2Max = false;
	
    if self.deactivateOnDetach then
        Swadro2000.onDeactivate(self);
    else
        Swadro2000.onDeactivateSounds(self)
    end;

	setVisibility(self.lightsbrake, false);

	self.flashLightRightActive = false;
	self.flashLightLeftActive = false;
	setVisibility(self.FlashLightRight, false);
	setVisibility(self.FlashLightLeft, false);
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
	
	
	 self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
	
end;

function Swadro2000:onLeave()

    if self.deactivateOnLeave then
        Swadro2000.onDeactivate(self);
    else
        Swadro2000.onDeactivateSounds(self)
    end;

end;

function Swadro2000:onDeactivate()

    Swadro2000.onDeactivateSounds(self)
 if self.animationEnabled then
        disableAnimTrack(self.animation.animCharSet, 0);
        self.animationEnabled = false;
    end;
				Utils.setEmittingState(self.drygrassParticleSystems, false)
				Utils.setEmittingState(self.grassParticleSystems, false)
				Utils.setEmittingState(self.wheatParticleSystems, false)
				Utils.setEmittingState(self.barleysParticleSystems, false)
    self.isTurnedOn = false;

end;

function Swadro2000:onDeactivateSounds()
	if self.sound1Enabled then
        stopSample(self.sound1);
        self.sound1Enabled = false;
    end;
	if self.sound2Enabled then
        stopSample(self.sound2);
        self.sound2Enabled = false;
    end;
	if self.sound3Enabled then
        stopSample(self.sound3);
        self.sound3Enabled = false;
    end;
	if self.windrowerSoundEnabled then
        stopSample(self.windrowerSound);
        self.windrowerSoundEnabled = false;
	end;
	
	
end;

function Swadro2000:lowerRmp()
	if self.backupRmp and self.attacherVehicle then
		if self.attacherVehicle.motor.minRpm <= self.backupRmp then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm -100; 
		else
			self.attacherVehicle.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;
function Swadro2000:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function Swadro2000:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end; 




