--
-- Universal 1010 DT
--
-- @autor Wallu
--
--
Universal1010DT = {};

function Universal1010DT.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Universal1010DT:load(xmlFile)
      self.Ventilator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ventilator#index"));
      self.VentilatorAlternator = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.VentilatorAlternator#index"));
      self.Rola = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Rola#index"));
      self.Rola1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Rola1#index"));

	local UseStangaNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UseStanga#index"));
    if UseStangaNode ~= nil then
        self.UseStanga = {};
        self.UseStanga.node = UseStangaNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.UseStanga#minRot"));
        self.UseStanga.minRot = {};
        self.UseStanga.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.UseStanga.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.UseStanga.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.UseStanga#maxRot"));
        self.UseStanga.maxRot = {};
        self.UseStanga.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.UseStanga.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.UseStanga.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.UseStanga.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.UseStanga#rotTime"), 200);
        self.UseStanga.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.UseStanga#touchRotLimit"), 10));
    end;

	local UseDreaptaNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.UseDreapta#index"));
    if UseDreaptaNode ~= nil then
        self.UseDreapta = {};
        self.UseDreapta.node = UseDreaptaNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.UseDreapta#minRot"));
        self.UseDreapta.minRot = {};
        self.UseDreapta.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.UseDreapta.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.UseDreapta.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.UseDreapta#maxRot"));
        self.UseDreapta.maxRot = {};
        self.UseDreapta.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.UseDreapta.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.UseDreapta.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.UseDreapta.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.UseDreapta#rotTime"), 200);
        self.UseDreapta.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.UseDreapta#touchRotLimit"), 10));
    end;

	local CapotaNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Capota#index"));
    if CapotaNode ~= nil then
        self.Capota = {};
        self.Capota.node = CapotaNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Capota#minRot"));
        self.Capota.minRot = {};
        self.Capota.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Capota.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Capota.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Capota#maxRot"));
        self.Capota.maxRot = {};
        self.Capota.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Capota.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Capota.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Capota.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Capota#rotTime"), 200);
        self.Capota.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Capota#touchRotLimit"), 10));
    end;

	local CuplaNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Cupla#index"));
    if CuplaNode ~= nil then
        self.Cupla = {};
        self.Cupla.node = CuplaNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Cupla#minRot"));
        self.Cupla.minRot = {};
        self.Cupla.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Cupla.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Cupla.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Cupla#maxRot"));
        self.Cupla.maxRot = {};
        self.Cupla.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Cupla.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Cupla.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Cupla.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Cupla#rotTime"), 200);
        self.Cupla.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Cupla#touchRotLimit"), 10));
    end;

	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;

 self.SchimbatorViteze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchimbatorViteze#index"));
 self.SchimbatorViteze4x4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchimbatorViteze4x4#index"));
end;

function Universal1010DT:delete()

end;

function Universal1010DT:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Universal1010DT:keyEvent(unicode, sym, modifier, isDown)

end;

function Universal1010DT:update(dt)

if self.inrange or self.isEntered then

	if InputBinding.hasEvent (InputBinding.DeschideUseaStanga) then
		self.openUseStanga = not self.openUseStanga;
	end;
	if InputBinding.hasEvent (InputBinding.DeschideUseaDreapta) then
		self.openUseDreapta = not self.openUseDreapta;
	end;
	if InputBinding.hasEvent (InputBinding.DeschideCapota) then
		self.openCapota = not self.openCapota;
	end;
	if InputBinding.hasEvent (InputBinding.Ataseaza_sCupla) then
		self.openCupla = not self.openCupla;
	end;
end;

	if self.inrange or self.isEntered then
		if self.openUseStanga then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide Usea Stanga", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideUseaStanga)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide Usea Stanga", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideUseaStanga)));
		end;
	end; 

	if self.inrange or self.isEntered then
		if self.openCapota then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide Capota", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideCapota)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide Capota", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideCapota)));
		end;
	end; 

	if self.inrange or self.isEntered then
		if self.openUseDreapta then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide Usea Dreapta", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideUseaDreapta)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide Usea Dreapta", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideUseaDreapta)));
		end;
	end; 

	if self.inrange or self.isEntered then
		if self.openCupla then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Dezataseaza Cupla", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ataseaza_sCupla)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Ataseaza Cupla", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ataseaza_sCupla)));
		end;
	end;

	if self.UseStanga ~= nil then
		local x, y, z = getRotation(self.UseStanga.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.UseStanga.minRot, self.UseStanga.maxRot, 3, self.UseStanga.rotTime, dt, self.openUseStanga);
		setRotation(self.UseStanga.node, unpack(newRot));
	end;
	if self.UseDreapta ~= nil then
		local x, y, z = getRotation(self.UseDreapta.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.UseDreapta.minRot, self.UseDreapta.maxRot, 3, self.UseDreapta.rotTime, dt, self.openUseDreapta);
		setRotation(self.UseDreapta.node, unpack(newRot));
	end;
	if self.Capota ~= nil then
		local x, y, z = getRotation(self.Capota.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Capota.minRot, self.Capota.maxRot, 3, self.Capota.rotTime, dt, self.openCapota);
		setRotation(self.Capota.node, unpack(newRot));
	end;
	if self.Cupla ~= nil then
		local x, y, z = getRotation(self.Cupla.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Capota.minRot, self.Cupla.maxRot, 3, self.Cupla.rotTime, dt, self.openCupla);
		setRotation(self.Cupla.node, unpack(newRot));
	end;


		local maxrpmneedle = 900;
			if self.rotationPart1 ~= nil then
				local x, y, z = getRotation(self.rotationPart1.node);
				y = ((self.rotationPart1.maxRot[2] - self.rotationPart1.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm/2.2) + self.rotationPart1.minRot[2];
				setRotation(self.rotationPart1.node, x, y ,z);
			end;


 	local speed = self.lastSpeed*3600;
     if self.SchimbatorViteze ~= nil then
--Inapoi--
          if self.movingDirection < 0 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(-15));
--Liber--
          else     
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
--Inainte--

          elseif speed >= 0.5 and speed <8 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(-10));

          elseif speed >= 8 and speed < 16 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(-10));

          elseif speed >= 16 and speed < 24 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 24 then
               setRotation(self.SchimbatorViteze, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));

          end;
     end;
  end;



     if self.SchimbatorViteze4x4 ~= nil then
--Inapoi--
          if self.movingDirection < 0 then
               setRotation(self.SchimbatorViteze4x4, Utils.degToRad(-5), Utils.degToRad(0), Utils.degToRad(-10));
--Liber--
          else     
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.SchimbatorViteze4x4, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
--Inainte--

          elseif speed >= 0.5 and speed <12 then
               setRotation(self.SchimbatorViteze4x4, Utils.degToRad(5), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 12 and speed < 24 then
               setRotation(self.SchimbatorViteze4x4, Utils.degToRad(-5), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 24 then
               setRotation(self.SchimbatorViteze4x4, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(0));

          end;
     end;
  end;

end;

function Universal1010DT:updateTick(dt)
	if self.isMotorStarted then
         		rotate(self.Ventilator, 0, 0, dt*0.01 );		
	end;

	if self.isMotorStarted then
         		rotate(self.VentilatorAlternator, 0, 0, dt*0.01 );		
	end;

	if self.isMotorStarted then
         		rotate(self.Rola, 0, 0, dt*0.01 );		
	end;

	if self.isMotorStarted then
         		rotate(self.Rola1, 0, 0, dt*0.01 );		
	end;

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function Universal1010DT:draw()  

end;

function Universal1010DT:onLeave()

end;