SetOviEvent = {};
SetOviEvent_mt = Class(SetOviEvent, Event);

InitEventClass(SetOviEvent, "SetOviEvent");

function SetOviEvent:emptyNew()
    local self = Event:new(SetOviEvent_mt);
    self.className="SetOviEvent";
    return self;
end;

function SetOviEvent:new(object, vasAuki, oikAuki, ikkunaAuki, sivuikkuna1Auki, sivuikkuna2Auki, luukkuAuki)
    local self = SetOviEvent:emptyNew()
    self.object = object;
	self.vasovi = vasAuki;
	self.oikovi = oikAuki;
	self.ikkuna = ikkunaAuki;
	self.sivuikkuna1a = sivuikkuna1Auki;
	self.sivuikkuna2a = sivuikkuna2Auki;
	self.luukku = luukkuAuki;
    return self;
end;


function SetOviEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.vasovi = streamReadBool(streamId);
	self.oikovi = streamReadBool(streamId);
	self.ikkuna = streamReadBool(streamId);
	self.sivuikkuna1a = streamReadBool(streamId);
	self.sivuikkuna2a = streamReadBool(streamId);
	self.luukku = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetOviEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.vasovi);
	streamWriteBool(streamId, self.oikovi);
	streamWriteBool(streamId, self.ikkuna);
	streamWriteBool(streamId, self.sivuikkuna1a);
	streamWriteBool(streamId, self.sivuikkuna2a);
	streamWriteBool(streamId, self.luukku);
end;

function SetOviEvent:run(connection)
    self.object:setVasOviAuki(self.vasovi, true);
	self.object:setOikOviAuki(self.oikovi, true);
	self.object:setIkkunaAuki(self.ikkuna, true);
	self.object:setSivuIkkuna1Auki(self.sivuikkuna1a, true);
	self.object:setSivuIkkuna2Auki(self.sivuikkuna2a, true);
	self.object:setLuukkuAuki(self.luukku, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetOviEvent:new(self.object, self.vasovi), nil, connection, self.object);
		 g_server:broadcastEvent(SetOviEvent:new(self.object, self.oikovi), nil, connection, self.object);
		  g_server:broadcastEvent(SetOviEvent:new(self.object, self.ikkuna), nil, connection, self.object);
		  g_server:broadcastEvent(SetOviEvent:new(self.object, self.sivuikkuna1a), nil, connection, self.object);
		  g_server:broadcastEvent(SetOviEvent:new(self.object, self.sivuikkuna2a), nil, connection, self.object);
		  g_server:broadcastEvent(SetOviEvent:new(self.object, self.luukku), nil, connection, self.object);
    end;
end;

function SetOviEvent.sendEvent(vehicle, vasAuki, oikAuki, ikkunaAuki, noEventSend)
    if vasAuki ~= vehicle.vasovi then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, vasAuki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, vasAuki));
            end;
        end;
    end;
	
	if oikAuki ~= vehicle.oikovi then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, oikAuki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, oikAuki));
            end;
        end;
    end;
	
	if ikkunaAuki ~= vehicle.ikkuna then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, ikkunaAuki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, ikkunaAuki));
            end;
        end;
    end;
	
	if sivuikkuna1Auki ~= vehicle.sivuikkuna1a then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, sivuikkuna1Auki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, sivuikkuna1Auki));
            end;
        end;
    end;
	
	if sivuikkuna2Auki ~= vehicle.sivuikkuna2a then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, sivuikkuna2Auki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, sivuikkuna2Auki));
            end;
        end;
    end;
	
	if luukkuAuki ~= vehicle.luukku then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetOviEvent:new(vehicle, luukkuAuki), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetOviEvent:new(vehicle, luukkuAuki));
            end;
        end;
    end;
end;

