   1  --
   2  -- Combine
   3  -- This is the specialization for combines
   4  --
   5  -- @author  Stefan Geiger
   6  -- @date  30/11/08
   7  --
   8  -- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
   9  
  10  Combine = {};
  11  source("dataS/scripts/vehicles/specializations/CombineSetPipeStateEvent.lua");
  12  source("dataS/scripts/vehicles/specializations/CombineSetThreshingEnabledEvent.lua");
  13  source("dataS/scripts/vehicles/specializations/CombinePipeParticleActivatedEvent.lua");
  14  source("dataS/scripts/vehicles/specializations/CombineAreaEvent.lua");
  15  source("dataS/scripts/vehicles/specializations/CombineSetStrawEnableEvent.lua");
  16  source("dataS/scripts/vehicles/specializations/CombineSetChopperEnableEvent.lua");
  17  
  18  function Combine.initSpecialization()
  19      Vehicle.registerJointType("cutter");
  20      Vehicle.registerJointType("trailerCombine");
  21  end;
  22  
  23  function Combine.prerequisitesPresent(specializations)
  24      return SpecializationUtil.hasSpecialization(Steerable, specializations);
  25  end;
  26  
  27  function Combine:load(xmlFile)
  28  
  29      self.allowGrainTankFruitType = Combine.allowGrainTankFruitType;
  30      self.emptyGrainTankIfLowFillLevel = Combine.emptyGrainTankIfLowFillLevel;
  31      self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
  32      self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
  33      self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
  34      self.setIsThreshing = SpecializationUtil.callSpecializationsFunction("setIsThreshing");
  35      self.setPipeOpening = SpecializationUtil.callSpecializationsFunction("setPipeOpening");
  36      self.setPipeState = SpecializationUtil.callSpecializationsFunction("setPipeState");
  37      self.getFruitTypeAndFillLevelToUnload = Combine.getFruitTypeAndFillLevelToUnload;
  38      self.findAutoAimTrailerToUnload = Combine.findAutoAimTrailerToUnload;
  39      self.findTrailerToUnload = Combine.findTrailerToUnload;
  40      self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;
  41      self.getIshreshingAllowed = Combine.getIshreshingAllowed;
  42  
  43      if self.isClient then
  44          local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
  45          if threshingStartSound ~= nil and threshingStartSound ~= "" then
  46              threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory);
  47              self.threshingStartSound = createSample("threshingStartSound");
  48              loadSample(self.threshingStartSound, threshingStartSound, false);
  49              self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



  50              self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
  51              self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
  52          end;
  53          self.threshingSoundActive = false;
  54  
  55          local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
  56          if threshingSound ~= nil and threshingSound ~= "" then
  57              threshingSound = Utils.getFilename(threshingSound, self.baseDirectory);
  58              self.threshingSound = createSample("threshingSound");
  59              loadSample(self.threshingSound, threshingSound, false);
  60              self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
  61              self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
  62              self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
  63          end;
  64  
  65          local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
  66          if threshingStopSound ~= nil and threshingStopSound ~= "" then
  67              threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory);
  68              self.threshingStopSound = createSample("threshingStopSound");
  69              loadSample(self.threshingStopSound, threshingStopSound, false);
  70              self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
  71              self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
  72              self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
  73          end;
  74  
  75          local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
  76          if pipeSound ~= nil and pipeSound ~= "" then
  77              pipeSound = Utils.getFilename(pipeSound, self.baseDirectory);
  78              self.pipeSound = createSample("pipeSound");
  79              loadSample(self.pipeSound, pipeSound, false);
  80              self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
  81              self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
  82              self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
  83          end;
  84      end;
  85  
  86      self.chopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));
  87  
  88      self.pipeParticleSystems = {};
  89  
  90      self.pipeNodes = {};
  91      self.numPipeStates = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.pipe#numStates"), 0);
  92      self.currentPipeState = 1;
  93      self.targetPipeState = 1;
  94      self.pipeStateIsUnloading = {};
  95      self.pipeStateIsAutoAiming = {};
  96      local unloadingPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#unloadingStates"));
  97      if unloadingPipeStates ~= nil then
  98          for i=1, table.getn(unloadingPipeStates) do
  99              if unloadingPipeStates[i] ~= nil thenCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 100                  self.pipeStateIsUnloading[unloadingPipeStates[i] ] = true;
 101              end;
 102          end;
 103      end;
 104      local autoAimPipeStates = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.pipe#autoAimStates"));
 105      if autoAimPipeStates ~= nil then
 106          for i=1, table.getn(autoAimPipeStates) do
 107              if autoAimPipeStates[i] ~= nil then
 108                  self.pipeStateIsAutoAiming[autoAimPipeStates[i] ] = true;
 109              end;
 110          end;
 111      end;
 112      local i = 0;
 113      while true do
 114          local key = string.format("vehicle.pipe.node(%d)", i);
 115          if not hasXMLProperty(xmlFile, key) then
 116              break;
 117          end;
 118          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
 119          if node ~= nil then
 120              local entry = {};
 121              entry.node = node;
 122              entry.autoAimXRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimXRotation"), false);
 123              entry.autoAimYRotation = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimYRotation"), false);
 124              entry.autoAimInvertZ = Utils.getNoNil(getXMLBool(xmlFile, key.."#autoAimInvertZ"), false);
 125              entry.states = {};
 126              for state=1,self.numPipeStates do
 127                  local stateKey = key..string.format(".state%d", state);
 128                  entry.states[state] = {};
 129                  local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#translation"));
 130                  if x == nil or y == nil or z == nil then
 131                      x,y,z = getTranslation(node);
 132                  end;
 133                  entry.states[state].translation = {x,y,z};
 134                  local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, stateKey.."#rotation"));
 135                  if x == nil or y == nil or z == nil then
 136                      x,y,z = getRotation(node);
 137                  else
 138                      x,y,z = math.rad(x),math.rad(y),math.rad(z);
 139                  end;
 140                  entry.states[state].rotation = {x,y,z};
 141              end;
 142              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translationSpeeds"));
 143              if x ~= nil and y ~= nil and z ~= nil then
 144                  x,y,z = x*0.001,y*0.001,z*0.001;
 145                  if x ~= 0 or y ~= 0 or z ~= 0 then
 146                      entry.translationSpeeds = {x,y,z};
 147                  end;
 148              end;
 149              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotationSpeeds"));Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 150              if x ~= nil and y ~= nil and z ~= nil then
 151                  x,y,z = math.rad(x)*0.001,math.rad(y)*0.001,math.rad(z)*0.001;
 152                  if x ~= 0 or y ~= 0 or z ~= 0 then
 153                      entry.rotationSpeeds = {x,y,z};
 154                  end;
 155              end;
 156  
 157              local x,y,z = getTranslation(node);
 158              entry.curTranslation = {x,y,z};
 159              local x,y,z = getRotation(node);
 160              entry.curRotation = {x,y,z};
 161              table.insert(self.pipeNodes, entry);
 162          end;
 163          i = i + 1;
 164      end;
 165      if table.getn(self.pipeNodes) == 0 then
 166          -- use the old format
 167  
 168          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
 169          if node ~= nil then
 170              self.numPipeStates = 2;
 171  
 172              local entry = {};
 173              entry.node = node;
 174              entry.states = {};
 175              entry.states[1] = {};
 176              entry.states[2] = {};
 177  
 178              local x,y,z = getRotation(node);
 179              entry.states[1].rotation = {0,0,z};
 180              entry.states[2].rotation = {math.rad(10),math.rad(-90),z};
 181  
 182              entry.rotationSpeeds = {0.00006, 0.0006, 0};
 183  
 184              local x,y,z = getRotation(node);
 185              entry.curRotation = {x,y,z};
 186  
 187              table.insert(self.pipeNodes, entry);
 188  
 189              self.pipeStateIsUnloading[2] = true;
 190          end;
 191      end;
 192  
 193      local pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));
 194      if pipeFlapLid ~= nil then
 195          if self.numPipeStates ~= 2 then
 196              print("Error: pipeFlapLid is only support with 2 pipe states in '"..self.configFileName.."'.");
 197          else
 198              local entry = {};
 199              entry.node = pipeFlapLid;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 200              entry.states = {};
 201              entry.states[1] = {};
 202              entry.states[2] = {};
 203  
 204              entry.states[1].rotation = {0,0,0};
 205              entry.states[2].rotation = {0,math.rad(-90),0};
 206  
 207              entry.rotationSpeeds = {0, 0.0006, 0};
 208  
 209              local x,y,z = getRotation(pipeFlapLid);
 210              entry.curRotation = {x,y,z};
 211  
 212              table.insert(self.pipeNodes, entry);
 213          end;
 214      end;
 215  
 216      if table.getn(self.pipeNodes) > 0 then
 217  
 218          self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));
 219  
 220          -- load the pipe particle system for each fruit type
 221          local i = 0;
 222          while true do
 223              local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
 224              local t = getXMLString(xmlFile, key .. "#type");
 225              if t == nil then
 226                  break;
 227              end;
 228  
 229              local desc = FruitUtil.fruitTypes[t];
 230              if desc ~= nil then
 231                  local currentPS = {};
 232  
 233                  local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory, self.pipeNodes[1].node);
 234                  self.pipeParticleSystems[desc.index] = currentPS;
 235                  if self.defaultPipeParticleSystem == nil then
 236                      self.defaultPipeParticleSystem = currentPS;
 237                  end;
 238  
 239                  if self.pipeRaycastNode == nil then
 240                      self.pipeRaycastNode = particleNode;
 241                  end;
 242              end;
 243              i = i + 1;
 244          end;
 245  
 246          if self.pipeRaycastNode == nil then
 247              self.pipeRaycastNode = self.components[1].node;
 248          end;
 249      end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 250      self.pipeRaycastDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);
 251  
 252      self.convertedFruits = {};
 253      local i = 0;
 254      while true do
 255          local key = string.format("vehicle.convertedFruits.convertedFruit(%d)", i);
 256          if not hasXMLProperty(xmlFile, key) then
 257              break;
 258          end;
 259          local inputType = getXMLString(xmlFile, key .. "#input");
 260          local outputType = getXMLString(xmlFile, key .. "#output");
 261  
 262          if inputType ~= nil and outputType ~= nil then
 263              local inputDesc = FruitUtil.fruitTypes[inputType];
 264              local outputDesc = FruitUtil.fruitTypes[outputType];
 265              if inputDesc ~= nil and outputDesc ~= nil then
 266                  self.convertedFruits[inputDesc.index] = outputDesc.index;
 267              end;
 268          end;
 269  
 270          i = i + 1;
 271      end;
 272  
 273      self.allowsThreshing = true;
 274  
 275      self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));
 276  
 277      self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));
 278  
 279      self.grainTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 200);
 280      self.grainTankUnloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankUnloadingCapacity"), 10);
 281      self.grainTankCrowded = false;
 282  
 283      self.allowThreshingDuringRain = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowThreshingDuringRain"), false);
 284  
 285  
 286      if self.isClient then
 287          -- grain planes
 288          self.grainTankPlanes = {};
 289          local i = 0;
 290          while true do
 291              local key = string.format("vehicle.grainTankPlanes.grainTankPlane(%d)", i);
 292              if not hasXMLProperty(xmlFile, key) then
 293                  break;
 294              end;
 295              local grainTankPlane = {};
 296              grainTankPlane.nodes = {};
 297              local fruitType = getXMLString(xmlFile, key.."#type");
 298              if fruitType ~= nil then
 299                  local nodeI = 0;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 300                  while true do
 301                      local nodeKey = key..string.format(".node(%d)", nodeI);
 302                      if not hasXMLProperty(xmlFile, nodeKey) then
 303                          break;
 304                      end;
 305                      local node = Utils.indexToObject(self.components, getXMLString(xmlFile, nodeKey.."#index"));
 306                      if node ~= nil then
 307                          local defaultX, defaultY, defaultZ = getTranslation(node);
 308                          local defaultRX, defaultRY, defaultRZ = getRotation(node);
 309                          setVisibility(node, false);
 310  
 311                          local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
 312                          local keyI = 0;
 313                          while true do
 314                              local animKey = nodeKey..string.format(".key(%d)", keyI);
 315                              local keyTime = getXMLFloat(xmlFile, animKey.."#time");
 316                              local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
 317                              if y == nil then
 318                                  y = getXMLFloat(xmlFile, animKey.."#y");
 319                              end;
 320                              local rx,ry,rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
 321                              local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
 322                              if keyTime == nil then
 323                                  break;
 324                              end;
 325                              local x = Utils.getNoNil(x, defaultX);
 326                              local y = Utils.getNoNil(y, defaultY);
 327                              local z = Utils.getNoNil(z, defaultZ);
 328                              local rx = Utils.getNoNil(rx, defaultRX);
 329                              local ry = Utils.getNoNil(ry, defaultRY);
 330                              local rz = Utils.getNoNil(rz, defaultRZ);
 331                              local sx = Utils.getNoNil(sx, 1);
 332                              local sy = Utils.getNoNil(sy, 1);
 333                              local sz = Utils.getNoNil(sz, 1);
 334                              animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
 335                              keyI = keyI +1;
 336                          end;
 337                          if keyI == 0 then
 338                              local minY, maxY = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxY"));
 339                              local minY = Utils.getNoNil(minY, defaultY);
 340                              local maxY = Utils.getNoNil(maxY, defaultY);
 341                              animCurve:addKeyframe({x=defaultX, y=minY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
 342                              animCurve:addKeyframe({x=defaultX, y=maxY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
 343                          end;
 344                          table.insert(grainTankPlane.nodes, {node=node, animCurve = animCurve});
 345                      end;
 346                      nodeI = nodeI +1;
 347                  end;
 348                  if table.getn(grainTankPlane.nodes) > 0 then
 349                      if self.defaultGrainTankPlane == nil thenCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 350                          self.defaultGrainTankPlane = grainTankPlane;
 351                      end;
 352                      self.grainTankPlanes[fruitType] = grainTankPlane;
 353                  end;
 354              end;
 355              i = i +1;
 356          end;
 357          if self.defaultGrainTankPlane==nil then
 358              self.grainTankPlanes = nil;
 359          end;
 360  
 361          if self.grainTankPlanes == nil then
 362              if hasXMLProperty(xmlFile, "vehicle.grainTankPlane.node") then
 363                  print("Warning: '"..self.configFileName.. "' uses old grainTankPlane format, which is not supported anymore.");
 364              end;
 365          end;
 366  
 367          -- chopper particle system
 368          self.chopperParticleSystems = {};
 369          local i = 0;
 370          while true do
 371              local key = string.format("vehicle.chopperParticleSystems.chopperParticleSystem(%d)", i);
 372              local t = getXMLString(xmlFile, key .. "#type");
 373              if t == nil then
 374                  break;
 375              end;
 376              local desc = FruitUtil.fruitTypes[t];
 377              if desc ~= nil then
 378                  local currentPS = {};
 379  
 380                  local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
 381                  self.chopperParticleSystems[desc.index] = currentPS;
 382                  if self.defaultChopperParticleSystem == nil then
 383                      self.defaultChopperParticleSystem = currentPS;
 384                  end;
 385              end;
 386              i = i + 1;
 387          end;
 388  
 389          self.chopperToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperParticleSystems#toggleTime"), 2500);
 390          self.chopperEnableTime = nil;
 391          self.chopperDisableTime = nil;
 392  
 393          -- start particle system
 394          self.strawParticleSystems = {};
 395          local i = 0;
 396          while true do
 397              local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
 398              local t = getXMLString(xmlFile, key .. "#type");
 399              if t == nil thenCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 400                  break;
 401              end;
 402              local desc = FruitUtil.fruitTypes[t];
 403              if desc ~= nil then
 404                  local currentPS = {};
 405  
 406                  local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
 407                  self.strawParticleSystems[desc.index] = currentPS;
 408                  if self.defaultStrawParticleSystem == nil then
 409                      self.defaultStrawParticleSystem = currentPS;
 410                  end;
 411              end;
 412              i = i + 1;
 413          end;
 414      end;
 415  
 416      self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 2500);
 417      self.strawEnableTime = nil;
 418      self.strawDisableTime = nil;
 419  
 420      self.strawEmitState = false;
 421  
 422  
 423      self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);
 424  
 425      local numStrawAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawAreas#count"), 0);
 426      self.strawAreas = {}
 427      for i=1, numStrawAreas do
 428          local area = {};
 429          local areanamei = string.format("vehicle.strawAreas.strawArea%d", i);
 430          area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
 431          area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
 432          area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
 433          table.insert(self.strawAreas, area);
 434      end;
 435  
 436      self.isThreshing = false;
 437      self.chopperActivated = false;
 438      self.defaultChopperState = false;
 439      --self.pipeOpening = false;
 440      --self.pipeOpen = false;
 441      --self.pipeClose = true;
 442      self.pipeIsUnloading = false;
 443      self.pipeParticleActivated = false;
 444      self.pipeParticleDeactivateTime = 0;
 445  
 446      --[[if self.isServer then
 447          self.sentPipeOpening = self.pipeOpening;
 448      end;]]
 449  Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 450      self.threshingScale = 1;
 451  
 452      self.grainTankFruitTypes = {};
 453      self.grainTankFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
 454  
 455      local fruitTypes = getXMLString(xmlFile, "vehicle.grainTankFruitTypes#fruitTypes");
 456      if fruitTypes ~= nil then
 457          local types = Utils.splitString(" ", fruitTypes);
 458          for k,v in pairs(types) do
 459              local desc = FruitUtil.fruitTypes[v];
 460              if desc ~= nil then
 461                  self.grainTankFruitTypes[desc.index] = true;
 462              end;
 463          end;
 464      end;
 465  
 466      self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 467      self.grainTankFillLevel = 0;
 468  
 469      self.grainTankTempFillLevel = 0;
 470      self.grainTankTempFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 471  
 472      self.minThreshold = 0.05;
 473  
 474      self.speedDisplayScale = 1.0;
 475      self.drawFillLevel = true;
 476  
 477      self.attachedCutters = {};
 478      self.numAttachedCutters = 0;
 479  
 480      self.lastArea = 0;
 481      self.lastFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 482      self.lastValidFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 483      self.lastOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 484      self.lastValidOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 485  
 486      self.combineDirtyFlag = self:getNextDirtyFlag();
 487  
 488  
 489      self:setGrainTankFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN);
 490  end;
 491  
 492  function Combine:delete()
 493  
 494      for k,v in pairs(self.pipeParticleSystems) do
 495          Utils.deleteParticleSystem(v);
 496      end;
 497      for k,v in pairs(self.chopperParticleSystems) do
 498          Utils.deleteParticleSystem(v);
 499      end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 500      for k,v in pairs(self.strawParticleSystems) do
 501          Utils.deleteParticleSystem(v);
 502      end;
 503  
 504      if self.threshingStartSound ~= nil then
 505          delete(self.threshingStartSound);
 506      end;
 507      if self.threshingSoundActive then
 508          delete(self.threshingSound);
 509          self.threshingSoundActive = false;
 510      end;
 511      if self.threshingStopSound ~= nil then
 512          delete(self.threshingStopSound);
 513      end;
 514      if self.pipeSound ~= nil then
 515          delete(self.pipeSound);
 516      end;
 517  
 518  end;
 519  
 520  function Combine:readStream(streamId, connection)
 521      local fillLevel = streamReadFloat32(streamId);
 522      local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
 523      self.pipeParticleActived = streamReadBool(streamId);
 524      self.pipeIsUnloading = streamReadBool(streamId);
 525      local pipeState = streamReadUIntN(streamId, 3);
 526      local isThreshing = streamReadBool(streamId);
 527      self:setGrainTankFillLevel(fillLevel, fillType);
 528      self:setPipeState(pipeState, true);
 529      self:setIsThreshing(isThreshing, true);
 530  
 531      local chopperPSenabled = streamReadBool(streamId);
 532      local chopperPSFruitType streamReadUIntN(streamId, FruitUtil.sendNumBits);
 533      local strawPSenabled = streamReadBool(streamId);
 534      local strawPSFruitType streamReadUIntN(streamId, FruitUtil.sendNumBits);
 535  
 536      CombineSetChopperEnableEvent.execute(self, chopperPSenabled, chopperPSFruitType);
 537      CombineSetStrawEnableEvent.execute(self, strawPSenabled, strawPSFruitType);
 538  
 539  
 540      self.lastValidFruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
 541      self.lastValidOutputFruitType = self.lastValidFruitType;
 542      if self.convertedFruits[self.lastValidFruitType] ~= nil then
 543          self.lastValidOutputFruitType = self.convertedFruits[self.lastValidFruitType];
 544      end;
 545  
 546      if self.lastValidFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 547          local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidFruitType];
 548          if fruitDesc.hasStraw then
 549              self.chopperActivated = false;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 550          else
 551              self.chopperActivated = true;
 552          end;
 553      else
 554          self.chopperActivated = self.defaultChopperState;
 555      end;
 556  end;
 557  
 558  function Combine:writeStream(streamId, connection)
 559      streamWriteFloat32(streamId, self.grainTankFillLevel);
 560      streamWriteUIntN(streamId, self.currentGrainTankFruitType, FruitUtil.sendNumBits);
 561      streamWriteBool(streamId, self.pipeParticleActived);
 562      streamWriteBool(streamId, self.pipeIsUnloading);
 563      streamWriteUIntN(streamId, self.targetPipeState, 3);
 564      streamWriteBool(streamId, self.isThreshing);
 565  
 566      streamWriteBool(streamId, self.chopperPSenabled);
 567      streamWriteUIntN(streamId, self.chopperPSFruitType, FruitUtil.sendNumBits);
 568      streamWriteBool(streamId, self.strawPSenabled);
 569      streamWriteUIntN(streamId, self.strawPSFruitType, FruitUtil.sendNumBits);
 570  
 571      streamWriteUIntN(streamId, self.lastValidFruitType, FruitUtil.sendNumBits);
 572  end;
 573  
 574  function Combine:readUpdateStream(streamId, timestamp, connection)
 575      if connection:getIsServer() then
 576          if streamReadBool(streamId) then
 577              local fillLevel = streamReadFloat32(streamId);
 578              local fillType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
 579  
 580              self:setGrainTankFillLevel(fillLevel, fillType);
 581  
 582              self.lastValidFruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
 583              self.lastValidOutputFruitType = self.lastValidFruitType;
 584              if self.convertedFruits[self.lastValidFruitType] ~= nil then
 585                  self.lastValidOutputFruitType = self.convertedFruits[self.lastValidFruitType];
 586              end;
 587  
 588              if self.lastValidFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 589                  local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidFruitType];
 590                  if fruitDesc.hasStraw then
 591                      self.chopperActivated = false;
 592                  else
 593                      self.chopperActivated = true;
 594                  end;
 595              else
 596                  self.chopperActivated = self.defaultChopperState;
 597              end;
 598          end;
 599      end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 600  end;
 601  
 602  function Combine:writeUpdateStream(streamId, connection, dirtyMask)
 603      if not connection:getIsServer() then
 604          if streamWriteBool(streamId, bitAND(dirtyMask, self.combineDirtyFlag) ~= 0) then
 605              streamWriteFloat32(streamId, self.grainTankFillLevel);
 606              streamWriteUIntN(streamId, self.currentGrainTankFruitType, FruitUtil.sendNumBits);
 607              streamWriteUIntN(streamId, self.lastValidFruitType, FruitUtil.sendNumBits);
 608          end;
 609      end;
 610  end;
 611  
 612  function Combine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
 613      local fillLevel = getXMLFloat(xmlFile, key.."#grainTankFillLevel");
 614      local fruitType = getXMLString(xmlFile, key.."#grainTankFruitType");
 615      if fillLevel ~= nil and fruitType ~= nil then
 616          local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
 617          if fruitTypeDesc ~= nil then
 618              self:setGrainTankFillLevel(fillLevel, fruitTypeDesc.index);
 619          end;
 620      end;
 621      return BaseMission.VEHICLE_LOAD_OK;
 622  end;
 623  
 624  function Combine:getSaveAttributesAndNodes(nodeIdent)
 625      local fruitType = "unknown";
 626      if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 627          fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
 628      end;
 629      local attributes = 'grainTankFillLevel="'..self.grainTankFillLevel..'" grainTankFruitType="'..fruitType..'"';
 630      return attributes, nil;
 631  end;
 632  
 633  function Combine:mouseEvent(posX, posY, isDown, isUp, button)
 634  end;
 635  
 636  function Combine:keyEvent(unicode, sym, modifier, isDown)
 637  end;
 638  
 639  function Combine:update(dt)
 640  
 641      if self:getIsActive() then
 642  
 643          if self.isClient then
 644              if self.isThreshing and self:getIsActiveForSound() then
 645                  if not self.threshingSoundActive and self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
 646                      playSample(self.threshingSound, 0, 1, 0);
 647                      self.threshingSoundActive = true;
 648                  end;
 649              end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 650          end;
 651  
 652          if self.isClient and self:getIsActiveForInput() then
 653  
 654              if self.grainTankFillLevel < self.grainTankCapacity or self.grainTankCapacity <= 0 then
 655                  if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
 656                      self:setIsThreshing(not self.isThreshing);
 657                  end;
 658              end;
 659  
 660              if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
 661                  local nextState = self.targetPipeState+1;
 662                  if nextState > self.numPipeStates then
 663                      nextState = 1;
 664                  end;
 665                  self:setPipeState(nextState);
 666              end;
 667          end;
 668  
 669          if self.isServer then
 670              if self.grainTankFillLevel >= self.grainTankCapacity and self.grainTankCapacity > 0 then
 671                  self:setIsThreshing(false);
 672              end;
 673          end;
 674  
 675  		if self.isThreshing and self.rotorFan ~= nil then
 676  			rotate(self.rotorFan, dt*0.005, 0, 0);
 677  		end;
 678  
 679  
 680          local chopperBlindRotationSpeed = 0.001;
 681          local minRotX = -83*3.1415/180.0;
 682          if self.chopperBlind ~= nil then
 683              local x,y,z = getRotation(self.chopperBlind);
 684              if self.chopperActivated then
 685                  x = x-dt*chopperBlindRotationSpeed;
 686                  if x < minRotX then
 687                      x = minRotX;
 688                  end;
 689              else
 690                  x = x+dt*chopperBlindRotationSpeed;
 691                  if x > 0.0 then
 692                      x = 0.0;
 693                  end;
 694              end;
 695              setRotation(self.chopperBlind, x, y, z);
 696          end;
 697  
 698          local doAutoAiming = self.pipeStateIsAutoAiming[self.currentPipeState];
 699          local targetTrailer = nil;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 700          if doAutoAiming then
 701              targetTrailer = self:findAutoAimTrailerToUnload(self.lastValidOutputFruitType);
 702  
 703              if targetTrailer == nil then
 704                  doAutoAiming = false;
 705              end;
 706          end;
 707          if (self.currentPipeState ~= self.targetPipeState or doAutoAiming) and self.targetPipeState <= self.numPipeStates then
 708              local autoAimX, autoAimY, autoAimZ;
 709              if doAutoAiming then
 710                  autoAimX, autoAimY, autoAimZ = getWorldTranslation(targetTrailer.fillAutoAimTargetNode);
 711              end;
 712  
 713  
 714              local moved = false;
 715              for i=1, table.getn(self.pipeNodes) do
 716                  local nodeMoved = false;
 717                  local pipeNode = self.pipeNodes[i];
 718  
 719                  local state = pipeNode.states[self.targetPipeState];
 720                  if pipeNode.translationSpeeds ~= nil then
 721                      for i=1, 3 do
 722                          if pipeNode.curTranslation[i] ~= state.translation[i] then
 723                              nodeMoved = true;
 724                              if pipeNode.curTranslation[i] < state.translation[i] then
 725                                  pipeNode.curTranslation[i] = math.min(pipeNode.curTranslation[i] + dt*pipeNode.translationSpeeds[i], state.translation[i]);
 726                              else
 727                                  pipeNode.curTranslation[i] = math.max(pipeNode.curTranslation[i] - dt*pipeNode.translationSpeeds[i], state.translation[i]);
 728                              end;
 729                          end;
 730                      end;
 731                      setTranslation(pipeNode.node, pipeNode.curTranslation[1],pipeNode.curTranslation[2],pipeNode.curTranslation[3])
 732                  end;
 733                  if pipeNode.rotationSpeeds ~= nil then
 734                      for i=1, 3 do
 735                          local targetRotation = state.rotation[i];
 736                          if doAutoAiming then
 737                              if pipeNode.autoAimXRotation and i == 1 then
 738                                  local x,y,z = getWorldTranslation(pipeNode.node);
 739                                  local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
 740                                  targetRotation = -math.atan2(y,z);
 741                                  if pipeNode.autoAimInvertZ then
 742                                      targetRotation = targetRotation+math.pi;
 743                                  end;
 744                                  targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
 745                              elseif pipeNode.autoAimYRotation and i == 2 then
 746                                  local x,y,z = getWorldTranslation(pipeNode.node);
 747                                  local x,y,z = worldDirectionToLocal(getParent(pipeNode.node), autoAimX-x, autoAimY-y, autoAimZ-z);
 748                                  targetRotation = math.atan2(x,z);
 749                                  if pipeNode.autoAimInvertZ thenCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 750                                      targetRotation = targetRotation+math.pi;
 751                                  end;
 752                                  targetRotation = Utils.normalizeRotationForShortestPath(targetRotation, pipeNode.curRotation[i]);
 753                              end;
 754                          end;
 755                          if pipeNode.curRotation[i] ~= targetRotation then
 756                              nodeMoved = true;
 757                              if pipeNode.curRotation[i] < targetRotation then
 758                                  pipeNode.curRotation[i] = math.min(pipeNode.curRotation[i] + dt*pipeNode.rotationSpeeds[i], targetRotation);
 759                              else
 760                                  pipeNode.curRotation[i] = math.max(pipeNode.curRotation[i] - dt*pipeNode.rotationSpeeds[i], targetRotation);
 761                              end;
 762                          end;
 763                      end;
 764                      setRotation(pipeNode.node, pipeNode.curRotation[1],pipeNode.curRotation[2],pipeNode.curRotation[3])
 765                  end;
 766                  moved = moved or nodeMoved;
 767  
 768                  if nodeMoved and self.setMovingToolDirty ~= nil then
 769                      self:setMovingToolDirty(pipeNode.node);
 770                  end;
 771              end;
 772              if not moved then
 773                  self.currentPipeState = self.targetPipeState;
 774              end;
 775          end;
 776  
 777          if self.isClient then
 778              if self.motor ~= nil then
 779                  if self.motor.speedLevel == 1 then
 780                      self.speedDisplayScale = 0.7;
 781                  elseif self.motor.speedLevel == 2 or self.motor.speedLevel == 4 then
 782                      self.speedDisplayScale = 0.75;
 783                  else
 784                      self.speedDisplayScale = 1.0;
 785                  end;
 786              end;
 787  
 788              if self.currentPipeState ~= self.targetPipeState then
 789                  if self.pipeSound ~= nil and not self.pipeSoundEnabled then
 790                      if self:getIsActiveForSound() then
 791                          setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
 792                          playSample(self.pipeSound, 0, 1, 0);
 793                          self.pipeSoundEnabled = true;
 794                      end;
 795                  end;
 796              else
 797                  if self.pipeSound ~= nil and self.pipeSoundEnabled then
 798                      stopSample(self.pipeSound);
 799                      self.pipeSoundEnabled = false;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 800                  end;
 801              end;
 802          end;
 803  
 804      end;
 805  
 806  end;
 807  
 808  function Combine:updateTick(dt)
 809      if self.isServer then
 810          if self.lastFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 811              self.lastValidFruitType = self.lastFruitType;
 812          end;
 813          if self.lastOutputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 814              self.lastValidOutputFruitType = self.lastOutputFruitType;
 815          end;
 816          self.lastArea = 0;
 817          self.lastFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 818          self.lastOutputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 819          self.grainTankTempFillLevel = 0;
 820  
 821          local disableChopperEmit = true;
 822          local disableStrawEmit = true;
 823  
 824          if self.isThreshing then
 825              local lastArea = 0;
 826              local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
 827              for cutter,implement in pairs(self.attachedCutters) do
 828                  if cutter.reelStarted then
 829                      if cutter.lastArea > 0 then
 830                          for cutter1,implement in pairs(self.attachedCutters) do
 831                              cutter1:setFruitType(cutter.currentFruitType);
 832                          end;
 833                          self.currentGrainTankFruitType = cutter.currentFruitType;
 834                          fruitType = cutter.currentFruitType;
 835                          lastArea = lastArea + cutter.lastArea;
 836                      end;
 837                  end;
 838              end;
 839              self.lastArea = lastArea;
 840              self.lastFruitType = fruitType;
 841              local outputFruitType = fruitType;
 842              if self.convertedFruits[fruitType] ~= nil then
 843                  outputFruitType = self.convertedFruits[fruitType];
 844              end;
 845              self.lastOutputFruitType = outputFruitType;
 846              if self.lastArea > 0 then
 847                  local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
 848                  if fruitDesc.hasStraw then
 849                      self.chopperActivated = false;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 850                  else
 851                      self.chopperActivated = true;
 852                  end;
 853  
 854                  if self.chopperActivated then
 855                      if self.chopperEnableTime == nil then
 856                          self.chopperEnableTime = self.time + self.chopperToggleTime;
 857                      else
 858                          self.chopperDisableTime = nil;
 859                      end;
 860                      self.chopperPSFruitType = fruitType;
 861                      disableChopperEmit = false;
 862                  else
 863                      if self.strawEnableTime == nil then
 864                          self.strawEnableTime = self.time + self.strawToggleTime;
 865                      else
 866                          self.strawDisableTime = nil;
 867                      end;
 868                      self.strawPSFruitType = fruitType;
 869                      disableStrawEmit = false;
 870                  end;
 871  
 872                  -- 8000/1200 = 6.66 liter/meter
 873                  -- 8000/1200 / 6 = 1.111 liter/m^2
 874                  -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
 875                  local pixelToSqm = g_currentMission:getFruitPixelsToSqm()  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
 876                  local literPerSqm = 1;
 877                  if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
 878                      literPerSqm = FruitUtil.fruitIndexToDesc[fruitType].literPerSqm; -- * (1 + 0.5 * (3 - g_currentMission.missionStats.difficulty));
 879                      if (outputFruitType ~= fruitType and outputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
 880                          literPerSqm = literPerSqm * FruitUtil.fruitIndexToDesc[outputFruitType].literPerSqm;
 881                      end;
 882                  end;
 883  
 884                  --local literPerPixel = 8000/1200 / 6 / (2*2);
 885  
 886                  --literPerPixel = literPerPixel*1.5;
 887                  local sqm = self.lastArea*pixelToSqm;
 888  
 889                  local deltaFillLevel = sqm*literPerSqm*self.threshingScale;
 890  
 891                  if self.grainTankCapacity > 0 then
 892                      local newFillLevel = self.grainTankFillLevel+deltaFillLevel;
 893                      self:setGrainTankFillLevel(newFillLevel, outputFruitType);
 894                  else
 895                      self.grainTankTempFillLevel = deltaFillLevel;
 896                      self.grainTankTempFruitType = outputFruitType;
 897                  end;
 898              end;
 899          end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 900          if disableChopperEmit and self.chopperDisableTime == nil then
 901              self.chopperDisableTime = self.time + self.chopperToggleTime;
 902          end;
 903          if disableStrawEmit and self.strawDisableTime == nil then
 904              self.strawDisableTime = self.time + self.strawToggleTime;
 905          end;
 906  
 907  
 908          if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
 909              self.chopperPSenabled = true;
 910              self.chopperEnableTime = nil;
 911          end;
 912          if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
 913              self.strawPSenabled = true;
 914              self.strawEnableTime = nil;
 915              self.strawEmitState = true;
 916          end;
 917          if self.strawEmitState then
 918              local cuttingAreasSend = {};
 919              for k, strawArea in pairs(self.strawAreas) do
 920                  local x,y,z = getWorldTranslation(strawArea.start);
 921                  local x1,y1,z1 = getWorldTranslation(strawArea.width);
 922                  local x2,y2,z2 = getWorldTranslation(strawArea.height);
 923                  local old, total = Utils.getFruitWindrowArea(self.strawPSFruitType, x, z, x1, z1, x2, z2);
 924                  local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
 925                  value = math.min(value, g_currentMission.maxWindrowValue);
 926                  --Utils.updateFruitWindrowArea(self.strawPSFruitType, x, z, x1, z1, x2, z2, value, true);
 927                  table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2,value});
 928              end;
 929  
 930              if (table.getn(cuttingAreasSend) > 0) then
 931                  CombineAreaEvent.runLocally(cuttingAreasSend, self.strawPSFruitType);
 932                  g_server:broadcastEvent(CombineAreaEvent:new(cuttingAreasSend, self.strawPSFruitType));
 933              end;
 934          end;
 935  
 936  
 937          self.pipeIsUnloading = false;
 938          self.pipeParticleActivated = false;
 939          if self.pipeStateIsUnloading[self.currentPipeState] then
 940              local fruitType, fillLevel, useGrainTank = self:getFruitTypeAndFillLevelToUnload();
 941              if fillLevel > 0 then
 942                  self.pipeParticleActivated = true;
 943                  self.pipeIsUnloading = true;
 944  
 945                  -- test if we should drain the grain tank
 946                  local trailer = self:findTrailerToUnload(fruitType);
 947                  if trailer == nil then
 948                      self.pipeIsUnloading = false;
 949                  elseCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



 950                      trailer:resetFillLevelIfNeeded(FruitUtil.fruitTypeToFillType[fruitType]);
 951  
 952                      local deltaLevel = fillLevel;
 953                      if useGrainTank then
 954                          deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
 955                      end;
 956                      deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
 957  
 958                      fillLevel = fillLevel-deltaLevel;
 959                      if fillLevel <= 0.0 then
 960                          deltaLevel = deltaLevel+fillLevel;
 961                          fillLevel = 0.0;
 962                          self.pipeIsUnloading = false;
 963                      elseif deltaLevel == 0 then
 964                          self.pipeIsUnloading = false;
 965                      end;
 966                      if useGrainTank then
 967                          self:setGrainTankFillLevel(fillLevel, fruitType);
 968                      end;
 969                      trailer:setFillLevel(trailer.fillLevel+deltaLevel, FruitUtil.fruitTypeToFillType[fruitType]);
 970                  end;
 971                  if not self.pipeIsUnloading and useGrainTank then
 972                      self.pipeParticleActivated = false;
 973                  end;
 974              end;
 975          end;
 976  
 977  
 978          if self.grainTankFillLevel ~= self.sentGrainTankFillLevel or self.currentGrainTankFruitType ~= self.sentGrainTankFruitType or self.lastValidFruitType ~= self.sentLastValidFruitType then
 979              --g_server:broadcastEvent(CombineFillEvent:new(self, self.grainTankFillLevel, self.currentGrainTankFruitType), nil, nil, self);
 980              self:raiseDirtyFlags(self.combineDirtyFlag);
 981              self.sentGrainTankFillLevel = self.grainTankFillLevel;
 982              self.sentGrainTankFruitType = self.currentGrainTankFruitType;
 983              self.sentLastValidFruitType = self.lastValidFruitType;
 984          end;
 985          if self.pipeParticleActivated ~= self.sentPipeParticleActivated or self.pipeIsUnloading ~= self.sentPipeIsUnloading then
 986              g_server:broadcastEvent(CombinePipeParticleActivatedEvent:new(self, self.pipeParticleActivated, self.pipeIsUnloading), nil, nil, self);
 987              self.sentPipeParticleActivated = self.pipeParticleActivated;
 988              self.sentPipeIsUnloading = self.pipeIsUnloading;
 989          end;
 990          if self.chopperPSenabled~= self.sentChopperPSenabled or (self.chopperPSenabled and self.chopperPSFruitType ~= self.sentChopperPSFruitType) then
 991             g_server:broadcastEvent(CombineSetChopperEnableEvent:new(self, self.chopperPSenabled, self.chopperPSFruitType), true, nil, self);
 992             self.sentChopperPSFruitType = self.chopperPSFruitType;
 993             self.sentChopperPSenabled = self.chopperPSenabled;
 994          end
 995          if self.strawPSenabled ~= self.sentStrawPSenabled or (self.strawPSenabled and self.strawPSFruitType ~= self.sentStrawPSFruitType) then
 996             g_server:broadcastEvent(CombineSetStrawEnableEvent:new(self, self.strawPSenabled, self.strawPSFruitType), true, nil, self);
 997             self.sentStrawPSFruitType = self.strawPSFruitType;
 998             self.sentStrawPSenabled = self.strawPSenabled;
 999          end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1000  
1001          if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
1002              self.chopperPSenabled = false;
1003              self.chopperDisableTime = nil;
1004          end;
1005          if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
1006              self.strawPSenabled = false;
1007              self.strawDisableTime = nil;
1008              self.strawEmitState = false;
1009          end;
1010      end;
1011  
1012      if self.pipeParticleActivated then
1013          self.pipeParticleDeactivateTime = self.time + 100;
1014          local currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
1015          if currentPipeParticleSystem == nil then
1016              currentPipeParticleSystem = self.defaultPipeParticleSystem;
1017          end;
1018          if currentPipeParticleSystem ~= self.currentPipeParticleSystem then
1019              if self.currentPipeParticleSystem ~= nil then
1020                  Utils.setEmittingState(self.currentPipeParticleSystem, false);
1021              end;
1022          end;
1023          self.currentPipeParticleSystem = currentPipeParticleSystem;
1024          Utils.setEmittingState(self.currentPipeParticleSystem, true);
1025      else
1026          if self.pipeParticleDeactivateTime <= self.time and self.currentPipeParticleSystem ~= nil then
1027              Utils.setEmittingState(self.currentPipeParticleSystem, false);
1028              self.currentPipeParticleSystem = nil;
1029          end;
1030      end;
1031  end;
1032  
1033  function Combine:draw()
1034      if self.isClient then
1035          local percent = 0;
1036          if self.grainTankCapacity > 0 then
1037              percent = self.grainTankFillLevel/self.grainTankCapacity*100;
1038              if self.currentPipeState == 2 and not self.pipeParticleActivated and self.grainTankFillLevel > 0 then
1039                  g_currentMission:addExtraPrintText(g_i18n:getText("Move_the_pipe_over_a_trailer"));
1040              elseif self.grainTankFillLevel == self.grainTankCapacity then
1041                  g_currentMission:addExtraPrintText(g_i18n:getText("Dump_corn_to_continue_threshing"));
1042              end;
1043          end;
1044          if self.drawFillLevel then
1045              self:drawGrainLevel(self.grainTankFillLevel, self.grainTankCapacity, 95);
1046          else
1047              self:drawGrainLevel(0,0, 101);
1048          end;
1049          if self.numAttachedCutters > 0 thenCopyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1050              if self.isThreshing then
1051                  g_currentMission:addHelpButtonText(g_i18n:getText("Turn_off_cutter"), InputBinding.ACTIVATE_THRESHING);
1052              else
1053                  g_currentMission:addHelpButtonText(g_i18n:getText("Turn_on_cutter"), InputBinding.ACTIVATE_THRESHING);
1054              end;
1055          end;
1056          if self.numPipeStates == 2 then
1057              if self.targetPipeState == 2 then
1058                  g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
1059              else
1060                  if percent > 80 then
1061                      g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
1062                  end;
1063              end;
1064          end;
1065  
1066          if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
1067              g_currentMission:setFruitOverlayFruitType(self.currentGrainTankFruitType);
1068          end;
1069  
1070          local printRainWarning = false;
1071          local printSpeedLevelWarning = false;
1072          local speedLevelStr;
1073          local speedLevelKeyStr;
1074          local speedLevel = 10;
1075          for _, implement in pairs(self.attachedCutters) do
1076              local cutter = implement.object;
1077              printRainWarning = printRainWarning or cutter.printRainWarning;
1078  
1079              if math.abs(cutter.speedViolationTimer - cutter.speedViolationMaxTime) > 2 then
1080                  printSpeedLevelWarning = true;
1081                  if Cutter.getUseLowSpeedLimit(cutter) then
1082                      if speedLevel > 1 then
1083                          speedLevel = 1;
1084                          speedLevelStr = "1";
1085                          speedLevelKeyStr = InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)
1086                      end;
1087                  else
1088                      if speedLevel > 2 then
1089                          speedLevel = 2;
1090                          speedLevelStr = "2";
1091                          speedLevelKeyStr = InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)
1092                      end;
1093                  end;
1094              end;
1095          end;
1096  
1097          if printRainWarning then
1098              g_currentMission:addWarning(g_i18n:getText("Dont_do_threshing_during_rain_or_hail"), 0.018, 0.033);
1099          end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1100          if printSpeedLevelWarning then
1101              g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), speedLevelStr, speedLevelKeyStr), 0.07+0.022, 0.019+0.029);
1102          end;
1103      end;
1104  
1105  end;
1106  
1107  function Combine:onEnter(isControlling)
1108  end;
1109  
1110  function Combine:onLeave()
1111      if self.deactivateOnLeave then
1112          Combine.onDeactivate(self);
1113      else
1114          Combine.onDeactivateSounds(self)
1115      end;
1116  end;
1117  
1118  function Combine:onDeactivate()
1119      self:stopThreshing();
1120      for k,v in pairs(self.chopperParticleSystems) do
1121          Utils.setEmittingState(v, false);
1122      end;
1123      for k,v in pairs(self.strawParticleSystems) do
1124          Utils.setEmittingState(v, false);
1125      end;
1126  
1127      self.chopperEnableTime = nil;
1128      self.chopperDisableTime = nil;
1129      self.strawEnableTime = nil;
1130      self.strawDisableTime = nil;
1131      self.strawEmitState = false;
1132      Combine.onDeactivateSounds(self)
1133  end;
1134  
1135  function Combine:onDeactivateSounds()
1136      if self.pipeSound ~= nil and self.pipeSoundEnabled then
1137          stopSample(self.pipeSound);
1138          self.pipeSoundEnabled = false;
1139      end;
1140      if self.threshingSoundActive then
1141          stopSample(self.threshingSound);
1142          self.threshingSoundActive = false;
1143      end;
1144  end;
1145  
1146  function Combine:attachImplement(implement)
1147      local object = implement.object;
1148      if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
1149          self.attachedCutters[object] = implement;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1150          self.numAttachedCutters = self.numAttachedCutters+1;
1151          -- cutter assumes the thresher's loaded fruit type
1152          object:setFruitType(self.currentGrainTankFruitType);
1153      end;
1154  end;
1155  
1156  function Combine:detachImplement(implementIndex)
1157      local object = self.attachedImplements[implementIndex].object;
1158      if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
1159          self.numAttachedCutters = self.numAttachedCutters-1;
1160          if self.numAttachedCutters == 0 then
1161              self:stopThreshing()
1162          end;
1163          self.attachedCutters[object] = nil;
1164      end;
1165  end;
1166  
1167  function Combine:allowGrainTankFruitType(fruitType)
1168      local allowed = false;
1169  
1170      if self.grainTankFruitTypes[fruitType] then -- is fruit type accepted by combine?
1171          if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then -- is combine currently not empty?
1172              if self.currentGrainTankFruitType ~= fruitType then -- is there another fill type in the tank?
1173                  if self.grainTankCapacity == 0 or self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
1174                      allowed = true; -- fill level is low enough to be overridden
1175                  end;
1176              else
1177                  allowed = true; -- fill type is the same as the combine's current fill type
1178              end;
1179          else
1180              allowed = true; -- combine is empty --> FruitUtil.FRUITTYPE_UNKNOWN
1181          end;
1182      end;
1183  
1184      return allowed;
1185  end;
1186  
1187  function Combine:emptyGrainTankIfLowFillLevel()
1188      if self.grainTankCapacity == 0 or self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
1189          self.grainTankFillLevel = 0; -- empty the combine
1190          --return true;
1191      end;
1192      --return false;
1193  end;
1194  
1195  function Combine:setGrainTankFillLevel(fillLevel, fruitType)
1196      if not self:allowGrainTankFruitType(fruitType) then
1197          return;
1198      end;
1199  Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1200      --self:emptyGrainTankIfLowFillLevel();
1201  
1202      self.grainTankFillLevel = Utils.clamp(fillLevel, 0, self.grainTankCapacity);
1203  
1204      self.currentGrainTankFruitType = fruitType;
1205  
1206      if self.isClient then
1207          if self.currentGrainTankPlane ~= nil then
1208              for _, node in ipairs(self.currentGrainTankPlane.nodes) do
1209                  setVisibility(node.node, false);
1210              end;
1211              self.currentGrainTankPlane = nil;
1212          end;
1213          if self.grainTankPlanes ~= nil and self.defaultGrainTankPlane ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
1214              local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
1215              local grainPlane = self.grainTankPlanes[fruitTypeName];
1216              if grainPlane == nil then
1217                  grainPlane = self.defaultGrainTankPlane;
1218              end;
1219              local t = self.grainTankFillLevel/self.grainTankCapacity
1220              for _, node in ipairs(grainPlane.nodes) do
1221                  local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
1222  
1223                  setTranslation(node.node, x, y, z);
1224                  setRotation(node.node, rx, ry, rz);
1225                  setScale(node.node, sx, sy, sz);
1226                  setVisibility(node.node, self.grainTankFillLevel > 0);
1227              end;
1228              self.currentGrainTankPlane = grainPlane;
1229          end;
1230      end;
1231  
1232      if self.grainTankFillLevel <= 0 then
1233          for cutter,implement in pairs(self.attachedCutters) do
1234              cutter:resetFruitType();
1235          end;
1236          self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
1237      else
1238          for cutter,implement in pairs(self.attachedCutters) do
1239              cutter:setFruitType(self.currentGrainTankFruitType);
1240          end;
1241      end;
1242  end;
1243  
1244  function Combine:startThreshing()
1245  
1246      if not self.isThreshing then
1247          if self.numAttachedCutters > 0 then
1248              self.chopperActivated = self.defaultChopperState;
1249              self.isThreshing = true;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1250              for cutter,implement in pairs(self.attachedCutters) do
1251                  self:setJointMoveDown(implement.jointDescIndex, true, true);
1252  
1253                  cutter:setReelSpeedScale(1); --0.003);
1254                  cutter:onStartReel();
1255              end;
1256  
1257              if self.isClient then
1258                  local threshingSoundOffset = 0;
1259                  if self.threshingStartSound ~= nil then
1260                      if self:getIsActiveForSound() then
1261                          setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
1262                          playSample(self.threshingStartSound, 1, 1, 0);
1263                      end;
1264                      threshingSoundOffset = getSampleDuration(self.threshingStartSound);
1265                  end;
1266  
1267                  self.playThreshingSoundTime = self.time+threshingSoundOffset;
1268              end;
1269          end;
1270      end;
1271  end;
1272  
1273  function Combine:stopThreshing()
1274  
1275      if self.isThreshing then
1276  
1277          if self.isClient then
1278              if self.threshingSound ~= nil then
1279                  stopSample(self.threshingSound);
1280              end;
1281  
1282              if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
1283                  setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
1284                  playSample(self.threshingStopSound, 1, 1, 0);
1285                  self.threshingSoundActive = false;
1286              end;
1287          end;
1288  
1289          self.chopperActivated = false;
1290          self.isThreshing = false;
1291          for cutter,implement in pairs(self.attachedCutters) do
1292              self:setJointMoveDown(implement.jointDescIndex, false, true);
1293              cutter:onStopReel();
1294          end;
1295      end;
1296  
1297  end;
1298  
1299  function Combine:setPipeOpening(pipeOpening, noEventSend)Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1300      if pipeOpening then
1301          self:setPipeState(2, noEventSend);
1302      else
1303          self:setPipeState(1, noEventSend);
1304      end;
1305  end;
1306  
1307  function Combine:setPipeState(pipeState, noEventSend)
1308      if self.targetPipeState ~= pipeState then
1309          if noEventSend == nil or noEventSend == false then
1310              if g_server ~= nil then
1311                  g_server:broadcastEvent(CombineSetPipeStateEvent:new(self, pipeState));
1312              else
1313                  g_client:getServerConnection():sendEvent(CombineSetPipeStateEvent:new(self, pipeState), nil, nil, self);
1314              end;
1315          end;
1316          self.targetPipeState = pipeState;
1317          self.currentPipeState = 0;
1318      end;
1319  end;
1320  
1321  function Combine:setIsThreshing(isThreshing, noEventSend)
1322      if isThreshing ~= self.isThreshing then
1323          if noEventSend == nil or noEventSend == false then
1324              if g_server ~= nil then
1325                  g_server:broadcastEvent(CombineSetThreshingEnabledEvent:new(self, isThreshing), nil, nil, self);
1326              else
1327                  g_client:getServerConnection():sendEvent(CombineSetThreshingEnabledEvent:new(self, isThreshing));
1328              end;
1329          end;
1330          if isThreshing then
1331              self:startThreshing();
1332          else
1333              self:stopThreshing();
1334          end;
1335      end;
1336  end;
1337  
1338  function Combine:getIshreshingAllowed(earlyWarning)
1339      if self.allowThreshingDuringRain then
1340          return true;
1341      end;
1342      if earlyWarning ~= nil and earlyWarning == true then
1343          if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
1344              return true;
1345          end;
1346      else
1347          if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
1348              return true;
1349          end;Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1350      end;
1351      return false;
1352  end;
1353  
1354  function Combine:getFruitTypeAndFillLevelToUnload()
1355      local fillLevel = self.grainTankFillLevel;
1356      local fruitType = self.currentGrainTankFruitType;
1357      local useGrainTank = self.grainTankCapacity > 0;
1358      if not useGrainTank then
1359          fillLevel = self.grainTankTempFillLevel;
1360          fruitType = self.grainTankTempFruitType;
1361      end;
1362      return fruitType, fillLevel, useGrainTank;
1363  end;
1364  
1365  function Combine:findAutoAimTrailerToUnload(fruitType)
1366      local trailer = nil;
1367      local smallestTrailerId = nil;
1368      if self.trailersInRange ~= nil then
1369          for trailerInRange, pipeStage in pairs(self.trailersInRange) do
1370              if trailerInRange:allowFillType(FruitUtil.fruitTypeToFillType[fruitType]) and trailerInRange.allowFillFromAir and trailerInRange.fillLevel < trailerInRange.capacity then
1371                  local id = networkGetObjectId(trailerInRange);
1372                  -- always take the trailer with the smalles network id. This is deterministic and is the same on the client
1373                  if trailer == nil or id < smallestTrailerId then
1374                      trailer = trailerInRange;
1375                      smallestTrailerId = id;
1376                  end;
1377              end;
1378          end;
1379      end;
1380      return trailer;
1381  end;
1382  
1383  function Combine:findTrailerToUnload(fruitType)
1384  
1385      local x,y,z = getWorldTranslation(self.pipeRaycastNode);
1386      local dx,dy,dz = localDirectionToWorld(self.pipeRaycastNode, 0,-1,0);
1387  
1388      self.trailerFound = 0;
1389      raycastAll(x, y, z, dx,dy,dz, "findTrailerRaycastCallback", self.pipeRaycastDistance, self);
1390  
1391      local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
1392      if trailer == nil or not trailer:allowFillType(FruitUtil.fruitTypeToFillType[fruitType]) or not trailer.allowFillFromAir or trailer.fillLevel >= trailer.capacity then
1393          return nil;
1394      end;
1395      return trailer;
1396  end;
1397  
1398  function Combine:findTrailerRaycastCallback(transformId, x, y, z, distance)
1399  Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
This document is to be published solely by ls-mods.de



1400      local vehicle = g_currentMission.nodeToVehicle[transformId];
1401      if vehicle ~= nil then
1402          if vehicle.exactFillRootNode == transformId then
1403              self.trailerFound = transformId;
1404              return false;
1405          end;
1406      end;
1407  
1408      return true;
1409  
1410  end;