--
-- subHud
-- Specialization for subHud
--
-- @author Felix "Outlaw" Sorge
-- @date  30/08/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

subHud = {};

subHud.helpHudRendered = false;
subHud.modifiedFuncCount = 0;

function subHud.prerequisitesPresent(specializations)
    return true;
end;

function subHud:load(xmlFile)
	if subHud.modifiedFuncCount == 0 then
		subHud.oldOverlayRender = g_currentMission.hudHelpBaseOverlay.render;
		g_currentMission.hudHelpBaseOverlay.render = function(self)
			subHud.helpHudRendered = true;
			subHud.oldOverlayRender(self);
		end;
	end;
	subHud.modifiedFuncCount = subHud.modifiedFuncCount + 1;
	self.addSubText = SpecializationUtil.callSpecializationsFunction("addSubText");
	self.addSubSettings = SpecializationUtil.callSpecializationsFunction("addSubSettings");
	self.subHudBack = Utils.getFilename("textures/fendt926HUD.png", self.baseDirectory);
	self.subHudInfoPoxX = 0.02; --  links rechts
    self.subHudInfoPoxY = 0.75; --   hoch runter
	
	self.subHudBackPoxX = 0.015; -- links rechts
	self.subHudBackWidth = 0.4; -- breite
    self.subHudBackPoxY = 0.73; --  ; hoch runter ( weniger runter ) 
    self.subHudBackHeight = 0.07; -- hoehe
    self.subHudOverlay = Overlay:new("subHudOverlay", self.subHudBack, self.subHudBackPoxX, self.subHudBackPoxY, self.subHudBackWidth, self.subHudBackHeight);
	self.renderText = {};
end;

function subHud:addSubSettings(hudTopic,subTopic,key,logo,logoX,logoY,logoW,logoH,logoHigher)
	if logo then
		local subHudlogo = Utils.getFilename(logo, self.baseDirectory);
		if not g_currentMission.showHelpText or not self.subHudhelpHudRendered then
			logoY = logoHigher;
		end; 
		
		self.subHudlogoOverlay = Overlay:new("subHudlogo", subHudlogo, logoX, logoY, logoW, logoH);
	end;
	self.hudTopic = hudTopic; 
	self.subTopic = subTopic;
	self.subHudKey = key;
end; 

function subHud:addSubText(text,input)
	if self.subHudOn then 
		if input then
			local buttonName = InputBinding.getButtonName(input);
			local sec = "";
			if buttonName ~= nil then
				 sec = " " .. g_i18n:getText("or").. " " ..g_i18n:getText("Button").. " " ..buttonName;
			end;
			table.insert(self.renderText,g_i18n:getText("Key").. " " ..InputBinding.getButtonKeyName(input).. sec.. ": " ..text);
		else
			table.insert(self.renderText,text);	
		end;		
	end; 	
end; 


function subHud:draw()
	if self.renderText ~= nil then
		if self.subHudOn then 
 			self.subHudOverlay:render();
			if self.subHudlogoOverlay ~= nil then
				self.subHudlogoOverlay:render();
			end;
			if self.subTopic then
				setTextBold(true);
				setTextColor(1,1,1,1);	
				self.subHudhelpHudRendered = subHud.helpHudRendered; 
				if g_currentMission.showHelpText and subHud.helpHudRendered then
					self.subHudInfoPoxY = 0.75; --   hoch runter
				else
					self.subHudInfoPoxY = 0.935; --   hoch runter
				end;
				renderText(self.subHudInfoPoxX+0.005, self.subHudInfoPoxY ,0.04, self.subTopic);
			end; 
			for i=1, table.getn(self.renderText) do
				local text = self.renderText[i];
				setTextBold(false);
				setTextColor(1,1,1,1);
				renderText(self.subHudInfoPoxX+0.005, self.subHudInfoPoxY - 0.025 * i,0.02, text);	
				if g_currentMission.showHelpText and subHud.helpHudRendered then
					self.subHudBackPoxY = 0.73 - 0.025 * i; 
				else
					self.subHudBackPoxY = 0.915 - 0.025 * i; 
				end; 
				self.subHudBackHeight = 0.07 + 0.025 * i; 
				self.subHudOverlay = Overlay:new("subHudOverlay", self.subHudBack, self.subHudBackPoxX, self.subHudBackPoxY, self.subHudBackWidth, self.subHudBackHeight);			
			end;
		end; 	
		self.renderText = {};
	end; 
	
	subHud.helpHudRendered = false;
	
	if self.subHudOn  then
		self:addSubText("Info Panel off",self.subHudKey); 
	elseif self.hudTopic then
		g_currentMission:addHelpButtonText(self.hudTopic.. " Info Panel on",self.subHudKey); 
	end; 
end;

function subHud:delete()
	if self.subHudOverlay ~= nil then
		self.subHudOverlay:delete();
	end; 
	if self.subHudlogoOverlay ~= nil then
		self.subHudlogoOverlay:delete();
	end; 
	self.subHudOn = false; 
	subHud.modifiedFuncCount = subHud.modifiedFuncCount - 1;
end;

function subHud:update(dt)
	if InputBinding.hasEvent(self.subHudKey) and self:getIsActiveForInput() then
		self.subHudOn = not self.subHudOn;
	end; 
end;

function subHud:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local subHud = getXMLBool(xmlFile, key.."#subHud");
		if subHud then
			self.subHudOn = not self.subHudOn; 
		end; 
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function subHud:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'subHud="'..tostring(self.subHudOn)..'"'; 
	return attributes, nil;
end;


function subHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function subHud:keyEvent(unicode, sym, modifier, isDown)
end; 