--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  Manuel Leithner 
-- @date  26/07/09
--

PowerShaft = {};

function PowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaft:load(xmlFile)
	
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.PowerShaftGo = nil;
	self.doJointSearch = false;
	
	
	self.powerShaft2 = {};		
	self.powerShaft2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft2#index"));
	local x,y,z = getRotation(self.powerShaft2.node);
	self.powerShaft2.rot = {x,y,z};
	self.powerShaft2.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft2#part"));
	x,y,z = getTranslation(self.powerShaft2.part);
	self.powerShaft2.trans = {x,y,z};
	self.powerShaft2.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft2#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft2.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft2.fixPoint);		
	self.powerShaft2.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.powerShaft2Go = nil;
	self.doJointSearch2 = false;
	
	
end;

function PowerShaft:delete()
end;

function PowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaft:update(dt)
	
	if self.doJointSearch then
		if self.horschImplement.Object then
			self.PowerShaftGo = self.horschImplement.Object.powerShaftAttacher;
			self.doJointSearch = false;
		end;
	end;
	
	
	if self.doJointSearch2 then
		if self.horschImplement.Object then
			self.PowerShaftGo2 = self.horschImplement.Object.powerShaftAttacher2;
			self.doJointSearch2 = false;
		end; 
	end;
	
		
	if self.PowerShaftGo ~= nil then		
		local ax, ay, az = getWorldTranslation(self.powerShaft.node);
		local bx, by, bz = getWorldTranslation(self.PowerShaftGo);
		local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
		setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
	end;		
	
	if self.PowerShaftGo2 ~= nil then		
		local ax, ay, az = getWorldTranslation(self.powerShaft2.node);
		local bx, by, bz = getWorldTranslation(self.PowerShaftGo2);
		local x, y, z = worldDirectionToLocal(getParent(self.powerShaft2.node), bx-ax, by-ay, bz-az);
		setDirection(self.powerShaft2.node, x, y, z, 0, -1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setTranslation(self.powerShaft2.part, 0, 0, distance-self.powerShaft2.distance);		
	end;		

end;

function PowerShaft:draw()
end;






