-- 
-- Scrypt do przyczepy HL 60.11 by maciusboss1
-- Scrypt by maciusboss1
-- Data: 21.07.2011 r.
-- Zakaz przerabiania i brania do swoich modeli
-- Zapraszam na www.lsmodss.pl


HL6011 = {};

function HL6011.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function HL6011:load(xmlFile)
	self.plandeka1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plandeka1#index"));
	self.plandeka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plandeka#index"));
	self.zakladki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zakladki#index"));
	self.zakladki1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zakladki1#index"));
	self.worki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.worki#index"));

	
	self.plandeka1Active = true;
	self.plandekaActive = false;
	self.zakladkiActive = false;
   	self.zakladki1Active = false;
   	self.workiActive = false;

	local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

	   local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
    end;
    
   	local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
    

    
	local translationPartNodePlandeka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartPlandeka#index"));
    if translationPartNodePlandeka ~= nil then
        self.translationPartPlandeka = {};
        self.translationPartPlandeka.node = translationPartNodePlandeka;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPlandeka#minTrans"));
        self.translationPartPlandeka.minTrans = {};
        self.translationPartPlandeka.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPlandeka.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPlandeka.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartPlandeka#maxTrans"));
        self.translationPartPlandeka.maxTrans = {};
        self.translationPartPlandeka.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartPlandeka.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartPlandeka.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartPlandeka.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPlandeka#transTime"), 2)*1000;
        self.translationPartPlandeka.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartPlandeka#touchTransLimit"), 10);
    end;


end;

function HL6011:delete()
end;

function HL6011:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HL6011:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_9 then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_m then
	    self.rotationMax = not self.rotationMax;
 	end;
	if isDown and sym == Input.KEY_n then
	    self.rotationMax2 = not self.rotationMax2;
	end;
	if isDown and sym == Input.KEY_KP_0 then
		self.zakladkiActive = not self.zakladkiActive;
        self.translationPartNodePlandeka = not self.translationPartNodePlandeka;
	end;
	if isDown and sym == Input.KEY_v then
       	self.plandeka1Active = not self.plandeka1Active;
		self.plandekaActive = not self.plandekaActive;
	end;
	if isDown and sym == Input.KEY_j then
		self.zakladki1Active = not self.zakladki1Active;
	end;
	if isDown and sym == Input.KEY_k then
		self.workiActive = not self.workiActive;
	end;
end;

function HL6011:update(dt)
	
	self.isExpanded = false;
	setVisibility(self.plandeka1, self.plandeka1Active);
	setVisibility(self.zakladki, self.zakladkiActive);
	setVisibility(self.plandeka, self.plandekaActive);
	setVisibility(self.zakladki1, self.zakladki1Active);
	setVisibility(self.worki, self.workiActive);
	if self.rotationPart ~= nil then
		local x, y, z = getRotation(self.rotationPart.node);
		local maxRot = self.rotationPart.maxRot;
		local eps = self.rotationPart.touchRotLimit
			
		if math.abs(x-maxRot[1]) < eps and math.abs(y-maxRot[2]) < eps and math.abs(z-maxRot[3]) < eps then
            self.isExpanded = true;
        end;
	end;
	if self.rotationPart ~= nil then
		local x, y, z = getRotation(self.rotationPart.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
		setRotation(self.rotationPart.node, unpack(newRot));
	end;
	if self.rotationPart2 ~= nil then
		local x, y, z = getRotation(self.rotationPart2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
		setRotation(self.rotationPart2.node, unpack(newRot));
	end;

    if self.translationPartPlandeka ~= nil then
		local x, y, z = getTranslation(self.translationPartPlandeka.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartPlandeka.maxTrans, self.translationPartPlandeka.minTrans, 3, self.translationPartPlandeka.transTime, dt, not self.translationPartNodePlandeka);
		setTranslation(self.translationPartPlandeka.node, unpack(newTrans));
	end;

end;

function HL6011:draw()
        
	if self.helpPanel then
           g_currentMission:addExtraPrintText("Wcisnij 9: Wlacz Info Przyczepa HL 60.11");
    else
          g_currentMission:addExtraPrintText("Wcisnij 9: Wylacz Info Przyczepa KL 60.11");
    end;
	if self.helpPanel then
			renderText(0.65, 0.67, 0.025, "Przyczepa HL 60.11 By Maciusboss1");
			renderText(0.65, 0.645, 0.02, "Wcisnij: N: otworz/zamknij burte lewa");
			renderText(0.65, 0.63, 0.02, "Wcisnij: M: otworz/zamknij burte prawa");
			renderText(0.65, 0.615, 0.02, "Wcisnij NUM 1|3/2: Kierunkowskazy/awaryjne");
			renderText(0.65, 0.6, 0.02, "Wcisnij V: zaloz/sciagnij plandeke");
			renderText(0.65, 0.585, 0.02, "Wcisnij NUM 0: wlacz/wylacz zakladki");
			renderText(0.65, 0.57, 0.02, "Wcisnij J: wlacz/wylacz zakladki QQ");
			renderText(0.65, 0.555, 0.02, "Wcisnij K: zaloz/sciagnij worki ");
			renderText(0.65, 0.5, 0.025, "www.lsmodss.pl");
		end;


end;


function HL6011:onAttach()
	
end;

function HL6011:onDetach()
end;

function HL6011:onLeave()
end;