--
-- Autor: HmcrE
--
-- Date: 05-01-11
--
-- Specialization for Pagliari SP 300
--

PagliariSP300 = {};

function PagliariSP300.prerequisitesPresent(specializations)
    return true;
end;

function PagliariSP300:load(xmlFile)

	self.trailerRaycastCallback = PagliariSP300.trailerRaycastCallback;

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;

end;

function PagliariSP300:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PagliariSP300:keyEvent(unicode, sym, modifier, isDown)
end;

function PagliariSP300:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.PagliariSP300_Braccio_Pescante1) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.PagliariSP300_Braccio_Pescante2) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
		
		if InputBinding.isPressed(InputBinding.PagliariSP300_Tubo_Pescante1) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.PagliariSP300_Tubo_Pescante2) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		end;
			
		if InputBinding.isPressed(InputBinding.PagliariSP300_Tubo_Telescopico1) and self:getIsActiveForInput() then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.PagliariSP300_Tubo_Telescopico2) and self:getIsActiveForInput() then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet+dt), false);
		end;
	end;
	
end;

function PagliariSP300:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
			if self.hydraulics[i].doScale then
				local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
				local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
				setScale(self.hydraulics[i].punch, 1, 1, newScale);
			else
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	end;
	
end;

function PagliariSP300:trailerRaycastCallback(transformId, x, y, z, distance)
	local vehicle = g_currentMission.nodeToVehicle[transformId];
	if vehicle ~= nil then
		if vehicle.exactFillRootNode == transformId then
			self.trailerFoundId = transformId;
			return false;
		end;
	end;
	return true;
end;

function PagliariSP300:delete()
end;

function PagliariSP300:draw()

	g_currentMission:addExtraPrintText(g_i18n:getText("PagliariSP300_Braccio_Pescante")); 
	g_currentMission:addExtraPrintText(g_i18n:getText("PagliariSP300_Tubo_Pescante")); 
	g_currentMission:addExtraPrintText(g_i18n:getText("PagliariSP300_Tubo_Telescopico"));

end;