-- Drehtor
-- @Copyright: Daniel (Desperados93) W. / GIANTS Software GmbH / sven777b
-- @date: 25.03.2011

--  Author @ Daniel "Desperados93" W.
   
  Drehtor = {};
  
  local Drehtor_mt = Class(Drehtor);
  
  function Drehtor.onCreate(id)
      g_currentMission:addUpdateable(Drehtor:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Drehtor:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Drehtor_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 1.8;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Drehtor:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Drehtor:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.001;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.001;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setRotation(self.barriers[i], 0, self.trans, 0);
          end;
      end;
      
  end;
  
  function Drehtor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("DrehtorOnCreate", Drehtor.onCreate);

