--
-- Multiplayer Event Script
--
-- M@D Author:  Heady
-- M@D date: 22.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

MPEvent = {};
MPEvent_mt = Class(MPEvent, Event);

InitEventClass(MPEvent, "MPEvent");

function MPEvent:emptyNew()
    local self = Event:new(MPEvent_mt);
    self.className="MPEvent";
    return self;
end;

function MPEvent:new(object)
    local self = MPEvent:emptyNew()
    self.object = object;
    return self;
end;

function MPEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);
    self.object.tipTrailerIndex = streamReadInt32(streamId);
    self.object.siloState = streamReadInt32(streamId);
	
	if connection:getIsServer() then
		self.object.silage.fillLevel = streamReadInt32(streamId);
		self.object.silo.fillLevel = streamReadInt32(streamId);
		self.object.silo.maxFillLevel = streamReadInt32(streamId);
	end;
	
	self.object:updateState();
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(MPEvent:new(self.object), nil, connection, self.object);
	end;
end;

function MPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, self.object.tipTrailerIndex);
    streamWriteInt32(streamId, self.object.siloState);
	if not connection:getIsServer() then
		streamWriteInt32(streamId, self.object.silage.fillLevel);
		streamWriteInt32(streamId, self.object.silo.fillLevel);
		streamWriteInt32(streamId, self.object.silo.maxFillLevel);
	end;
end;


MPEventMoveSilagePlane = {};
MPEventMoveSilagePlane_mt = Class(MPEventMoveSilagePlane, Event);

InitEventClass(MPEventMoveSilagePlane, "MPEventMoveSilagePlane");

function MPEventMoveSilagePlane:emptyNew()
    local self = Event:new(MPEventMoveSilagePlane_mt);
    self.className="MPEventMoveSilagePlane";
    return self;
end;

function MPEventMoveSilagePlane:new(object)
    local self = MPEventMoveSilagePlane:emptyNew()
    self.object = object;
    return self;
end;

function MPEventMoveSilagePlane:readStream(streamId, connection)
	local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);	

	self.object:moveSilagePlane(self.object.silage.fillLevel);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(MPEventMoveSilagePlane:new(self.object), nil, connection, self.object);
	end;
end;

function MPEventMoveSilagePlane:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;


MPEventMoveSiloPlane = {};
MPEventMoveSiloPlane_mt = Class(MPEventMoveSiloPlane, Event);

InitEventClass(MPEventMoveSiloPlane, "MPEventMoveSiloPlane");

function MPEventMoveSiloPlane:emptyNew()
    local self = Event:new(MPEventMoveSiloPlane_mt);
    self.className="MPEventMoveSiloPlane";
    return self;
end;

function MPEventMoveSiloPlane:new(object)
    local self = MPEventMoveSiloPlane:emptyNew()
    self.object = object;
    return self;
end;

function MPEventMoveSiloPlane:readStream(streamId, connection)
	local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);	

	self.object:moveSiloPlane(self.object.silo.fillLevel);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(MPEventMoveSiloPlane:new(self.object), nil, connection, self.object);
	end;
end;

function MPEventMoveSiloPlane:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
